/*
	Source file for SM_XRAYS.JPG
	Submitted for the May-June 1995 Raytracing Competition

	Created by Stefan T. Maes - maes@uia.ua.ac.be
	Other traces of mine can be found on the WWW.
	The URL is http://www.uia.ac.be/u/maes/index.html
*/

# include "colors.inc"
# include "newcolor.inc"
# include "textures.inc"
# include "shapes.inc"
# include "shapes2.inc"

# include "crystals.inc"

// Units are mm! , RIGHT HANDED COORDINATE SYSTEM !


#declare XRayTool=
  union{
	 box{ <-.7,-45,-.7>, <.7,-31,.7>
	      texture{ Polished_Brass pigment{ Bronze }
		       finish{ phong .7 phong_size 10 }
		     }
	    }

	 cone{ <0,-31,0>, 4 , <0,-30,0>, 5
	       texture{ Chrome_Texture
			pigment{ Gray15 }
			finish{ reflection .7
				phong 0.4 phong_size 20 }
		      }
	     }
	 cylinder{ <0,-30,0>, <0,-20,0>, 5
		   texture{ pigment{ Silver }
			    finish{ ambient 0.2      diffuse 0.28
				    reflection 0.25  brilliance 7
				    phong 0.25       phong_size 130
				  }
			 }
		 }
	 cylinder{ <0,-20,0>, <0,20,0>, 5
	       texture{ Chrome_Texture
			pigment{ Gray15 }
			finish{ reflection .5
				ambient .3
				phong 0.4 phong_size 120 }
		      }
		 }
	 cylinder{ <0,20,0>, <0,30,0>, 5
		   texture{ pigment{ Silver }
			    finish{ ambient 0.2      diffuse 0.28
				    reflection 0.25  brilliance 7
				    phong 0.25       phong_size 130
				  }
			 }
		 }
	 cone{ <0,30,0>, 5 , <0,31,0>, 4
	       texture{ Chrome_Texture
			pigment{ Gray15 }
			finish{ phong 0.4 phong_size 20 }
		      }
	     }
	 difference{
		     cylinder{ <0,31,0>, <0,37,0>, 1.5 }  
		     box{ <-.85,30,-.85>, <.85,38,.85> }
		     texture{ Polished_Brass pigment{Bronze} }
		   }
	   } // XRayTool

#declare XRayTool2=
   union{ union{ sphere{ <0,0,0>, 2}
		 cylinder{ <0,0,0>, <0,95,0>, 2 }
		 sphere{ <0,95,0>, 2 }
		 texture{ pigment{Black}
			  finish{ phong .8 phong_size 10
				  ambient .6
				} 
			}
	       }
	  union{ cylinder{ <0,-25,0>, <0,0,0>, .5 }
		 box{ <-.1,-1,-.5>, <1,1,.5>
		      rotate z*45
		      scale <1,2,1>
		      translate <0,-25,0>
		    }
		 texture{ Chrome_Texture
			  pigment{ Gray15 }
			  finish{ reflection .95
				  ambient .3
				  phong 0.8 phong_size 120
				}
			}
	       }
	  rotate y*32
	  translate <0,0,2>
	} // XRayTool2

#declare Capillary=
   cylinder{ <0,0,-1>, <0,0,12>, .4
	     texture{Glass}
	   } // Capillary

#declare CapillaryHolder=
   difference{ union{ cylinder{ <0,0,0>, <0,0,6.5>, 1.5 }
		      cylinder{ <0,0,6.5>, <0,0,7>, 3   }
		    }
	       cylinder{ <0,0,-1>, <0,0,8>, .4 }
	       texture{ pigment{ color rgb <.962,1.,.969>}
			finish{ ambient 0.33  diffuse 0.35
				reflection 0.34  brilliance 9
				phong 0.49 phong_size 20
				     }
			 }
	      } // CapillaryHolder

#declare BlackScrew=
  difference{
	      union{ cone{ <3.3,0,1.15>, .85, <3.45,0,1.15>, 1  }
		     cone{ <3.45,0,1.15>,  1, <3.6,0,1.15>, .85 }
		     cylinder{ <3.6,0,1.15>, <3.8,0,1.15>, .85 }
		     cone{ <3.8,0,1.15>, .85, <3.95,0,1.15>, 1  }
		     cone{ <3.95,0,1.15>,  1, <4.1,0,1.15>, .85 }
		     cylinder{ <4.1,0,1.15>, <4.3,0,1.15>, .85 }
		     cone{ <4.2,0,1.15>, .85, <4.35,0,1.15>, 1  }
		     cone{ <4.35,0,1.15>,  1, <4.5,0,1.15>, .85 }
		   }
	      box{ <3.3,-.65,.5>, <4.7,.65,1.7> }
	      texture{ Polished_Chrome }
	    } // BlackScrew

#declare TopPiece=
  union{
	 difference{ union{ cylinder{ <0,0,0>, <0,0,2.3>, 3.5}
			    cone{ <0,0,2.3>, 3.5, <0,0,3>, 3}
			  }
		     plane{ -z, -3.25 rotate x*55 rotate z*180 }
		     plane{ -z, -3.25 rotate x*55 }
		     cylinder{ <0,0,1>, <0,0,4>, 1.5 }
		     cylinder{ <3.3,0,1.15>, <4,0,1.15>, 1 }
		     texture{ pigment{ Gray95 }
			      finish{ ambient 0.33  diffuse 0.7
				      reflection 0.2  brilliance 9
				      phong 0.49 phong_size 20
					   }
			       }
		   }
	 object{ BlackScrew }
       } // TopPiece

#declare MidPiece1=
  cylinder{ <0,0,0>, <0,0,1>, 2.5
	    texture{ pigment{color Grey }
		     normal{ dents .1 }
		     finish{ ambient 0.3     diffuse .7
			     reflection 0.45 brilliance 9
			     specular .13    roughness 0.1
			     phong .9        phong_size 80
			   }
		   }
	  } // MidPiece1

#declare Ring=
   difference{ difference{ cylinder{ <0,0,0>,  <0,0,1.5>, 6 }
			   cylinder{ <0,0,-1>, <0,0,3>, 4 }
			 }
	       cylinder { <5,0,.75>, <7,0,.75>, .5 }
	       sphere{ <6.4,0,.75>, .8 }
	       cylinder { <5,0,.75>, <7,0,.75>, .5  rotate z*90 }
	       sphere{ <6.4,0,.75>, .8 rotate z*90 }
	       cylinder { <5,0,.75>, <7,0,.75>, .5  rotate z*180 }
	       sphere{ <6.4,0,.75>, .8 rotate z*180 }
	       cylinder { <5,0,.75>, <7,0,.75>, .5  rotate z*270 }
	       sphere{ <6.4,0,.75>, .8 rotate z*270 }
	       texture{ Chrome_Metal }      
	     } // Ring

#declare Rod=
   union{ cylinder{ <-6,0,0>, <6,0,0>, .9 }
	  sphere{ <-6,0,0>, .9 scale <.9,1,1> }
	  sphere{ < 6,0,0>, .9 scale <.9,1,1> }
	  texture{Chrome_Metal}
	} // Rod

#declare Wires=
   difference{
	       union{ cone{ <0,0,  0>, 3.5, <0,0, .5>,   4 }
		      cone{ <0,0, .5>,   4, <0,0,  1>, 3.5 }
		      cone{ <0,0,  1>, 3.5, <0,0,1.5>,   4 }
		      cone{ <0,0,1.5>,   4, <0,0,  2>, 3.5 }
		      cone{ <0,0,  2>, 3.5, <0,0,2.5>,   4 }
		      cone{ <0,0,2.5>,   4, <0,0,  3>, 3.5 }
		      cone{ <0,0,  3>, 3.5, <0,0,3.5>,   4 }
		      cone{ <0,0,3.5>,   4, <0,0,  4>, 3.5 }
		      cone{ <0,0,  4>, 3.5, <0,0,4.5>,   4 }
		      cone{ <0,0,4.5>,   4, <0,0,  5>, 3.5 }
		      cone{ <0,0,  5>, 3.5, <0,0,5.5>,   4 }
		      cone{ <0,0,5.5>,   4, <0,0,  6>, 3.5 }
		      cone{ <0,0,  6>, 3.5, <0,0,6.5>,   4 }
		      cone{ <0,0,6.5>,   4, <0,0,  7>, 3.5 }
		   }
	       box{ <-3.2,-5,-1>, <3.2,5,8> inverse }
	       union{
		      cylinder{ <-4,0,2>, <4,0,2>, 1 }
		      cylinder{ <-4,0,5>, <4,0,5>, 1 }
		      box{ <-4,-1,2>,     <4,1,5>    }
		    }
	       texture{ pigment{color Slate_Grey }
			finish {ambient 0.2    diffuse .07
				reflection 0.6 brilliance 9
				specular .13   roughness 0.1
				phong .3       phong_size 80
			       }
		      }
	     } // Wires

#declare HeightAdjust=
   union{
	  object{ Wires }
	  object{ Ring translate <0,0,1.0> rotate z*12}
	  object{ Rod  translate <0,0,3.4> }
	  object{ Ring translate <0,0,4.3> rotate z*-39}
	} // HeightAdjust

#declare MidPiece2=
  cylinder{ <0,0,0>, <0,0,.7>, 2.5
	    texture{ Chrome_Metal }      
	  } // MidPiece2

#declare Trapezium=
  union{
	difference{ box{ <0,-5.5,0>, <4,5.5,3.5> }
		    plane{ -z,4.9 rotate x*243 inverse }
		    plane{ -z,4.9 rotate x*243 rotate z*180 inverse }
	    }
	difference{ plane{ -z,4.9 rotate x*243 }
		    box{ <0,-5.5,0>, <4,5.5,3.5>  inverse }
		  }
	difference{ plane{ -z,4.9 rotate x*243 rotate z*180 }
		    box{ <0,-5.5,0>, <4,5.5,3.5>  inverse }
		  }
	texture{ pigment{ color White }
		 finish { ambient 0.4     diffuse .5
			  reflection 0.35 brilliance 12
			  specular .35    roughness 0.3
			  phong .5        phong_size 60
			}
	       }
	translate <0,0,-1000>
       } // Trapezium

#declare XYShifter=
  union{ box { <8,7.5,0>, <4.,-7.5,.6> }
	 cylinder{ <-10,0,.3>, <10,0,.3>, 1.1 }
	 difference{
		     box{ <-12.6,-.9,-.9>, <-10,.9,.9> rotate x*35 }
		     cylinder{ <-13,0,0>, <-9,0,0>, .8 }
		     translate <0,0,.3>
		     texture{ Polished_Brass
			      pigment{ Gray75 }
			      finish{ phong .7 phong_size 10 }
			    }
		   }
	 difference{
		     box{ <12,-.9,-.9>, <10,.9,.9> rotate x*35 }
		     cylinder{ <13,0,0>, <9,0,0>, .8 }
		     translate <0,0,.3>
		     texture{ Polished_Brass
			      pigment{ Gray75 }
			      finish{ phong .7 phong_size 10 }
			    }
		   }
	 texture{ pigment{ color Gray35 }
		  finish { ambient 0.3     diffuse .7
			   reflection 0.45 brilliance 9
			   specular .13
			   phong .2    phong_size 80
			 } 
		}      
       } // XYShifter

#declare Screw=
   difference{ cylinder {<0,0,0>, <0,0,.3>, 1.3}
	       box{ <-.3,-1.5,.15>, <.3,1.5,.4>}
	       texture{Polished_Chrome}
	     } // Screw

#declare XAdjust=
  union{
	 difference{ box{ <-10,-10,0>, <10,10,5>}
		     cone{ <0,0,0>, 12.5, <0,0,5>, 11.3 inverse }
		     object{ Trapezium translate <4,0,1002.1> }
		     object{ Trapezium translate <7,0,1002.1> }
		     object{ Trapezium translate <-10.2,0,1002.1> }
		     box{ <11,-12,3.7>, <6,12,4.4> }
		     cylinder{ <0,0,4.6>, <0,0,6>, 1.4 translate <7, 6,0> }
		     cylinder{ <0,0,4.6>, <0,0,6>, 1.4 translate <7,-6,0> }
		     sphere{<0,10.2,3>, 1.25 }
		     texture{ pigment{color Grey }
			      normal{ dents .1 }
			      finish{ ambient 0.3     diffuse .7
				      reflection 0.45 brilliance 9
				      specular .13    roughness 0.1
				      phong .9        phong_size 80
				    }
			    }
		   }
	 object{ BlackScrew rotate z*90 translate <0,5.7,1.85> }
	 object{ Screw      rotate z*15 translate <7, 6, 4.6> }
	 object{ Screw      rotate z*65 translate <7, -6, 4.6> }
	 object{ XYShifter              translate <0,  0, 3.8> }
	} // XAdjust

#declare XRail1=
  intersection{
		difference{ box{ <-14.4,10,-3>, <14.4,8,4.2>}
			    cylinder{ <0,-14.5,0>, <0,14.5,0>, 14.5
				      scale <1,1,.29> translate <0,0,5>
				    }
			  }
		cylinder{ <0,-14.5,0>, <0,14.5,0>, 14.5
			  scale <1,1,.29> translate <0,0,3.5>
			}
	     } // XRail1

#declare XRail2=
  intersection{
		difference{ box{ <-14.4,10,-3>, <14.4,6.5,4.2>}
			    cylinder{ <0,-14.5,0>, <0,14.5,0>, 14.5
				      scale <1,1,.29> translate <0,0,5>
				    }
			  }
		cylinder{ <0,-14.5,0>, <0,14.5,0>, 14.5
			  scale <1,1,.29> translate <0,0,3.5>
			}
	     } // XRail2

#declare SquareScrew=
   difference{
	       box{ <2,-.9,-.9>, <0,.9,.9> rotate x*23 }
	       cylinder{ <3,0,0>, <-1,0,0>, .8 }
	       translate <0,0,.3>
  texture{Polished_Chrome}
	     } // SquareScrew

#declare XBow=
   union{
      difference{
	 union{
	   difference{ box{ <-20,-10,0>, <20,10,4.2>}
		       cylinder{ <0,-14.5,0>, <0,14.5,0>, 14.5
				 scale <1,1,.29> translate <0,0,5>
			       }
		     }
	   object{ XRail1 translate <0,0,1.4> }
	   object{ XRail1 rotate z*180 translate <0,0,1.4> }
	   object{ XRail2 translate <0,0,2.8> }
	   object{ XRail2 rotate z*180 translate <0,0,2.8> }
	 }
	 cylinder{ <0,0,-3>, <0,0,8>, 15.5 inverse }
	 box{ <-20,-2,-1.5>, <-16,2,2> pigment{ Gray20 } }
	 box{ < 15,-2,-1.5>, < 20,2,2> pigment{ Gray20 } }
	 texture{ pigment{color Gray50 }
		  normal{ dents .1 }
		  finish{ ambient 0.4     diffuse .7
			  reflection 0.65 brilliance 11
			  specular .67    roughness 0.1
			  phong .9        phong_size 180
			}
		}
    } // difference
      object{ SquareScrew translate <15,0,0.1> }
      object{ SquareScrew rotate z*180 translate <15,0,0.1> }
   } // XBow


#declare YAdjust=
  union{
	 difference{
		     union{ box{ <-10,-10,3>, <10,10,5> }
			    cylinder{ <-10,0,0>, <10,0,0>, 10
				      scale <1,1,.2> translate <0,0,3>
				    }
			  }
		     cylinder{ <0,0,-5>, <0,0,5>, 12.5 inverse }
		     object{ Trapezium translate <4,0,1002.1> }
		     object{ Trapezium translate <7,0,1002.1> }
		     object{ Trapezium translate <-10.2,0,1002.1> }
		     box{ <11,-12,3.7>, <6,12,4.4> }
		     sphere{<0,10.2,3>, 1.25 }
		     texture{ pigment{color Grey }
			      normal{ dents .1 }
			      finish{ ambient 0.3     diffuse .7
				      reflection 0.45 brilliance 9
				      specular .13    roughness 0.1
				      phong .9    phong_size 80
				    }
			    }
		   }
	 object{ BlackScrew rotate z*90 translate <0,5.7,1.85> }
	 object{ XYShifter              translate <0,  0, 3.4> }
	 rotate z*-90
       } // YAdjust

#declare MidPiece3=
	 difference{ box{ <-9,-9.9,-1>, <9,9.9,2>}
		     object{ YAdjust }
		     object{ XRail1 translate <0,0,-1.4> }
		     object{ XRail1 rotate z*180 translate <0,0,-1.4> }
		     object{ XRail2 translate <0,0,0> }
		     object{ XRail2 rotate z*180 translate <0,0,0> }
		     cylinder{ <0,0,-5>, <0,0,5>, 12.5 inverse }
		     texture{ pigment{color Grey }
			      normal{ dents .1 }
			      finish{ ambient 0.3     diffuse .7
				      reflection 0.45 brilliance 9
				      specular .13    roughness 0.1
				      phong .9        phong_size 80
				    }
			    }
		   } // MidPiece3

#declare YRail1=
  intersection{
		difference{ box{ <-18.4,10,-3>, <18.4,8,4.2> }
			    cylinder{ <0,-18.5,0>, <0,18.5,0>, 18.5
				      scale <1,1,.29> translate <0,0,4>
				    }
			  }
		cylinder{ <0,-18.5,0>, <0,18.5,0>, 18.5
			  scale <1,1,.29> translate <0,0,2.5>
			}
	    } // Yrail1

#declare YRail2=
  intersection{
		difference{ box{ <-18.4,10,-3>, <18.4,6.5,4.2> }
			    cylinder{ <0,-18.5,0>, <0,18.5,0>, 18.5
				      scale <1,1,.29> translate <0,0,4>
				    }
			  }
		cylinder{ <0,-18.5,0>, <0,18.5,0>, 18.5
			  scale <1,1,.29> translate <0,0,2.5>
			}
	    } // YRail2

#declare YBow=
   union{
      object{ SquareScrew translate <14.8,0,-2.7> }
      object{ SquareScrew translate <14.8,0,-2.7> rotate z*180 }
      difference{
	 union{
	    difference{ box{ <-20,-10,-3>, <20,10,4.2> }
			cylinder{ <0,-18.5,0>, <0,18.5,0>, 18.5
				  scale <1,1,.29> translate <0,0,4>
				}
		      }
	    object{ YRail1 translate <0,0,1.5> }
	    object{ YRail2 translate <0,0,3.0> }
	    object{ YRail1 rotate z*180 translate <0,0,1.5> }
	    object{ YRail2 rotate z*180 translate <0,0,3.0> }
	      }
	 cylinder{ <0,0,-8>, <0,0,8>, 17.5 inverse }
	 box{ <-20,-2,-3.5>, <-16,2,-.5> pigment{ Gray20 } }
	 box{ < 15,-2,-3.5>, < 20,2,-.5> pigment{ Gray20 } }
		}
      rotate z*-90
      texture { pigment{color Gray70 }
		normal{ dents .1 }
		finish{ ambient 0.4     diffuse .7
			reflection 0.65 brilliance 11
			specular .76    roughness 0.1
			phong .93       phong_size 180
		      }
	      }
   } // Ybow

#declare MidPiece4=
   difference{ box{ <-9,-9.9,-4>, <9,9.9,1.5>}
	       object{ YBow translate <0,0,-2> }
	       texture{ pigment{Gray95 }
			finish { metallic
				 ambient 0.45    diffuse 0.65
				 reflection 0.65 brilliance 9
				 phong 1         phong_size 70
			       }
		     }
	     } // MidPiece4

#declare MidPiece5=
   union{
	  cylinder{ <0,0,0>, <0,0,1.3>, 10.4 }
	  cylinder{ <0,0,1.3>, <0,0,2>, 7 }
	  texture{Chrome_Metal}
	} // MidPiece5

#declare BottomRing=
   cylinder{ <0,0,0>, <0,0,5>, 16.5
	     texture{ Chrome_Metal }
	   } // BottomRing

#declare ClipBox=
   box{ <-1.98,-1.98,-1>, <1.98,1.98,7>
	rotate z*45.
	translate <19,0,0>
      } // ClipBox

#declare ClipBox2=
   union{ object{ ClipBox}
	  object{ ClipBox rotate z*4.5 }
	} // ClipBox2

#declare ClipBox3=
   union{ object{ ClipBox2}
	  object{ ClipBox2 rotate z*9  }
	  object{ ClipBox2 rotate z*18 }
	  object{ ClipBox2 rotate z*27 }
	  object{ ClipBox2 rotate z*36 }
	  object{ ClipBox2 rotate z*45 }
	} // ClipBox3

#declare ClipBox4=
   union{ object{ ClipBox3}
	  object{ ClipBox3 rotate z*45  }
	  object{ ClipBox3 rotate z*90  }
	  object{ ClipBox3 rotate z*135 }
	  object{ ClipBox3 rotate z*180 }
	  object{ ClipBox3 rotate z*225 }
	  object{ ClipBox3 rotate z*270 }
	  object{ ClipBox3 rotate z*315 }
	} // ClipBox4

#declare FastenRing=
   difference{
	       union{ cone{ <0,0,0>, 16.5, <0,0,1>, 17.5 }
		      cylinder{ <0,0,1>,   <0,0,4>, 17.5 }
		      cone{ <0,0,4>, 17.5, <0,0,5>, 16.5 }
		    }
	       object{ ClipBox4 }
	       texture{ pigment{color Gray25 }
			finish{ ambient 0.4     diffuse .5
				reflection 0.25 brilliance 12
				specular .4     roughness 0.3
				phong .15       phong_size 60
			      }
		      }
	     } // FastenRing

#declare GonioHead=
  union{
	 object{ BottomRing      translate <0,0,  0  > }
	 object{ FastenRing      translate <0,0,  5  > }
	 object{ MidPiece5       translate <0,0, 10  > }
	 object{ YBow            translate <0,0, 15  > }
	 object{ MidPiece4       translate <0,0, 17.2> }
	 object{ XBow            translate <0,0, 17.2> }
	 object{ MidPiece3       translate <0,0, 20  > }
	 object{ YAdjust         translate <0,0, 20  > }
	 object{ XAdjust         translate <0,0, 24.9> }
	 object{ MidPiece2       translate <0,0, 29.9> }
	 object{ HeightAdjust    translate <0,0, 30.6> }
	 object{ MidPiece1       translate <0,0, 37.6> }
	 object{ TopPiece        translate <0,0, 38.6> }
	 object{ CapillaryHolder translate <0,0, 35.3> }
	 object{ Capillary       translate <0,0, 42.3> }
       } // GonioHead

#declare FilterPaper=
   cylinder{ <0,0,0>, <0,0,.2>, 40
		  texture{ pigment{ Linen }
			       normal{ bumps .15  scale .25 }
			     }
	   } // FilterPaper

//****************************************************************

// Actual Scene

//****************************************************************

camera{ location <90,90,20>
	sky <0,0,1>
	up <0,0,1>
	right <1.3333,0,0>
	look_at <6,-3,7>
      }

union{ light_source{ <45,45,80> color rgb <1.7,1.7,1.7> /* was <1.7,1.7,1.7> */
		     spotlight point_at <0,-20,0>
		     radius  100 falloff 60 tightness 5
		   }           
       object{ GonioHead }
       translate < 2, 38,  0> 
      }

object{ Crystals rotate z*35 translate <42,27,.1> }
object{ FilterPaper           translate < 36, 20,  0> }
object{ XRayTool2 rotate z*25 translate <34, 67,  0> }
object{ XRayTool rotate z*75 translate <15, -35,  5> }
object{ plane{ z,0
	       texture{ pigment{ rgb <.587,.563,.469> }
			finish{ ambient 0.2 reflection .3 }
		      }
	     }
      }
