// "USENET"
// (c) 1995, Chris Herborth (cherborth@semprini.waterloo-rdp.on.ca)
//
// March 6/95
//
// POV-Ray 2.x scene description
//
// Created for the March '95 comp.graphics.raytracing competition.  This
// month's subject was "The Internet".
//
// This is my depiction of USENET.  Enjoy.

#include "colors.inc"	// When will those Americans learn to spell?
#include "textures.inc"
#include "shapes.inc"

// Here's a really great texture from the DKB-L (DKB Trace/POV-Ray
// mailing list).
#include "flame.inc"

// Create a light source
object {
	light_source {
		< -10, 5, -10 >
		colour White
	}
}
object {
	light_source {
		< 10, 5, -10 >
		colour White
	}
}

// Create a camera
camera {
	location  < 0,   0, 0 >
	look_at   < 0,   0, 1 >
	direction < 0,   0, 1 >
	up        < 0,   1, 0 >
	right     < 4/3, 0, 0 >

	translate < 0, 0, -5 >
}

// Create my interpretation of USENET! :-)

#declare UsenetTexture = texture {
	Chrome_Metal
}

#declare Eye = object {
	sphere {
		< 0, 0, 0 > 1
		scale 1
		texture { UsenetTexture }
	}
}

#declare Eyes = object {
	union {
		object {
			Eye
			translate < -2, 2, 0 >
		}
		object {
			Eye
			translate < -2, -2, 0 >
		}
	}
}

#declare Nose = object {
	cylinder {
		< -1, 0, 0 >
		< 4/3, 0, 0 >
		.5
	}
	texture { UsenetTexture }
}

#declare Mouth = object {
	difference {
		sphere {
			< 0, 0, 0 >
			2
			translate < 2, 0, 0 >
		}
		cylinder {
			< 0, 0, -2 >
			< 0, 0, 2 >
			3
		}
	}
	texture { UsenetTexture }
}

#declare UsenetFace = object {
	union {
		object { Eyes }
		object { Nose }
		object { Mouth }
	}
}

// Draw our USENET Face
object {
	UsenetFace
	scale < .5, .5, .5 >
}

