#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "rajtex.inc"

#default {
	pigment
		{
                color VLightGrey
		}
	finish
		{
                ambient .4
		diffuse .3
                phong .7
		}
	}


camera { 
        location        <5.72000, 9.58000, -35.48000>
        direction       <0, 0, 1.0>
        up              <0, 1, 0>
        right           <1.3333, 0, 0 >
        look_at <3.64000, 7.34667, 1.12000>
}

#declare Master =  union
{

	/*Start Definition of   Cube0*/

   object
   {
	box
		{<-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0> 
		scale < 2.38000, 2.10000, 1.84000>
		translate < 0.30000, 0.12000, 0.00000> 
                pigment { image_map { gif "Qm4.gif" }}
                }  
   } 


   object
   {
        box
                {<-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0> 
                scale < 2.64000, 2.56000, 1.36000>
                translate < 0.24000, 0.24000, -0.24000> 
                }  
   } 


   object
   {
        box
                {<-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0> 
                scale < 1.84000, 3.52000, 1.52000>
                translate < 5.36000, -0.80000, 0.00000> 
                }  
           } 
   }


	/*Start Definition of   bicorn*/

   object
   {
        quartic {
        < 1.0, 0.0,   0.0,   0.0,  1.0,   0.0,   4.0,   2.0,   0.0, -2.0,
          0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
          0.0, 0.0,   0.0,   1.0,  0.0,   3.0,   0.0,   4.0,   0.0, -4.0,
          1.0, 0.0,  -2.0,   0.0,  1.0 >
        scale <1.0, 2.0, 1.0>
        translate <0.0, -1.0, 0.0>


	scale < 2.64000, 0.99999, 1.72372>
	translate < 0.24000, -3.48000, -0.12373> 
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Cube4*/

   object
   {
	box
		{<-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0> 
		scale < 16.61715, 0.32000, 6.28572>
		translate < -0.24000, -4.72000, 0.00000>
                texture { DMFDarkOak }
                }  
   } 

   object
   {
	box
		{<-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0> 
		scale < 1.71429, 0.42857, 1.42857>
		translate < -7.57143, -3.71429, -4.14286> 
                }  
   } 

   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.56357, 1.61928, 0.42857>
		translate < -7.57929, -2.33357, -4.00000>
                pigment { color Black }
                }  
   } 

   object
   {
	cylinder
                { <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,0.5
                scale < 0.56357, 1.71928, 0.42857>
		translate < -7.57929, -2.33357, -4.00000>
                pigment { color Red }
                }  
   } 

   object
   {
	box
		{<-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0> 
		scale < 1.14286, 0.42857, 1.85714>
		translate < -5.42857, -3.71429, 0.14286> 
		pigment
		{
		colour rgbf <0.000000, 0.000000, 0.000000, 0.000000>
                }  
                }  
   } 

   object
   {
	box
		{<-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0> 
		scale < 2.14285, 0.14286, 1.71428>
		translate < 8.71429, -4.00000, -4.14286>
                pigment { color MediumBlue }
                }  
   } 

	/*Start Definition of   CylX18*/

   object
   {
	cylinder
		{ <-1.0, 0.0, 0.0>,<1.0, 0.0, 0.0>,1 
		scale < 7.35163, 2.03174, 1.88617>
		rotate < 0, 89, 0>
		translate < 33.68242, 20.43158, 16.61620> 
		}  /* End Shape */
   } /*End object*/

   object
   {
	union
	{
		triangle  { <-1.01483, 2.06250, -1.20000>, <-0.85018, 2.06250, 0.85714>, <-0.88078, 2.06250, -1.20000> }
		triangle  { <-1.01483, 2.06250, -1.20000>, <-0.85018, 2.06250, 0.85714>, <-0.98372, 2.06250, 0.89145> }
		triangle  { <-0.88078, 2.06250, -1.20000>, <-2.18559, -2.93750, 1.20000>, <-2.22130, -2.93750, -1.20000> }
		triangle  { <-0.88078, 2.06250, -1.20000>, <-2.18559, -2.93750, 1.20000>, <-0.85018, 2.06250, 0.85714> }
		triangle  { <-2.22130, -2.93750, -1.20000>, <-0.98372, -2.93750, 0.89145>, <-1.01483, -2.93750, -1.20000> }
		triangle  { <-2.22130, -2.93750, -1.20000>, <-0.98372, -2.93750, 0.89145>, <-2.18559, -2.93750, 1.20000> }
		triangle  { <-1.01483, -2.93750, -1.20000>, <0.35170, 1.93750, 0.54858>, <0.32569, 1.93750, -1.20000> }
		triangle  { <-1.01483, -2.93750, -1.20000>, <0.35170, 1.93750, 0.54858>, <-0.98372, -2.93750, 0.89145> }
		triangle  { <0.32569, 1.93750, -1.20000>, <1.82066, 1.93750, 0.17142>, <1.80027, 1.93750, -1.20000> }
		triangle  { <0.32569, 1.93750, -1.20000>, <1.82066, 1.93750, 0.17142>, <0.35170, 1.93750, 0.54858> }
		triangle  { <1.80027, 1.93750, -1.20000>, <2.22130, 2.93750, 0.06858>, <2.20242, 2.93750, -1.20000> }
		triangle  { <1.80027, 1.93750, -1.20000>, <2.22130, 2.93750, 0.06858>, <1.82066, 1.93750, 0.17142> }
		triangle  { <2.20242, 2.93750, -1.20000>, <-1.51789, 2.93750, 1.02858>, <-1.55104, 2.93750, -1.20000> }
		triangle  { <2.20242, 2.93750, -1.20000>, <-1.51789, 2.93750, 1.02858>, <2.22130, 2.93750, 0.06858> }
		triangle  { <-1.55104, 2.93750, -1.20000>, <-2.05206, 1.93750, 1.16572>, <-2.08724, 1.93750, -1.20000> }
		triangle  { <-1.55104, 2.93750, -1.20000>, <-2.05206, 1.93750, 1.16572>, <-1.51789, 2.93750, 1.02858> }
		triangle  { <-2.08724, 1.93750, -1.20000>, <-0.85018, 2.06250, 0.85714>, <-0.88078, 2.06250, -1.20000> }
		triangle  { <-2.08724, 1.93750, -1.20000>, <-0.85018, 2.06250, 0.85714>, <-2.05206, 1.93750, 1.16572> }

		translate < 20.82130, 6.93750, 0.00000>
                texture { Silver_Texture }
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Spli42*/

   object
   {
	union
	{
		triangle  { <-1.48759, 2.56250, -1.22296>, <-2.63210, -2.43750, 1.28571>, <-2.65179, -2.43750, -1.22296> }
		triangle  { <-1.48759, 2.56250, -1.22296>, <-2.63210, -2.43750, 1.28571>, <-1.47233, 2.56250, 0.72125> }
		triangle  { <-2.65179, -2.43750, -1.22296>, <-1.34346, -2.43750, 0.65855>, <-1.35823, -2.43750, -1.22296> }
		triangle  { <-2.65179, -2.43750, -1.22296>, <-1.34346, -2.43750, 0.65855>, <-2.63210, -2.43750, 1.28571> }
		triangle  { <-1.35823, -2.43750, -1.22296>, <-0.82802, -0.31250, 0.40763>, <-0.84081, -0.31250, -1.22296> }
		triangle  { <-1.35823, -2.43750, -1.22296>, <-0.82802, -0.31250, 0.40763>, <-1.34346, -2.43750, 0.65855> }
		triangle  { <-0.84081, -0.31250, -1.22296>, <0.58948, -0.31250, -0.28223>, <0.58210, -0.31250, -1.22296> }
		triangle  { <-0.84081, -0.31250, -1.22296>, <0.58948, -0.31250, -0.28223>, <-0.82802, -0.31250, 0.40763> }
		triangle  { <0.58210, -0.31250, -1.22296>, <0.20289, -2.56250, -0.09408>, <0.19403, -2.56250, -1.22296> }
		triangle  { <0.58210, -0.31250, -1.22296>, <0.20289, -2.56250, -0.09408>, <0.58948, -0.31250, -0.28223> }
		triangle  { <0.19403, -2.56250, -1.22296>, <1.62039, -2.56250, -0.78395>, <1.61694, -2.56250, -1.22296> }
		triangle  { <0.19403, -2.56250, -1.22296>, <1.62039, -2.56250, -0.78395>, <0.20289, -2.56250, -0.09408> }
		triangle  { <1.61694, -2.56250, -1.22296>, <2.65129, 2.56250, -1.28571>, <2.65179, 2.56250, -1.22296> }
		triangle  { <1.61694, -2.56250, -1.22296>, <2.65129, 2.56250, -1.28571>, <1.62039, -2.56250, -0.78395> }
		triangle  { <2.65179, 2.56250, -1.22296>, <1.36266, 2.56250, -0.65855>, <1.35823, 2.56250, -1.22296> }
		triangle  { <2.65179, 2.56250, -1.22296>, <1.36266, 2.56250, -0.65855>, <2.65129, 2.56250, -1.28571> }
		triangle  { <1.35823, 2.56250, -1.22296>, <0.97607, 0.68750, -0.47039>, <0.97017, 0.68750, -1.22296> }
		triangle  { <1.35823, 2.56250, -1.22296>, <0.97607, 0.68750, -0.47039>, <1.36266, 2.56250, -0.65855> }
		triangle  { <0.97017, 0.68750, -1.22296>, <-0.69915, 0.81250, 0.34493>, <-0.71145, 0.81250, -1.22296> }
		triangle  { <0.97017, 0.68750, -1.22296>, <-0.69915, 0.81250, 0.34493>, <0.97607, 0.68750, -0.47039> }
		triangle  { <-0.71145, 0.81250, -1.22296>, <-0.18370, 2.56250, 0.09408>, <-0.19403, 2.56250, -1.22296> }
		triangle  { <-0.71145, 0.81250, -1.22296>, <-0.18370, 2.56250, 0.09408>, <-0.69915, 0.81250, 0.34493> }
		triangle  { <-0.19403, 2.56250, -1.22296>, <-1.21461, 2.56250, 0.59579>, <-1.22888, 2.56250, -1.22296> }
		triangle  { <-0.19403, 2.56250, -1.22296>, <-1.21461, 2.56250, 0.59579>, <-0.18370, 2.56250, 0.09408> }

		translate < 0.93750, 15.68750, 0.00000>
                texture { Silver_Texture }
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Spli44*/

   object
   {
	union
	{
		triangle  { <-1.21241, 1.78500, -0.57892>, <-2.28973, -2.62500, 1.00000>, <-2.30357, -2.62500, -0.57892> }
		triangle  { <-1.21241, 1.78500, -0.57892>, <-2.28973, -2.62500, 1.00000>, <-1.20272, 1.78500, 0.52631> }
		triangle  { <-2.30357, -2.62500, -0.57892>, <1.21287, -2.62500, -0.52631>, <1.21241, -2.62500, -0.57892> }
		triangle  { <-2.30357, -2.62500, -0.57892>, <1.21287, -2.62500, -0.52631>, <-2.28973, -2.62500, 1.00000> }
		triangle  { <1.21241, -2.62500, -0.57892>, <1.45442, -1.57500, -0.63159>, <1.45489, -1.57500, -0.57892> }
		triangle  { <1.21241, -2.62500, -0.57892>, <1.45442, -1.57500, -0.63159>, <1.21287, -2.62500, -0.52631> }
		triangle  { <1.45489, -1.57500, -0.57892>, <-0.71961, -1.57500, 0.31579>, <-0.72744, -1.57500, -0.57892> }
		triangle  { <1.45489, -1.57500, -0.57892>, <-0.71961, -1.57500, 0.31579>, <1.45442, -1.57500, -0.63159> }
		triangle  { <-0.72744, -1.57500, -0.57892>, <-0.35726, -0.21000, 0.15790>, <-0.36372, -0.21000, -0.57892> }
		triangle  { <-0.72744, -1.57500, -0.57892>, <-0.35726, -0.21000, 0.15790>, <-0.71961, -1.57500, 0.31579> }
		triangle  { <-0.36372, -0.21000, -0.57892>, <1.33365, -0.21000, -0.57892>, <-0.35726, -0.21000, 0.15790> }
		triangle  { <1.33365, -0.21000, -0.57892>, <1.69598, 0.73500, -0.73682>, <1.69737, 0.73500, -0.57892> }
		triangle  { <1.69737, 0.73500, -0.57892>, <1.81677, 0.73500, -0.78944>, <1.81861, 0.73500, -0.57892> }
		triangle  { <1.69737, 0.73500, -0.57892>, <1.81677, 0.73500, -0.78944>, <1.69598, 0.73500, -0.73682> }
		triangle  { <1.81861, 0.73500, -0.57892>, <-0.23649, 0.73500, 0.10528>, <-0.24248, 0.73500, -0.57892> }
		triangle  { <1.81861, 0.73500, -0.57892>, <-0.23649, 0.73500, 0.10528>, <1.81677, 0.73500, -0.78944> }
		triangle  { <-0.24248, 0.73500, -0.57892>, <0.12586, 1.78500, -0.05262>, <0.12124, 1.78500, -0.57892> }
		triangle  { <-0.24248, 0.73500, -0.57892>, <0.12586, 1.78500, -0.05262>, <-0.23649, 0.73500, 0.10528> }
		triangle  { <0.12124, 1.78500, -0.57892>, <1.93754, 1.78500, -0.84210>, <1.93985, 1.78500, -0.57892> }
		triangle  { <0.12124, 1.78500, -0.57892>, <1.93754, 1.78500, -0.84210>, <0.12586, 1.78500, -0.05262> }
		triangle  { <1.93985, 1.78500, -0.57892>, <2.29989, 2.62500, -1.00000>, <2.30357, 2.62500, -0.57892> }
		triangle  { <1.93985, 1.78500, -0.57892>, <2.29989, 2.62500, -1.00000>, <1.93754, 1.78500, -0.84210> }
		triangle  { <2.30357, 2.62500, -0.57892>, <-0.71961, 2.62500, 0.31579>, <-0.72744, 2.62500, -0.57892> }
		triangle  { <2.30357, 2.62500, -0.57892>, <-0.71961, 2.62500, 0.31579>, <2.29989, 2.62500, -1.00000> }
		triangle  { <-0.72744, 2.62500, -0.57892>, <-1.20272, 1.68000, 0.52631>, <-1.21241, 1.68000, -0.57892> }
		triangle  { <-0.72744, 2.62500, -0.57892>, <-1.20272, 1.68000, 0.52631>, <-0.71961, 2.62500, 0.31579> }

		translate < 15.87500, 7.00000, 0.00000>
                texture { Silver_Texture }
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Spli46*/

   object
   {
	union
	{
		triangle  { <0.64508, 4.43750, -1.14286>, <-2.05337, -4.43750, 1.14286>, <-2.07357, -4.43750, -1.14286> }
		triangle  { <0.64508, 4.43750, -1.14286>, <-2.05337, -4.43750, 1.14286>, <0.65493, 4.43750, -0.02789> }
		triangle  { <-2.07357, -4.43750, -1.14286>, <-0.63473, -4.43750, 0.52959>, <-0.64951, -4.43750, -1.14286> }
		triangle  { <-2.07357, -4.43750, -1.14286>, <-0.63473, -4.43750, 0.52959>, <-2.05337, -4.43750, 1.14286> }
		triangle  { <-0.64951, -4.43750, -1.14286>, <2.07357, 4.43750, -0.64111>, <2.06914, 4.43750, -1.14286> }
		triangle  { <-0.64951, -4.43750, -1.14286>, <2.07357, 4.43750, -0.64111>, <-0.63473, -4.43750, 0.52959> }
		triangle  { <2.06914, 4.43750, -1.14286>, <0.65493, 4.43750, -0.02789>, <0.64508, 4.43750, -1.14286> }
		triangle  { <2.06914, 4.43750, -1.14286>, <0.65493, 4.43750, -0.02789>, <2.07357, 4.43750, -0.64111> }

		translate < -14.49786, 5.56250, 0.00000>
                texture { Silver_Texture }
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Spli49*/

   object
   {
	union
	{
		triangle  { <-1.21233, 2.49219, -1.14286>, <-2.59616, -2.75000, 1.14286>, <-2.61607, -2.75000, -1.14286> }
		triangle  { <-1.21233, 2.49219, -1.14286>, <-2.59616, -2.75000, 1.14286>, <-1.19776, 2.49219, 0.52959> }
		triangle  { <-2.61607, -2.75000, -1.14286>, <-1.32489, -2.75000, 0.58537>, <-1.33994, -2.75000, -1.14286> }
		triangle  { <-2.61607, -2.75000, -1.14286>, <-1.32489, -2.75000, 0.58537>, <-2.59616, -2.75000, 1.14286> }
		triangle  { <-1.33994, -2.75000, -1.14286>, <-0.43500, 1.46094, 0.19514>, <-0.44665, 1.46094, -1.14286> }
		triangle  { <-1.33994, -2.75000, -1.14286>, <-0.43500, 1.46094, 0.19514>, <-1.32489, -2.75000, 0.58537> }
		triangle  { <-0.44665, 1.46094, -1.14286>, <1.09054, -2.66406, -0.47386>, <1.08471, -2.66406, -1.14286> }
		triangle  { <-0.44665, 1.46094, -1.14286>, <1.09054, -2.66406, -0.47386>, <-0.43500, 1.46094, 0.19514> }
		triangle  { <1.08471, -2.66406, -1.14286>, <2.36182, -2.66406, -1.03134>, <2.36085, -2.66406, -1.14286> }
		triangle  { <1.08471, -2.66406, -1.14286>, <2.36182, -2.66406, -1.03134>, <1.09054, -2.66406, -0.47386> }
		triangle  { <2.36085, -2.66406, -1.14286>, <2.61607, 2.75000, -1.14286>, <2.36182, -2.66406, -1.03134> }
		triangle  { <2.61607, 2.75000, -1.14286>, <1.47192, 2.75000, -0.64111>, <1.46755, 2.75000, -1.14286> }
		triangle  { <1.46755, 2.75000, -1.14286>, <1.47192, -0.25781, -0.64111>, <1.46755, -0.25781, -1.14286> }
		triangle  { <1.46755, 2.75000, -1.14286>, <1.47192, -0.25781, -0.64111>, <1.47192, 2.75000, -0.64111> }
		triangle  { <1.46755, -0.25781, -1.14286>, <-0.05361, 2.49219, 0.02789>, <-0.06381, 2.49219, -1.14286> }
		triangle  { <1.46755, -0.25781, -1.14286>, <-0.05361, 2.49219, 0.02789>, <1.47192, -0.25781, -0.64111> }
		triangle  { <-0.06381, 2.49219, -1.14286>, <-0.94351, 2.49219, 0.41812>, <-0.95710, 2.49219, -1.14286> }
		triangle  { <-0.06381, 2.49219, -1.14286>, <-0.94351, 2.49219, 0.41812>, <-0.05361, 2.49219, 0.02789> }

		translate < -9.81250, 7.25000, 0.00000>
                texture { Silver_Texture }
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Spli51*/

   object
   {
	union
	{
		triangle  { <-1.78692, 2.55588, -0.50122>, <-2.55783, -2.68529, 1.28571>, <-2.57143, -2.68529, -0.50122> }
		triangle  { <-1.78692, 2.55588, -0.50122>, <-2.55783, -2.68529, 1.28571>, <-1.77631, 2.55588, 0.89349> }
		triangle  { <-2.57143, -2.68529, -0.50122>, <-1.68948, -2.68529, 0.84987>, <-1.69976, -2.68529, -0.50122> }
		triangle  { <-2.57143, -2.68529, -0.50122>, <-1.68948, -2.68529, 0.84987>, <-2.55783, -2.68529, 1.28571> }
		triangle  { <-1.69976, -2.68529, -0.50122>, <-1.16846, 0.03235, 0.58840>, <-1.17676, 0.03235, -0.50122> }
		triangle  { <-1.69976, -2.68529, -0.50122>, <-1.16846, 0.03235, 0.58840>, <-1.68948, -2.68529, 0.84987> }
		triangle  { <-1.17676, 0.03235, -0.50122>, <0.22090, 0.03235, -0.10895>, <0.21792, 0.03235, -0.50122> }
		triangle  { <-1.17676, 0.03235, -0.50122>, <0.22090, 0.03235, -0.10895>, <-1.16846, 0.03235, 0.58840> }
		triangle  { <0.21792, 0.03235, -0.50122>, <0.82875, -0.16176, -0.41403>, <0.82809, -0.16176, -0.50122> }
		triangle  { <0.21792, 0.03235, -0.50122>, <0.82875, -0.16176, -0.41403>, <0.22090, 0.03235, -0.10895> }
		triangle  { <0.82809, -0.16176, -0.50122>, <1.08925, -0.67941, -0.54479>, <1.08959, -0.67941, -0.50122> }
		triangle  { <0.82809, -0.16176, -0.50122>, <1.08925, -0.67941, -0.54479>, <0.82875, -0.16176, -0.41403> }
		triangle  { <1.08959, -0.67941, -0.50122>, <1.26293, -1.06765, -0.63197>, <1.26392, -1.06765, -0.50122> }
		triangle  { <1.08959, -0.67941, -0.50122>, <1.26293, -1.06765, -0.63197>, <1.08925, -0.67941, -0.54479> }
		triangle  { <1.26392, -1.06765, -0.50122>, <1.00242, -2.75000, -0.50122>, <1.26293, -1.06765, -0.63197> }
		triangle  { <1.00242, -2.75000, -0.50122>, <1.87077, -2.75000, -0.93706>, <1.87409, -2.75000, -0.50122> }
		triangle  { <1.87409, -2.75000, -0.50122>, <2.13128, -1.06765, -1.06781>, <2.13559, -1.06765, -0.50122> }
		triangle  { <1.87409, -2.75000, -0.50122>, <2.13128, -1.06765, -1.06781>, <1.87077, -2.75000, -0.93706> }
		triangle  { <2.13559, -1.06765, -0.50122>, <1.69711, 0.16176, -0.84987>, <1.69976, 0.16176, -0.50122> }
		triangle  { <2.13559, -1.06765, -0.50122>, <1.69711, 0.16176, -0.84987>, <2.13128, -1.06765, -1.06781> }
		triangle  { <1.69976, 0.16176, -0.50122>, <0.82875, 0.67941, -0.41403>, <0.82809, 0.67941, -0.50122> }
		triangle  { <1.69976, 0.16176, -0.50122>, <0.82875, 0.67941, -0.41403>, <1.69711, 0.16176, -0.84987> }
		triangle  { <0.82809, 0.67941, -0.50122>, <2.13128, 1.13235, -1.06781>, <2.13559, 1.13235, -0.50122> }
		triangle  { <0.82809, 0.67941, -0.50122>, <2.13128, 1.13235, -1.06781>, <0.82875, 0.67941, -0.41403> }
		triangle  { <2.13559, 1.13235, -0.50122>, <2.56546, 2.36176, -1.28571>, <2.57143, 2.36176, -0.50122> }
		triangle  { <2.13559, 1.13235, -0.50122>, <2.56546, 2.36176, -1.28571>, <2.13128, 1.13235, -1.06781> }
		triangle  { <2.57143, 2.36176, -0.50122>, <2.21812, 2.75000, -1.11139>, <2.22276, 2.75000, -0.50122> }
		triangle  { <2.57143, 2.36176, -0.50122>, <2.21812, 2.75000, -1.11139>, <2.56546, 2.36176, -1.28571> }
		triangle  { <2.22276, 2.75000, -0.50122>, <-1.42897, 2.75000, 0.71912>, <-1.43826, 2.75000, -0.50122> }
		triangle  { <2.22276, 2.75000, -0.50122>, <-1.42897, 2.75000, 0.71912>, <2.21812, 2.75000, -1.11139> }
		triangle  { <-1.43826, 2.75000, -0.50122>, <-1.77631, 2.55588, 0.89349>, <-1.78692, 2.55588, -0.50122> }
		triangle  { <-1.43826, 2.75000, -0.50122>, <-1.77631, 2.55588, 0.89349>, <-1.42897, 2.75000, 0.71912> }

		translate < 5.00000, 7.00000, 0.00000>
                texture { Silver_Texture }
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Spli52*/

   object
   {
	union
	{
		triangle  { <-1.17473, 2.06250, -1.14286>, <-0.98414, 2.06250, 0.81632>, <-1.01956, 2.06250, -1.14286> }
		triangle  { <-1.17473, 2.06250, -1.14286>, <-0.98414, 2.06250, 0.81632>, <-1.13872, 2.06250, 0.84900> }
		triangle  { <-1.01956, 2.06250, -1.14286>, <-2.52997, -2.93750, 1.14286>, <-2.57130, -2.93750, -1.14286> }
		triangle  { <-1.01956, 2.06250, -1.14286>, <-2.52997, -2.93750, 1.14286>, <-0.98414, 2.06250, 0.81632> }
		triangle  { <-2.57130, -2.93750, -1.14286>, <-1.13872, -2.93750, 0.84900>, <-1.17473, -2.93750, -1.14286> }
		triangle  { <-2.57130, -2.93750, -1.14286>, <-1.13872, -2.93750, 0.84900>, <-2.52997, -2.93750, 1.14286> }
		triangle  { <-1.17473, -2.93750, -1.14286>, <0.40712, 1.93750, 0.52246>, <0.37701, 1.93750, -1.14286> }
		triangle  { <-1.17473, -2.93750, -1.14286>, <0.40712, 1.93750, 0.52246>, <-1.13872, -2.93750, 0.84900> }
		triangle  { <0.37701, 1.93750, -1.14286>, <2.10754, 1.93750, 0.16325>, <2.08393, 1.93750, -1.14286> }
		triangle  { <0.37701, 1.93750, -1.14286>, <2.10754, 1.93750, 0.16325>, <0.40712, 1.93750, 0.52246> }
		triangle  { <2.08393, 1.93750, -1.14286>, <2.57130, 2.93750, 0.06532>, <2.54945, 2.93750, -1.14286> }
		triangle  { <2.08393, 1.93750, -1.14286>, <2.57130, 2.93750, 0.06532>, <2.10754, 1.93750, 0.16325> }
		triangle  { <2.54945, 2.93750, -1.14286>, <-1.75706, 2.93750, 0.97960>, <-1.79543, 2.93750, -1.14286> }
		triangle  { <2.54945, 2.93750, -1.14286>, <-1.75706, 2.93750, 0.97960>, <2.57130, 2.93750, 0.06532> }
		triangle  { <-1.79543, 2.93750, -1.14286>, <-2.37540, 1.93750, 1.11021>, <-2.41613, 1.93750, -1.14286> }
		triangle  { <-1.79543, 2.93750, -1.14286>, <-2.37540, 1.93750, 1.11021>, <-1.75706, 2.93750, 0.97960> }
		triangle  { <-2.41613, 1.93750, -1.14286>, <-0.98414, 2.06250, 0.81632>, <-1.01956, 2.06250, -1.14286> }
		triangle  { <-2.41613, 1.93750, -1.14286>, <-0.98414, 2.06250, 0.81632>, <-2.37540, 1.93750, 1.11021> }

		translate < -4.42870, 15.31250, 0.00000>
                texture { Silver_Texture }
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Spli53*/

   object
   {
	union
	{
		triangle  { <-1.09478, 1.88697, -1.20000>, <-0.91716, 1.88697, 0.85714>, <-0.95017, 1.88697, -1.20000> }
		triangle  { <-1.09478, 1.88697, -1.20000>, <-0.91716, 1.88697, 0.85714>, <-1.06122, 1.88697, 0.89145> }
		triangle  { <-0.95017, 1.88697, -1.20000>, <-2.35778, -2.68750, 1.20000>, <-2.39630, -2.68750, -1.20000> }
		triangle  { <-0.95017, 1.88697, -1.20000>, <-2.35778, -2.68750, 1.20000>, <-0.91716, 1.88697, 0.85714> }
		triangle  { <-2.39630, -2.68750, -1.20000>, <-1.06122, -2.68750, 0.89145>, <-1.09478, -2.68750, -1.20000> }
		triangle  { <-2.39630, -2.68750, -1.20000>, <-1.06122, -2.68750, 0.89145>, <-2.35778, -2.68750, 1.20000> }
		triangle  { <-1.09478, -2.68750, -1.20000>, <0.37941, 1.77261, 0.54858>, <0.35135, 1.77261, -1.20000> }
		triangle  { <-1.09478, -2.68750, -1.20000>, <0.37941, 1.77261, 0.54858>, <-1.06122, -2.68750, 0.89145> }
		triangle  { <0.35135, 1.77261, -1.20000>, <1.96410, 1.77261, 0.17142>, <1.94210, 1.77261, -1.20000> }
		triangle  { <0.35135, 1.77261, -1.20000>, <1.96410, 1.77261, 0.17142>, <0.37941, 1.77261, 0.54858> }
		triangle  { <1.94210, 1.77261, -1.20000>, <2.39630, 2.68750, 0.06858>, <2.37594, 2.68750, -1.20000> }
		triangle  { <1.94210, 1.77261, -1.20000>, <2.39630, 2.68750, 0.06858>, <1.96410, 1.77261, 0.17142> }
		triangle  { <2.37594, 2.68750, -1.20000>, <-1.63747, 2.68750, 1.02858>, <-1.67323, 2.68750, -1.20000> }
		triangle  { <2.37594, 2.68750, -1.20000>, <-1.63747, 2.68750, 1.02858>, <2.39630, 2.68750, 0.06858> }
		triangle  { <-1.67323, 2.68750, -1.20000>, <-2.21373, 1.77261, 1.16572>, <-2.25168, 1.77261, -1.20000> }
		triangle  { <-1.67323, 2.68750, -1.20000>, <-2.21373, 1.77261, 1.16572>, <-1.63747, 2.68750, 1.02858> }
		triangle  { <-2.25168, 1.77261, -1.20000>, <-0.91716, 1.88697, 0.85714>, <-0.95017, 1.88697, -1.20000> }
		triangle  { <-2.25168, 1.77261, -1.20000>, <-0.91716, 1.88697, 0.85714>, <-2.21373, 1.77261, 1.16572> }

		translate < -4.80370, 7.18750, 0.00000>
                texture { Silver_Texture }
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Spli54*/

   object
   {
	union
	{
		triangle  { <-1.40789, 1.78500, -0.81049>, <-2.65893, -2.62500, 1.40000>, <-2.67500, -2.62500, -0.81049> }
		triangle  { <-1.40789, 1.78500, -0.81049>, <-2.65893, -2.62500, 1.40000>, <-1.39664, 1.78500, 0.73683> }
		triangle  { <-2.67500, -2.62500, -0.81049>, <1.40844, -2.62500, -0.73683>, <1.40789, -2.62500, -0.81049> }
		triangle  { <-2.67500, -2.62500, -0.81049>, <1.40844, -2.62500, -0.73683>, <-2.65893, -2.62500, 1.40000> }
		triangle  { <1.40789, -2.62500, -0.81049>, <1.68893, -1.57500, -0.88422>, <1.68947, -1.57500, -0.81049> }
		triangle  { <1.40789, -2.62500, -0.81049>, <1.68893, -1.57500, -0.88422>, <1.40844, -2.62500, -0.73683> }
		triangle  { <1.68947, -1.57500, -0.81049>, <-0.83564, -1.57500, 0.44211>, <-0.84474, -1.57500, -0.81049> }
		triangle  { <1.68947, -1.57500, -0.81049>, <-0.83564, -1.57500, 0.44211>, <1.68893, -1.57500, -0.88422> }
		triangle  { <-0.84474, -1.57500, -0.81049>, <-0.41487, -0.21000, 0.22106>, <-0.42237, -0.21000, -0.81049> }
		triangle  { <-0.84474, -1.57500, -0.81049>, <-0.41487, -0.21000, 0.22106>, <-0.83564, -1.57500, 0.44211> }
		triangle  { <-0.42237, -0.21000, -0.81049>, <1.54868, -0.21000, -0.81049>, <-0.41487, -0.21000, 0.22106> }
		triangle  { <1.54868, -0.21000, -0.81049>, <1.96944, 0.73500, -1.03155>, <1.97105, 0.73500, -0.81049> }
		triangle  { <1.97105, 0.73500, -0.81049>, <2.10970, 0.73500, -1.10521>, <2.11184, 0.73500, -0.81049> }
		triangle  { <1.97105, 0.73500, -0.81049>, <2.10970, 0.73500, -1.10521>, <1.96944, 0.73500, -1.03155> }
		triangle  { <2.11184, 0.73500, -0.81049>, <-0.27462, 0.73500, 0.14739>, <-0.28158, 0.73500, -0.81049> }
		triangle  { <2.11184, 0.73500, -0.81049>, <-0.27462, 0.73500, 0.14739>, <2.10970, 0.73500, -1.10521> }
		triangle  { <-0.28158, 0.73500, -0.81049>, <0.14615, 1.78500, -0.07366>, <0.14079, 1.78500, -0.81049> }
		triangle  { <-0.28158, 0.73500, -0.81049>, <0.14615, 1.78500, -0.07366>, <-0.27462, 0.73500, 0.14739> }
		triangle  { <0.14079, 1.78500, -0.81049>, <2.24995, 1.78500, -1.17894>, <2.25263, 1.78500, -0.81049> }
		triangle  { <0.14079, 1.78500, -0.81049>, <2.24995, 1.78500, -1.17894>, <0.14615, 1.78500, -0.07366> }
		triangle  { <2.25263, 1.78500, -0.81049>, <2.67072, 2.62500, -1.40000>, <2.67500, 2.62500, -0.81049> }
		triangle  { <2.25263, 1.78500, -0.81049>, <2.67072, 2.62500, -1.40000>, <2.24995, 1.78500, -1.17894> }
		triangle  { <2.67500, 2.62500, -0.81049>, <-0.83564, 2.62500, 0.44211>, <-0.84474, 2.62500, -0.81049> }
		triangle  { <2.67500, 2.62500, -0.81049>, <-0.83564, 2.62500, 0.44211>, <2.67072, 2.62500, -1.40000> }
		triangle  { <-0.84474, 2.62500, -0.81049>, <-1.39664, 1.68000, 0.73683>, <-1.40789, 1.68000, -0.81049> }
		triangle  { <-0.84474, 2.62500, -0.81049>, <-1.39664, 1.68000, 0.73683>, <-0.83564, 2.62500, 0.44211> }

		translate < 5.87500, 15.62500, 0.00000>
                texture { Silver_Texture }
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Spli55*/

   object
   {
	union
	{
		triangle  { <-1.23684, 1.78500, -0.69471>, <-2.33588, -2.62500, 1.20000>, <-2.35000, -2.62500, -0.69471> }
		triangle  { <-1.23684, 1.78500, -0.69471>, <-2.33588, -2.62500, 1.20000>, <-1.22696, 1.78500, 0.63157> }
		triangle  { <-2.35000, -2.62500, -0.69471>, <1.23732, -2.62500, -0.63157>, <1.23684, -2.62500, -0.69471> }
		triangle  { <-2.35000, -2.62500, -0.69471>, <1.23732, -2.62500, -0.63157>, <-2.33588, -2.62500, 1.20000> }
		triangle  { <1.23684, -2.62500, -0.69471>, <1.48374, -1.57500, -0.75791>, <1.48421, -1.57500, -0.69471> }
		triangle  { <1.23684, -2.62500, -0.69471>, <1.48374, -1.57500, -0.75791>, <1.23732, -2.62500, -0.63157> }
		triangle  { <1.48421, -1.57500, -0.69471>, <-0.73411, -1.57500, 0.37895>, <-0.74211, -1.57500, -0.69471> }
		triangle  { <1.48421, -1.57500, -0.69471>, <-0.73411, -1.57500, 0.37895>, <1.48374, -1.57500, -0.75791> }
		triangle  { <-0.74211, -1.57500, -0.69471>, <-0.36446, -0.21000, 0.18948>, <-0.37105, -0.21000, -0.69471> }
		triangle  { <-0.74211, -1.57500, -0.69471>, <-0.36446, -0.21000, 0.18948>, <-0.73411, -1.57500, 0.37895> }
		triangle  { <-0.37105, -0.21000, -0.69471>, <1.36053, -0.21000, -0.69471>, <-0.36446, -0.21000, 0.18948> }
		triangle  { <1.36053, -0.21000, -0.69471>, <1.73016, 0.73500, -0.88419>, <1.73158, 0.73500, -0.69471> }
		triangle  { <1.73158, 0.73500, -0.69471>, <1.85338, 0.73500, -0.94733>, <1.85526, 0.73500, -0.69471> }
		triangle  { <1.73158, 0.73500, -0.69471>, <1.85338, 0.73500, -0.94733>, <1.73016, 0.73500, -0.88419> }
		triangle  { <1.85526, 0.73500, -0.69471>, <-0.24125, 0.73500, 0.12634>, <-0.24737, 0.73500, -0.69471> }
		triangle  { <1.85526, 0.73500, -0.69471>, <-0.24125, 0.73500, 0.12634>, <1.85338, 0.73500, -0.94733> }
		triangle  { <-0.24737, 0.73500, -0.69471>, <0.12839, 1.78500, -0.06314>, <0.12368, 1.78500, -0.69471> }
		triangle  { <-0.24737, 0.73500, -0.69471>, <0.12839, 1.78500, -0.06314>, <-0.24125, 0.73500, 0.12634> }
		triangle  { <0.12368, 1.78500, -0.69471>, <1.97659, 1.78500, -1.01052>, <1.97895, 1.78500, -0.69471> }
		triangle  { <0.12368, 1.78500, -0.69471>, <1.97659, 1.78500, -1.01052>, <0.12839, 1.78500, -0.06314> }
		triangle  { <1.97895, 1.78500, -0.69471>, <2.34624, 2.62500, -1.20000>, <2.35000, 2.62500, -0.69471> }
		triangle  { <1.97895, 1.78500, -0.69471>, <2.34624, 2.62500, -1.20000>, <1.97659, 1.78500, -1.01052> }
		triangle  { <2.35000, 2.62500, -0.69471>, <-0.73411, 2.62500, 0.37895>, <-0.74211, 2.62500, -0.69471> }
		triangle  { <2.35000, 2.62500, -0.69471>, <-0.73411, 2.62500, 0.37895>, <2.34624, 2.62500, -1.20000> }
		triangle  { <-0.74211, 2.62500, -0.69471>, <-1.22696, 1.68000, 0.63157>, <-1.23684, 1.68000, -0.69471> }
		triangle  { <-0.74211, 2.62500, -0.69471>, <-1.22696, 1.68000, 0.63157>, <-0.73411, 2.62500, 0.37895> }

		translate < -0.25000, 7.12500, 0.00000>
                texture { Silver_Texture }
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Spli56*/

   object
   {
	union
	{
		triangle  { <-1.07165, 2.49219, -1.00000>, <-2.29490, -2.75000, 1.00000>, <-2.31250, -2.75000, -1.00000> }
		triangle  { <-1.07165, 2.49219, -1.00000>, <-2.29490, -2.75000, 1.00000>, <-1.05877, 2.49219, 0.46339> }
		triangle  { <-2.31250, -2.75000, -1.00000>, <-1.17115, -2.75000, 0.51220>, <-1.18445, -2.75000, -1.00000> }
		triangle  { <-2.31250, -2.75000, -1.00000>, <-1.17115, -2.75000, 0.51220>, <-2.29490, -2.75000, 1.00000> }
		triangle  { <-1.18445, -2.75000, -1.00000>, <-0.38452, 1.46094, 0.17075>, <-0.39482, 1.46094, -1.00000> }
		triangle  { <-1.18445, -2.75000, -1.00000>, <-0.38452, 1.46094, 0.17075>, <-1.17115, -2.75000, 0.51220> }
		triangle  { <-0.39482, 1.46094, -1.00000>, <0.96399, -2.66406, -0.41463>, <0.95884, -2.66406, -1.00000> }
		triangle  { <-0.39482, 1.46094, -1.00000>, <0.96399, -2.66406, -0.41463>, <-0.38452, 1.46094, 0.17075> }
		triangle  { <0.95884, -2.66406, -1.00000>, <2.08775, -2.66406, -0.90242>, <2.08689, -2.66406, -1.00000> }
		triangle  { <0.95884, -2.66406, -1.00000>, <2.08775, -2.66406, -0.90242>, <0.96399, -2.66406, -0.41463> }
		triangle  { <2.08689, -2.66406, -1.00000>, <2.31250, 2.75000, -1.00000>, <2.08775, -2.66406, -0.90242> }
		triangle  { <2.31250, 2.75000, -1.00000>, <1.30112, 2.75000, -0.56097>, <1.29726, 2.75000, -1.00000> }
		triangle  { <1.29726, 2.75000, -1.00000>, <1.30112, -0.25781, -0.56097>, <1.29726, -0.25781, -1.00000> }
		triangle  { <1.29726, 2.75000, -1.00000>, <1.30112, -0.25781, -0.56097>, <1.30112, 2.75000, -0.56097> }
		triangle  { <1.29726, -0.25781, -1.00000>, <-0.04739, 2.49219, 0.02441>, <-0.05640, 2.49219, -1.00000> }
		triangle  { <1.29726, -0.25781, -1.00000>, <-0.04739, 2.49219, 0.02441>, <1.30112, -0.25781, -0.56097> }
		triangle  { <-0.05640, 2.49219, -1.00000>, <-0.83402, 2.49219, 0.36586>, <-0.84604, 2.49219, -1.00000> }
		triangle  { <-0.05640, 2.49219, -1.00000>, <-0.83402, 2.49219, 0.36586>, <-0.04739, 2.49219, 0.02441> }

		translate < 10.31250, 7.00000, 0.00000>
                texture { Silver_Texture }
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Tria14*/

   object
   {
	union
	{
		triangle  { <-4.20000, 0.07096, -1.69000>, <4.20000, 0.07096, -1.69000>, <-4.20000, -0.20000, -1.69000> }
		triangle  { <4.20000, -0.20000, -1.69000>, <4.20000, 0.07096, -1.69000>, <-4.20000, -0.20000, -1.69000> }
		triangle  { <4.20000, 0.07096, -1.69000>, <4.20000, -0.20000, -1.69000>, <4.20000, -0.20000, 1.14278> }
		triangle  { <4.20000, 0.07096, -1.69000>, <4.20000, 0.07096, 1.14278>, <4.20000, -0.20000, 1.14278> }
		triangle  { <-4.20000, 0.07096, -1.69000>, <-4.20000, -0.20000, -1.69000>, <-4.20000, -0.20000, 1.14278> }
		triangle  { <-4.20000, 0.07096, -1.69000>, <-4.20000, 0.07096, 1.14278>, <-4.20000, -0.20000, 1.14278> }
		triangle  { <-4.20000, 0.07096, 1.14278>, <4.20000, 0.07096, 1.14278>, <-4.20000, -0.20000, 1.14278> }
		triangle  { <4.20000, 0.07096, 1.14278>, <4.20000, -0.20000, 1.14278>, <-4.20000, -0.20000, 1.14278> }
		triangle  { <-4.20000, -0.20000, -1.69000>, <4.20000, -0.20000, -1.69000>, <4.20000, -0.20000, 1.14278> }
		triangle  { <-4.20000, -0.20000, -1.69000>, <-4.20000, -0.20000, 1.14278>, <4.20000, -0.20000, 1.14278> }
		triangle  { <-4.20000, 0.07096, -1.69000>, <-4.20000, 0.07096, 1.14278>, <4.20000, 0.07096, 1.14278> }
		triangle  { <-4.20000, 0.07096, -1.69000>, <4.20000, 0.07096, -1.69000>, <4.20000, 0.07096, 1.14278> }
		triangle  { <-3.95469, 0.20000, -1.56122>, <-2.97335, 0.20000, -1.56122>, <-3.95469, -0.12255, -1.56122> }
		triangle  { <-2.97335, -0.12255, -1.56122>, <-2.97335, 0.20000, -1.56122>, <-3.95469, -0.12255, -1.56122> }
		triangle  { <-2.97335, 0.20000, -1.56122>, <-2.97335, -0.12255, -1.56122>, <-2.97335, -0.12255, -1.17494> }
		triangle  { <-2.97335, 0.20000, -1.56122>, <-2.97335, 0.20000, -1.17494>, <-2.97335, -0.12255, -1.17494> }
		triangle  { <-3.95469, 0.20000, -1.56122>, <-3.95469, -0.12255, -1.56122>, <-3.95469, -0.12255, -1.17494> }
		triangle  { <-3.95469, 0.20000, -1.56122>, <-3.95469, 0.20000, -1.17494>, <-3.95469, -0.12255, -1.17494> }
		triangle  { <-3.95469, 0.20000, -1.17494>, <-2.97335, 0.20000, -1.17494>, <-3.95469, -0.12255, -1.17494> }
		triangle  { <-2.97335, 0.20000, -1.17494>, <-2.97335, -0.12255, -1.17494>, <-3.95469, -0.12255, -1.17494> }
		triangle  { <-3.95469, -0.12255, -1.56122>, <-2.97335, -0.12255, -1.56122>, <-2.97335, -0.12255, -1.17494> }
		triangle  { <-3.95469, -0.12255, -1.56122>, <-3.95469, -0.12255, -1.17494>, <-2.97335, -0.12255, -1.17494> }
		triangle  { <-3.95469, 0.20000, -1.56122>, <-3.95469, 0.20000, -1.17494>, <-2.97335, 0.20000, -1.17494> }
		triangle  { <-3.95469, 0.20000, -1.56122>, <-2.97335, 0.20000, -1.56122>, <-2.97335, 0.20000, -1.17494> }
		triangle  { <-3.95460, 0.20000, -1.11061>, <-2.58077, 0.20000, -1.11061>, <-3.95460, -0.12255, -1.11061> }
		triangle  { <-2.58077, -0.12255, -1.11061>, <-2.58077, 0.20000, -1.11061>, <-3.95460, -0.12255, -1.11061> }
		triangle  { <-2.58077, 0.20000, -1.11061>, <-2.58077, -0.12255, -1.11061>, <-2.58077, -0.12255, -0.72433> }
		triangle  { <-2.58077, 0.20000, -1.11061>, <-2.58077, 0.20000, -0.72433>, <-2.58077, -0.12255, -0.72433> }
		triangle  { <-3.95460, 0.20000, -1.11061>, <-3.95460, -0.12255, -1.11061>, <-3.95460, -0.12255, -0.72433> }
		triangle  { <-3.95460, 0.20000, -1.11061>, <-3.95460, 0.20000, -0.72433>, <-3.95460, -0.12255, -0.72433> }
		triangle  { <-3.95460, 0.20000, -0.72433>, <-2.58077, 0.20000, -0.72433>, <-3.95460, -0.12255, -0.72433> }
		triangle  { <-2.58077, 0.20000, -0.72433>, <-2.58077, -0.12255, -0.72433>, <-3.95460, -0.12255, -0.72433> }
		triangle  { <-3.95460, -0.12255, -1.11061>, <-2.58077, -0.12255, -1.11061>, <-2.58077, -0.12255, -0.72433> }
		triangle  { <-3.95460, -0.12255, -1.11061>, <-3.95460, -0.12255, -0.72433>, <-2.58077, -0.12255, -0.72433> }
		triangle  { <-3.95460, 0.20000, -1.11061>, <-3.95460, 0.20000, -0.72433>, <-2.58077, 0.20000, -0.72433> }
		triangle  { <-3.95460, 0.20000, -1.11061>, <-2.58077, 0.20000, -1.11061>, <-2.58077, 0.20000, -0.72433> }
		triangle  { <-3.95460, 0.20000, -0.59556>, <-2.77706, 0.20000, -0.59556>, <-3.95460, -0.12255, -0.59556> }
		triangle  { <-2.77706, -0.12255, -0.59556>, <-2.77706, 0.20000, -0.59556>, <-3.95460, -0.12255, -0.59556> }
		triangle  { <-2.77706, 0.20000, -0.59556>, <-2.77706, -0.12255, -0.59556>, <-2.77706, -0.12255, -0.20928> }
		triangle  { <-2.77706, 0.20000, -0.59556>, <-2.77706, 0.20000, -0.20928>, <-2.77706, -0.12255, -0.20928> }
		triangle  { <-3.95460, 0.20000, -0.59556>, <-3.95460, -0.12255, -0.59556>, <-3.95460, -0.12255, -0.20928> }
		triangle  { <-3.95460, 0.20000, -0.59556>, <-3.95460, 0.20000, -0.20928>, <-3.95460, -0.12255, -0.20928> }
		triangle  { <-3.95460, 0.20000, -0.20928>, <-2.77706, 0.20000, -0.20928>, <-3.95460, -0.12255, -0.20928> }
		triangle  { <-2.77706, 0.20000, -0.20928>, <-2.77706, -0.12255, -0.20928>, <-3.95460, -0.12255, -0.20928> }
		triangle  { <-3.95460, -0.12255, -0.59556>, <-2.77706, -0.12255, -0.59556>, <-2.77706, -0.12255, -0.20928> }
		triangle  { <-3.95460, -0.12255, -0.59556>, <-3.95460, -0.12255, -0.20928>, <-2.77706, -0.12255, -0.20928> }
		triangle  { <-3.95460, 0.20000, -0.59556>, <-3.95460, 0.20000, -0.20928>, <-2.77706, 0.20000, -0.20928> }
		triangle  { <-3.95460, 0.20000, -0.59556>, <-2.77706, 0.20000, -0.59556>, <-2.77706, 0.20000, -0.20928> }
		triangle  { <-3.95460, 0.20000, -0.04828>, <-2.58077, 0.20000, -0.04828>, <-3.95460, -0.12255, -0.04828> }
		triangle  { <-2.58077, -0.12255, -0.04828>, <-2.58077, 0.20000, -0.04828>, <-3.95460, -0.12255, -0.04828> }
		triangle  { <-2.58077, 0.20000, -0.04828>, <-2.58077, -0.12255, -0.04828>, <-2.58077, -0.12255, 0.33800> }
		triangle  { <-2.58077, 0.20000, -0.04828>, <-2.58077, 0.20000, 0.33800>, <-2.58077, -0.12255, 0.33800> }
		triangle  { <-3.95460, 0.20000, -0.04828>, <-3.95460, -0.12255, -0.04828>, <-3.95460, -0.12255, 0.33800> }
		triangle  { <-3.95460, 0.20000, -0.04828>, <-3.95460, 0.20000, 0.33800>, <-3.95460, -0.12255, 0.33800> }
		triangle  { <-3.95460, 0.20000, 0.33800>, <-2.58077, 0.20000, 0.33800>, <-3.95460, -0.12255, 0.33800> }
		triangle  { <-2.58077, 0.20000, 0.33800>, <-2.58077, -0.12255, 0.33800>, <-3.95460, -0.12255, 0.33800> }
		triangle  { <-3.95460, -0.12255, -0.04828>, <-2.58077, -0.12255, -0.04828>, <-2.58077, -0.12255, 0.33800> }
		triangle  { <-3.95460, -0.12255, -0.04828>, <-3.95460, -0.12255, 0.33800>, <-2.58077, -0.12255, 0.33800> }
		triangle  { <-3.95460, 0.20000, -0.04828>, <-3.95460, 0.20000, 0.33800>, <-2.58077, 0.20000, 0.33800> }
		triangle  { <-3.95460, 0.20000, -0.04828>, <-2.58077, 0.20000, -0.04828>, <-2.58077, 0.20000, 0.33800> }
		triangle  { <-2.28643, 0.20000, 0.69211>, <-1.79580, 0.20000, 0.69211>, <-2.28643, -0.12255, 0.69211> }
		triangle  { <-1.79580, -0.12255, 0.69211>, <-1.79580, 0.20000, 0.69211>, <-2.28643, -0.12255, 0.69211> }
		triangle  { <-1.79580, 0.20000, 0.69211>, <-1.79580, -0.12255, 0.69211>, <-1.79580, -0.12255, 1.01400> }
		triangle  { <-1.79580, 0.20000, 0.69211>, <-1.79580, 0.20000, 1.01400>, <-1.79580, -0.12255, 1.01400> }
		triangle  { <-2.28643, 0.20000, 0.69211>, <-2.28643, -0.12255, 0.69211>, <-2.28643, -0.12255, 1.01400> }
		triangle  { <-2.28643, 0.20000, 0.69211>, <-2.28643, 0.20000, 1.01400>, <-2.28643, -0.12255, 1.01400> }
		triangle  { <-2.28643, 0.20000, 1.01400>, <-1.79580, 0.20000, 1.01400>, <-2.28643, -0.12255, 1.01400> }
		triangle  { <-1.79580, 0.20000, 1.01400>, <-1.79580, -0.12255, 1.01400>, <-2.28643, -0.12255, 1.01400> }
		triangle  { <-2.28643, -0.12255, 0.69211>, <-1.79580, -0.12255, 0.69211>, <-1.79580, -0.12255, 1.01400> }
		triangle  { <-2.28643, -0.12255, 0.69211>, <-2.28643, -0.12255, 1.01400>, <-1.79580, -0.12255, 1.01400> }
		triangle  { <-2.28643, 0.20000, 0.69211>, <-2.28643, 0.20000, 1.01400>, <-1.79580, 0.20000, 1.01400> }
		triangle  { <-2.28643, 0.20000, 0.69211>, <-1.79580, 0.20000, 0.69211>, <-1.79580, 0.20000, 1.01400> }
		triangle  { <-1.64855, 0.20000, 0.69211>, <-1.15792, 0.20000, 0.69211>, <-1.64855, -0.12255, 0.69211> }
		triangle  { <-1.15792, -0.12255, 0.69211>, <-1.15792, 0.20000, 0.69211>, <-1.64855, -0.12255, 0.69211> }
		triangle  { <-1.15792, 0.20000, 0.69211>, <-1.15792, -0.12255, 0.69211>, <-1.15792, -0.12255, 1.01400> }
		triangle  { <-1.15792, 0.20000, 0.69211>, <-1.15792, 0.20000, 1.01400>, <-1.15792, -0.12255, 1.01400> }
		triangle  { <-1.64855, 0.20000, 0.69211>, <-1.64855, -0.12255, 0.69211>, <-1.64855, -0.12255, 1.01400> }
		triangle  { <-1.64855, 0.20000, 0.69211>, <-1.64855, 0.20000, 1.01400>, <-1.64855, -0.12255, 1.01400> }
		triangle  { <-1.64855, 0.20000, 1.01400>, <-1.15792, 0.20000, 1.01400>, <-1.64855, -0.12255, 1.01400> }
		triangle  { <-1.15792, 0.20000, 1.01400>, <-1.15792, -0.12255, 1.01400>, <-1.64855, -0.12255, 1.01400> }
		triangle  { <-1.64855, -0.12255, 0.69211>, <-1.15792, -0.12255, 0.69211>, <-1.15792, -0.12255, 1.01400> }
		triangle  { <-1.64855, -0.12255, 0.69211>, <-1.64855, -0.12255, 1.01400>, <-1.15792, -0.12255, 1.01400> }
		triangle  { <-1.64855, 0.20000, 0.69211>, <-1.64855, 0.20000, 1.01400>, <-1.15792, 0.20000, 1.01400> }
		triangle  { <-1.64855, 0.20000, 0.69211>, <-1.15792, 0.20000, 0.69211>, <-1.15792, 0.20000, 1.01400> }
		triangle  { <-1.01066, 0.20000, 0.69211>, <-0.52004, 0.20000, 0.69211>, <-1.01066, -0.12255, 0.69211> }
		triangle  { <-0.52004, -0.12255, 0.69211>, <-0.52004, 0.20000, 0.69211>, <-1.01066, -0.12255, 0.69211> }
		triangle  { <-0.52004, 0.20000, 0.69211>, <-0.52004, -0.12255, 0.69211>, <-0.52004, -0.12255, 1.01400> }
		triangle  { <-0.52004, 0.20000, 0.69211>, <-0.52004, 0.20000, 1.01400>, <-0.52004, -0.12255, 1.01400> }
		triangle  { <-1.01066, 0.20000, 0.69211>, <-1.01066, -0.12255, 0.69211>, <-1.01066, -0.12255, 1.01400> }
		triangle  { <-1.01066, 0.20000, 0.69211>, <-1.01066, 0.20000, 1.01400>, <-1.01066, -0.12255, 1.01400> }
		triangle  { <-1.01066, 0.20000, 1.01400>, <-0.52004, 0.20000, 1.01400>, <-1.01066, -0.12255, 1.01400> }
		triangle  { <-0.52004, 0.20000, 1.01400>, <-0.52004, -0.12255, 1.01400>, <-1.01066, -0.12255, 1.01400> }
		triangle  { <-1.01066, -0.12255, 0.69211>, <-0.52004, -0.12255, 0.69211>, <-0.52004, -0.12255, 1.01400> }
		triangle  { <-1.01066, -0.12255, 0.69211>, <-1.01066, -0.12255, 1.01400>, <-0.52004, -0.12255, 1.01400> }
		triangle  { <-1.01066, 0.20000, 0.69211>, <-1.01066, 0.20000, 1.01400>, <-0.52004, 0.20000, 1.01400> }
		triangle  { <-1.01066, 0.20000, 0.69211>, <-0.52004, 0.20000, 0.69211>, <-0.52004, 0.20000, 1.01400> }
		triangle  { <-4.00371, 0.20000, 0.69211>, <-3.51309, 0.20000, 0.69211>, <-4.00371, -0.12255, 0.69211> }
		triangle  { <-3.51309, -0.12255, 0.69211>, <-3.51309, 0.20000, 0.69211>, <-4.00371, -0.12255, 0.69211> }
		triangle  { <-3.51309, 0.20000, 0.69211>, <-3.51309, -0.12255, 0.69211>, <-3.51309, -0.12255, 1.01400> }
		triangle  { <-3.51309, 0.20000, 0.69211>, <-3.51309, 0.20000, 1.01400>, <-3.51309, -0.12255, 1.01400> }
		triangle  { <-4.00371, 0.20000, 0.69211>, <-4.00371, -0.12255, 0.69211>, <-4.00371, -0.12255, 1.01400> }
		triangle  { <-4.00371, 0.20000, 0.69211>, <-4.00371, 0.20000, 1.01400>, <-4.00371, -0.12255, 1.01400> }
		triangle  { <-4.00371, 0.20000, 1.01400>, <-3.51309, 0.20000, 1.01400>, <-4.00371, -0.12255, 1.01400> }
		triangle  { <-3.51309, 0.20000, 1.01400>, <-3.51309, -0.12255, 1.01400>, <-4.00371, -0.12255, 1.01400> }
		triangle  { <-4.00371, -0.12255, 0.69211>, <-3.51309, -0.12255, 0.69211>, <-3.51309, -0.12255, 1.01400> }
		triangle  { <-4.00371, -0.12255, 0.69211>, <-4.00371, -0.12255, 1.01400>, <-3.51309, -0.12255, 1.01400> }
		triangle  { <-4.00371, 0.20000, 0.69211>, <-4.00371, 0.20000, 1.01400>, <-3.51309, 0.20000, 1.01400> }
		triangle  { <-4.00371, 0.20000, 0.69211>, <-3.51309, 0.20000, 0.69211>, <-3.51309, 0.20000, 1.01400> }
		triangle  { <-0.37286, 0.20000, 0.69211>, <0.11776, 0.20000, 0.69211>, <-0.37286, -0.12255, 0.69211> }
		triangle  { <0.11776, -0.12255, 0.69211>, <0.11776, 0.20000, 0.69211>, <-0.37286, -0.12255, 0.69211> }
		triangle  { <0.11776, 0.20000, 0.69211>, <0.11776, -0.12255, 0.69211>, <0.11776, -0.12255, 1.01400> }
		triangle  { <0.11776, 0.20000, 0.69211>, <0.11776, 0.20000, 1.01400>, <0.11776, -0.12255, 1.01400> }
		triangle  { <-0.37286, 0.20000, 0.69211>, <-0.37286, -0.12255, 0.69211>, <-0.37286, -0.12255, 1.01400> }
		triangle  { <-0.37286, 0.20000, 0.69211>, <-0.37286, 0.20000, 1.01400>, <-0.37286, -0.12255, 1.01400> }
		triangle  { <-0.37286, 0.20000, 1.01400>, <0.11776, 0.20000, 1.01400>, <-0.37286, -0.12255, 1.01400> }
		triangle  { <0.11776, 0.20000, 1.01400>, <0.11776, -0.12255, 1.01400>, <-0.37286, -0.12255, 1.01400> }
		triangle  { <-0.37286, -0.12255, 0.69211>, <0.11776, -0.12255, 0.69211>, <0.11776, -0.12255, 1.01400> }
		triangle  { <-0.37286, -0.12255, 0.69211>, <-0.37286, -0.12255, 1.01400>, <0.11776, -0.12255, 1.01400> }
		triangle  { <-0.37286, 0.20000, 0.69211>, <-0.37286, 0.20000, 1.01400>, <0.11776, 0.20000, 1.01400> }
		triangle  { <-0.37286, 0.20000, 0.69211>, <0.11776, 0.20000, 0.69211>, <0.11776, 0.20000, 1.01400> }
		triangle  { <0.26502, 0.20000, 0.69211>, <0.75565, 0.20000, 0.69211>, <0.26502, -0.12255, 0.69211> }
		triangle  { <0.75565, -0.12255, 0.69211>, <0.75565, 0.20000, 0.69211>, <0.26502, -0.12255, 0.69211> }
		triangle  { <0.75565, 0.20000, 0.69211>, <0.75565, -0.12255, 0.69211>, <0.75565, -0.12255, 1.01400> }
		triangle  { <0.75565, 0.20000, 0.69211>, <0.75565, 0.20000, 1.01400>, <0.75565, -0.12255, 1.01400> }
		triangle  { <0.26502, 0.20000, 0.69211>, <0.26502, -0.12255, 0.69211>, <0.26502, -0.12255, 1.01400> }
		triangle  { <0.26502, 0.20000, 0.69211>, <0.26502, 0.20000, 1.01400>, <0.26502, -0.12255, 1.01400> }
		triangle  { <0.26502, 0.20000, 1.01400>, <0.75565, 0.20000, 1.01400>, <0.26502, -0.12255, 1.01400> }
		triangle  { <0.75565, 0.20000, 1.01400>, <0.75565, -0.12255, 1.01400>, <0.26502, -0.12255, 1.01400> }
		triangle  { <0.26502, -0.12255, 0.69211>, <0.75565, -0.12255, 0.69211>, <0.75565, -0.12255, 1.01400> }
		triangle  { <0.26502, -0.12255, 0.69211>, <0.26502, -0.12255, 1.01400>, <0.75565, -0.12255, 1.01400> }
		triangle  { <0.26502, 0.20000, 0.69211>, <0.26502, 0.20000, 1.01400>, <0.75565, 0.20000, 1.01400> }
		triangle  { <0.26502, 0.20000, 0.69211>, <0.75565, 0.20000, 0.69211>, <0.75565, 0.20000, 1.01400> }
		triangle  { <0.90282, 0.20000, 0.69211>, <1.39345, 0.20000, 0.69211>, <0.90282, -0.12255, 0.69211> }
		triangle  { <1.39345, -0.12255, 0.69211>, <1.39345, 0.20000, 0.69211>, <0.90282, -0.12255, 0.69211> }
		triangle  { <1.39345, 0.20000, 0.69211>, <1.39345, -0.12255, 0.69211>, <1.39345, -0.12255, 1.01400> }
		triangle  { <1.39345, 0.20000, 0.69211>, <1.39345, 0.20000, 1.01400>, <1.39345, -0.12255, 1.01400> }
		triangle  { <0.90282, 0.20000, 0.69211>, <0.90282, -0.12255, 0.69211>, <0.90282, -0.12255, 1.01400> }
		triangle  { <0.90282, 0.20000, 0.69211>, <0.90282, 0.20000, 1.01400>, <0.90282, -0.12255, 1.01400> }
		triangle  { <0.90282, 0.20000, 1.01400>, <1.39345, 0.20000, 1.01400>, <0.90282, -0.12255, 1.01400> }
		triangle  { <1.39345, 0.20000, 1.01400>, <1.39345, -0.12255, 1.01400>, <0.90282, -0.12255, 1.01400> }
		triangle  { <0.90282, -0.12255, 0.69211>, <1.39345, -0.12255, 0.69211>, <1.39345, -0.12255, 1.01400> }
		triangle  { <0.90282, -0.12255, 0.69211>, <0.90282, -0.12255, 1.01400>, <1.39345, -0.12255, 1.01400> }
		triangle  { <0.90282, 0.20000, 0.69211>, <0.90282, 0.20000, 1.01400>, <1.39345, 0.20000, 1.01400> }
		triangle  { <0.90282, 0.20000, 0.69211>, <1.39345, 0.20000, 0.69211>, <1.39345, 0.20000, 1.01400> }
		triangle  { <1.54070, 0.20000, 0.69211>, <2.03133, 0.20000, 0.69211>, <1.54070, -0.12255, 0.69211> }
		triangle  { <2.03133, -0.12255, 0.69211>, <2.03133, 0.20000, 0.69211>, <1.54070, -0.12255, 0.69211> }
		triangle  { <2.03133, 0.20000, 0.69211>, <2.03133, -0.12255, 0.69211>, <2.03133, -0.12255, 1.01400> }
		triangle  { <2.03133, 0.20000, 0.69211>, <2.03133, 0.20000, 1.01400>, <2.03133, -0.12255, 1.01400> }
		triangle  { <1.54070, 0.20000, 0.69211>, <1.54070, -0.12255, 0.69211>, <1.54070, -0.12255, 1.01400> }
		triangle  { <1.54070, 0.20000, 0.69211>, <1.54070, 0.20000, 1.01400>, <1.54070, -0.12255, 1.01400> }
		triangle  { <1.54070, 0.20000, 1.01400>, <2.03133, 0.20000, 1.01400>, <1.54070, -0.12255, 1.01400> }
		triangle  { <2.03133, 0.20000, 1.01400>, <2.03133, -0.12255, 1.01400>, <1.54070, -0.12255, 1.01400> }
		triangle  { <1.54070, -0.12255, 0.69211>, <2.03133, -0.12255, 0.69211>, <2.03133, -0.12255, 1.01400> }
		triangle  { <1.54070, -0.12255, 0.69211>, <1.54070, -0.12255, 1.01400>, <2.03133, -0.12255, 1.01400> }
		triangle  { <1.54070, 0.20000, 0.69211>, <1.54070, 0.20000, 1.01400>, <2.03133, 0.20000, 1.01400> }
		triangle  { <1.54070, 0.20000, 0.69211>, <2.03133, 0.20000, 0.69211>, <2.03133, 0.20000, 1.01400> }
		triangle  { <2.12947, 0.20000, 0.69211>, <2.62010, 0.20000, 0.69211>, <2.12947, -0.12255, 0.69211> }
		triangle  { <2.62010, -0.12255, 0.69211>, <2.62010, 0.20000, 0.69211>, <2.12947, -0.12255, 0.69211> }
		triangle  { <2.62010, 0.20000, 0.69211>, <2.62010, -0.12255, 0.69211>, <2.62010, -0.12255, 1.01400> }
		triangle  { <2.62010, 0.20000, 0.69211>, <2.62010, 0.20000, 1.01400>, <2.62010, -0.12255, 1.01400> }
		triangle  { <2.12947, 0.20000, 0.69211>, <2.12947, -0.12255, 0.69211>, <2.12947, -0.12255, 1.01400> }
		triangle  { <2.12947, 0.20000, 0.69211>, <2.12947, 0.20000, 1.01400>, <2.12947, -0.12255, 1.01400> }
		triangle  { <2.12947, 0.20000, 1.01400>, <2.62010, 0.20000, 1.01400>, <2.12947, -0.12255, 1.01400> }
		triangle  { <2.62010, 0.20000, 1.01400>, <2.62010, -0.12255, 1.01400>, <2.12947, -0.12255, 1.01400> }
		triangle  { <2.12947, -0.12255, 0.69211>, <2.62010, -0.12255, 0.69211>, <2.62010, -0.12255, 1.01400> }
		triangle  { <2.12947, -0.12255, 0.69211>, <2.12947, -0.12255, 1.01400>, <2.62010, -0.12255, 1.01400> }
		triangle  { <2.12947, 0.20000, 0.69211>, <2.12947, 0.20000, 1.01400>, <2.62010, 0.20000, 1.01400> }
		triangle  { <2.12947, 0.20000, 0.69211>, <2.62010, 0.20000, 0.69211>, <2.62010, 0.20000, 1.01400> }
		triangle  { <-2.92423, 0.20000, 0.69211>, <-2.43360, 0.20000, 0.69211>, <-2.92423, -0.12255, 0.69211> }
		triangle  { <-2.43360, -0.12255, 0.69211>, <-2.43360, 0.20000, 0.69211>, <-2.92423, -0.12255, 0.69211> }
		triangle  { <-2.43360, 0.20000, 0.69211>, <-2.43360, -0.12255, 0.69211>, <-2.43360, -0.12255, 1.01400> }
		triangle  { <-2.43360, 0.20000, 0.69211>, <-2.43360, 0.20000, 1.01400>, <-2.43360, -0.12255, 1.01400> }
		triangle  { <-2.92423, 0.20000, 0.69211>, <-2.92423, -0.12255, 0.69211>, <-2.92423, -0.12255, 1.01400> }
		triangle  { <-2.92423, 0.20000, 0.69211>, <-2.92423, 0.20000, 1.01400>, <-2.92423, -0.12255, 1.01400> }
		triangle  { <-2.92423, 0.20000, 1.01400>, <-2.43360, 0.20000, 1.01400>, <-2.92423, -0.12255, 1.01400> }
		triangle  { <-2.43360, 0.20000, 1.01400>, <-2.43360, -0.12255, 1.01400>, <-2.92423, -0.12255, 1.01400> }
		triangle  { <-2.92423, -0.12255, 0.69211>, <-2.43360, -0.12255, 0.69211>, <-2.43360, -0.12255, 1.01400> }
		triangle  { <-2.92423, -0.12255, 0.69211>, <-2.92423, -0.12255, 1.01400>, <-2.43360, -0.12255, 1.01400> }
		triangle  { <-2.92423, 0.20000, 0.69211>, <-2.92423, 0.20000, 1.01400>, <-2.43360, 0.20000, 1.01400> }
		triangle  { <-2.92423, 0.20000, 0.69211>, <-2.43360, 0.20000, 0.69211>, <-2.43360, 0.20000, 1.01400> }
		triangle  { <-1.79572, 0.20000, -0.01611>, <-1.30509, 0.20000, -0.01611>, <-1.79572, -0.12255, -0.01611> }
		triangle  { <-1.30509, -0.12255, -0.01611>, <-1.30509, 0.20000, -0.01611>, <-1.79572, -0.12255, -0.01611> }
		triangle  { <-1.30509, 0.20000, -0.01611>, <-1.30509, -0.12255, -0.01611>, <-1.30509, -0.12255, 0.30578> }
		triangle  { <-1.30509, 0.20000, -0.01611>, <-1.30509, 0.20000, 0.30578>, <-1.30509, -0.12255, 0.30578> }
		triangle  { <-1.79572, 0.20000, -0.01611>, <-1.79572, -0.12255, -0.01611>, <-1.79572, -0.12255, 0.30578> }
		triangle  { <-1.79572, 0.20000, -0.01611>, <-1.79572, 0.20000, 0.30578>, <-1.79572, -0.12255, 0.30578> }
		triangle  { <-1.79572, 0.20000, 0.30578>, <-1.30509, 0.20000, 0.30578>, <-1.79572, -0.12255, 0.30578> }
		triangle  { <-1.30509, 0.20000, 0.30578>, <-1.30509, -0.12255, 0.30578>, <-1.79572, -0.12255, 0.30578> }
		triangle  { <-1.79572, -0.12255, -0.01611>, <-1.30509, -0.12255, -0.01611>, <-1.30509, -0.12255, 0.30578> }
		triangle  { <-1.79572, -0.12255, -0.01611>, <-1.79572, -0.12255, 0.30578>, <-1.30509, -0.12255, 0.30578> }
		triangle  { <-1.79572, 0.20000, -0.01611>, <-1.79572, 0.20000, 0.30578>, <-1.30509, 0.20000, 0.30578> }
		triangle  { <-1.79572, 0.20000, -0.01611>, <-1.30509, 0.20000, -0.01611>, <-1.30509, 0.20000, 0.30578> }
		triangle  { <2.62010, 0.20000, 1.36811>, <3.11073, 0.20000, 1.36811>, <2.62010, -0.12255, 1.36811> }
		triangle  { <3.11073, -0.12255, 1.36811>, <3.11073, 0.20000, 1.36811>, <2.62010, -0.12255, 1.36811> }
		triangle  { <3.11073, 0.20000, 1.36811>, <3.11073, -0.12255, 1.36811>, <3.11073, -0.12255, 1.69000> }
		triangle  { <3.11073, 0.20000, 1.36811>, <3.11073, 0.20000, 1.69000>, <3.11073, -0.12255, 1.69000> }
		triangle  { <2.62010, 0.20000, 1.36811>, <2.62010, -0.12255, 1.36811>, <2.62010, -0.12255, 1.69000> }
		triangle  { <2.62010, 0.20000, 1.36811>, <2.62010, 0.20000, 1.69000>, <2.62010, -0.12255, 1.69000> }
		triangle  { <2.62010, 0.20000, 1.69000>, <3.11073, 0.20000, 1.69000>, <2.62010, -0.12255, 1.69000> }
		triangle  { <3.11073, 0.20000, 1.69000>, <3.11073, -0.12255, 1.69000>, <2.62010, -0.12255, 1.69000> }
		triangle  { <2.62010, -0.12255, 1.36811>, <3.11073, -0.12255, 1.36811>, <3.11073, -0.12255, 1.69000> }
		triangle  { <2.62010, -0.12255, 1.36811>, <2.62010, -0.12255, 1.69000>, <3.11073, -0.12255, 1.69000> }
		triangle  { <2.62010, 0.20000, 1.36811>, <2.62010, 0.20000, 1.69000>, <3.11073, 0.20000, 1.69000> }
		triangle  { <2.62010, 0.20000, 1.36811>, <3.11073, 0.20000, 1.36811>, <3.11073, 0.20000, 1.69000> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, -0.12255, 0.69211>, <3.25790, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <3.25790, 0.20000, 1.01400>, <3.25790, -0.12255, 1.01400>, <2.76727, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <3.25790, -0.12255, 0.69211>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, -0.12255, 0.69211>, <2.76727, -0.12255, 1.01400>, <3.25790, -0.12255, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <2.76727, 0.20000, 1.01400>, <3.25790, 0.20000, 1.01400> }
		triangle  { <2.76727, 0.20000, 0.69211>, <3.25790, 0.20000, 0.69211>, <3.25790, 0.20000, 1.01400> }
		triangle  { <-2.43360, 0.20000, -0.01611>, <-1.94298, 0.20000, -0.01611>, <-2.43360, -0.12255, -0.01611> }
		triangle  { <-1.94298, -0.12255, -0.01611>, <-1.94298, 0.20000, -0.01611>, <-2.43360, -0.12255, -0.01611> }
		triangle  { <-1.94298, 0.20000, -0.01611>, <-1.94298, -0.12255, -0.01611>, <-1.94298, -0.12255, 0.30578> }
		triangle  { <-1.94298, 0.20000, -0.01611>, <-1.94298, 0.20000, 0.30578>, <-1.94298, -0.12255, 0.30578> }
		triangle  { <-2.43360, 0.20000, -0.01611>, <-2.43360, -0.12255, -0.01611>, <-2.43360, -0.12255, 0.30578> }
		triangle  { <-2.43360, 0.20000, -0.01611>, <-2.43360, 0.20000, 0.30578>, <-2.43360, -0.12255, 0.30578> }
		triangle  { <-2.43360, 0.20000, 0.30578>, <-1.94298, 0.20000, 0.30578>, <-2.43360, -0.12255, 0.30578> }
		triangle  { <-1.94298, 0.20000, 0.30578>, <-1.94298, -0.12255, 0.30578>, <-2.43360, -0.12255, 0.30578> }
		triangle  { <-2.43360, -0.12255, -0.01611>, <-1.94298, -0.12255, -0.01611>, <-1.94298, -0.12255, 0.30578> }
		triangle  { <-2.43360, -0.12255, -0.01611>, <-2.43360, -0.12255, 0.30578>, <-1.94298, -0.12255, 0.30578> }
		triangle  { <-2.43360, 0.20000, -0.01611>, <-2.43360, 0.20000, 0.30578>, <-1.94298, 0.20000, 0.30578> }
		triangle  { <-2.43360, 0.20000, -0.01611>, <-1.94298, 0.20000, -0.01611>, <-1.94298, 0.20000, 0.30578> }
		triangle  { <-1.20695, 0.20000, -0.01611>, <-0.71632, 0.20000, -0.01611>, <-1.20695, -0.12255, -0.01611> }
		triangle  { <-0.71632, -0.12255, -0.01611>, <-0.71632, 0.20000, -0.01611>, <-1.20695, -0.12255, -0.01611> }
		triangle  { <-0.71632, 0.20000, -0.01611>, <-0.71632, -0.12255, -0.01611>, <-0.71632, -0.12255, 0.30578> }
		triangle  { <-0.71632, 0.20000, -0.01611>, <-0.71632, 0.20000, 0.30578>, <-0.71632, -0.12255, 0.30578> }
		triangle  { <-1.20695, 0.20000, -0.01611>, <-1.20695, -0.12255, -0.01611>, <-1.20695, -0.12255, 0.30578> }
		triangle  { <-1.20695, 0.20000, -0.01611>, <-1.20695, 0.20000, 0.30578>, <-1.20695, -0.12255, 0.30578> }
		triangle  { <-1.20695, 0.20000, 0.30578>, <-0.71632, 0.20000, 0.30578>, <-1.20695, -0.12255, 0.30578> }
		triangle  { <-0.71632, 0.20000, 0.30578>, <-0.71632, -0.12255, 0.30578>, <-1.20695, -0.12255, 0.30578> }
		triangle  { <-1.20695, -0.12255, -0.01611>, <-0.71632, -0.12255, -0.01611>, <-0.71632, -0.12255, 0.30578> }
		triangle  { <-1.20695, -0.12255, -0.01611>, <-1.20695, -0.12255, 0.30578>, <-0.71632, -0.12255, 0.30578> }
		triangle  { <-1.20695, 0.20000, -0.01611>, <-1.20695, 0.20000, 0.30578>, <-0.71632, 0.20000, 0.30578> }
		triangle  { <-1.20695, 0.20000, -0.01611>, <-0.71632, 0.20000, -0.01611>, <-0.71632, 0.20000, 0.30578> }
		triangle  { <-0.56915, 0.20000, -0.01611>, <0.01962, 0.20000, -0.01611>, <-0.56915, -0.12255, -0.01611> }
		triangle  { <0.01962, -0.12255, -0.01611>, <0.01962, 0.20000, -0.01611>, <-0.56915, -0.12255, -0.01611> }
		triangle  { <0.01962, 0.20000, -0.01611>, <0.01962, -0.12255, -0.01611>, <0.01962, -0.12255, 0.30578> }
		triangle  { <0.01962, 0.20000, -0.01611>, <0.01962, 0.20000, 0.30578>, <0.01962, -0.12255, 0.30578> }
		triangle  { <-0.56915, 0.20000, -0.01611>, <-0.56915, -0.12255, -0.01611>, <-0.56915, -0.12255, 0.30578> }
		triangle  { <-0.56915, 0.20000, -0.01611>, <-0.56915, 0.20000, 0.30578>, <-0.56915, -0.12255, 0.30578> }
		triangle  { <-0.56915, 0.20000, 0.30578>, <0.01962, 0.20000, 0.30578>, <-0.56915, -0.12255, 0.30578> }
		triangle  { <0.01962, 0.20000, 0.30578>, <0.01962, -0.12255, 0.30578>, <-0.56915, -0.12255, 0.30578> }
		triangle  { <-0.56915, -0.12255, -0.01611>, <0.01962, -0.12255, -0.01611>, <0.01962, -0.12255, 0.30578> }
		triangle  { <-0.56915, -0.12255, -0.01611>, <-0.56915, -0.12255, 0.30578>, <0.01962, -0.12255, 0.30578> }
		triangle  { <-0.56915, 0.20000, -0.01611>, <-0.56915, 0.20000, 0.30578>, <0.01962, 0.20000, 0.30578> }
		triangle  { <-0.56915, 0.20000, -0.01611>, <0.01962, 0.20000, -0.01611>, <0.01962, 0.20000, 0.30578> }
		triangle  { <0.16688, 0.20000, -0.01611>, <0.65750, 0.20000, -0.01611>, <0.16688, -0.12255, -0.01611> }
		triangle  { <0.65750, -0.12255, -0.01611>, <0.65750, 0.20000, -0.01611>, <0.16688, -0.12255, -0.01611> }
		triangle  { <0.65750, 0.20000, -0.01611>, <0.65750, -0.12255, -0.01611>, <0.65750, -0.12255, 0.30578> }
		triangle  { <0.65750, 0.20000, -0.01611>, <0.65750, 0.20000, 0.30578>, <0.65750, -0.12255, 0.30578> }
		triangle  { <0.16688, 0.20000, -0.01611>, <0.16688, -0.12255, -0.01611>, <0.16688, -0.12255, 0.30578> }
		triangle  { <0.16688, 0.20000, -0.01611>, <0.16688, 0.20000, 0.30578>, <0.16688, -0.12255, 0.30578> }
		triangle  { <0.16688, 0.20000, 0.30578>, <0.65750, 0.20000, 0.30578>, <0.16688, -0.12255, 0.30578> }
		triangle  { <0.65750, 0.20000, 0.30578>, <0.65750, -0.12255, 0.30578>, <0.16688, -0.12255, 0.30578> }
		triangle  { <0.16688, -0.12255, -0.01611>, <0.65750, -0.12255, -0.01611>, <0.65750, -0.12255, 0.30578> }
		triangle  { <0.16688, -0.12255, -0.01611>, <0.16688, -0.12255, 0.30578>, <0.65750, -0.12255, 0.30578> }
		triangle  { <0.16688, 0.20000, -0.01611>, <0.16688, 0.20000, 0.30578>, <0.65750, 0.20000, 0.30578> }
		triangle  { <0.16688, 0.20000, -0.01611>, <0.65750, 0.20000, -0.01611>, <0.65750, 0.20000, 0.30578> }
		triangle  { <0.80468, 0.20000, -0.01611>, <1.29530, 0.20000, -0.01611>, <0.80468, -0.12255, -0.01611> }
		triangle  { <1.29530, -0.12255, -0.01611>, <1.29530, 0.20000, -0.01611>, <0.80468, -0.12255, -0.01611> }
		triangle  { <1.29530, 0.20000, -0.01611>, <1.29530, -0.12255, -0.01611>, <1.29530, -0.12255, 0.30578> }
		triangle  { <1.29530, 0.20000, -0.01611>, <1.29530, 0.20000, 0.30578>, <1.29530, -0.12255, 0.30578> }
		triangle  { <0.80468, 0.20000, -0.01611>, <0.80468, -0.12255, -0.01611>, <0.80468, -0.12255, 0.30578> }
		triangle  { <0.80468, 0.20000, -0.01611>, <0.80468, 0.20000, 0.30578>, <0.80468, -0.12255, 0.30578> }
		triangle  { <0.80468, 0.20000, 0.30578>, <1.29530, 0.20000, 0.30578>, <0.80468, -0.12255, 0.30578> }
		triangle  { <1.29530, 0.20000, 0.30578>, <1.29530, -0.12255, 0.30578>, <0.80468, -0.12255, 0.30578> }
		triangle  { <0.80468, -0.12255, -0.01611>, <1.29530, -0.12255, -0.01611>, <1.29530, -0.12255, 0.30578> }
		triangle  { <0.80468, -0.12255, -0.01611>, <0.80468, -0.12255, 0.30578>, <1.29530, -0.12255, 0.30578> }
		triangle  { <0.80468, 0.20000, -0.01611>, <0.80468, 0.20000, 0.30578>, <1.29530, 0.20000, 0.30578> }
		triangle  { <0.80468, 0.20000, -0.01611>, <1.29530, 0.20000, -0.01611>, <1.29530, 0.20000, 0.30578> }
		triangle  { <1.49159, 0.20000, -0.01611>, <1.98222, 0.20000, -0.01611>, <1.49159, -0.12255, -0.01611> }
		triangle  { <1.98222, -0.12255, -0.01611>, <1.98222, 0.20000, -0.01611>, <1.49159, -0.12255, -0.01611> }
		triangle  { <1.98222, 0.20000, -0.01611>, <1.98222, -0.12255, -0.01611>, <1.98222, -0.12255, 0.30578> }
		triangle  { <1.98222, 0.20000, -0.01611>, <1.98222, 0.20000, 0.30578>, <1.98222, -0.12255, 0.30578> }
		triangle  { <1.49159, 0.20000, -0.01611>, <1.49159, -0.12255, -0.01611>, <1.49159, -0.12255, 0.30578> }
		triangle  { <1.49159, 0.20000, -0.01611>, <1.49159, 0.20000, 0.30578>, <1.49159, -0.12255, 0.30578> }
		triangle  { <1.49159, 0.20000, 0.30578>, <1.98222, 0.20000, 0.30578>, <1.49159, -0.12255, 0.30578> }
		triangle  { <1.98222, 0.20000, 0.30578>, <1.98222, -0.12255, 0.30578>, <1.49159, -0.12255, 0.30578> }
		triangle  { <1.49159, -0.12255, -0.01611>, <1.98222, -0.12255, -0.01611>, <1.98222, -0.12255, 0.30578> }
		triangle  { <1.49159, -0.12255, -0.01611>, <1.49159, -0.12255, 0.30578>, <1.98222, -0.12255, 0.30578> }
		triangle  { <1.49159, 0.20000, -0.01611>, <1.49159, 0.20000, 0.30578>, <1.98222, 0.20000, 0.30578> }
		triangle  { <1.49159, 0.20000, -0.01611>, <1.98222, 0.20000, -0.01611>, <1.98222, 0.20000, 0.30578> }
		triangle  { <2.12947, 0.20000, -0.04828>, <3.20887, 0.20000, -0.04828>, <2.12947, -0.12255, -0.04828> }
		triangle  { <3.20887, -0.12255, -0.04828>, <3.20887, 0.20000, -0.04828>, <2.12947, -0.12255, -0.04828> }
		triangle  { <3.20887, 0.20000, -0.04828>, <3.20887, -0.12255, -0.04828>, <3.20887, -0.12255, 0.33800> }
		triangle  { <3.20887, 0.20000, -0.04828>, <3.20887, 0.20000, 0.33800>, <3.20887, -0.12255, 0.33800> }
		triangle  { <2.12947, 0.20000, -0.04828>, <2.12947, -0.12255, -0.04828>, <2.12947, -0.12255, 0.33800> }
		triangle  { <2.12947, 0.20000, -0.04828>, <2.12947, 0.20000, 0.33800>, <2.12947, -0.12255, 0.33800> }
		triangle  { <2.12947, 0.20000, 0.33800>, <3.20887, 0.20000, 0.33800>, <2.12947, -0.12255, 0.33800> }
		triangle  { <3.20887, 0.20000, 0.33800>, <3.20887, -0.12255, 0.33800>, <2.12947, -0.12255, 0.33800> }
		triangle  { <2.12947, -0.12255, -0.04828>, <3.20887, -0.12255, -0.04828>, <3.20887, -0.12255, 0.33800> }
		triangle  { <2.12947, -0.12255, -0.04828>, <2.12947, -0.12255, 0.33800>, <3.20887, -0.12255, 0.33800> }
		triangle  { <2.12947, 0.20000, -0.04828>, <2.12947, 0.20000, 0.33800>, <3.20887, 0.20000, 0.33800> }
		triangle  { <2.12947, 0.20000, -0.04828>, <3.20887, 0.20000, -0.04828>, <3.20887, 0.20000, 0.33800> }
		triangle  { <3.40516, 0.20000, 0.69211>, <3.89578, 0.20000, 0.69211>, <3.40516, -0.12255, 0.69211> }
		triangle  { <3.89578, -0.12255, 0.69211>, <3.89578, 0.20000, 0.69211>, <3.40516, -0.12255, 0.69211> }
		triangle  { <3.89578, 0.20000, 0.69211>, <3.89578, -0.12255, 0.69211>, <3.89578, -0.12255, 1.01400> }
		triangle  { <3.89578, 0.20000, 0.69211>, <3.89578, 0.20000, 1.01400>, <3.89578, -0.12255, 1.01400> }
		triangle  { <3.40516, 0.20000, 0.69211>, <3.40516, -0.12255, 0.69211>, <3.40516, -0.12255, 1.01400> }
		triangle  { <3.40516, 0.20000, 0.69211>, <3.40516, 0.20000, 1.01400>, <3.40516, -0.12255, 1.01400> }
		triangle  { <3.40516, 0.20000, 1.01400>, <3.89578, 0.20000, 1.01400>, <3.40516, -0.12255, 1.01400> }
		triangle  { <3.89578, 0.20000, 1.01400>, <3.89578, -0.12255, 1.01400>, <3.40516, -0.12255, 1.01400> }
		triangle  { <3.40516, -0.12255, 0.69211>, <3.89578, -0.12255, 0.69211>, <3.89578, -0.12255, 1.01400> }
		triangle  { <3.40516, -0.12255, 0.69211>, <3.40516, -0.12255, 1.01400>, <3.89578, -0.12255, 1.01400> }
		triangle  { <3.40516, 0.20000, 0.69211>, <3.40516, 0.20000, 1.01400>, <3.89578, 0.20000, 1.01400> }
		triangle  { <3.40516, 0.20000, 0.69211>, <3.89578, 0.20000, 0.69211>, <3.89578, 0.20000, 1.01400> }
		triangle  { <2.37479, 0.20000, -0.56333>, <3.94490, 0.20000, -0.56333>, <2.37479, -0.12255, -0.56333> }
		triangle  { <3.94490, -0.12255, -0.56333>, <3.94490, 0.20000, -0.56333>, <2.37479, -0.12255, -0.56333> }
		triangle  { <3.94490, 0.20000, -0.56333>, <3.94490, -0.12255, -0.56333>, <3.94490, -0.12255, -0.17706> }
		triangle  { <3.94490, 0.20000, -0.56333>, <3.94490, 0.20000, -0.17706>, <3.94490, -0.12255, -0.17706> }
		triangle  { <2.37479, 0.20000, -0.56333>, <2.37479, -0.12255, -0.56333>, <2.37479, -0.12255, -0.17706> }
		triangle  { <2.37479, 0.20000, -0.56333>, <2.37479, 0.20000, -0.17706>, <2.37479, -0.12255, -0.17706> }
		triangle  { <2.37479, 0.20000, -0.17706>, <3.94490, 0.20000, -0.17706>, <2.37479, -0.12255, -0.17706> }
		triangle  { <3.94490, 0.20000, -0.17706>, <3.94490, -0.12255, -0.17706>, <2.37479, -0.12255, -0.17706> }
		triangle  { <2.37479, -0.12255, -0.56333>, <3.94490, -0.12255, -0.56333>, <3.94490, -0.12255, -0.17706> }
		triangle  { <2.37479, -0.12255, -0.56333>, <2.37479, -0.12255, -0.17706>, <3.94490, -0.12255, -0.17706> }
		triangle  { <2.37479, 0.20000, -0.56333>, <2.37479, 0.20000, -0.17706>, <3.94490, 0.20000, -0.17706> }
		triangle  { <2.37479, 0.20000, -0.56333>, <3.94490, 0.20000, -0.56333>, <3.94490, 0.20000, -0.17706> }
		triangle  { <3.40516, 0.20000, 0.01611>, <3.89578, 0.20000, 0.01611>, <3.40516, -0.12255, 0.01611> }
		triangle  { <3.89578, -0.12255, 0.01611>, <3.89578, 0.20000, 0.01611>, <3.40516, -0.12255, 0.01611> }
		triangle  { <3.89578, 0.20000, 0.01611>, <3.89578, -0.12255, 0.01611>, <3.89578, -0.12255, 0.33800> }
		triangle  { <3.89578, 0.20000, 0.01611>, <3.89578, 0.20000, 0.33800>, <3.89578, -0.12255, 0.33800> }
		triangle  { <3.40516, 0.20000, 0.01611>, <3.40516, -0.12255, 0.01611>, <3.40516, -0.12255, 0.33800> }
		triangle  { <3.40516, 0.20000, 0.01611>, <3.40516, 0.20000, 0.33800>, <3.40516, -0.12255, 0.33800> }
		triangle  { <3.40516, 0.20000, 0.33800>, <3.89578, 0.20000, 0.33800>, <3.40516, -0.12255, 0.33800> }
		triangle  { <3.89578, 0.20000, 0.33800>, <3.89578, -0.12255, 0.33800>, <3.40516, -0.12255, 0.33800> }
		triangle  { <3.40516, -0.12255, 0.01611>, <3.89578, -0.12255, 0.01611>, <3.89578, -0.12255, 0.33800> }
		triangle  { <3.40516, -0.12255, 0.01611>, <3.40516, -0.12255, 0.33800>, <3.89578, -0.12255, 0.33800> }
		triangle  { <3.40516, 0.20000, 0.01611>, <3.40516, 0.20000, 0.33800>, <3.89578, 0.20000, 0.33800> }
		triangle  { <3.40516, 0.20000, 0.01611>, <3.89578, 0.20000, 0.01611>, <3.89578, 0.20000, 0.33800> }
		triangle  { <1.98230, 0.20000, -1.07839>, <3.94490, 0.20000, -1.07839>, <1.98230, -0.12255, -1.07839> }
		triangle  { <3.94490, -0.12255, -1.07839>, <3.94490, 0.20000, -1.07839>, <1.98230, -0.12255, -1.07839> }
		triangle  { <3.94490, 0.20000, -1.07839>, <3.94490, -0.12255, -1.07839>, <3.94490, -0.12255, -0.69211> }
		triangle  { <3.94490, 0.20000, -1.07839>, <3.94490, 0.20000, -0.69211>, <3.94490, -0.12255, -0.69211> }
		triangle  { <1.98230, 0.20000, -1.07839>, <1.98230, -0.12255, -1.07839>, <1.98230, -0.12255, -0.69211> }
		triangle  { <1.98230, 0.20000, -1.07839>, <1.98230, 0.20000, -0.69211>, <1.98230, -0.12255, -0.69211> }
		triangle  { <1.98230, 0.20000, -0.69211>, <3.94490, 0.20000, -0.69211>, <1.98230, -0.12255, -0.69211> }
		triangle  { <3.94490, 0.20000, -0.69211>, <3.94490, -0.12255, -0.69211>, <1.98230, -0.12255, -0.69211> }
		triangle  { <1.98230, -0.12255, -1.07839>, <3.94490, -0.12255, -1.07839>, <3.94490, -0.12255, -0.69211> }
		triangle  { <1.98230, -0.12255, -1.07839>, <1.98230, -0.12255, -0.69211>, <3.94490, -0.12255, -0.69211> }
		triangle  { <1.98230, 0.20000, -1.07839>, <1.98230, 0.20000, -0.69211>, <3.94490, 0.20000, -0.69211> }
		triangle  { <1.98230, 0.20000, -1.07839>, <3.94490, 0.20000, -1.07839>, <3.94490, 0.20000, -0.69211> }
		triangle  { <2.66921, 0.20000, -1.59344>, <3.94490, 0.20000, -1.59344>, <2.66921, -0.12255, -1.59344> }
		triangle  { <3.94490, -0.12255, -1.59344>, <3.94490, 0.20000, -1.59344>, <2.66921, -0.12255, -1.59344> }
		triangle  { <3.94490, 0.20000, -1.59344>, <3.94490, -0.12255, -1.59344>, <3.94490, -0.12255, -1.20717> }
		triangle  { <3.94490, 0.20000, -1.59344>, <3.94490, 0.20000, -1.20717>, <3.94490, -0.12255, -1.20717> }
		triangle  { <2.66921, 0.20000, -1.59344>, <2.66921, -0.12255, -1.59344>, <2.66921, -0.12255, -1.20717> }
		triangle  { <2.66921, 0.20000, -1.59344>, <2.66921, 0.20000, -1.20717>, <2.66921, -0.12255, -1.20717> }
		triangle  { <2.66921, 0.20000, -1.20717>, <3.94490, 0.20000, -1.20717>, <2.66921, -0.12255, -1.20717> }
		triangle  { <3.94490, 0.20000, -1.20717>, <3.94490, -0.12255, -1.20717>, <2.66921, -0.12255, -1.20717> }
		triangle  { <2.66921, -0.12255, -1.59344>, <3.94490, -0.12255, -1.59344>, <3.94490, -0.12255, -1.20717> }
		triangle  { <2.66921, -0.12255, -1.59344>, <2.66921, -0.12255, -1.20717>, <3.94490, -0.12255, -1.20717> }
		triangle  { <2.66921, 0.20000, -1.59344>, <2.66921, 0.20000, -1.20717>, <3.94490, 0.20000, -1.20717> }
		triangle  { <2.66921, 0.20000, -1.59344>, <3.94490, 0.20000, -1.59344>, <3.94490, 0.20000, -1.20717> }
		triangle  { <-2.62989, 0.20000, -0.53117>, <-2.13926, 0.20000, -0.53117>, <-2.62989, -0.12255, -0.53117> }
		triangle  { <-2.13926, -0.12255, -0.53117>, <-2.13926, 0.20000, -0.53117>, <-2.62989, -0.12255, -0.53117> }
		triangle  { <-2.13926, 0.20000, -0.53117>, <-2.13926, -0.12255, -0.53117>, <-2.13926, -0.12255, -0.20928> }
		triangle  { <-2.13926, 0.20000, -0.53117>, <-2.13926, 0.20000, -0.20928>, <-2.13926, -0.12255, -0.20928> }
		triangle  { <-2.62989, 0.20000, -0.53117>, <-2.62989, -0.12255, -0.53117>, <-2.62989, -0.12255, -0.20928> }
		triangle  { <-2.62989, 0.20000, -0.53117>, <-2.62989, 0.20000, -0.20928>, <-2.62989, -0.12255, -0.20928> }
		triangle  { <-2.62989, 0.20000, -0.20928>, <-2.13926, 0.20000, -0.20928>, <-2.62989, -0.12255, -0.20928> }
		triangle  { <-2.13926, 0.20000, -0.20928>, <-2.13926, -0.12255, -0.20928>, <-2.62989, -0.12255, -0.20928> }
		triangle  { <-2.62989, -0.12255, -0.53117>, <-2.13926, -0.12255, -0.53117>, <-2.13926, -0.12255, -0.20928> }
		triangle  { <-2.62989, -0.12255, -0.53117>, <-2.62989, -0.12255, -0.20928>, <-2.13926, -0.12255, -0.20928> }
		triangle  { <-2.62989, 0.20000, -0.53117>, <-2.62989, 0.20000, -0.20928>, <-2.13926, 0.20000, -0.20928> }
		triangle  { <-2.62989, 0.20000, -0.53117>, <-2.13926, 0.20000, -0.53117>, <-2.13926, 0.20000, -0.20928> }
		triangle  { <-1.99200, 0.20000, -0.53117>, <-1.50138, 0.20000, -0.53117>, <-1.99200, -0.12255, -0.53117> }
		triangle  { <-1.50138, -0.12255, -0.53117>, <-1.50138, 0.20000, -0.53117>, <-1.99200, -0.12255, -0.53117> }
		triangle  { <-1.50138, 0.20000, -0.53117>, <-1.50138, -0.12255, -0.53117>, <-1.50138, -0.12255, -0.20928> }
		triangle  { <-1.50138, 0.20000, -0.53117>, <-1.50138, 0.20000, -0.20928>, <-1.50138, -0.12255, -0.20928> }
		triangle  { <-1.99200, 0.20000, -0.53117>, <-1.99200, -0.12255, -0.53117>, <-1.99200, -0.12255, -0.20928> }
		triangle  { <-1.99200, 0.20000, -0.53117>, <-1.99200, 0.20000, -0.20928>, <-1.99200, -0.12255, -0.20928> }
		triangle  { <-1.99200, 0.20000, -0.20928>, <-1.50138, 0.20000, -0.20928>, <-1.99200, -0.12255, -0.20928> }
		triangle  { <-1.50138, 0.20000, -0.20928>, <-1.50138, -0.12255, -0.20928>, <-1.99200, -0.12255, -0.20928> }
		triangle  { <-1.99200, -0.12255, -0.53117>, <-1.50138, -0.12255, -0.53117>, <-1.50138, -0.12255, -0.20928> }
		triangle  { <-1.99200, -0.12255, -0.53117>, <-1.99200, -0.12255, -0.20928>, <-1.50138, -0.12255, -0.20928> }
		triangle  { <-1.99200, 0.20000, -0.53117>, <-1.99200, 0.20000, -0.20928>, <-1.50138, 0.20000, -0.20928> }
		triangle  { <-1.99200, 0.20000, -0.53117>, <-1.50138, 0.20000, -0.53117>, <-1.50138, 0.20000, -0.20928> }
		triangle  { <-1.30509, 0.20000, -0.53117>, <-0.81446, 0.20000, -0.53117>, <-1.30509, -0.12255, -0.53117> }
		triangle  { <-0.81446, -0.12255, -0.53117>, <-0.81446, 0.20000, -0.53117>, <-1.30509, -0.12255, -0.53117> }
		triangle  { <-0.81446, 0.20000, -0.53117>, <-0.81446, -0.12255, -0.53117>, <-0.81446, -0.12255, -0.20928> }
		triangle  { <-0.81446, 0.20000, -0.53117>, <-0.81446, 0.20000, -0.20928>, <-0.81446, -0.12255, -0.20928> }
		triangle  { <-1.30509, 0.20000, -0.53117>, <-1.30509, -0.12255, -0.53117>, <-1.30509, -0.12255, -0.20928> }
		triangle  { <-1.30509, 0.20000, -0.53117>, <-1.30509, 0.20000, -0.20928>, <-1.30509, -0.12255, -0.20928> }
		triangle  { <-1.30509, 0.20000, -0.20928>, <-0.81446, 0.20000, -0.20928>, <-1.30509, -0.12255, -0.20928> }
		triangle  { <-0.81446, 0.20000, -0.20928>, <-0.81446, -0.12255, -0.20928>, <-1.30509, -0.12255, -0.20928> }
		triangle  { <-1.30509, -0.12255, -0.53117>, <-0.81446, -0.12255, -0.53117>, <-0.81446, -0.12255, -0.20928> }
		triangle  { <-1.30509, -0.12255, -0.53117>, <-1.30509, -0.12255, -0.20928>, <-0.81446, -0.12255, -0.20928> }
		triangle  { <-1.30509, 0.20000, -0.53117>, <-1.30509, 0.20000, -0.20928>, <-0.81446, 0.20000, -0.20928> }
		triangle  { <-1.30509, 0.20000, -0.53117>, <-0.81446, 0.20000, -0.53117>, <-0.81446, 0.20000, -0.20928> }
		triangle  { <-0.61818, 0.20000, -0.53117>, <-0.12755, 0.20000, -0.53117>, <-0.61818, -0.12255, -0.53117> }
		triangle  { <-0.12755, -0.12255, -0.53117>, <-0.12755, 0.20000, -0.53117>, <-0.61818, -0.12255, -0.53117> }
		triangle  { <-0.12755, 0.20000, -0.53117>, <-0.12755, -0.12255, -0.53117>, <-0.12755, -0.12255, -0.20928> }
		triangle  { <-0.12755, 0.20000, -0.53117>, <-0.12755, 0.20000, -0.20928>, <-0.12755, -0.12255, -0.20928> }
		triangle  { <-0.61818, 0.20000, -0.53117>, <-0.61818, -0.12255, -0.53117>, <-0.61818, -0.12255, -0.20928> }
		triangle  { <-0.61818, 0.20000, -0.53117>, <-0.61818, 0.20000, -0.20928>, <-0.61818, -0.12255, -0.20928> }
		triangle  { <-0.61818, 0.20000, -0.20928>, <-0.12755, 0.20000, -0.20928>, <-0.61818, -0.12255, -0.20928> }
		triangle  { <-0.12755, 0.20000, -0.20928>, <-0.12755, -0.12255, -0.20928>, <-0.61818, -0.12255, -0.20928> }
		triangle  { <-0.61818, -0.12255, -0.53117>, <-0.12755, -0.12255, -0.53117>, <-0.12755, -0.12255, -0.20928> }
		triangle  { <-0.61818, -0.12255, -0.53117>, <-0.61818, -0.12255, -0.20928>, <-0.12755, -0.12255, -0.20928> }
		triangle  { <-0.61818, 0.20000, -0.53117>, <-0.61818, 0.20000, -0.20928>, <-0.12755, 0.20000, -0.20928> }
		triangle  { <-0.61818, 0.20000, -0.53117>, <-0.12755, 0.20000, -0.53117>, <-0.12755, 0.20000, -0.20928> }
		triangle  { <0.06873, 0.20000, -0.53117>, <0.55936, 0.20000, -0.53117>, <0.06873, -0.12255, -0.53117> }
		triangle  { <0.55936, -0.12255, -0.53117>, <0.55936, 0.20000, -0.53117>, <0.06873, -0.12255, -0.53117> }
		triangle  { <0.55936, 0.20000, -0.53117>, <0.55936, -0.12255, -0.53117>, <0.55936, -0.12255, -0.20928> }
		triangle  { <0.55936, 0.20000, -0.53117>, <0.55936, 0.20000, -0.20928>, <0.55936, -0.12255, -0.20928> }
		triangle  { <0.06873, 0.20000, -0.53117>, <0.06873, -0.12255, -0.53117>, <0.06873, -0.12255, -0.20928> }
		triangle  { <0.06873, 0.20000, -0.53117>, <0.06873, 0.20000, -0.20928>, <0.06873, -0.12255, -0.20928> }
		triangle  { <0.06873, 0.20000, -0.20928>, <0.55936, 0.20000, -0.20928>, <0.06873, -0.12255, -0.20928> }
		triangle  { <0.55936, 0.20000, -0.20928>, <0.55936, -0.12255, -0.20928>, <0.06873, -0.12255, -0.20928> }
		triangle  { <0.06873, -0.12255, -0.53117>, <0.55936, -0.12255, -0.53117>, <0.55936, -0.12255, -0.20928> }
		triangle  { <0.06873, -0.12255, -0.53117>, <0.06873, -0.12255, -0.20928>, <0.55936, -0.12255, -0.20928> }
		triangle  { <0.06873, 0.20000, -0.53117>, <0.06873, 0.20000, -0.20928>, <0.55936, 0.20000, -0.20928> }
		triangle  { <0.06873, 0.20000, -0.53117>, <0.55936, 0.20000, -0.53117>, <0.55936, 0.20000, -0.20928> }
		triangle  { <0.70662, 0.20000, -0.49894>, <1.19725, 0.20000, -0.49894>, <0.70662, -0.12255, -0.49894> }
		triangle  { <1.19725, -0.12255, -0.49894>, <1.19725, 0.20000, -0.49894>, <0.70662, -0.12255, -0.49894> }
		triangle  { <1.19725, 0.20000, -0.49894>, <1.19725, -0.12255, -0.49894>, <1.19725, -0.12255, -0.17706> }
		triangle  { <1.19725, 0.20000, -0.49894>, <1.19725, 0.20000, -0.17706>, <1.19725, -0.12255, -0.17706> }
		triangle  { <0.70662, 0.20000, -0.49894>, <0.70662, -0.12255, -0.49894>, <0.70662, -0.12255, -0.17706> }
		triangle  { <0.70662, 0.20000, -0.49894>, <0.70662, 0.20000, -0.17706>, <0.70662, -0.12255, -0.17706> }
		triangle  { <0.70662, 0.20000, -0.17706>, <1.19725, 0.20000, -0.17706>, <0.70662, -0.12255, -0.17706> }
		triangle  { <1.19725, 0.20000, -0.17706>, <1.19725, -0.12255, -0.17706>, <0.70662, -0.12255, -0.17706> }
		triangle  { <0.70662, -0.12255, -0.49894>, <1.19725, -0.12255, -0.49894>, <1.19725, -0.12255, -0.17706> }
		triangle  { <0.70662, -0.12255, -0.49894>, <0.70662, -0.12255, -0.17706>, <1.19725, -0.12255, -0.17706> }
		triangle  { <0.70662, 0.20000, -0.49894>, <0.70662, 0.20000, -0.17706>, <1.19725, 0.20000, -0.17706> }
		triangle  { <0.70662, 0.20000, -0.49894>, <1.19725, 0.20000, -0.49894>, <1.19725, 0.20000, -0.17706> }
		triangle  { <1.39353, 0.20000, -0.49894>, <1.88416, 0.20000, -0.49894>, <1.39353, -0.12255, -0.49894> }
		triangle  { <1.88416, -0.12255, -0.49894>, <1.88416, 0.20000, -0.49894>, <1.39353, -0.12255, -0.49894> }
		triangle  { <1.88416, 0.20000, -0.49894>, <1.88416, -0.12255, -0.49894>, <1.88416, -0.12255, -0.17706> }
		triangle  { <1.88416, 0.20000, -0.49894>, <1.88416, 0.20000, -0.17706>, <1.88416, -0.12255, -0.17706> }
		triangle  { <1.39353, 0.20000, -0.49894>, <1.39353, -0.12255, -0.49894>, <1.39353, -0.12255, -0.17706> }
		triangle  { <1.39353, 0.20000, -0.49894>, <1.39353, 0.20000, -0.17706>, <1.39353, -0.12255, -0.17706> }
		triangle  { <1.39353, 0.20000, -0.17706>, <1.88416, 0.20000, -0.17706>, <1.39353, -0.12255, -0.17706> }
		triangle  { <1.88416, 0.20000, -0.17706>, <1.88416, -0.12255, -0.17706>, <1.39353, -0.12255, -0.17706> }
		triangle  { <1.39353, -0.12255, -0.49894>, <1.88416, -0.12255, -0.49894>, <1.88416, -0.12255, -0.17706> }
		triangle  { <1.39353, -0.12255, -0.49894>, <1.39353, -0.12255, -0.17706>, <1.88416, -0.12255, -0.17706> }
		triangle  { <1.39353, 0.20000, -0.49894>, <1.39353, 0.20000, -0.17706>, <1.88416, 0.20000, -0.17706> }
		triangle  { <1.39353, 0.20000, -0.49894>, <1.88416, 0.20000, -0.49894>, <1.88416, 0.20000, -0.17706> }
		triangle  { <-2.48263, 0.20000, -1.04622>, <-1.99200, 0.20000, -1.04622>, <-2.48263, -0.12255, -1.04622> }
		triangle  { <-1.99200, -0.12255, -1.04622>, <-1.99200, 0.20000, -1.04622>, <-2.48263, -0.12255, -1.04622> }
		triangle  { <-1.99200, 0.20000, -1.04622>, <-1.99200, -0.12255, -1.04622>, <-1.99200, -0.12255, -0.72433> }
		triangle  { <-1.99200, 0.20000, -1.04622>, <-1.99200, 0.20000, -0.72433>, <-1.99200, -0.12255, -0.72433> }
		triangle  { <-2.48263, 0.20000, -1.04622>, <-2.48263, -0.12255, -1.04622>, <-2.48263, -0.12255, -0.72433> }
		triangle  { <-2.48263, 0.20000, -1.04622>, <-2.48263, 0.20000, -0.72433>, <-2.48263, -0.12255, -0.72433> }
		triangle  { <-2.48263, 0.20000, -0.72433>, <-1.99200, 0.20000, -0.72433>, <-2.48263, -0.12255, -0.72433> }
		triangle  { <-1.99200, 0.20000, -0.72433>, <-1.99200, -0.12255, -0.72433>, <-2.48263, -0.12255, -0.72433> }
		triangle  { <-2.48263, -0.12255, -1.04622>, <-1.99200, -0.12255, -1.04622>, <-1.99200, -0.12255, -0.72433> }
		triangle  { <-2.48263, -0.12255, -1.04622>, <-2.48263, -0.12255, -0.72433>, <-1.99200, -0.12255, -0.72433> }
		triangle  { <-2.48263, 0.20000, -1.04622>, <-2.48263, 0.20000, -0.72433>, <-1.99200, 0.20000, -0.72433> }
		triangle  { <-2.48263, 0.20000, -1.04622>, <-1.99200, 0.20000, -1.04622>, <-1.99200, 0.20000, -0.72433> }
		triangle  { <-1.84483, 0.20000, -1.04622>, <-1.35421, 0.20000, -1.04622>, <-1.84483, -0.12255, -1.04622> }
		triangle  { <-1.35421, -0.12255, -1.04622>, <-1.35421, 0.20000, -1.04622>, <-1.84483, -0.12255, -1.04622> }
		triangle  { <-1.35421, 0.20000, -1.04622>, <-1.35421, -0.12255, -1.04622>, <-1.35421, -0.12255, -0.72433> }
		triangle  { <-1.35421, 0.20000, -1.04622>, <-1.35421, 0.20000, -0.72433>, <-1.35421, -0.12255, -0.72433> }
		triangle  { <-1.84483, 0.20000, -1.04622>, <-1.84483, -0.12255, -1.04622>, <-1.84483, -0.12255, -0.72433> }
		triangle  { <-1.84483, 0.20000, -1.04622>, <-1.84483, 0.20000, -0.72433>, <-1.84483, -0.12255, -0.72433> }
		triangle  { <-1.84483, 0.20000, -0.72433>, <-1.35421, 0.20000, -0.72433>, <-1.84483, -0.12255, -0.72433> }
		triangle  { <-1.35421, 0.20000, -0.72433>, <-1.35421, -0.12255, -0.72433>, <-1.84483, -0.12255, -0.72433> }
		triangle  { <-1.84483, -0.12255, -1.04622>, <-1.35421, -0.12255, -1.04622>, <-1.35421, -0.12255, -0.72433> }
		triangle  { <-1.84483, -0.12255, -1.04622>, <-1.84483, -0.12255, -0.72433>, <-1.35421, -0.12255, -0.72433> }
		triangle  { <-1.84483, 0.20000, -1.04622>, <-1.84483, 0.20000, -0.72433>, <-1.35421, 0.20000, -0.72433> }
		triangle  { <-1.84483, 0.20000, -1.04622>, <-1.35421, 0.20000, -1.04622>, <-1.35421, 0.20000, -0.72433> }
		triangle  { <-1.20695, 0.20000, -1.04622>, <-0.71632, 0.20000, -1.04622>, <-1.20695, -0.12255, -1.04622> }
		triangle  { <-0.71632, -0.12255, -1.04622>, <-0.71632, 0.20000, -1.04622>, <-1.20695, -0.12255, -1.04622> }
		triangle  { <-0.71632, 0.20000, -1.04622>, <-0.71632, -0.12255, -1.04622>, <-0.71632, -0.12255, -0.72433> }
		triangle  { <-0.71632, 0.20000, -1.04622>, <-0.71632, 0.20000, -0.72433>, <-0.71632, -0.12255, -0.72433> }
		triangle  { <-1.20695, 0.20000, -1.04622>, <-1.20695, -0.12255, -1.04622>, <-1.20695, -0.12255, -0.72433> }
		triangle  { <-1.20695, 0.20000, -1.04622>, <-1.20695, 0.20000, -0.72433>, <-1.20695, -0.12255, -0.72433> }
		triangle  { <-1.20695, 0.20000, -0.72433>, <-0.71632, 0.20000, -0.72433>, <-1.20695, -0.12255, -0.72433> }
		triangle  { <-0.71632, 0.20000, -0.72433>, <-0.71632, -0.12255, -0.72433>, <-1.20695, -0.12255, -0.72433> }
		triangle  { <-1.20695, -0.12255, -1.04622>, <-0.71632, -0.12255, -1.04622>, <-0.71632, -0.12255, -0.72433> }
		triangle  { <-1.20695, -0.12255, -1.04622>, <-1.20695, -0.12255, -0.72433>, <-0.71632, -0.12255, -0.72433> }
		triangle  { <-1.20695, 0.20000, -1.04622>, <-1.20695, 0.20000, -0.72433>, <-0.71632, 0.20000, -0.72433> }
		triangle  { <-1.20695, 0.20000, -1.04622>, <-0.71632, 0.20000, -1.04622>, <-0.71632, 0.20000, -0.72433> }
		triangle  { <-0.56915, 0.20000, -1.04622>, <-0.07852, 0.20000, -1.04622>, <-0.56915, -0.12255, -1.04622> }
		triangle  { <-0.07852, -0.12255, -1.04622>, <-0.07852, 0.20000, -1.04622>, <-0.56915, -0.12255, -1.04622> }
		triangle  { <-0.07852, 0.20000, -1.04622>, <-0.07852, -0.12255, -1.04622>, <-0.07852, -0.12255, -0.72433> }
		triangle  { <-0.07852, 0.20000, -1.04622>, <-0.07852, 0.20000, -0.72433>, <-0.07852, -0.12255, -0.72433> }
		triangle  { <-0.56915, 0.20000, -1.04622>, <-0.56915, -0.12255, -1.04622>, <-0.56915, -0.12255, -0.72433> }
		triangle  { <-0.56915, 0.20000, -1.04622>, <-0.56915, 0.20000, -0.72433>, <-0.56915, -0.12255, -0.72433> }
		triangle  { <-0.56915, 0.20000, -0.72433>, <-0.07852, 0.20000, -0.72433>, <-0.56915, -0.12255, -0.72433> }
		triangle  { <-0.07852, 0.20000, -0.72433>, <-0.07852, -0.12255, -0.72433>, <-0.56915, -0.12255, -0.72433> }
		triangle  { <-0.56915, -0.12255, -1.04622>, <-0.07852, -0.12255, -1.04622>, <-0.07852, -0.12255, -0.72433> }
		triangle  { <-0.56915, -0.12255, -1.04622>, <-0.56915, -0.12255, -0.72433>, <-0.07852, -0.12255, -0.72433> }
		triangle  { <-0.56915, 0.20000, -1.04622>, <-0.56915, 0.20000, -0.72433>, <-0.07852, 0.20000, -0.72433> }
		triangle  { <-0.56915, 0.20000, -1.04622>, <-0.07852, 0.20000, -1.04622>, <-0.07852, 0.20000, -0.72433> }
		triangle  { <0.06873, 0.20000, -1.04622>, <0.55936, 0.20000, -1.04622>, <0.06873, -0.12255, -1.04622> }
		triangle  { <0.55936, -0.12255, -1.04622>, <0.55936, 0.20000, -1.04622>, <0.06873, -0.12255, -1.04622> }
		triangle  { <0.55936, 0.20000, -1.04622>, <0.55936, -0.12255, -1.04622>, <0.55936, -0.12255, -0.72433> }
		triangle  { <0.55936, 0.20000, -1.04622>, <0.55936, 0.20000, -0.72433>, <0.55936, -0.12255, -0.72433> }
		triangle  { <0.06873, 0.20000, -1.04622>, <0.06873, -0.12255, -1.04622>, <0.06873, -0.12255, -0.72433> }
		triangle  { <0.06873, 0.20000, -1.04622>, <0.06873, 0.20000, -0.72433>, <0.06873, -0.12255, -0.72433> }
		triangle  { <0.06873, 0.20000, -0.72433>, <0.55936, 0.20000, -0.72433>, <0.06873, -0.12255, -0.72433> }
		triangle  { <0.55936, 0.20000, -0.72433>, <0.55936, -0.12255, -0.72433>, <0.06873, -0.12255, -0.72433> }
		triangle  { <0.06873, -0.12255, -1.04622>, <0.55936, -0.12255, -1.04622>, <0.55936, -0.12255, -0.72433> }
		triangle  { <0.06873, -0.12255, -1.04622>, <0.06873, -0.12255, -0.72433>, <0.55936, -0.12255, -0.72433> }
		triangle  { <0.06873, 0.20000, -1.04622>, <0.06873, 0.20000, -0.72433>, <0.55936, 0.20000, -0.72433> }
		triangle  { <0.06873, 0.20000, -1.04622>, <0.55936, 0.20000, -1.04622>, <0.55936, 0.20000, -0.72433> }
		triangle  { <0.75565, 0.20000, -1.04622>, <1.24627, 0.20000, -1.04622>, <0.75565, -0.12255, -1.04622> }
		triangle  { <1.24627, -0.12255, -1.04622>, <1.24627, 0.20000, -1.04622>, <0.75565, -0.12255, -1.04622> }
		triangle  { <1.24627, 0.20000, -1.04622>, <1.24627, -0.12255, -1.04622>, <1.24627, -0.12255, -0.72433> }
		triangle  { <1.24627, 0.20000, -1.04622>, <1.24627, 0.20000, -0.72433>, <1.24627, -0.12255, -0.72433> }
		triangle  { <0.75565, 0.20000, -1.04622>, <0.75565, -0.12255, -1.04622>, <0.75565, -0.12255, -0.72433> }
		triangle  { <0.75565, 0.20000, -1.04622>, <0.75565, 0.20000, -0.72433>, <0.75565, -0.12255, -0.72433> }
		triangle  { <0.75565, 0.20000, -0.72433>, <1.24627, 0.20000, -0.72433>, <0.75565, -0.12255, -0.72433> }
		triangle  { <1.24627, 0.20000, -0.72433>, <1.24627, -0.12255, -0.72433>, <0.75565, -0.12255, -0.72433> }
		triangle  { <0.75565, -0.12255, -1.04622>, <1.24627, -0.12255, -1.04622>, <1.24627, -0.12255, -0.72433> }
		triangle  { <0.75565, -0.12255, -1.04622>, <0.75565, -0.12255, -0.72433>, <1.24627, -0.12255, -0.72433> }
		triangle  { <0.75565, 0.20000, -1.04622>, <0.75565, 0.20000, -0.72433>, <1.24627, 0.20000, -0.72433> }
		triangle  { <0.75565, 0.20000, -1.04622>, <1.24627, 0.20000, -1.04622>, <1.24627, 0.20000, -0.72433> }
		triangle  { <1.34442, 0.20000, -1.04622>, <1.83504, 0.20000, -1.04622>, <1.34442, -0.12255, -1.04622> }
		triangle  { <1.83504, -0.12255, -1.04622>, <1.83504, 0.20000, -1.04622>, <1.34442, -0.12255, -1.04622> }
		triangle  { <1.83504, 0.20000, -1.04622>, <1.83504, -0.12255, -1.04622>, <1.83504, -0.12255, -0.72433> }
		triangle  { <1.83504, 0.20000, -1.04622>, <1.83504, 0.20000, -0.72433>, <1.83504, -0.12255, -0.72433> }
		triangle  { <1.34442, 0.20000, -1.04622>, <1.34442, -0.12255, -1.04622>, <1.34442, -0.12255, -0.72433> }
		triangle  { <1.34442, 0.20000, -1.04622>, <1.34442, 0.20000, -0.72433>, <1.34442, -0.12255, -0.72433> }
		triangle  { <1.34442, 0.20000, -0.72433>, <1.83504, 0.20000, -0.72433>, <1.34442, -0.12255, -0.72433> }
		triangle  { <1.83504, 0.20000, -0.72433>, <1.83504, -0.12255, -0.72433>, <1.34442, -0.12255, -0.72433> }
		triangle  { <1.34442, -0.12255, -1.04622>, <1.83504, -0.12255, -1.04622>, <1.83504, -0.12255, -0.72433> }
		triangle  { <1.34442, -0.12255, -1.04622>, <1.34442, -0.12255, -0.72433>, <1.83504, -0.12255, -0.72433> }
		triangle  { <1.34442, 0.20000, -1.04622>, <1.34442, 0.20000, -0.72433>, <1.83504, 0.20000, -0.72433> }
		triangle  { <1.34442, 0.20000, -1.04622>, <1.83504, 0.20000, -1.04622>, <1.83504, 0.20000, -0.72433> }
		triangle  { <-2.77706, 0.20000, -1.52906>, <-2.28643, 0.20000, -1.52906>, <-2.77706, -0.12255, -1.52906> }
		triangle  { <-2.28643, -0.12255, -1.52906>, <-2.28643, 0.20000, -1.52906>, <-2.77706, -0.12255, -1.52906> }
		triangle  { <-2.28643, 0.20000, -1.52906>, <-2.28643, -0.12255, -1.52906>, <-2.28643, -0.12255, -1.20717> }
		triangle  { <-2.28643, 0.20000, -1.52906>, <-2.28643, 0.20000, -1.20717>, <-2.28643, -0.12255, -1.20717> }
		triangle  { <-2.77706, 0.20000, -1.52906>, <-2.77706, -0.12255, -1.52906>, <-2.77706, -0.12255, -1.20717> }
		triangle  { <-2.77706, 0.20000, -1.52906>, <-2.77706, 0.20000, -1.20717>, <-2.77706, -0.12255, -1.20717> }
		triangle  { <-2.77706, 0.20000, -1.20717>, <-2.28643, 0.20000, -1.20717>, <-2.77706, -0.12255, -1.20717> }
		triangle  { <-2.28643, 0.20000, -1.20717>, <-2.28643, -0.12255, -1.20717>, <-2.77706, -0.12255, -1.20717> }
		triangle  { <-2.77706, -0.12255, -1.52906>, <-2.28643, -0.12255, -1.52906>, <-2.28643, -0.12255, -1.20717> }
		triangle  { <-2.77706, -0.12255, -1.52906>, <-2.77706, -0.12255, -1.20717>, <-2.28643, -0.12255, -1.20717> }
		triangle  { <-2.77706, 0.20000, -1.52906>, <-2.77706, 0.20000, -1.20717>, <-2.28643, 0.20000, -1.20717> }
		triangle  { <-2.77706, 0.20000, -1.52906>, <-2.28643, 0.20000, -1.52906>, <-2.28643, 0.20000, -1.20717> }
		triangle  { <-2.09015, 0.20000, -1.52906>, <-1.59952, 0.20000, -1.52906>, <-2.09015, -0.12255, -1.52906> }
		triangle  { <-1.59952, -0.12255, -1.52906>, <-1.59952, 0.20000, -1.52906>, <-2.09015, -0.12255, -1.52906> }
		triangle  { <-1.59952, 0.20000, -1.52906>, <-1.59952, -0.12255, -1.52906>, <-1.59952, -0.12255, -1.20717> }
		triangle  { <-1.59952, 0.20000, -1.52906>, <-1.59952, 0.20000, -1.20717>, <-1.59952, -0.12255, -1.20717> }
		triangle  { <-2.09015, 0.20000, -1.52906>, <-2.09015, -0.12255, -1.52906>, <-2.09015, -0.12255, -1.20717> }
		triangle  { <-2.09015, 0.20000, -1.52906>, <-2.09015, 0.20000, -1.20717>, <-2.09015, -0.12255, -1.20717> }
		triangle  { <-2.09015, 0.20000, -1.20717>, <-1.59952, 0.20000, -1.20717>, <-2.09015, -0.12255, -1.20717> }
		triangle  { <-1.59952, 0.20000, -1.20717>, <-1.59952, -0.12255, -1.20717>, <-2.09015, -0.12255, -1.20717> }
		triangle  { <-2.09015, -0.12255, -1.52906>, <-1.59952, -0.12255, -1.52906>, <-1.59952, -0.12255, -1.20717> }
		triangle  { <-2.09015, -0.12255, -1.52906>, <-2.09015, -0.12255, -1.20717>, <-1.59952, -0.12255, -1.20717> }
		triangle  { <-2.09015, 0.20000, -1.52906>, <-2.09015, 0.20000, -1.20717>, <-1.59952, 0.20000, -1.20717> }
		triangle  { <-2.09015, 0.20000, -1.52906>, <-1.59952, 0.20000, -1.52906>, <-1.59952, 0.20000, -1.20717> }
		triangle  { <-1.40323, 0.20000, -1.52906>, <-0.91261, 0.20000, -1.52906>, <-1.40323, -0.12255, -1.52906> }
		triangle  { <-0.91261, -0.12255, -1.52906>, <-0.91261, 0.20000, -1.52906>, <-1.40323, -0.12255, -1.52906> }
		triangle  { <-0.91261, 0.20000, -1.52906>, <-0.91261, -0.12255, -1.52906>, <-0.91261, -0.12255, -1.20717> }
		triangle  { <-0.91261, 0.20000, -1.52906>, <-0.91261, 0.20000, -1.20717>, <-0.91261, -0.12255, -1.20717> }
		triangle  { <-1.40323, 0.20000, -1.52906>, <-1.40323, -0.12255, -1.52906>, <-1.40323, -0.12255, -1.20717> }
		triangle  { <-1.40323, 0.20000, -1.52906>, <-1.40323, 0.20000, -1.20717>, <-1.40323, -0.12255, -1.20717> }
		triangle  { <-1.40323, 0.20000, -1.20717>, <-0.91261, 0.20000, -1.20717>, <-1.40323, -0.12255, -1.20717> }
		triangle  { <-0.91261, 0.20000, -1.20717>, <-0.91261, -0.12255, -1.20717>, <-1.40323, -0.12255, -1.20717> }
		triangle  { <-1.40323, -0.12255, -1.52906>, <-0.91261, -0.12255, -1.52906>, <-0.91261, -0.12255, -1.20717> }
		triangle  { <-1.40323, -0.12255, -1.52906>, <-1.40323, -0.12255, -1.20717>, <-0.91261, -0.12255, -1.20717> }
		triangle  { <-1.40323, 0.20000, -1.52906>, <-1.40323, 0.20000, -1.20717>, <-0.91261, 0.20000, -1.20717> }
		triangle  { <-1.40323, 0.20000, -1.52906>, <-0.91261, 0.20000, -1.52906>, <-0.91261, 0.20000, -1.20717> }
		triangle  { <-0.76535, 0.20000, -1.52906>, <-0.27472, 0.20000, -1.52906>, <-0.76535, -0.12255, -1.52906> }
		triangle  { <-0.27472, -0.12255, -1.52906>, <-0.27472, 0.20000, -1.52906>, <-0.76535, -0.12255, -1.52906> }
		triangle  { <-0.27472, 0.20000, -1.52906>, <-0.27472, -0.12255, -1.52906>, <-0.27472, -0.12255, -1.20717> }
		triangle  { <-0.27472, 0.20000, -1.52906>, <-0.27472, 0.20000, -1.20717>, <-0.27472, -0.12255, -1.20717> }
		triangle  { <-0.76535, 0.20000, -1.52906>, <-0.76535, -0.12255, -1.52906>, <-0.76535, -0.12255, -1.20717> }
		triangle  { <-0.76535, 0.20000, -1.52906>, <-0.76535, 0.20000, -1.20717>, <-0.76535, -0.12255, -1.20717> }
		triangle  { <-0.76535, 0.20000, -1.20717>, <-0.27472, 0.20000, -1.20717>, <-0.76535, -0.12255, -1.20717> }
		triangle  { <-0.27472, 0.20000, -1.20717>, <-0.27472, -0.12255, -1.20717>, <-0.76535, -0.12255, -1.20717> }
		triangle  { <-0.76535, -0.12255, -1.52906>, <-0.27472, -0.12255, -1.52906>, <-0.27472, -0.12255, -1.20717> }
		triangle  { <-0.76535, -0.12255, -1.52906>, <-0.76535, -0.12255, -1.20717>, <-0.27472, -0.12255, -1.20717> }
		triangle  { <-0.76535, 0.20000, -1.52906>, <-0.76535, 0.20000, -1.20717>, <-0.27472, 0.20000, -1.20717> }
		triangle  { <-0.76535, 0.20000, -1.52906>, <-0.27472, 0.20000, -1.52906>, <-0.27472, 0.20000, -1.20717> }
		triangle  { <-0.07844, 0.20000, -1.52906>, <0.41219, 0.20000, -1.52906>, <-0.07844, -0.12255, -1.52906> }
		triangle  { <0.41219, -0.12255, -1.52906>, <0.41219, 0.20000, -1.52906>, <-0.07844, -0.12255, -1.52906> }
		triangle  { <0.41219, 0.20000, -1.52906>, <0.41219, -0.12255, -1.52906>, <0.41219, -0.12255, -1.20717> }
		triangle  { <0.41219, 0.20000, -1.52906>, <0.41219, 0.20000, -1.20717>, <0.41219, -0.12255, -1.20717> }
		triangle  { <-0.07844, 0.20000, -1.52906>, <-0.07844, -0.12255, -1.52906>, <-0.07844, -0.12255, -1.20717> }
		triangle  { <-0.07844, 0.20000, -1.52906>, <-0.07844, 0.20000, -1.20717>, <-0.07844, -0.12255, -1.20717> }
		triangle  { <-0.07844, 0.20000, -1.20717>, <0.41219, 0.20000, -1.20717>, <-0.07844, -0.12255, -1.20717> }
		triangle  { <0.41219, 0.20000, -1.20717>, <0.41219, -0.12255, -1.20717>, <-0.07844, -0.12255, -1.20717> }
		triangle  { <-0.07844, -0.12255, -1.52906>, <0.41219, -0.12255, -1.52906>, <0.41219, -0.12255, -1.20717> }
		triangle  { <-0.07844, -0.12255, -1.52906>, <-0.07844, -0.12255, -1.20717>, <0.41219, -0.12255, -1.20717> }
		triangle  { <-0.07844, 0.20000, -1.52906>, <-0.07844, 0.20000, -1.20717>, <0.41219, 0.20000, -1.20717> }
		triangle  { <-0.07844, 0.20000, -1.52906>, <0.41219, 0.20000, -1.52906>, <0.41219, 0.20000, -1.20717> }
		triangle  { <0.55936, 0.20000, -1.52906>, <1.04999, 0.20000, -1.52906>, <0.55936, -0.12255, -1.52906> }
		triangle  { <1.04999, -0.12255, -1.52906>, <1.04999, 0.20000, -1.52906>, <0.55936, -0.12255, -1.52906> }
		triangle  { <1.04999, 0.20000, -1.52906>, <1.04999, -0.12255, -1.52906>, <1.04999, -0.12255, -1.20717> }
		triangle  { <1.04999, 0.20000, -1.52906>, <1.04999, 0.20000, -1.20717>, <1.04999, -0.12255, -1.20717> }
		triangle  { <0.55936, 0.20000, -1.52906>, <0.55936, -0.12255, -1.52906>, <0.55936, -0.12255, -1.20717> }
		triangle  { <0.55936, 0.20000, -1.52906>, <0.55936, 0.20000, -1.20717>, <0.55936, -0.12255, -1.20717> }
		triangle  { <0.55936, 0.20000, -1.20717>, <1.04999, 0.20000, -1.20717>, <0.55936, -0.12255, -1.20717> }
		triangle  { <1.04999, 0.20000, -1.20717>, <1.04999, -0.12255, -1.20717>, <0.55936, -0.12255, -1.20717> }
		triangle  { <0.55936, -0.12255, -1.52906>, <1.04999, -0.12255, -1.52906>, <1.04999, -0.12255, -1.20717> }
		triangle  { <0.55936, -0.12255, -1.52906>, <0.55936, -0.12255, -1.20717>, <1.04999, -0.12255, -1.20717> }
		triangle  { <0.55936, 0.20000, -1.52906>, <0.55936, 0.20000, -1.20717>, <1.04999, 0.20000, -1.20717> }
		triangle  { <0.55936, 0.20000, -1.52906>, <1.04999, 0.20000, -1.52906>, <1.04999, 0.20000, -1.20717> }
		triangle  { <1.19725, 0.20000, -1.52906>, <1.68787, 0.20000, -1.52906>, <1.19725, -0.12255, -1.52906> }
		triangle  { <1.68787, -0.12255, -1.52906>, <1.68787, 0.20000, -1.52906>, <1.19725, -0.12255, -1.52906> }
		triangle  { <1.68787, 0.20000, -1.52906>, <1.68787, -0.12255, -1.52906>, <1.68787, -0.12255, -1.20717> }
		triangle  { <1.68787, 0.20000, -1.52906>, <1.68787, 0.20000, -1.20717>, <1.68787, -0.12255, -1.20717> }
		triangle  { <1.19725, 0.20000, -1.52906>, <1.19725, -0.12255, -1.52906>, <1.19725, -0.12255, -1.20717> }
		triangle  { <1.19725, 0.20000, -1.52906>, <1.19725, 0.20000, -1.20717>, <1.19725, -0.12255, -1.20717> }
		triangle  { <1.19725, 0.20000, -1.20717>, <1.68787, 0.20000, -1.20717>, <1.19725, -0.12255, -1.20717> }
		triangle  { <1.68787, 0.20000, -1.20717>, <1.68787, -0.12255, -1.20717>, <1.19725, -0.12255, -1.20717> }
		triangle  { <1.19725, -0.12255, -1.52906>, <1.68787, -0.12255, -1.52906>, <1.68787, -0.12255, -1.20717> }
		triangle  { <1.19725, -0.12255, -1.52906>, <1.19725, -0.12255, -1.20717>, <1.68787, -0.12255, -1.20717> }
		triangle  { <1.19725, 0.20000, -1.52906>, <1.19725, 0.20000, -1.20717>, <1.68787, 0.20000, -1.20717> }
		triangle  { <1.19725, 0.20000, -1.52906>, <1.68787, 0.20000, -1.52906>, <1.68787, 0.20000, -1.20717> }
		triangle  { <1.93319, 0.20000, -1.56128>, <2.42381, 0.20000, -1.56128>, <1.93319, -0.12255, -1.56128> }
		triangle  { <2.42381, -0.12255, -1.56128>, <2.42381, 0.20000, -1.56128>, <1.93319, -0.12255, -1.56128> }
		triangle  { <2.42381, 0.20000, -1.56128>, <2.42381, -0.12255, -1.56128>, <2.42381, -0.12255, -1.23933> }
		triangle  { <2.42381, 0.20000, -1.56128>, <2.42381, 0.20000, -1.23933>, <2.42381, -0.12255, -1.23933> }
		triangle  { <1.93319, 0.20000, -1.56128>, <1.93319, -0.12255, -1.56128>, <1.93319, -0.12255, -1.23933> }
		triangle  { <1.93319, 0.20000, -1.56128>, <1.93319, 0.20000, -1.23933>, <1.93319, -0.12255, -1.23933> }
		triangle  { <1.93319, 0.20000, -1.23933>, <2.42381, 0.20000, -1.23933>, <1.93319, -0.12255, -1.23933> }
		triangle  { <2.42381, 0.20000, -1.23933>, <2.42381, -0.12255, -1.23933>, <1.93319, -0.12255, -1.23933> }
		triangle  { <1.93319, -0.12255, -1.56128>, <2.42381, -0.12255, -1.56128>, <2.42381, -0.12255, -1.23933> }
		triangle  { <1.93319, -0.12255, -1.56128>, <1.93319, -0.12255, -1.23933>, <2.42381, -0.12255, -1.23933> }
		triangle  { <1.93319, 0.20000, -1.56128>, <1.93319, 0.20000, -1.23933>, <2.42381, 0.20000, -1.23933> }
		triangle  { <1.93319, 0.20000, -1.56128>, <2.42381, 0.20000, -1.56128>, <2.42381, 0.20000, -1.23933> }

		translate < 0.50000, -4.10000, -3.99000>
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Ligh5*/

   object
   {
	light_source
		{ <0.0, 0.0, 0.0>
		colour rgb <1.00000, 1.00000, 1.00000>
		scale <1.60000, 1.76000, 1.60000> 
		translate < 0.40000, 7.68000, 0.00000> 
		}  /* End Light Shape */
   } /*End object*/



	/*Start Definition of   Spli22*/

   object
   {
	union
	{
		triangle  { <-4.25000, 2.16667, -0.00022>, <-2.58420, -1.41667, 0.94021>, <-2.75000, -1.41667, -0.00022> }
		triangle  { <-4.25000, 2.16667, -0.00022>, <-2.58420, -1.41667, 0.94021>, <-3.99376, 2.16667, 1.45317> }
		triangle  { <-2.75000, -1.41667, -0.00022>, <-2.27096, -1.75000, 0.82621>, <-2.41667, -1.75000, -0.00022> }
		triangle  { <-2.75000, -1.41667, -0.00022>, <-2.27096, -1.75000, 0.82621>, <-2.58420, -1.41667, 0.94021> }
		triangle  { <-2.41667, -1.75000, -0.00022>, <-1.95773, -2.00000, 0.71222>, <-2.08333, -2.00000, -0.00022> }
		triangle  { <-2.41667, -1.75000, -0.00022>, <-1.95773, -2.00000, 0.71222>, <-2.27096, -1.75000, 0.82621> }
		triangle  { <-2.08333, -2.00000, -0.00022>, <-0.86140, -2.16667, 0.31325>, <-0.91667, -2.16667, -0.00022> }
		triangle  { <-2.08333, -2.00000, -0.00022>, <-0.86140, -2.16667, 0.31325>, <-1.95773, -2.00000, 0.71222> }
		triangle  { <-0.91667, -2.16667, -0.00022>, <1.87942, -2.16667, -0.68417>, <2.00000, -2.16667, -0.00022> }
		triangle  { <-0.91667, -2.16667, -0.00022>, <1.87942, -2.16667, -0.68417>, <-0.86140, -2.16667, 0.31325> }
		triangle  { <2.00000, -2.16667, -0.00022>, <2.89744, -2.00000, -1.05465>, <3.08333, -2.00000, -0.00022> }
		triangle  { <2.00000, -2.16667, -0.00022>, <2.89744, -2.00000, -1.05465>, <1.87942, -2.16667, -0.68417> }
		triangle  { <3.08333, -2.00000, -0.00022>, <3.28898, -1.58333, -1.19714>, <3.50000, -1.58333, -0.00022> }
		triangle  { <3.08333, -2.00000, -0.00022>, <3.28898, -1.58333, -1.19714>, <2.89744, -2.00000, -1.05465> }
		triangle  { <3.50000, -1.58333, -0.00022>, <5.63825, 2.08333, -2.05207>, <6.00000, 2.08333, -0.00022> }
		triangle  { <3.50000, -1.58333, -0.00022>, <5.63825, 2.08333, -2.05207>, <3.28898, -1.58333, -1.19714> }
		triangle  { <-3.99376, 2.16667, 1.45317>, <-2.10679, -1.41667, 1.76724>, <-2.58420, -1.41667, 0.94021> }
		triangle  { <-3.99376, 2.16667, 1.45317>, <-2.10679, -1.41667, 1.76724>, <-3.25595, 2.16667, 2.73131> }
		triangle  { <-2.58420, -1.41667, 0.94021>, <-1.85142, -1.75000, 1.55300>, <-2.27096, -1.75000, 0.82621> }
		triangle  { <-2.58420, -1.41667, 0.94021>, <-1.85142, -1.75000, 1.55300>, <-2.10679, -1.41667, 1.76724> }
		triangle  { <-2.27096, -1.75000, 0.82621>, <-1.59606, -2.00000, 1.33876>, <-1.95773, -2.00000, 0.71222> }
		triangle  { <-2.27096, -1.75000, 0.82621>, <-1.59606, -2.00000, 1.33876>, <-1.85142, -1.75000, 1.55300> }
		triangle  { <-1.95773, -2.00000, 0.71222>, <-0.70226, -2.16667, 0.58893>, <-0.86140, -2.16667, 0.31325> }
		triangle  { <-1.95773, -2.00000, 0.71222>, <-0.70226, -2.16667, 0.58893>, <-1.59606, -2.00000, 1.33876> }
		triangle  { <-0.86140, -2.16667, 0.31325>, <1.53221, -2.16667, -1.28565>, <1.87942, -2.16667, -0.68417> }
		triangle  { <-0.86140, -2.16667, 0.31325>, <1.53221, -2.16667, -1.28565>, <-0.70226, -2.16667, 0.58893> }
		triangle  { <1.87942, -2.16667, -0.68417>, <2.36216, -2.00000, -1.98193>, <2.89744, -2.00000, -1.05465> }
		triangle  { <1.87942, -2.16667, -0.68417>, <2.36216, -2.00000, -1.98193>, <1.53221, -2.16667, -1.28565> }
		triangle  { <2.89744, -2.00000, -1.05465>, <2.68137, -1.58333, -2.24972>, <3.28898, -1.58333, -1.19714> }
		triangle  { <2.89744, -2.00000, -1.05465>, <2.68137, -1.58333, -2.24972>, <2.36216, -2.00000, -1.98193> }
		triangle  { <3.28898, -1.58333, -1.19714>, <4.59664, 2.08333, -3.85651>, <5.63825, 2.08333, -2.05207> }
		triangle  { <3.28898, -1.58333, -1.19714>, <4.59664, 2.08333, -3.85651>, <2.68137, -1.58333, -2.24972> }
		triangle  { <-3.25595, 2.16667, 2.73131>, <-1.37534, -1.41667, 2.38115>, <-2.10679, -1.41667, 1.76724> }
		triangle  { <-3.25595, 2.16667, 2.73131>, <-1.37534, -1.41667, 2.38115>, <-2.12553, 2.16667, 3.68008> }
		triangle  { <-2.10679, -1.41667, 1.76724>, <-1.20864, -1.75000, 2.09250>, <-1.85142, -1.75000, 1.55300> }
		triangle  { <-2.10679, -1.41667, 1.76724>, <-1.20864, -1.75000, 2.09250>, <-1.37534, -1.41667, 2.38115> }
		triangle  { <-1.85142, -1.75000, 1.55300>, <-1.04193, -2.00000, 1.80384>, <-1.59606, -2.00000, 1.33876> }
		triangle  { <-1.85142, -1.75000, 1.55300>, <-1.04193, -2.00000, 1.80384>, <-1.20864, -1.75000, 2.09250> }
		triangle  { <-1.59606, -2.00000, 1.33876>, <-0.45845, -2.16667, 0.79357>, <-0.70226, -2.16667, 0.58893> }
		triangle  { <-1.59606, -2.00000, 1.33876>, <-0.45845, -2.16667, 0.79357>, <-1.04193, -2.00000, 1.80384> }
		triangle  { <-0.70226, -2.16667, 0.58893>, <1.00025, -2.16667, -1.73213>, <1.53221, -2.16667, -1.28565> }
		triangle  { <-0.70226, -2.16667, 0.58893>, <1.00025, -2.16667, -1.73213>, <-0.45845, -2.16667, 0.79357> }
		triangle  { <1.53221, -2.16667, -1.28565>, <1.54205, -2.00000, -2.67025>, <2.36216, -2.00000, -1.98193> }
		triangle  { <1.53221, -2.16667, -1.28565>, <1.54205, -2.00000, -2.67025>, <1.00025, -2.16667, -1.73213> }
		triangle  { <2.36216, -2.00000, -1.98193>, <1.75044, -1.58333, -3.03106>, <2.68137, -1.58333, -2.24972> }
		triangle  { <2.36216, -2.00000, -1.98193>, <1.75044, -1.58333, -3.03106>, <1.54205, -2.00000, -2.67025> }
		triangle  { <2.68137, -1.58333, -2.24972>, <3.00075, 2.08333, -5.19594>, <4.59664, 2.08333, -3.85651> }
		triangle  { <2.68137, -1.58333, -2.24972>, <3.00075, 2.08333, -5.19594>, <1.75044, -1.58333, -3.03106> }
		triangle  { <-2.12553, 2.16667, 3.68008>, <-0.47805, -1.41667, 2.70790>, <-1.37534, -1.41667, 2.38115> }
		triangle  { <-2.12553, 2.16667, 3.68008>, <-0.47805, -1.41667, 2.70790>, <-0.73881, 2.16667, 4.18507> }
		triangle  { <-1.37534, -1.41667, 2.38115>, <-0.42011, -1.75000, 2.37965>, <-1.20864, -1.75000, 2.09250> }
		triangle  { <-1.37534, -1.41667, 2.38115>, <-0.42011, -1.75000, 2.37965>, <-0.47805, -1.41667, 2.70790> }
		triangle  { <-1.20864, -1.75000, 2.09250>, <-0.36216, -2.00000, 2.05139>, <-1.04193, -2.00000, 1.80384> }
		triangle  { <-1.20864, -1.75000, 2.09250>, <-0.36216, -2.00000, 2.05139>, <-0.42011, -1.75000, 2.37965> }
		triangle  { <-1.04193, -2.00000, 1.80384>, <-0.15935, -2.16667, 0.90249>, <-0.45845, -2.16667, 0.79357> }
		triangle  { <-1.04193, -2.00000, 1.80384>, <-0.15935, -2.16667, 0.90249>, <-0.36216, -2.00000, 2.05139> }
		triangle  { <-0.45845, -2.16667, 0.79357>, <0.34767, -2.16667, -1.96977>, <1.00025, -2.16667, -1.73213> }
		triangle  { <-0.45845, -2.16667, 0.79357>, <0.34767, -2.16667, -1.96977>, <-0.15935, -2.16667, 0.90249> }
		triangle  { <1.00025, -2.16667, -1.73213>, <0.53600, -2.00000, -3.03661>, <1.54205, -2.00000, -2.67025> }
		triangle  { <1.00025, -2.16667, -1.73213>, <0.53600, -2.00000, -3.03661>, <0.34767, -2.16667, -1.96977> }
		triangle  { <1.54205, -2.00000, -2.67025>, <0.60843, -1.58333, -3.44693>, <1.75044, -1.58333, -3.03106> }
		triangle  { <1.54205, -2.00000, -2.67025>, <0.60843, -1.58333, -3.44693>, <0.53600, -2.00000, -3.03661> }
		triangle  { <1.75044, -1.58333, -3.03106>, <1.04302, 2.08333, -5.90887>, <3.00075, 2.08333, -5.19594> }
		triangle  { <1.75044, -1.58333, -3.03106>, <1.04302, 2.08333, -5.90887>, <0.60843, -1.58333, -3.44693> }
		triangle  { <-0.73881, 2.16667, 4.18507>, <0.47688, -1.41667, 2.70811>, <-0.47805, -1.41667, 2.70790> }
		triangle  { <-0.73881, 2.16667, 4.18507>, <0.47688, -1.41667, 2.70811>, <0.73700, 2.16667, 4.18539> }
		triangle  { <-0.47805, -1.41667, 2.70790>, <0.41908, -1.75000, 2.37983>, <-0.42011, -1.75000, 2.37965> }
		triangle  { <-0.47805, -1.41667, 2.70790>, <0.41908, -1.75000, 2.37983>, <0.47688, -1.41667, 2.70811> }
		triangle  { <-0.42011, -1.75000, 2.37965>, <0.36127, -2.00000, 2.05154>, <-0.36216, -2.00000, 2.05139> }
		triangle  { <-0.42011, -1.75000, 2.37965>, <0.36127, -2.00000, 2.05154>, <0.41908, -1.75000, 2.37983> }
		triangle  { <-0.36216, -2.00000, 2.05139>, <0.15896, -2.16667, 0.90255>, <-0.15935, -2.16667, 0.90249> }
		triangle  { <-0.36216, -2.00000, 2.05139>, <0.15896, -2.16667, 0.90255>, <0.36127, -2.00000, 2.05154> }
		triangle  { <-0.15935, -2.16667, 0.90249>, <-0.34682, -2.16667, -1.96992>, <0.34767, -2.16667, -1.96977> }
		triangle  { <-0.15935, -2.16667, 0.90249>, <-0.34682, -2.16667, -1.96992>, <0.15896, -2.16667, 0.90255> }
		triangle  { <0.34767, -2.16667, -1.96977>, <-0.53469, -2.00000, -3.03684>, <0.53600, -2.00000, -3.03661> }
		triangle  { <0.34767, -2.16667, -1.96977>, <-0.53469, -2.00000, -3.03684>, <-0.34682, -2.16667, -1.96992> }
		triangle  { <0.53600, -2.00000, -3.03661>, <-0.60694, -1.58333, -3.44720>, <0.60843, -1.58333, -3.44693> }
		triangle  { <0.53600, -2.00000, -3.03661>, <-0.60694, -1.58333, -3.44720>, <-0.53469, -2.00000, -3.03684> }
		triangle  { <0.60843, -1.58333, -3.44693>, <-1.04047, 2.08333, -5.90932>, <1.04302, 2.08333, -5.90887> }
		triangle  { <0.60843, -1.58333, -3.44693>, <-1.04047, 2.08333, -5.90932>, <-0.60694, -1.58333, -3.44720> }
		triangle  { <0.73700, 2.16667, 4.18539>, <1.37431, -1.41667, 2.38174>, <0.47688, -1.41667, 2.70811> }
		triangle  { <0.73700, 2.16667, 4.18539>, <1.37431, -1.41667, 2.38174>, <2.12394, 2.16667, 3.68100> }
		triangle  { <0.47688, -1.41667, 2.70811>, <1.20773, -1.75000, 2.09302>, <0.41908, -1.75000, 2.37983> }
		triangle  { <0.47688, -1.41667, 2.70811>, <1.20773, -1.75000, 2.09302>, <1.37431, -1.41667, 2.38174> }
		triangle  { <0.41908, -1.75000, 2.37983>, <1.04115, -2.00000, 1.80430>, <0.36127, -2.00000, 2.05154> }
		triangle  { <0.41908, -1.75000, 2.37983>, <1.04115, -2.00000, 1.80430>, <1.20773, -1.75000, 2.09302> }
		triangle  { <0.36127, -2.00000, 2.05154>, <0.45810, -2.16667, 0.79376>, <0.15896, -2.16667, 0.90255> }
		triangle  { <0.36127, -2.00000, 2.05154>, <0.45810, -2.16667, 0.79376>, <1.04115, -2.00000, 1.80430> }
		triangle  { <0.15896, -2.16667, 0.90255>, <-0.99950, -2.16667, -1.73256>, <-0.34682, -2.16667, -1.96992> }
		triangle  { <0.15896, -2.16667, 0.90255>, <-0.99950, -2.16667, -1.73256>, <0.45810, -2.16667, 0.79376> }
		triangle  { <-0.34682, -2.16667, -1.96992>, <-1.54090, -2.00000, -2.67091>, <-0.53469, -2.00000, -3.03684> }
		triangle  { <-0.34682, -2.16667, -1.96992>, <-1.54090, -2.00000, -2.67091>, <-0.99950, -2.16667, -1.73256> }
		triangle  { <-0.53469, -2.00000, -3.03684>, <-1.74913, -1.58333, -3.03182>, <-0.60694, -1.58333, -3.44720> }
		triangle  { <-0.53469, -2.00000, -3.03684>, <-1.74913, -1.58333, -3.03182>, <-1.54090, -2.00000, -2.67091> }
		triangle  { <-0.60694, -1.58333, -3.44720>, <-2.99850, 2.08333, -5.19724>, <-1.04047, 2.08333, -5.90932> }
		triangle  { <-0.60694, -1.58333, -3.44720>, <-2.99850, 2.08333, -5.19724>, <-1.74913, -1.58333, -3.03182> }
		triangle  { <2.12394, 2.16667, 3.68100>, <2.10603, -1.41667, 1.76815>, <1.37431, -1.41667, 2.38174> }
		triangle  { <2.12394, 2.16667, 3.68100>, <2.10603, -1.41667, 1.76815>, <3.25477, 2.16667, 2.73272> }
		triangle  { <1.37431, -1.41667, 2.38174>, <1.85075, -1.75000, 1.55380>, <1.20773, -1.75000, 2.09302> }
		triangle  { <1.37431, -1.41667, 2.38174>, <1.85075, -1.75000, 1.55380>, <2.10603, -1.41667, 1.76815> }
		triangle  { <1.20773, -1.75000, 2.09302>, <1.59547, -2.00000, 1.33945>, <1.04115, -2.00000, 1.80430> }
		triangle  { <1.20773, -1.75000, 2.09302>, <1.59547, -2.00000, 1.33945>, <1.85075, -1.75000, 1.55380> }
		triangle  { <1.04115, -2.00000, 1.80430>, <0.70201, -2.16667, 0.58923>, <0.45810, -2.16667, 0.79376> }
		triangle  { <1.04115, -2.00000, 1.80430>, <0.70201, -2.16667, 0.58923>, <1.59547, -2.00000, 1.33945> }
		triangle  { <0.45810, -2.16667, 0.79376>, <-1.53166, -2.16667, -1.28632>, <-0.99950, -2.16667, -1.73256> }
		triangle  { <0.45810, -2.16667, 0.79376>, <-1.53166, -2.16667, -1.28632>, <0.70201, -2.16667, 0.58923> }
		triangle  { <-0.99950, -2.16667, -1.73256>, <-2.36130, -2.00000, -1.98295>, <-1.54090, -2.00000, -2.67091> }
		triangle  { <-0.99950, -2.16667, -1.73256>, <-2.36130, -2.00000, -1.98295>, <-1.53166, -2.16667, -1.28632> }
		triangle  { <-1.54090, -2.00000, -2.67091>, <-2.68040, -1.58333, -2.25088>, <-1.74913, -1.58333, -3.03182> }
		triangle  { <-1.54090, -2.00000, -2.67091>, <-2.68040, -1.58333, -2.25088>, <-2.36130, -2.00000, -1.98295> }
		triangle  { <-1.74913, -1.58333, -3.03182>, <-4.59497, 2.08333, -3.85850>, <-2.99850, 2.08333, -5.19724> }
		triangle  { <-1.74913, -1.58333, -3.03182>, <-4.59497, 2.08333, -3.85850>, <-2.68040, -1.58333, -2.25088> }
		triangle  { <3.25477, 2.16667, 2.73272>, <2.58379, -1.41667, 0.94132>, <2.10603, -1.41667, 1.76815> }
		triangle  { <3.25477, 2.16667, 2.73272>, <2.58379, -1.41667, 0.94132>, <3.99313, 2.16667, 1.45490> }
		triangle  { <2.10603, -1.41667, 1.76815>, <2.27061, -1.75000, 0.82720>, <1.85075, -1.75000, 1.55380> }
		triangle  { <2.10603, -1.41667, 1.76815>, <2.27061, -1.75000, 0.82720>, <2.58379, -1.41667, 0.94132> }
		triangle  { <1.85075, -1.75000, 1.55380>, <1.95742, -2.00000, 0.71307>, <1.59547, -2.00000, 1.33945> }
		triangle  { <1.85075, -1.75000, 1.55380>, <1.95742, -2.00000, 0.71307>, <2.27061, -1.75000, 0.82720> }
		triangle  { <1.59547, -2.00000, 1.33945>, <0.86126, -2.16667, 0.31362>, <0.70201, -2.16667, 0.58923> }
		triangle  { <1.59547, -2.00000, 1.33945>, <0.86126, -2.16667, 0.31362>, <1.95742, -2.00000, 0.71307> }
		triangle  { <0.70201, -2.16667, 0.58923>, <-1.87912, -2.16667, -0.68499>, <-1.53166, -2.16667, -1.28632> }
		triangle  { <0.70201, -2.16667, 0.58923>, <-1.87912, -2.16667, -0.68499>, <0.86126, -2.16667, 0.31362> }
		triangle  { <-1.53166, -2.16667, -1.28632>, <-2.89698, -2.00000, -1.05590>, <-2.36130, -2.00000, -1.98295> }
		triangle  { <-1.53166, -2.16667, -1.28632>, <-2.89698, -2.00000, -1.05590>, <-1.87912, -2.16667, -0.68499> }
		triangle  { <-2.36130, -2.00000, -1.98295>, <-3.28846, -1.58333, -1.19856>, <-2.68040, -1.58333, -2.25088> }
		triangle  { <-2.36130, -2.00000, -1.98295>, <-3.28846, -1.58333, -1.19856>, <-2.89698, -2.00000, -1.05590> }
		triangle  { <-2.68040, -1.58333, -2.25088>, <-5.63737, 2.08333, -2.05451>, <-4.59497, 2.08333, -3.85850> }
		triangle  { <-2.68040, -1.58333, -2.25088>, <-5.63737, 2.08333, -2.05451>, <-3.28846, -1.58333, -1.19856> }
		triangle  { <3.99313, 2.16667, 1.45490>, <2.75000, -1.41667, 0.00096>, <2.58379, -1.41667, 0.94132> }
		triangle  { <3.99313, 2.16667, 1.45490>, <2.75000, -1.41667, 0.00096>, <4.25000, 2.16667, 0.00161> }
		triangle  { <2.58379, -1.41667, 0.94132>, <2.41667, -1.75000, 0.00082>, <2.27061, -1.75000, 0.82720> }
		triangle  { <2.58379, -1.41667, 0.94132>, <2.41667, -1.75000, 0.00082>, <2.75000, -1.41667, 0.00096> }
		triangle  { <2.27061, -1.75000, 0.82720>, <2.08333, -2.00000, 0.00068>, <1.95742, -2.00000, 0.71307> }
		triangle  { <2.27061, -1.75000, 0.82720>, <2.08333, -2.00000, 0.00068>, <2.41667, -1.75000, 0.00082> }
		triangle  { <1.95742, -2.00000, 0.71307>, <0.91667, -2.16667, 0.00017>, <0.86126, -2.16667, 0.31362> }
		triangle  { <1.95742, -2.00000, 0.71307>, <0.91667, -2.16667, 0.00017>, <2.08333, -2.00000, 0.00068> }
		triangle  { <0.86126, -2.16667, 0.31362>, <-2.00000, -2.16667, -0.00109>, <-1.87912, -2.16667, -0.68499> }
		triangle  { <0.86126, -2.16667, 0.31362>, <-2.00000, -2.16667, -0.00109>, <0.91667, -2.16667, 0.00017> }
		triangle  { <-1.87912, -2.16667, -0.68499>, <-3.08333, -2.00000, -0.00156>, <-2.89698, -2.00000, -1.05590> }
		triangle  { <-1.87912, -2.16667, -0.68499>, <-3.08333, -2.00000, -0.00156>, <-2.00000, -2.16667, -0.00109> }
		triangle  { <-2.89698, -2.00000, -1.05590>, <-3.50000, -1.58333, -0.00174>, <-3.28846, -1.58333, -1.19856> }
		triangle  { <-2.89698, -2.00000, -1.05590>, <-3.50000, -1.58333, -0.00174>, <-3.08333, -2.00000, -0.00156> }
		triangle  { <-3.28846, -1.58333, -1.19856>, <-6.00000, 2.08333, -0.00282>, <-5.63737, 2.08333, -2.05451> }
		triangle  { <-3.28846, -1.58333, -1.19856>, <-6.00000, 2.08333, -0.00282>, <-3.50000, -1.58333, -0.00174> }
		triangle  { <4.25000, 2.16667, 0.00161>, <2.58461, -1.41667, -0.93954>, <2.75000, -1.41667, 0.00096> }
		triangle  { <4.25000, 2.16667, 0.00161>, <2.58461, -1.41667, -0.93954>, <3.99439, 2.16667, -1.45189> }
		triangle  { <2.75000, -1.41667, 0.00096>, <2.27132, -1.75000, -0.82568>, <2.41667, -1.75000, 0.00082> }
		triangle  { <2.75000, -1.41667, 0.00096>, <2.27132, -1.75000, -0.82568>, <2.58461, -1.41667, -0.93954> }
		triangle  { <2.41667, -1.75000, 0.00082>, <1.95803, -2.00000, -0.71183>, <2.08333, -2.00000, 0.00068> }
		triangle  { <2.41667, -1.75000, 0.00082>, <1.95803, -2.00000, -0.71183>, <2.27132, -1.75000, -0.82568> }
		triangle  { <2.08333, -2.00000, 0.00068>, <0.86154, -2.16667, -0.31333>, <0.91667, -2.16667, 0.00017> }
		triangle  { <2.08333, -2.00000, 0.00068>, <0.86154, -2.16667, -0.31333>, <1.95803, -2.00000, -0.71183> }
		triangle  { <0.91667, -2.16667, 0.00017>, <-1.87971, -2.16667, 0.68291>, <-2.00000, -2.16667, -0.00109> }
		triangle  { <0.91667, -2.16667, 0.00017>, <-1.87971, -2.16667, 0.68291>, <0.86154, -2.16667, -0.31333> }
		triangle  { <-2.00000, -2.16667, -0.00109>, <-2.89789, -2.00000, 1.05294>, <-3.08333, -2.00000, -0.00156> }
		triangle  { <-2.00000, -2.16667, -0.00109>, <-2.89789, -2.00000, 1.05294>, <-1.87971, -2.16667, 0.68291> }
		triangle  { <-3.08333, -2.00000, -0.00156>, <-3.28950, -1.58333, 1.19526>, <-3.50000, -1.58333, -0.00174> }
		triangle  { <-3.08333, -2.00000, -0.00156>, <-3.28950, -1.58333, 1.19526>, <-2.89789, -2.00000, 1.05294> }
		triangle  { <-3.50000, -1.58333, -0.00174>, <-5.63914, 2.08333, 2.04919>, <-6.00000, 2.08333, -0.00282> }
		triangle  { <-3.50000, -1.58333, -0.00174>, <-5.63914, 2.08333, 2.04919>, <-3.28950, -1.58333, 1.19526> }
		triangle  { <3.99439, 2.16667, -1.45189>, <2.10756, -1.41667, -1.76678>, <2.58461, -1.41667, -0.93954> }
		triangle  { <3.99439, 2.16667, -1.45189>, <2.10756, -1.41667, -1.76678>, <3.25713, 2.16667, -2.73035> }
		triangle  { <2.58461, -1.41667, -0.93954>, <1.85209, -1.75000, -1.55265>, <2.27132, -1.75000, -0.82568> }
		triangle  { <2.58461, -1.41667, -0.93954>, <1.85209, -1.75000, -1.55265>, <2.10756, -1.41667, -1.76678> }
		triangle  { <2.27132, -1.75000, -0.82568>, <1.59663, -2.00000, -1.33852>, <1.95803, -2.00000, -0.71183> }
		triangle  { <2.27132, -1.75000, -0.82568>, <1.59663, -2.00000, -1.33852>, <1.85209, -1.75000, -1.55265> }
		triangle  { <1.95803, -2.00000, -0.71183>, <0.70252, -2.16667, -0.58908>, <0.86154, -2.16667, -0.31333> }
		triangle  { <1.95803, -2.00000, -0.71183>, <0.70252, -2.16667, -0.58908>, <1.59663, -2.00000, -1.33852> }
		triangle  { <0.86154, -2.16667, -0.31333>, <-1.53277, -2.16667, 1.28454>, <-1.87971, -2.16667, 0.68291> }
		triangle  { <0.86154, -2.16667, -0.31333>, <-1.53277, -2.16667, 1.28454>, <0.70252, -2.16667, -0.58908> }
		triangle  { <-1.87971, -2.16667, 0.68291>, <-2.36302, -2.00000, 1.98045>, <-2.89789, -2.00000, 1.05294> }
		triangle  { <-1.87971, -2.16667, 0.68291>, <-2.36302, -2.00000, 1.98045>, <-1.53277, -2.16667, 1.28454> }
		triangle  { <-2.89789, -2.00000, 1.05294>, <-2.68235, -1.58333, 2.24811>, <-3.28950, -1.58333, 1.19526> }
		triangle  { <-2.89789, -2.00000, 1.05294>, <-2.68235, -1.58333, 2.24811>, <-2.36302, -2.00000, 1.98045> }
		triangle  { <-3.28950, -1.58333, 1.19526>, <-4.59831, 2.08333, 3.85407>, <-5.63914, 2.08333, 2.04919> }
		triangle  { <-3.28950, -1.58333, 1.19526>, <-4.59831, 2.08333, 3.85407>, <-2.68235, -1.58333, 2.24811> }
		triangle  { <3.25713, 2.16667, -2.73035>, <1.37637, -1.41667, -2.38100>, <2.10756, -1.41667, -1.76678> }
		triangle  { <3.25713, 2.16667, -2.73035>, <1.37637, -1.41667, -2.38100>, <2.12712, 2.16667, -3.67961> }
		triangle  { <2.10756, -1.41667, -1.76678>, <1.20954, -1.75000, -2.09242>, <1.85209, -1.75000, -1.55265> }
		triangle  { <2.10756, -1.41667, -1.76678>, <1.20954, -1.75000, -2.09242>, <1.37637, -1.41667, -2.38100> }
		triangle  { <1.85209, -1.75000, -1.55265>, <1.04271, -2.00000, -1.80384>, <1.59663, -2.00000, -1.33852> }
		triangle  { <1.85209, -1.75000, -1.55265>, <1.04271, -2.00000, -1.80384>, <1.20954, -1.75000, -2.09242> }
		triangle  { <1.59663, -2.00000, -1.33852>, <0.45879, -2.16667, -0.79382>, <0.70252, -2.16667, -0.58908> }
		triangle  { <1.59663, -2.00000, -1.33852>, <0.45879, -2.16667, -0.79382>, <1.04271, -2.00000, -1.80384> }
		triangle  { <0.70252, -2.16667, -0.58908>, <-1.00100, -2.16667, 1.73125>, <-1.53277, -2.16667, 1.28454> }
		triangle  { <0.70252, -2.16667, -0.58908>, <-1.00100, -2.16667, 1.73125>, <0.45879, -2.16667, -0.79382> }
		triangle  { <-1.53277, -2.16667, 1.28454>, <-1.54321, -2.00000, 2.66913>, <-2.36302, -2.00000, 1.98045> }
		triangle  { <-1.53277, -2.16667, 1.28454>, <-1.54321, -2.00000, 2.66913>, <-1.00100, -2.16667, 1.73125> }
		triangle  { <-2.36302, -2.00000, 1.98045>, <-1.75175, -1.58333, 3.02985>, <-2.68235, -1.58333, 2.24811> }
		triangle  { <-2.36302, -2.00000, 1.98045>, <-1.75175, -1.58333, 3.02985>, <-1.54321, -2.00000, 2.66913> }
		triangle  { <-2.68235, -1.58333, 2.24811>, <-3.00300, 2.08333, 5.19420>, <-4.59831, 2.08333, 3.85407> }
		triangle  { <-2.68235, -1.58333, 2.24811>, <-3.00300, 2.08333, 5.19420>, <-1.75175, -1.58333, 3.02985> }
		triangle  { <2.12712, 2.16667, -3.67961>, <0.47922, -1.41667, -2.70815>, <1.37637, -1.41667, -2.38100> }
		triangle  { <2.12712, 2.16667, -3.67961>, <0.47922, -1.41667, -2.70815>, <0.74062, 2.16667, -4.18520> }
		triangle  { <1.37637, -1.41667, -2.38100>, <0.42114, -1.75000, -2.37991>, <1.20954, -1.75000, -2.09242> }
		triangle  { <1.37637, -1.41667, -2.38100>, <0.42114, -1.75000, -2.37991>, <0.47922, -1.41667, -2.70815> }
		triangle  { <1.20954, -1.75000, -2.09242>, <0.36305, -2.00000, -2.05168>, <1.04271, -2.00000, -1.80384> }
		triangle  { <1.20954, -1.75000, -2.09242>, <0.36305, -2.00000, -2.05168>, <0.42114, -1.75000, -2.37991> }
		triangle  { <1.04271, -2.00000, -1.80384>, <0.15974, -2.16667, -0.90287>, <0.45879, -2.16667, -0.79382> }
		triangle  { <1.04271, -2.00000, -1.80384>, <0.15974, -2.16667, -0.90287>, <0.36305, -2.00000, -2.05168> }
		triangle  { <0.45879, -2.16667, -0.79382>, <-0.34853, -2.16667, 1.96917>, <-1.00100, -2.16667, 1.73125> }
		triangle  { <0.45879, -2.16667, -0.79382>, <-0.34853, -2.16667, 1.96917>, <0.15974, -2.16667, -0.90287> }
		triangle  { <-1.00100, -2.16667, 1.73125>, <-0.53731, -2.00000, 3.03593>, <-1.54321, -2.00000, 2.66913> }
		triangle  { <-1.00100, -2.16667, 1.73125>, <-0.53731, -2.00000, 3.03593>, <-0.34853, -2.16667, 1.96917> }
		triangle  { <-1.54321, -2.00000, 2.66913>, <-0.60992, -1.58333, 3.44622>, <-1.75175, -1.58333, 3.02985> }
		triangle  { <-1.54321, -2.00000, 2.66913>, <-0.60992, -1.58333, 3.44622>, <-0.53731, -2.00000, 3.03593> }
		triangle  { <-1.75175, -1.58333, 3.02985>, <-1.04558, 2.08333, 5.90797>, <-3.00300, 2.08333, 5.19420> }
		triangle  { <-1.75175, -1.58333, 3.02985>, <-1.04558, 2.08333, 5.90797>, <-0.60992, -1.58333, 3.44622> }
		triangle  { <0.74062, 2.16667, -4.18520>, <-0.47571, -1.41667, -2.70877>, <0.47922, -1.41667, -2.70815> }
		triangle  { <0.74062, 2.16667, -4.18520>, <-0.47571, -1.41667, -2.70877>, <-0.73519, 2.16667, -4.18615> }
		triangle  { <0.47922, -1.41667, -2.70815>, <-0.41805, -1.75000, -2.38046>, <0.42114, -1.75000, -2.37991> }
		triangle  { <0.47922, -1.41667, -2.70815>, <-0.41805, -1.75000, -2.38046>, <-0.47571, -1.41667, -2.70877> }
		triangle  { <0.42114, -1.75000, -2.37991>, <-0.36039, -2.00000, -2.05215>, <0.36305, -2.00000, -2.05168> }
		triangle  { <0.42114, -1.75000, -2.37991>, <-0.36039, -2.00000, -2.05215>, <-0.41805, -1.75000, -2.38046> }
		triangle  { <0.36305, -2.00000, -2.05168>, <-0.15857, -2.16667, -0.90307>, <0.15974, -2.16667, -0.90287> }
		triangle  { <0.36305, -2.00000, -2.05168>, <-0.15857, -2.16667, -0.90307>, <-0.36039, -2.00000, -2.05215> }
		triangle  { <0.15974, -2.16667, -0.90287>, <0.34597, -2.16667, 1.96962>, <-0.34853, -2.16667, 1.96917> }
		triangle  { <0.15974, -2.16667, -0.90287>, <0.34597, -2.16667, 1.96962>, <-0.15857, -2.16667, -0.90307> }
		triangle  { <-0.34853, -2.16667, 1.96917>, <0.53337, -2.00000, 3.03663>, <-0.53731, -2.00000, 3.03593> }
		triangle  { <-0.34853, -2.16667, 1.96917>, <0.53337, -2.00000, 3.03663>, <0.34597, -2.16667, 1.96962> }
		triangle  { <-0.53731, -2.00000, 3.03593>, <0.60545, -1.58333, 3.44701>, <-0.60992, -1.58333, 3.44622> }
		triangle  { <-0.53731, -2.00000, 3.03593>, <0.60545, -1.58333, 3.44701>, <0.53337, -2.00000, 3.03663> }
		triangle  { <-0.60992, -1.58333, 3.44622>, <1.03791, 2.08333, 5.90932>, <-1.04558, 2.08333, 5.90797> }
		triangle  { <-0.60992, -1.58333, 3.44622>, <1.03791, 2.08333, 5.90932>, <0.60545, -1.58333, 3.44701> }
		triangle  { <-0.73519, 2.16667, -4.18615>, <-1.37328, -1.41667, -2.38279>, <-0.47571, -1.41667, -2.70877> }
		triangle  { <-0.73519, 2.16667, -4.18615>, <-1.37328, -1.41667, -2.38279>, <-2.12235, 2.16667, -3.68236> }
		triangle  { <-0.47571, -1.41667, -2.70877>, <-1.20682, -1.75000, -2.09399>, <-0.41805, -1.75000, -2.38046> }
		triangle  { <-0.47571, -1.41667, -2.70877>, <-1.20682, -1.75000, -2.09399>, <-1.37328, -1.41667, -2.38279> }
		triangle  { <-0.41805, -1.75000, -2.38046>, <-1.04037, -2.00000, -1.80519>, <-0.36039, -2.00000, -2.05215> }
		triangle  { <-0.41805, -1.75000, -2.38046>, <-1.04037, -2.00000, -1.80519>, <-1.20682, -1.75000, -2.09399> }
		triangle  { <-0.36039, -2.00000, -2.05215>, <-0.45776, -2.16667, -0.79441>, <-0.15857, -2.16667, -0.90307> }
		triangle  { <-0.36039, -2.00000, -2.05215>, <-0.45776, -2.16667, -0.79441>, <-1.04037, -2.00000, -1.80519> }
		triangle  { <-0.15857, -2.16667, -0.90307>, <0.99875, -2.16667, 1.73255>, <0.34597, -2.16667, 1.96962> }
		triangle  { <-0.15857, -2.16667, -0.90307>, <0.99875, -2.16667, 1.73255>, <-0.45776, -2.16667, -0.79441> }
		triangle  { <0.34597, -2.16667, 1.96962>, <1.53974, -2.00000, 2.67113>, <0.53337, -2.00000, 3.03663> }
		triangle  { <0.34597, -2.16667, 1.96962>, <1.53974, -2.00000, 2.67113>, <0.99875, -2.16667, 1.73255> }
		triangle  { <0.53337, -2.00000, 3.03663>, <1.74781, -1.58333, 3.03213>, <0.60545, -1.58333, 3.44701> }
		triangle  { <0.53337, -2.00000, 3.03663>, <1.74781, -1.58333, 3.03213>, <1.53974, -2.00000, 2.67113> }
		triangle  { <0.60545, -1.58333, 3.44701>, <2.99625, 2.08333, 5.19809>, <1.03791, 2.08333, 5.90932> }
		triangle  { <0.60545, -1.58333, 3.44701>, <2.99625, 2.08333, 5.19809>, <1.74781, -1.58333, 3.03213> }
		triangle  { <-2.12235, 2.16667, -3.68236>, <-2.10526, -1.41667, -1.76951>, <-1.37328, -1.41667, -2.38279> }
		triangle  { <-2.12235, 2.16667, -3.68236>, <-2.10526, -1.41667, -1.76951>, <-3.25359, 2.16667, -2.73458> }
		triangle  { <-1.37328, -1.41667, -2.38279>, <-1.85008, -1.75000, -1.55505>, <-1.20682, -1.75000, -2.09399> }
		triangle  { <-1.37328, -1.41667, -2.38279>, <-1.85008, -1.75000, -1.55505>, <-2.10526, -1.41667, -1.76951> }
		triangle  { <-1.20682, -1.75000, -2.09399>, <-1.59490, -2.00000, -1.34059>, <-1.04037, -2.00000, -1.80519> }
		triangle  { <-1.20682, -1.75000, -2.09399>, <-1.59490, -2.00000, -1.34059>, <-1.85008, -1.75000, -1.55505> }
		triangle  { <-1.04037, -2.00000, -1.80519>, <-0.70175, -2.16667, -0.58999>, <-0.45776, -2.16667, -0.79441> }
		triangle  { <-1.04037, -2.00000, -1.80519>, <-0.70175, -2.16667, -0.58999>, <-1.59490, -2.00000, -1.34059> }
		triangle  { <-0.45776, -2.16667, -0.79441>, <1.53110, -2.16667, 1.28653>, <0.99875, -2.16667, 1.73255> }
		triangle  { <-0.45776, -2.16667, -0.79441>, <1.53110, -2.16667, 1.28653>, <-0.70175, -2.16667, -0.58999> }
		triangle  { <0.99875, -2.16667, 1.73255>, <2.36044, -2.00000, 1.98352>, <1.53974, -2.00000, 2.67113> }
		triangle  { <0.99875, -2.16667, 1.73255>, <2.36044, -2.00000, 1.98352>, <1.53110, -2.16667, 1.28653> }
		triangle  { <1.53974, -2.00000, 2.67113>, <2.67942, -1.58333, 2.25159>, <1.74781, -1.58333, 3.03213> }
		triangle  { <1.53974, -2.00000, 2.67113>, <2.67942, -1.58333, 2.25159>, <2.36044, -2.00000, 1.98352> }
		triangle  { <1.74781, -1.58333, 3.03213>, <4.59330, 2.08333, 3.86004>, <2.99625, 2.08333, 5.19809> }
		triangle  { <1.74781, -1.58333, 3.03213>, <4.59330, 2.08333, 3.86004>, <2.67942, -1.58333, 2.25159> }
		triangle  { <-3.25359, 2.16667, -2.73458>, <-2.58339, -1.41667, -0.94289>, <-2.10526, -1.41667, -1.76951> }
		triangle  { <-3.25359, 2.16667, -2.73458>, <-2.58339, -1.41667, -0.94289>, <-3.99250, 2.16667, -1.45707> }
		triangle  { <-2.10526, -1.41667, -1.76951>, <-2.27025, -1.75000, -0.82863>, <-1.85008, -1.75000, -1.55505> }
		triangle  { <-2.10526, -1.41667, -1.76951>, <-2.27025, -1.75000, -0.82863>, <-2.58339, -1.41667, -0.94289> }
		triangle  { <-1.85008, -1.75000, -1.55505>, <-1.95711, -2.00000, -0.71437>, <-1.59490, -2.00000, -1.34059> }
		triangle  { <-1.85008, -1.75000, -1.55505>, <-1.95711, -2.00000, -0.71437>, <-2.27025, -1.75000, -0.82863> }
		triangle  { <-1.59490, -2.00000, -1.34059>, <-0.86113, -2.16667, -0.31445>, <-0.70175, -2.16667, -0.58999> }
		triangle  { <-1.59490, -2.00000, -1.34059>, <-0.86113, -2.16667, -0.31445>, <-1.95711, -2.00000, -0.71437> }
		triangle  { <-0.70175, -2.16667, -0.58999>, <1.87883, -2.16667, 0.68535>, <1.53110, -2.16667, 1.28653> }
		triangle  { <-0.70175, -2.16667, -0.58999>, <1.87883, -2.16667, 0.68535>, <-0.86113, -2.16667, -0.31445> }
		triangle  { <1.53110, -2.16667, 1.28653>, <2.89652, -2.00000, 1.05670>, <2.36044, -2.00000, 1.98352> }
		triangle  { <1.53110, -2.16667, 1.28653>, <2.89652, -2.00000, 1.05670>, <1.87883, -2.16667, 0.68535> }
		triangle  { <2.36044, -2.00000, 1.98352>, <3.28794, -1.58333, 1.19953>, <2.67942, -1.58333, 2.25159> }
		triangle  { <2.36044, -2.00000, 1.98352>, <3.28794, -1.58333, 1.19953>, <2.89652, -2.00000, 1.05670> }
		triangle  { <2.67942, -1.58333, 2.25159>, <5.63648, 2.08333, 2.05650>, <4.59330, 2.08333, 3.86004> }
		triangle  { <2.67942, -1.58333, 2.25159>, <5.63648, 2.08333, 2.05650>, <3.28794, -1.58333, 1.19953> }
		triangle  { <-3.99250, 2.16667, -1.45707>, <-2.75000, -1.41667, -0.00260>, <-2.58339, -1.41667, -0.94289> }
		triangle  { <-3.99250, 2.16667, -1.45707>, <-2.75000, -1.41667, -0.00260>, <-4.25000, 2.16667, -0.00390> }
		triangle  { <-2.58339, -1.41667, -0.94289>, <-2.41667, -1.75000, -0.00232>, <-2.27025, -1.75000, -0.82863> }
		triangle  { <-2.58339, -1.41667, -0.94289>, <-2.41667, -1.75000, -0.00232>, <-2.75000, -1.41667, -0.00260> }
		triangle  { <-2.27025, -1.75000, -0.82863>, <-2.08333, -2.00000, -0.00203>, <-1.95711, -2.00000, -0.71437> }
		triangle  { <-2.27025, -1.75000, -0.82863>, <-2.08333, -2.00000, -0.00203>, <-2.41667, -1.75000, -0.00232> }
		triangle  { <-1.95711, -2.00000, -0.71437>, <-0.91667, -2.16667, -0.00102>, <-0.86113, -2.16667, -0.31445> }
		triangle  { <-1.95711, -2.00000, -0.71437>, <-0.91667, -2.16667, -0.00102>, <-2.08333, -2.00000, -0.00203> }
		triangle  { <-0.86113, -2.16667, -0.31445>, <2.00000, -2.16667, 0.00151>, <1.87883, -2.16667, 0.68535> }
		triangle  { <-0.86113, -2.16667, -0.31445>, <2.00000, -2.16667, 0.00151>, <-0.91667, -2.16667, -0.00102> }
		triangle  { <1.87883, -2.16667, 0.68535>, <3.08333, -2.00000, 0.00244>, <2.89652, -2.00000, 1.05670> }
		triangle  { <1.87883, -2.16667, 0.68535>, <3.08333, -2.00000, 0.00244>, <2.00000, -2.16667, 0.00151> }
		triangle  { <2.89652, -2.00000, 1.05670>, <3.50000, -1.58333, 0.00280>, <3.28794, -1.58333, 1.19953> }
		triangle  { <2.89652, -2.00000, 1.05670>, <3.50000, -1.58333, 0.00280>, <3.08333, -2.00000, 0.00244> }
		triangle  { <3.28794, -1.58333, 1.19953>, <6.00000, 2.08333, 0.00497>, <5.63648, 2.08333, 2.05650> }
		triangle  { <3.28794, -1.58333, 1.19953>, <6.00000, 2.08333, 0.00497>, <3.50000, -1.58333, 0.00280> }
		rotate < 0, 335, 89>

		translate < 31.08872, 20.00370, 7.30524>
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   Spli23*/

   object
   {
	union
	{
		triangle  { <-4.25000, 2.16667, -0.00022>, <-2.58420, -1.41667, 0.94021>, <-2.75000, -1.41667, -0.00022> }
		triangle  { <-4.25000, 2.16667, -0.00022>, <-2.58420, -1.41667, 0.94021>, <-3.99376, 2.16667, 1.45317> }
		triangle  { <-2.75000, -1.41667, -0.00022>, <-2.27096, -1.75000, 0.82621>, <-2.41667, -1.75000, -0.00022> }
		triangle  { <-2.75000, -1.41667, -0.00022>, <-2.27096, -1.75000, 0.82621>, <-2.58420, -1.41667, 0.94021> }
		triangle  { <-2.41667, -1.75000, -0.00022>, <-1.95773, -2.00000, 0.71222>, <-2.08333, -2.00000, -0.00022> }
		triangle  { <-2.41667, -1.75000, -0.00022>, <-1.95773, -2.00000, 0.71222>, <-2.27096, -1.75000, 0.82621> }
		triangle  { <-2.08333, -2.00000, -0.00022>, <-0.86140, -2.16667, 0.31325>, <-0.91667, -2.16667, -0.00022> }
		triangle  { <-2.08333, -2.00000, -0.00022>, <-0.86140, -2.16667, 0.31325>, <-1.95773, -2.00000, 0.71222> }
		triangle  { <-0.91667, -2.16667, -0.00022>, <1.87942, -2.16667, -0.68417>, <2.00000, -2.16667, -0.00022> }
		triangle  { <-0.91667, -2.16667, -0.00022>, <1.87942, -2.16667, -0.68417>, <-0.86140, -2.16667, 0.31325> }
		triangle  { <2.00000, -2.16667, -0.00022>, <2.89744, -2.00000, -1.05465>, <3.08333, -2.00000, -0.00022> }
		triangle  { <2.00000, -2.16667, -0.00022>, <2.89744, -2.00000, -1.05465>, <1.87942, -2.16667, -0.68417> }
		triangle  { <3.08333, -2.00000, -0.00022>, <3.28898, -1.58333, -1.19714>, <3.50000, -1.58333, -0.00022> }
		triangle  { <3.08333, -2.00000, -0.00022>, <3.28898, -1.58333, -1.19714>, <2.89744, -2.00000, -1.05465> }
		triangle  { <3.50000, -1.58333, -0.00022>, <5.63825, 2.08333, -2.05207>, <6.00000, 2.08333, -0.00022> }
		triangle  { <3.50000, -1.58333, -0.00022>, <5.63825, 2.08333, -2.05207>, <3.28898, -1.58333, -1.19714> }
		triangle  { <-3.99376, 2.16667, 1.45317>, <-2.10679, -1.41667, 1.76724>, <-2.58420, -1.41667, 0.94021> }
		triangle  { <-3.99376, 2.16667, 1.45317>, <-2.10679, -1.41667, 1.76724>, <-3.25595, 2.16667, 2.73131> }
		triangle  { <-2.58420, -1.41667, 0.94021>, <-1.85142, -1.75000, 1.55300>, <-2.27096, -1.75000, 0.82621> }
		triangle  { <-2.58420, -1.41667, 0.94021>, <-1.85142, -1.75000, 1.55300>, <-2.10679, -1.41667, 1.76724> }
		triangle  { <-2.27096, -1.75000, 0.82621>, <-1.59606, -2.00000, 1.33876>, <-1.95773, -2.00000, 0.71222> }
		triangle  { <-2.27096, -1.75000, 0.82621>, <-1.59606, -2.00000, 1.33876>, <-1.85142, -1.75000, 1.55300> }
		triangle  { <-1.95773, -2.00000, 0.71222>, <-0.70226, -2.16667, 0.58893>, <-0.86140, -2.16667, 0.31325> }
		triangle  { <-1.95773, -2.00000, 0.71222>, <-0.70226, -2.16667, 0.58893>, <-1.59606, -2.00000, 1.33876> }
		triangle  { <-0.86140, -2.16667, 0.31325>, <1.53221, -2.16667, -1.28565>, <1.87942, -2.16667, -0.68417> }
		triangle  { <-0.86140, -2.16667, 0.31325>, <1.53221, -2.16667, -1.28565>, <-0.70226, -2.16667, 0.58893> }
		triangle  { <1.87942, -2.16667, -0.68417>, <2.36216, -2.00000, -1.98193>, <2.89744, -2.00000, -1.05465> }
		triangle  { <1.87942, -2.16667, -0.68417>, <2.36216, -2.00000, -1.98193>, <1.53221, -2.16667, -1.28565> }
		triangle  { <2.89744, -2.00000, -1.05465>, <2.68137, -1.58333, -2.24972>, <3.28898, -1.58333, -1.19714> }
		triangle  { <2.89744, -2.00000, -1.05465>, <2.68137, -1.58333, -2.24972>, <2.36216, -2.00000, -1.98193> }
		triangle  { <3.28898, -1.58333, -1.19714>, <4.59664, 2.08333, -3.85651>, <5.63825, 2.08333, -2.05207> }
		triangle  { <3.28898, -1.58333, -1.19714>, <4.59664, 2.08333, -3.85651>, <2.68137, -1.58333, -2.24972> }
		triangle  { <-3.25595, 2.16667, 2.73131>, <-1.37534, -1.41667, 2.38115>, <-2.10679, -1.41667, 1.76724> }
		triangle  { <-3.25595, 2.16667, 2.73131>, <-1.37534, -1.41667, 2.38115>, <-2.12553, 2.16667, 3.68008> }
		triangle  { <-2.10679, -1.41667, 1.76724>, <-1.20864, -1.75000, 2.09250>, <-1.85142, -1.75000, 1.55300> }
		triangle  { <-2.10679, -1.41667, 1.76724>, <-1.20864, -1.75000, 2.09250>, <-1.37534, -1.41667, 2.38115> }
		triangle  { <-1.85142, -1.75000, 1.55300>, <-1.04193, -2.00000, 1.80384>, <-1.59606, -2.00000, 1.33876> }
		triangle  { <-1.85142, -1.75000, 1.55300>, <-1.04193, -2.00000, 1.80384>, <-1.20864, -1.75000, 2.09250> }
		triangle  { <-1.59606, -2.00000, 1.33876>, <-0.45845, -2.16667, 0.79357>, <-0.70226, -2.16667, 0.58893> }
		triangle  { <-1.59606, -2.00000, 1.33876>, <-0.45845, -2.16667, 0.79357>, <-1.04193, -2.00000, 1.80384> }
		triangle  { <-0.70226, -2.16667, 0.58893>, <1.00025, -2.16667, -1.73213>, <1.53221, -2.16667, -1.28565> }
		triangle  { <-0.70226, -2.16667, 0.58893>, <1.00025, -2.16667, -1.73213>, <-0.45845, -2.16667, 0.79357> }
		triangle  { <1.53221, -2.16667, -1.28565>, <1.54205, -2.00000, -2.67025>, <2.36216, -2.00000, -1.98193> }
		triangle  { <1.53221, -2.16667, -1.28565>, <1.54205, -2.00000, -2.67025>, <1.00025, -2.16667, -1.73213> }
		triangle  { <2.36216, -2.00000, -1.98193>, <1.75044, -1.58333, -3.03106>, <2.68137, -1.58333, -2.24972> }
		triangle  { <2.36216, -2.00000, -1.98193>, <1.75044, -1.58333, -3.03106>, <1.54205, -2.00000, -2.67025> }
		triangle  { <2.68137, -1.58333, -2.24972>, <3.00075, 2.08333, -5.19594>, <4.59664, 2.08333, -3.85651> }
		triangle  { <2.68137, -1.58333, -2.24972>, <3.00075, 2.08333, -5.19594>, <1.75044, -1.58333, -3.03106> }
		triangle  { <-2.12553, 2.16667, 3.68008>, <-0.47805, -1.41667, 2.70790>, <-1.37534, -1.41667, 2.38115> }
		triangle  { <-2.12553, 2.16667, 3.68008>, <-0.47805, -1.41667, 2.70790>, <-0.73881, 2.16667, 4.18507> }
		triangle  { <-1.37534, -1.41667, 2.38115>, <-0.42011, -1.75000, 2.37965>, <-1.20864, -1.75000, 2.09250> }
		triangle  { <-1.37534, -1.41667, 2.38115>, <-0.42011, -1.75000, 2.37965>, <-0.47805, -1.41667, 2.70790> }
		triangle  { <-1.20864, -1.75000, 2.09250>, <-0.36216, -2.00000, 2.05139>, <-1.04193, -2.00000, 1.80384> }
		triangle  { <-1.20864, -1.75000, 2.09250>, <-0.36216, -2.00000, 2.05139>, <-0.42011, -1.75000, 2.37965> }
		triangle  { <-1.04193, -2.00000, 1.80384>, <-0.15935, -2.16667, 0.90249>, <-0.45845, -2.16667, 0.79357> }
		triangle  { <-1.04193, -2.00000, 1.80384>, <-0.15935, -2.16667, 0.90249>, <-0.36216, -2.00000, 2.05139> }
		triangle  { <-0.45845, -2.16667, 0.79357>, <0.34767, -2.16667, -1.96977>, <1.00025, -2.16667, -1.73213> }
		triangle  { <-0.45845, -2.16667, 0.79357>, <0.34767, -2.16667, -1.96977>, <-0.15935, -2.16667, 0.90249> }
		triangle  { <1.00025, -2.16667, -1.73213>, <0.53600, -2.00000, -3.03661>, <1.54205, -2.00000, -2.67025> }
		triangle  { <1.00025, -2.16667, -1.73213>, <0.53600, -2.00000, -3.03661>, <0.34767, -2.16667, -1.96977> }
		triangle  { <1.54205, -2.00000, -2.67025>, <0.60843, -1.58333, -3.44693>, <1.75044, -1.58333, -3.03106> }
		triangle  { <1.54205, -2.00000, -2.67025>, <0.60843, -1.58333, -3.44693>, <0.53600, -2.00000, -3.03661> }
		triangle  { <1.75044, -1.58333, -3.03106>, <1.04302, 2.08333, -5.90887>, <3.00075, 2.08333, -5.19594> }
		triangle  { <1.75044, -1.58333, -3.03106>, <1.04302, 2.08333, -5.90887>, <0.60843, -1.58333, -3.44693> }
		triangle  { <-0.73881, 2.16667, 4.18507>, <0.47688, -1.41667, 2.70811>, <-0.47805, -1.41667, 2.70790> }
		triangle  { <-0.73881, 2.16667, 4.18507>, <0.47688, -1.41667, 2.70811>, <0.73700, 2.16667, 4.18539> }
		triangle  { <-0.47805, -1.41667, 2.70790>, <0.41908, -1.75000, 2.37983>, <-0.42011, -1.75000, 2.37965> }
		triangle  { <-0.47805, -1.41667, 2.70790>, <0.41908, -1.75000, 2.37983>, <0.47688, -1.41667, 2.70811> }
		triangle  { <-0.42011, -1.75000, 2.37965>, <0.36127, -2.00000, 2.05154>, <-0.36216, -2.00000, 2.05139> }
		triangle  { <-0.42011, -1.75000, 2.37965>, <0.36127, -2.00000, 2.05154>, <0.41908, -1.75000, 2.37983> }
		triangle  { <-0.36216, -2.00000, 2.05139>, <0.15896, -2.16667, 0.90255>, <-0.15935, -2.16667, 0.90249> }
		triangle  { <-0.36216, -2.00000, 2.05139>, <0.15896, -2.16667, 0.90255>, <0.36127, -2.00000, 2.05154> }
		triangle  { <-0.15935, -2.16667, 0.90249>, <-0.34682, -2.16667, -1.96992>, <0.34767, -2.16667, -1.96977> }
		triangle  { <-0.15935, -2.16667, 0.90249>, <-0.34682, -2.16667, -1.96992>, <0.15896, -2.16667, 0.90255> }
		triangle  { <0.34767, -2.16667, -1.96977>, <-0.53469, -2.00000, -3.03684>, <0.53600, -2.00000, -3.03661> }
		triangle  { <0.34767, -2.16667, -1.96977>, <-0.53469, -2.00000, -3.03684>, <-0.34682, -2.16667, -1.96992> }
		triangle  { <0.53600, -2.00000, -3.03661>, <-0.60694, -1.58333, -3.44720>, <0.60843, -1.58333, -3.44693> }
		triangle  { <0.53600, -2.00000, -3.03661>, <-0.60694, -1.58333, -3.44720>, <-0.53469, -2.00000, -3.03684> }
		triangle  { <0.60843, -1.58333, -3.44693>, <-1.04047, 2.08333, -5.90932>, <1.04302, 2.08333, -5.90887> }
		triangle  { <0.60843, -1.58333, -3.44693>, <-1.04047, 2.08333, -5.90932>, <-0.60694, -1.58333, -3.44720> }
		triangle  { <0.73700, 2.16667, 4.18539>, <1.37431, -1.41667, 2.38174>, <0.47688, -1.41667, 2.70811> }
		triangle  { <0.73700, 2.16667, 4.18539>, <1.37431, -1.41667, 2.38174>, <2.12394, 2.16667, 3.68100> }
		triangle  { <0.47688, -1.41667, 2.70811>, <1.20773, -1.75000, 2.09302>, <0.41908, -1.75000, 2.37983> }
		triangle  { <0.47688, -1.41667, 2.70811>, <1.20773, -1.75000, 2.09302>, <1.37431, -1.41667, 2.38174> }
		triangle  { <0.41908, -1.75000, 2.37983>, <1.04115, -2.00000, 1.80430>, <0.36127, -2.00000, 2.05154> }
		triangle  { <0.41908, -1.75000, 2.37983>, <1.04115, -2.00000, 1.80430>, <1.20773, -1.75000, 2.09302> }
		triangle  { <0.36127, -2.00000, 2.05154>, <0.45810, -2.16667, 0.79376>, <0.15896, -2.16667, 0.90255> }
		triangle  { <0.36127, -2.00000, 2.05154>, <0.45810, -2.16667, 0.79376>, <1.04115, -2.00000, 1.80430> }
		triangle  { <0.15896, -2.16667, 0.90255>, <-0.99950, -2.16667, -1.73256>, <-0.34682, -2.16667, -1.96992> }
		triangle  { <0.15896, -2.16667, 0.90255>, <-0.99950, -2.16667, -1.73256>, <0.45810, -2.16667, 0.79376> }
		triangle  { <-0.34682, -2.16667, -1.96992>, <-1.54090, -2.00000, -2.67091>, <-0.53469, -2.00000, -3.03684> }
		triangle  { <-0.34682, -2.16667, -1.96992>, <-1.54090, -2.00000, -2.67091>, <-0.99950, -2.16667, -1.73256> }
		triangle  { <-0.53469, -2.00000, -3.03684>, <-1.74913, -1.58333, -3.03182>, <-0.60694, -1.58333, -3.44720> }
		triangle  { <-0.53469, -2.00000, -3.03684>, <-1.74913, -1.58333, -3.03182>, <-1.54090, -2.00000, -2.67091> }
		triangle  { <-0.60694, -1.58333, -3.44720>, <-2.99850, 2.08333, -5.19724>, <-1.04047, 2.08333, -5.90932> }
		triangle  { <-0.60694, -1.58333, -3.44720>, <-2.99850, 2.08333, -5.19724>, <-1.74913, -1.58333, -3.03182> }
		triangle  { <2.12394, 2.16667, 3.68100>, <2.10603, -1.41667, 1.76815>, <1.37431, -1.41667, 2.38174> }
		triangle  { <2.12394, 2.16667, 3.68100>, <2.10603, -1.41667, 1.76815>, <3.25477, 2.16667, 2.73272> }
		triangle  { <1.37431, -1.41667, 2.38174>, <1.85075, -1.75000, 1.55380>, <1.20773, -1.75000, 2.09302> }
		triangle  { <1.37431, -1.41667, 2.38174>, <1.85075, -1.75000, 1.55380>, <2.10603, -1.41667, 1.76815> }
		triangle  { <1.20773, -1.75000, 2.09302>, <1.59547, -2.00000, 1.33945>, <1.04115, -2.00000, 1.80430> }
		triangle  { <1.20773, -1.75000, 2.09302>, <1.59547, -2.00000, 1.33945>, <1.85075, -1.75000, 1.55380> }
		triangle  { <1.04115, -2.00000, 1.80430>, <0.70201, -2.16667, 0.58923>, <0.45810, -2.16667, 0.79376> }
		triangle  { <1.04115, -2.00000, 1.80430>, <0.70201, -2.16667, 0.58923>, <1.59547, -2.00000, 1.33945> }
		triangle  { <0.45810, -2.16667, 0.79376>, <-1.53166, -2.16667, -1.28632>, <-0.99950, -2.16667, -1.73256> }
		triangle  { <0.45810, -2.16667, 0.79376>, <-1.53166, -2.16667, -1.28632>, <0.70201, -2.16667, 0.58923> }
		triangle  { <-0.99950, -2.16667, -1.73256>, <-2.36130, -2.00000, -1.98295>, <-1.54090, -2.00000, -2.67091> }
		triangle  { <-0.99950, -2.16667, -1.73256>, <-2.36130, -2.00000, -1.98295>, <-1.53166, -2.16667, -1.28632> }
		triangle  { <-1.54090, -2.00000, -2.67091>, <-2.68040, -1.58333, -2.25088>, <-1.74913, -1.58333, -3.03182> }
		triangle  { <-1.54090, -2.00000, -2.67091>, <-2.68040, -1.58333, -2.25088>, <-2.36130, -2.00000, -1.98295> }
		triangle  { <-1.74913, -1.58333, -3.03182>, <-4.59497, 2.08333, -3.85850>, <-2.99850, 2.08333, -5.19724> }
		triangle  { <-1.74913, -1.58333, -3.03182>, <-4.59497, 2.08333, -3.85850>, <-2.68040, -1.58333, -2.25088> }
		triangle  { <3.25477, 2.16667, 2.73272>, <2.58379, -1.41667, 0.94132>, <2.10603, -1.41667, 1.76815> }
		triangle  { <3.25477, 2.16667, 2.73272>, <2.58379, -1.41667, 0.94132>, <3.99313, 2.16667, 1.45490> }
		triangle  { <2.10603, -1.41667, 1.76815>, <2.27061, -1.75000, 0.82720>, <1.85075, -1.75000, 1.55380> }
		triangle  { <2.10603, -1.41667, 1.76815>, <2.27061, -1.75000, 0.82720>, <2.58379, -1.41667, 0.94132> }
		triangle  { <1.85075, -1.75000, 1.55380>, <1.95742, -2.00000, 0.71307>, <1.59547, -2.00000, 1.33945> }
		triangle  { <1.85075, -1.75000, 1.55380>, <1.95742, -2.00000, 0.71307>, <2.27061, -1.75000, 0.82720> }
		triangle  { <1.59547, -2.00000, 1.33945>, <0.86126, -2.16667, 0.31362>, <0.70201, -2.16667, 0.58923> }
		triangle  { <1.59547, -2.00000, 1.33945>, <0.86126, -2.16667, 0.31362>, <1.95742, -2.00000, 0.71307> }
		triangle  { <0.70201, -2.16667, 0.58923>, <-1.87912, -2.16667, -0.68499>, <-1.53166, -2.16667, -1.28632> }
		triangle  { <0.70201, -2.16667, 0.58923>, <-1.87912, -2.16667, -0.68499>, <0.86126, -2.16667, 0.31362> }
		triangle  { <-1.53166, -2.16667, -1.28632>, <-2.89698, -2.00000, -1.05590>, <-2.36130, -2.00000, -1.98295> }
		triangle  { <-1.53166, -2.16667, -1.28632>, <-2.89698, -2.00000, -1.05590>, <-1.87912, -2.16667, -0.68499> }
		triangle  { <-2.36130, -2.00000, -1.98295>, <-3.28846, -1.58333, -1.19856>, <-2.68040, -1.58333, -2.25088> }
		triangle  { <-2.36130, -2.00000, -1.98295>, <-3.28846, -1.58333, -1.19856>, <-2.89698, -2.00000, -1.05590> }
		triangle  { <-2.68040, -1.58333, -2.25088>, <-5.63737, 2.08333, -2.05451>, <-4.59497, 2.08333, -3.85850> }
		triangle  { <-2.68040, -1.58333, -2.25088>, <-5.63737, 2.08333, -2.05451>, <-3.28846, -1.58333, -1.19856> }
		triangle  { <3.99313, 2.16667, 1.45490>, <2.75000, -1.41667, 0.00096>, <2.58379, -1.41667, 0.94132> }
		triangle  { <3.99313, 2.16667, 1.45490>, <2.75000, -1.41667, 0.00096>, <4.25000, 2.16667, 0.00161> }
		triangle  { <2.58379, -1.41667, 0.94132>, <2.41667, -1.75000, 0.00082>, <2.27061, -1.75000, 0.82720> }
		triangle  { <2.58379, -1.41667, 0.94132>, <2.41667, -1.75000, 0.00082>, <2.75000, -1.41667, 0.00096> }
		triangle  { <2.27061, -1.75000, 0.82720>, <2.08333, -2.00000, 0.00068>, <1.95742, -2.00000, 0.71307> }
		triangle  { <2.27061, -1.75000, 0.82720>, <2.08333, -2.00000, 0.00068>, <2.41667, -1.75000, 0.00082> }
		triangle  { <1.95742, -2.00000, 0.71307>, <0.91667, -2.16667, 0.00017>, <0.86126, -2.16667, 0.31362> }
		triangle  { <1.95742, -2.00000, 0.71307>, <0.91667, -2.16667, 0.00017>, <2.08333, -2.00000, 0.00068> }
		triangle  { <0.86126, -2.16667, 0.31362>, <-2.00000, -2.16667, -0.00109>, <-1.87912, -2.16667, -0.68499> }
		triangle  { <0.86126, -2.16667, 0.31362>, <-2.00000, -2.16667, -0.00109>, <0.91667, -2.16667, 0.00017> }
		triangle  { <-1.87912, -2.16667, -0.68499>, <-3.08333, -2.00000, -0.00156>, <-2.89698, -2.00000, -1.05590> }
		triangle  { <-1.87912, -2.16667, -0.68499>, <-3.08333, -2.00000, -0.00156>, <-2.00000, -2.16667, -0.00109> }
		triangle  { <-2.89698, -2.00000, -1.05590>, <-3.50000, -1.58333, -0.00174>, <-3.28846, -1.58333, -1.19856> }
		triangle  { <-2.89698, -2.00000, -1.05590>, <-3.50000, -1.58333, -0.00174>, <-3.08333, -2.00000, -0.00156> }
		triangle  { <-3.28846, -1.58333, -1.19856>, <-6.00000, 2.08333, -0.00282>, <-5.63737, 2.08333, -2.05451> }
		triangle  { <-3.28846, -1.58333, -1.19856>, <-6.00000, 2.08333, -0.00282>, <-3.50000, -1.58333, -0.00174> }
		triangle  { <4.25000, 2.16667, 0.00161>, <2.58461, -1.41667, -0.93954>, <2.75000, -1.41667, 0.00096> }
		triangle  { <4.25000, 2.16667, 0.00161>, <2.58461, -1.41667, -0.93954>, <3.99439, 2.16667, -1.45189> }
		triangle  { <2.75000, -1.41667, 0.00096>, <2.27132, -1.75000, -0.82568>, <2.41667, -1.75000, 0.00082> }
		triangle  { <2.75000, -1.41667, 0.00096>, <2.27132, -1.75000, -0.82568>, <2.58461, -1.41667, -0.93954> }
		triangle  { <2.41667, -1.75000, 0.00082>, <1.95803, -2.00000, -0.71183>, <2.08333, -2.00000, 0.00068> }
		triangle  { <2.41667, -1.75000, 0.00082>, <1.95803, -2.00000, -0.71183>, <2.27132, -1.75000, -0.82568> }
		triangle  { <2.08333, -2.00000, 0.00068>, <0.86154, -2.16667, -0.31333>, <0.91667, -2.16667, 0.00017> }
		triangle  { <2.08333, -2.00000, 0.00068>, <0.86154, -2.16667, -0.31333>, <1.95803, -2.00000, -0.71183> }
		triangle  { <0.91667, -2.16667, 0.00017>, <-1.87971, -2.16667, 0.68291>, <-2.00000, -2.16667, -0.00109> }
		triangle  { <0.91667, -2.16667, 0.00017>, <-1.87971, -2.16667, 0.68291>, <0.86154, -2.16667, -0.31333> }
		triangle  { <-2.00000, -2.16667, -0.00109>, <-2.89789, -2.00000, 1.05294>, <-3.08333, -2.00000, -0.00156> }
		triangle  { <-2.00000, -2.16667, -0.00109>, <-2.89789, -2.00000, 1.05294>, <-1.87971, -2.16667, 0.68291> }
		triangle  { <-3.08333, -2.00000, -0.00156>, <-3.28950, -1.58333, 1.19526>, <-3.50000, -1.58333, -0.00174> }
		triangle  { <-3.08333, -2.00000, -0.00156>, <-3.28950, -1.58333, 1.19526>, <-2.89789, -2.00000, 1.05294> }
		triangle  { <-3.50000, -1.58333, -0.00174>, <-5.63914, 2.08333, 2.04919>, <-6.00000, 2.08333, -0.00282> }
		triangle  { <-3.50000, -1.58333, -0.00174>, <-5.63914, 2.08333, 2.04919>, <-3.28950, -1.58333, 1.19526> }
		triangle  { <3.99439, 2.16667, -1.45189>, <2.10756, -1.41667, -1.76678>, <2.58461, -1.41667, -0.93954> }
		triangle  { <3.99439, 2.16667, -1.45189>, <2.10756, -1.41667, -1.76678>, <3.25713, 2.16667, -2.73035> }
		triangle  { <2.58461, -1.41667, -0.93954>, <1.85209, -1.75000, -1.55265>, <2.27132, -1.75000, -0.82568> }
		triangle  { <2.58461, -1.41667, -0.93954>, <1.85209, -1.75000, -1.55265>, <2.10756, -1.41667, -1.76678> }
		triangle  { <2.27132, -1.75000, -0.82568>, <1.59663, -2.00000, -1.33852>, <1.95803, -2.00000, -0.71183> }
		triangle  { <2.27132, -1.75000, -0.82568>, <1.59663, -2.00000, -1.33852>, <1.85209, -1.75000, -1.55265> }
		triangle  { <1.95803, -2.00000, -0.71183>, <0.70252, -2.16667, -0.58908>, <0.86154, -2.16667, -0.31333> }
		triangle  { <1.95803, -2.00000, -0.71183>, <0.70252, -2.16667, -0.58908>, <1.59663, -2.00000, -1.33852> }
		triangle  { <0.86154, -2.16667, -0.31333>, <-1.53277, -2.16667, 1.28454>, <-1.87971, -2.16667, 0.68291> }
		triangle  { <0.86154, -2.16667, -0.31333>, <-1.53277, -2.16667, 1.28454>, <0.70252, -2.16667, -0.58908> }
		triangle  { <-1.87971, -2.16667, 0.68291>, <-2.36302, -2.00000, 1.98045>, <-2.89789, -2.00000, 1.05294> }
		triangle  { <-1.87971, -2.16667, 0.68291>, <-2.36302, -2.00000, 1.98045>, <-1.53277, -2.16667, 1.28454> }
		triangle  { <-2.89789, -2.00000, 1.05294>, <-2.68235, -1.58333, 2.24811>, <-3.28950, -1.58333, 1.19526> }
		triangle  { <-2.89789, -2.00000, 1.05294>, <-2.68235, -1.58333, 2.24811>, <-2.36302, -2.00000, 1.98045> }
		triangle  { <-3.28950, -1.58333, 1.19526>, <-4.59831, 2.08333, 3.85407>, <-5.63914, 2.08333, 2.04919> }
		triangle  { <-3.28950, -1.58333, 1.19526>, <-4.59831, 2.08333, 3.85407>, <-2.68235, -1.58333, 2.24811> }
		triangle  { <3.25713, 2.16667, -2.73035>, <1.37637, -1.41667, -2.38100>, <2.10756, -1.41667, -1.76678> }
		triangle  { <3.25713, 2.16667, -2.73035>, <1.37637, -1.41667, -2.38100>, <2.12712, 2.16667, -3.67961> }
		triangle  { <2.10756, -1.41667, -1.76678>, <1.20954, -1.75000, -2.09242>, <1.85209, -1.75000, -1.55265> }
		triangle  { <2.10756, -1.41667, -1.76678>, <1.20954, -1.75000, -2.09242>, <1.37637, -1.41667, -2.38100> }
		triangle  { <1.85209, -1.75000, -1.55265>, <1.04271, -2.00000, -1.80384>, <1.59663, -2.00000, -1.33852> }
		triangle  { <1.85209, -1.75000, -1.55265>, <1.04271, -2.00000, -1.80384>, <1.20954, -1.75000, -2.09242> }
		triangle  { <1.59663, -2.00000, -1.33852>, <0.45879, -2.16667, -0.79382>, <0.70252, -2.16667, -0.58908> }
		triangle  { <1.59663, -2.00000, -1.33852>, <0.45879, -2.16667, -0.79382>, <1.04271, -2.00000, -1.80384> }
		triangle  { <0.70252, -2.16667, -0.58908>, <-1.00100, -2.16667, 1.73125>, <-1.53277, -2.16667, 1.28454> }
		triangle  { <0.70252, -2.16667, -0.58908>, <-1.00100, -2.16667, 1.73125>, <0.45879, -2.16667, -0.79382> }
		triangle  { <-1.53277, -2.16667, 1.28454>, <-1.54321, -2.00000, 2.66913>, <-2.36302, -2.00000, 1.98045> }
		triangle  { <-1.53277, -2.16667, 1.28454>, <-1.54321, -2.00000, 2.66913>, <-1.00100, -2.16667, 1.73125> }
		triangle  { <-2.36302, -2.00000, 1.98045>, <-1.75175, -1.58333, 3.02985>, <-2.68235, -1.58333, 2.24811> }
		triangle  { <-2.36302, -2.00000, 1.98045>, <-1.75175, -1.58333, 3.02985>, <-1.54321, -2.00000, 2.66913> }
		triangle  { <-2.68235, -1.58333, 2.24811>, <-3.00300, 2.08333, 5.19420>, <-4.59831, 2.08333, 3.85407> }
		triangle  { <-2.68235, -1.58333, 2.24811>, <-3.00300, 2.08333, 5.19420>, <-1.75175, -1.58333, 3.02985> }
		triangle  { <2.12712, 2.16667, -3.67961>, <0.47922, -1.41667, -2.70815>, <1.37637, -1.41667, -2.38100> }
		triangle  { <2.12712, 2.16667, -3.67961>, <0.47922, -1.41667, -2.70815>, <0.74062, 2.16667, -4.18520> }
		triangle  { <1.37637, -1.41667, -2.38100>, <0.42114, -1.75000, -2.37991>, <1.20954, -1.75000, -2.09242> }
		triangle  { <1.37637, -1.41667, -2.38100>, <0.42114, -1.75000, -2.37991>, <0.47922, -1.41667, -2.70815> }
		triangle  { <1.20954, -1.75000, -2.09242>, <0.36305, -2.00000, -2.05168>, <1.04271, -2.00000, -1.80384> }
		triangle  { <1.20954, -1.75000, -2.09242>, <0.36305, -2.00000, -2.05168>, <0.42114, -1.75000, -2.37991> }
		triangle  { <1.04271, -2.00000, -1.80384>, <0.15974, -2.16667, -0.90287>, <0.45879, -2.16667, -0.79382> }
		triangle  { <1.04271, -2.00000, -1.80384>, <0.15974, -2.16667, -0.90287>, <0.36305, -2.00000, -2.05168> }
		triangle  { <0.45879, -2.16667, -0.79382>, <-0.34853, -2.16667, 1.96917>, <-1.00100, -2.16667, 1.73125> }
		triangle  { <0.45879, -2.16667, -0.79382>, <-0.34853, -2.16667, 1.96917>, <0.15974, -2.16667, -0.90287> }
		triangle  { <-1.00100, -2.16667, 1.73125>, <-0.53731, -2.00000, 3.03593>, <-1.54321, -2.00000, 2.66913> }
		triangle  { <-1.00100, -2.16667, 1.73125>, <-0.53731, -2.00000, 3.03593>, <-0.34853, -2.16667, 1.96917> }
		triangle  { <-1.54321, -2.00000, 2.66913>, <-0.60992, -1.58333, 3.44622>, <-1.75175, -1.58333, 3.02985> }
		triangle  { <-1.54321, -2.00000, 2.66913>, <-0.60992, -1.58333, 3.44622>, <-0.53731, -2.00000, 3.03593> }
		triangle  { <-1.75175, -1.58333, 3.02985>, <-1.04558, 2.08333, 5.90797>, <-3.00300, 2.08333, 5.19420> }
		triangle  { <-1.75175, -1.58333, 3.02985>, <-1.04558, 2.08333, 5.90797>, <-0.60992, -1.58333, 3.44622> }
		triangle  { <0.74062, 2.16667, -4.18520>, <-0.47571, -1.41667, -2.70877>, <0.47922, -1.41667, -2.70815> }
		triangle  { <0.74062, 2.16667, -4.18520>, <-0.47571, -1.41667, -2.70877>, <-0.73519, 2.16667, -4.18615> }
		triangle  { <0.47922, -1.41667, -2.70815>, <-0.41805, -1.75000, -2.38046>, <0.42114, -1.75000, -2.37991> }
		triangle  { <0.47922, -1.41667, -2.70815>, <-0.41805, -1.75000, -2.38046>, <-0.47571, -1.41667, -2.70877> }
		triangle  { <0.42114, -1.75000, -2.37991>, <-0.36039, -2.00000, -2.05215>, <0.36305, -2.00000, -2.05168> }
		triangle  { <0.42114, -1.75000, -2.37991>, <-0.36039, -2.00000, -2.05215>, <-0.41805, -1.75000, -2.38046> }
		triangle  { <0.36305, -2.00000, -2.05168>, <-0.15857, -2.16667, -0.90307>, <0.15974, -2.16667, -0.90287> }
		triangle  { <0.36305, -2.00000, -2.05168>, <-0.15857, -2.16667, -0.90307>, <-0.36039, -2.00000, -2.05215> }
		triangle  { <0.15974, -2.16667, -0.90287>, <0.34597, -2.16667, 1.96962>, <-0.34853, -2.16667, 1.96917> }
		triangle  { <0.15974, -2.16667, -0.90287>, <0.34597, -2.16667, 1.96962>, <-0.15857, -2.16667, -0.90307> }
		triangle  { <-0.34853, -2.16667, 1.96917>, <0.53337, -2.00000, 3.03663>, <-0.53731, -2.00000, 3.03593> }
		triangle  { <-0.34853, -2.16667, 1.96917>, <0.53337, -2.00000, 3.03663>, <0.34597, -2.16667, 1.96962> }
		triangle  { <-0.53731, -2.00000, 3.03593>, <0.60545, -1.58333, 3.44701>, <-0.60992, -1.58333, 3.44622> }
		triangle  { <-0.53731, -2.00000, 3.03593>, <0.60545, -1.58333, 3.44701>, <0.53337, -2.00000, 3.03663> }
		triangle  { <-0.60992, -1.58333, 3.44622>, <1.03791, 2.08333, 5.90932>, <-1.04558, 2.08333, 5.90797> }
		triangle  { <-0.60992, -1.58333, 3.44622>, <1.03791, 2.08333, 5.90932>, <0.60545, -1.58333, 3.44701> }
		triangle  { <-0.73519, 2.16667, -4.18615>, <-1.37328, -1.41667, -2.38279>, <-0.47571, -1.41667, -2.70877> }
		triangle  { <-0.73519, 2.16667, -4.18615>, <-1.37328, -1.41667, -2.38279>, <-2.12235, 2.16667, -3.68236> }
		triangle  { <-0.47571, -1.41667, -2.70877>, <-1.20682, -1.75000, -2.09399>, <-0.41805, -1.75000, -2.38046> }
		triangle  { <-0.47571, -1.41667, -2.70877>, <-1.20682, -1.75000, -2.09399>, <-1.37328, -1.41667, -2.38279> }
		triangle  { <-0.41805, -1.75000, -2.38046>, <-1.04037, -2.00000, -1.80519>, <-0.36039, -2.00000, -2.05215> }
		triangle  { <-0.41805, -1.75000, -2.38046>, <-1.04037, -2.00000, -1.80519>, <-1.20682, -1.75000, -2.09399> }
		triangle  { <-0.36039, -2.00000, -2.05215>, <-0.45776, -2.16667, -0.79441>, <-0.15857, -2.16667, -0.90307> }
		triangle  { <-0.36039, -2.00000, -2.05215>, <-0.45776, -2.16667, -0.79441>, <-1.04037, -2.00000, -1.80519> }
		triangle  { <-0.15857, -2.16667, -0.90307>, <0.99875, -2.16667, 1.73255>, <0.34597, -2.16667, 1.96962> }
		triangle  { <-0.15857, -2.16667, -0.90307>, <0.99875, -2.16667, 1.73255>, <-0.45776, -2.16667, -0.79441> }
		triangle  { <0.34597, -2.16667, 1.96962>, <1.53974, -2.00000, 2.67113>, <0.53337, -2.00000, 3.03663> }
		triangle  { <0.34597, -2.16667, 1.96962>, <1.53974, -2.00000, 2.67113>, <0.99875, -2.16667, 1.73255> }
		triangle  { <0.53337, -2.00000, 3.03663>, <1.74781, -1.58333, 3.03213>, <0.60545, -1.58333, 3.44701> }
		triangle  { <0.53337, -2.00000, 3.03663>, <1.74781, -1.58333, 3.03213>, <1.53974, -2.00000, 2.67113> }
		triangle  { <0.60545, -1.58333, 3.44701>, <2.99625, 2.08333, 5.19809>, <1.03791, 2.08333, 5.90932> }
		triangle  { <0.60545, -1.58333, 3.44701>, <2.99625, 2.08333, 5.19809>, <1.74781, -1.58333, 3.03213> }
		triangle  { <-2.12235, 2.16667, -3.68236>, <-2.10526, -1.41667, -1.76951>, <-1.37328, -1.41667, -2.38279> }
		triangle  { <-2.12235, 2.16667, -3.68236>, <-2.10526, -1.41667, -1.76951>, <-3.25359, 2.16667, -2.73458> }
		triangle  { <-1.37328, -1.41667, -2.38279>, <-1.85008, -1.75000, -1.55505>, <-1.20682, -1.75000, -2.09399> }
		triangle  { <-1.37328, -1.41667, -2.38279>, <-1.85008, -1.75000, -1.55505>, <-2.10526, -1.41667, -1.76951> }
		triangle  { <-1.20682, -1.75000, -2.09399>, <-1.59490, -2.00000, -1.34059>, <-1.04037, -2.00000, -1.80519> }
		triangle  { <-1.20682, -1.75000, -2.09399>, <-1.59490, -2.00000, -1.34059>, <-1.85008, -1.75000, -1.55505> }
		triangle  { <-1.04037, -2.00000, -1.80519>, <-0.70175, -2.16667, -0.58999>, <-0.45776, -2.16667, -0.79441> }
		triangle  { <-1.04037, -2.00000, -1.80519>, <-0.70175, -2.16667, -0.58999>, <-1.59490, -2.00000, -1.34059> }
		triangle  { <-0.45776, -2.16667, -0.79441>, <1.53110, -2.16667, 1.28653>, <0.99875, -2.16667, 1.73255> }
		triangle  { <-0.45776, -2.16667, -0.79441>, <1.53110, -2.16667, 1.28653>, <-0.70175, -2.16667, -0.58999> }
		triangle  { <0.99875, -2.16667, 1.73255>, <2.36044, -2.00000, 1.98352>, <1.53974, -2.00000, 2.67113> }
		triangle  { <0.99875, -2.16667, 1.73255>, <2.36044, -2.00000, 1.98352>, <1.53110, -2.16667, 1.28653> }
		triangle  { <1.53974, -2.00000, 2.67113>, <2.67942, -1.58333, 2.25159>, <1.74781, -1.58333, 3.03213> }
		triangle  { <1.53974, -2.00000, 2.67113>, <2.67942, -1.58333, 2.25159>, <2.36044, -2.00000, 1.98352> }
		triangle  { <1.74781, -1.58333, 3.03213>, <4.59330, 2.08333, 3.86004>, <2.99625, 2.08333, 5.19809> }
		triangle  { <1.74781, -1.58333, 3.03213>, <4.59330, 2.08333, 3.86004>, <2.67942, -1.58333, 2.25159> }
		triangle  { <-3.25359, 2.16667, -2.73458>, <-2.58339, -1.41667, -0.94289>, <-2.10526, -1.41667, -1.76951> }
		triangle  { <-3.25359, 2.16667, -2.73458>, <-2.58339, -1.41667, -0.94289>, <-3.99250, 2.16667, -1.45707> }
		triangle  { <-2.10526, -1.41667, -1.76951>, <-2.27025, -1.75000, -0.82863>, <-1.85008, -1.75000, -1.55505> }
		triangle  { <-2.10526, -1.41667, -1.76951>, <-2.27025, -1.75000, -0.82863>, <-2.58339, -1.41667, -0.94289> }
		triangle  { <-1.85008, -1.75000, -1.55505>, <-1.95711, -2.00000, -0.71437>, <-1.59490, -2.00000, -1.34059> }
		triangle  { <-1.85008, -1.75000, -1.55505>, <-1.95711, -2.00000, -0.71437>, <-2.27025, -1.75000, -0.82863> }
		triangle  { <-1.59490, -2.00000, -1.34059>, <-0.86113, -2.16667, -0.31445>, <-0.70175, -2.16667, -0.58999> }
		triangle  { <-1.59490, -2.00000, -1.34059>, <-0.86113, -2.16667, -0.31445>, <-1.95711, -2.00000, -0.71437> }
		triangle  { <-0.70175, -2.16667, -0.58999>, <1.87883, -2.16667, 0.68535>, <1.53110, -2.16667, 1.28653> }
		triangle  { <-0.70175, -2.16667, -0.58999>, <1.87883, -2.16667, 0.68535>, <-0.86113, -2.16667, -0.31445> }
		triangle  { <1.53110, -2.16667, 1.28653>, <2.89652, -2.00000, 1.05670>, <2.36044, -2.00000, 1.98352> }
		triangle  { <1.53110, -2.16667, 1.28653>, <2.89652, -2.00000, 1.05670>, <1.87883, -2.16667, 0.68535> }
		triangle  { <2.36044, -2.00000, 1.98352>, <3.28794, -1.58333, 1.19953>, <2.67942, -1.58333, 2.25159> }
		triangle  { <2.36044, -2.00000, 1.98352>, <3.28794, -1.58333, 1.19953>, <2.89652, -2.00000, 1.05670> }
		triangle  { <2.67942, -1.58333, 2.25159>, <5.63648, 2.08333, 2.05650>, <4.59330, 2.08333, 3.86004> }
		triangle  { <2.67942, -1.58333, 2.25159>, <5.63648, 2.08333, 2.05650>, <3.28794, -1.58333, 1.19953> }
		triangle  { <-3.99250, 2.16667, -1.45707>, <-2.75000, -1.41667, -0.00260>, <-2.58339, -1.41667, -0.94289> }
		triangle  { <-3.99250, 2.16667, -1.45707>, <-2.75000, -1.41667, -0.00260>, <-4.25000, 2.16667, -0.00390> }
		triangle  { <-2.58339, -1.41667, -0.94289>, <-2.41667, -1.75000, -0.00232>, <-2.27025, -1.75000, -0.82863> }
		triangle  { <-2.58339, -1.41667, -0.94289>, <-2.41667, -1.75000, -0.00232>, <-2.75000, -1.41667, -0.00260> }
		triangle  { <-2.27025, -1.75000, -0.82863>, <-2.08333, -2.00000, -0.00203>, <-1.95711, -2.00000, -0.71437> }
		triangle  { <-2.27025, -1.75000, -0.82863>, <-2.08333, -2.00000, -0.00203>, <-2.41667, -1.75000, -0.00232> }
		triangle  { <-1.95711, -2.00000, -0.71437>, <-0.91667, -2.16667, -0.00102>, <-0.86113, -2.16667, -0.31445> }
		triangle  { <-1.95711, -2.00000, -0.71437>, <-0.91667, -2.16667, -0.00102>, <-2.08333, -2.00000, -0.00203> }
		triangle  { <-0.86113, -2.16667, -0.31445>, <2.00000, -2.16667, 0.00151>, <1.87883, -2.16667, 0.68535> }
		triangle  { <-0.86113, -2.16667, -0.31445>, <2.00000, -2.16667, 0.00151>, <-0.91667, -2.16667, -0.00102> }
		triangle  { <1.87883, -2.16667, 0.68535>, <3.08333, -2.00000, 0.00244>, <2.89652, -2.00000, 1.05670> }
		triangle  { <1.87883, -2.16667, 0.68535>, <3.08333, -2.00000, 0.00244>, <2.00000, -2.16667, 0.00151> }
		triangle  { <2.89652, -2.00000, 1.05670>, <3.50000, -1.58333, 0.00280>, <3.28794, -1.58333, 1.19953> }
		triangle  { <2.89652, -2.00000, 1.05670>, <3.50000, -1.58333, 0.00280>, <3.08333, -2.00000, 0.00244> }
		triangle  { <3.28794, -1.58333, 1.19953>, <6.00000, 2.08333, 0.00497>, <5.63648, 2.08333, 2.05650> }
		triangle  { <3.28794, -1.58333, 1.19953>, <6.00000, 2.08333, 0.00497>, <3.50000, -1.58333, 0.00280> }
		rotate < 0, 356, 90>

		translate < 30.08872, 20.00370, 22.30524>
		}  /* End Shape */
   } /*End object*/

   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.31625, 2.74374, 0.75312>
		rotate < 24, 0, 311>
		translate < 21.27938, 11.71266, 3.74688> 
		pigment
		{
		colour rgbf <1.000000, 0.000000, 0.000000, 0.000000>
		}  /* End Colour */
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   CylY28*/

   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.31625, 2.74374, 0.75312>
		rotate < 24, 0, 311>
		translate < 27.02938, 16.21266, 5.74688> 
		pigment
		{
		colour rgbf <1.000000, 0.000000, 0.000000, 0.000000>
		}  /* End Colour */
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   CylY31*/

   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.31625, 2.74374, 0.75312>
		rotate < 30, 0, 312>
		translate < 10.27937, 2.46266, 0.00000> 
		pigment
		{
		colour rgbf <1.000000, 0.000000, 0.000000, 0.000000>
		}  /* End Colour */
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   CylY32*/

   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.31625, 2.74374, 0.75312>
		rotate < 21, 0, 311>
		translate < 15.52938, 6.96266, 1.74688> 
		pigment
		{
		colour rgbf <1.000000, 0.000000, 0.000000, 0.000000>
		}  /* End Colour */
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   CylY33*/

   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.31625, 2.74374, 0.75312>
		rotate < 0, 0, 313>
		translate < 14.47356, 9.14883, 21.24688> 
		pigment
		{
		colour rgbf <1.000000, 0.000000, 0.000000, 0.000000>
		}  /* End Colour */
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   CylY34*/

   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.31625, 2.74374, 0.75312>
		rotate < 0, 0, 313>
		translate < 9.72356, 4.89883, 21.24688> 
		pigment
		{
		colour rgbf <1.000000, 0.000000, 0.000000, 0.000000>
		}  /* End Colour */
		}  /* End Shape */
   } /*End object*/


   object
   {
	union
	{
		triangle  { <-1.08333, 1.64583, 0.00005>, <-0.68963, -1.24794, 0.29928>, <-0.73387, -1.24794, 0.00005> }
		triangle  { <-1.08333, 1.64583, 0.00005>, <-0.68963, -1.24794, 0.29928>, <-1.01802, 1.64583, 0.44177> }
		triangle  { <-0.73387, -1.24794, 0.00005>, <-0.68963, -1.64583, 0.29928>, <-0.73387, -1.64583, 0.00005> }
		triangle  { <-0.73387, -1.24794, 0.00005>, <-0.68963, -1.64583, 0.29928>, <-0.68963, -1.24794, 0.29928> }
		triangle  { <-0.73387, -1.64583, 0.00005>, <0.65679, -1.64583, -0.28493>, <0.69893, -1.64583, 0.00005> }
		triangle  { <-0.73387, -1.64583, 0.00005>, <0.65679, -1.64583, -0.28493>, <-0.68963, -1.64583, 0.29928> }
		triangle  { <0.69893, -1.64583, 0.00005>, <0.65679, -1.28411, -0.28493>, <0.69893, -1.28411, 0.00005> }
		triangle  { <0.69893, -1.64583, 0.00005>, <0.65679, -1.28411, -0.28493>, <0.65679, -1.64583, -0.28493> }
		triangle  { <0.69893, -1.28411, 0.00005>, <0.98518, 1.60966, -0.42742>, <1.04839, 1.60966, 0.00005> }
		triangle  { <0.69893, -1.28411, 0.00005>, <0.98518, 1.60966, -0.42742>, <0.65679, -1.28411, -0.28493> }
		triangle  { <-1.01802, 1.64583, 0.44177>, <-0.56222, -1.24794, 0.56242>, <-0.68963, -1.24794, 0.29928> }
		triangle  { <-1.01802, 1.64583, 0.44177>, <-0.56222, -1.24794, 0.56242>, <-0.82995, 1.64583, 0.83022> }
		triangle  { <-0.68963, -1.24794, 0.29928>, <-0.56222, -1.64583, 0.56242>, <-0.68963, -1.64583, 0.29928> }
		triangle  { <-0.68963, -1.24794, 0.29928>, <-0.56222, -1.64583, 0.56242>, <-0.56222, -1.24794, 0.56242> }
		triangle  { <-0.68963, -1.64583, 0.29928>, <0.53545, -1.64583, -0.53555>, <0.65679, -1.64583, -0.28493> }
		triangle  { <-0.68963, -1.64583, 0.29928>, <0.53545, -1.64583, -0.53555>, <-0.56222, -1.64583, 0.56242> }
		triangle  { <0.65679, -1.64583, -0.28493>, <0.53545, -1.28411, -0.53555>, <0.65679, -1.28411, -0.28493> }
		triangle  { <0.65679, -1.64583, -0.28493>, <0.53545, -1.28411, -0.53555>, <0.53545, -1.64583, -0.53555> }
		triangle  { <0.65679, -1.28411, -0.28493>, <0.80318, 1.60966, -0.80334>, <0.98518, 1.60966, -0.42742> }
		triangle  { <0.65679, -1.28411, -0.28493>, <0.80318, 1.60966, -0.80334>, <0.53545, -1.28411, -0.53555> }
		triangle  { <-0.82995, 1.64583, 0.83022>, <-0.36703, -1.24794, 0.75776>, <-0.56222, -1.24794, 0.56242> }
		triangle  { <-0.82995, 1.64583, 0.83022>, <-0.36703, -1.24794, 0.75776>, <-0.54180, 1.64583, 1.11857> }
		triangle  { <-0.56222, -1.24794, 0.56242>, <-0.36703, -1.64583, 0.75776>, <-0.56222, -1.64583, 0.56242> }
		triangle  { <-0.56222, -1.24794, 0.56242>, <-0.36703, -1.64583, 0.75776>, <-0.36703, -1.24794, 0.75776> }
		triangle  { <-0.56222, -1.64583, 0.56242>, <0.34955, -1.64583, -0.72158>, <0.53545, -1.64583, -0.53555> }
		triangle  { <-0.56222, -1.64583, 0.56242>, <0.34955, -1.64583, -0.72158>, <-0.36703, -1.64583, 0.75776> }
		triangle  { <0.53545, -1.64583, -0.53555>, <0.34955, -1.28411, -0.72158>, <0.53545, -1.28411, -0.53555> }
		triangle  { <0.53545, -1.64583, -0.53555>, <0.34955, -1.28411, -0.72158>, <0.34955, -1.64583, -0.72158> }
		triangle  { <0.53545, -1.28411, -0.53555>, <0.52432, 1.60966, -1.08239>, <0.80318, 1.60966, -0.80334> }
		triangle  { <0.53545, -1.28411, -0.53555>, <0.52432, 1.60966, -1.08239>, <0.34955, -1.28411, -0.72158> }
		triangle  { <-0.54180, 1.64583, 1.11857>, <-0.12757, -1.24794, 0.86173>, <-0.36703, -1.24794, 0.75776> }
		triangle  { <-0.54180, 1.64583, 1.11857>, <-0.12757, -1.24794, 0.86173>, <-0.18832, 1.64583, 1.27205> }
		triangle  { <-0.36703, -1.24794, 0.75776>, <-0.12757, -1.64583, 0.86173>, <-0.36703, -1.64583, 0.75776> }
		triangle  { <-0.36703, -1.24794, 0.75776>, <-0.12757, -1.64583, 0.86173>, <-0.12757, -1.24794, 0.86173> }
		triangle  { <-0.36703, -1.64583, 0.75776>, <0.12150, -1.64583, -0.82060>, <0.34955, -1.64583, -0.72158> }
		triangle  { <-0.36703, -1.64583, 0.75776>, <0.12150, -1.64583, -0.82060>, <-0.12757, -1.64583, 0.86173> }
		triangle  { <0.34955, -1.64583, -0.72158>, <0.12150, -1.28411, -0.82060>, <0.34955, -1.28411, -0.72158> }
		triangle  { <0.34955, -1.64583, -0.72158>, <0.12150, -1.28411, -0.82060>, <0.12150, -1.64583, -0.82060> }
		triangle  { <0.34955, -1.28411, -0.72158>, <0.18225, 1.60966, -1.23092>, <0.52432, 1.60966, -1.08239> }
		triangle  { <0.34955, -1.28411, -0.72158>, <0.18225, 1.60966, -1.23092>, <0.12150, -1.28411, -0.82060> }
		triangle  { <-0.18832, 1.64583, 1.27205>, <0.12726, -1.24794, 0.86179>, <-0.12757, -1.24794, 0.86173> }
		triangle  { <-0.18832, 1.64583, 1.27205>, <0.12726, -1.24794, 0.86179>, <0.18786, 1.64583, 1.27215> }
		triangle  { <-0.12757, -1.24794, 0.86173>, <0.12726, -1.64583, 0.86179>, <-0.12757, -1.64583, 0.86173> }
		triangle  { <-0.12757, -1.24794, 0.86173>, <0.12726, -1.64583, 0.86179>, <0.12726, -1.24794, 0.86179> }
		triangle  { <-0.12757, -1.64583, 0.86173>, <-0.12120, -1.64583, -0.82066>, <0.12150, -1.64583, -0.82060> }
		triangle  { <-0.12757, -1.64583, 0.86173>, <-0.12120, -1.64583, -0.82066>, <0.12726, -1.64583, 0.86179> }
		triangle  { <0.12150, -1.64583, -0.82060>, <-0.12120, -1.28411, -0.82066>, <0.12150, -1.28411, -0.82060> }
		triangle  { <0.12150, -1.64583, -0.82060>, <-0.12120, -1.28411, -0.82066>, <-0.12120, -1.64583, -0.82066> }
		triangle  { <0.12150, -1.28411, -0.82060>, <-0.18180, 1.60966, -1.23101>, <0.18225, 1.60966, -1.23092> }
		triangle  { <0.12150, -1.28411, -0.82060>, <-0.18180, 1.60966, -1.23101>, <-0.12120, -1.28411, -0.82066> }
		triangle  { <0.18786, 1.64583, 1.27215>, <0.36675, -1.24794, 0.75795>, <0.12726, -1.24794, 0.86179> }
		triangle  { <0.18786, 1.64583, 1.27215>, <0.36675, -1.24794, 0.75795>, <0.54140, 1.64583, 1.11885> }
		triangle  { <0.12726, -1.24794, 0.86179>, <0.36675, -1.64583, 0.75795>, <0.12726, -1.64583, 0.86179> }
		triangle  { <0.12726, -1.24794, 0.86179>, <0.36675, -1.64583, 0.75795>, <0.36675, -1.24794, 0.75795> }
		triangle  { <0.12726, -1.64583, 0.86179>, <-0.34929, -1.64583, -0.72176>, <-0.12120, -1.64583, -0.82066> }
		triangle  { <0.12726, -1.64583, 0.86179>, <-0.34929, -1.64583, -0.72176>, <0.36675, -1.64583, 0.75795> }
		triangle  { <-0.12120, -1.64583, -0.82066>, <-0.34929, -1.28411, -0.72176>, <-0.12120, -1.28411, -0.82066> }
		triangle  { <-0.12120, -1.64583, -0.82066>, <-0.34929, -1.28411, -0.72176>, <-0.34929, -1.64583, -0.72176> }
		triangle  { <-0.12120, -1.28411, -0.82066>, <-0.52393, 1.60966, -1.08266>, <-0.18180, 1.60966, -1.23101> }
		triangle  { <-0.12120, -1.28411, -0.82066>, <-0.52393, 1.60966, -1.08266>, <-0.34929, -1.28411, -0.72176> }
		triangle  { <0.54140, 1.64583, 1.11885>, <0.56202, -1.24794, 0.56271>, <0.36675, -1.24794, 0.75795> }
		triangle  { <0.54140, 1.64583, 1.11885>, <0.56202, -1.24794, 0.56271>, <0.82965, 1.64583, 0.83065> }
		triangle  { <0.36675, -1.24794, 0.75795>, <0.56202, -1.64583, 0.56271>, <0.36675, -1.64583, 0.75795> }
		triangle  { <0.36675, -1.24794, 0.75795>, <0.56202, -1.64583, 0.56271>, <0.56202, -1.24794, 0.56271> }
		triangle  { <0.36675, -1.64583, 0.75795>, <-0.53526, -1.64583, -0.53582>, <-0.34929, -1.64583, -0.72176> }
		triangle  { <0.36675, -1.64583, 0.75795>, <-0.53526, -1.64583, -0.53582>, <0.56202, -1.64583, 0.56271> }
		triangle  { <-0.34929, -1.64583, -0.72176>, <-0.53526, -1.28411, -0.53582>, <-0.34929, -1.28411, -0.72176> }
		triangle  { <-0.34929, -1.64583, -0.72176>, <-0.53526, -1.28411, -0.53582>, <-0.53526, -1.64583, -0.53582> }
		triangle  { <-0.34929, -1.28411, -0.72176>, <-0.80288, 1.60966, -0.80376>, <-0.52393, 1.60966, -1.08266> }
		triangle  { <-0.34929, -1.28411, -0.72176>, <-0.80288, 1.60966, -0.80376>, <-0.53526, -1.28411, -0.53582> }
		triangle  { <0.82965, 1.64583, 0.83065>, <0.68952, -1.24794, 0.29963>, <0.56202, -1.24794, 0.56271> }
		triangle  { <0.82965, 1.64583, 0.83065>, <0.68952, -1.24794, 0.29963>, <1.01786, 1.64583, 0.44229> }
		triangle  { <0.56202, -1.24794, 0.56271>, <0.68952, -1.64583, 0.29963>, <0.56202, -1.64583, 0.56271> }
		triangle  { <0.56202, -1.24794, 0.56271>, <0.68952, -1.64583, 0.29963>, <0.68952, -1.24794, 0.29963> }
		triangle  { <0.56202, -1.64583, 0.56271>, <-0.65668, -1.64583, -0.28527>, <-0.53526, -1.64583, -0.53582> }
		triangle  { <0.56202, -1.64583, 0.56271>, <-0.65668, -1.64583, -0.28527>, <0.68952, -1.64583, 0.29963> }
		triangle  { <-0.53526, -1.64583, -0.53582>, <-0.65668, -1.28411, -0.28527>, <-0.53526, -1.28411, -0.53582> }
		triangle  { <-0.53526, -1.64583, -0.53582>, <-0.65668, -1.28411, -0.28527>, <-0.65668, -1.64583, -0.28527> }
		triangle  { <-0.53526, -1.28411, -0.53582>, <-0.98502, 1.60966, -0.42793>, <-0.80288, 1.60966, -0.80376> }
		triangle  { <-0.53526, -1.28411, -0.53582>, <-0.98502, 1.60966, -0.42793>, <-0.65668, -1.28411, -0.28527> }
		triangle  { <1.01786, 1.64583, 0.44229>, <0.73387, -1.24794, 0.00043>, <0.68952, -1.24794, 0.29963> }
		triangle  { <1.01786, 1.64583, 0.44229>, <0.73387, -1.24794, 0.00043>, <1.08333, 1.64583, 0.00061> }
		triangle  { <0.68952, -1.24794, 0.29963>, <0.73387, -1.64583, 0.00043>, <0.68952, -1.64583, 0.29963> }
		triangle  { <0.68952, -1.24794, 0.29963>, <0.73387, -1.64583, 0.00043>, <0.73387, -1.24794, 0.00043> }
		triangle  { <0.68952, -1.64583, 0.29963>, <-0.69892, -1.64583, -0.00031>, <-0.65668, -1.64583, -0.28527> }
		triangle  { <0.68952, -1.64583, 0.29963>, <-0.69892, -1.64583, -0.00031>, <0.73387, -1.64583, 0.00043> }
		triangle  { <-0.65668, -1.64583, -0.28527>, <-0.69892, -1.28411, -0.00031>, <-0.65668, -1.28411, -0.28527> }
		triangle  { <-0.65668, -1.64583, -0.28527>, <-0.69892, -1.28411, -0.00031>, <-0.69892, -1.64583, -0.00031> }
		triangle  { <-0.65668, -1.28411, -0.28527>, <-1.04839, 1.60966, -0.00049>, <-0.98502, 1.60966, -0.42793> }
		triangle  { <-0.65668, -1.28411, -0.28527>, <-1.04839, 1.60966, -0.00049>, <-0.69892, -1.28411, -0.00031> }
		triangle  { <1.08333, 1.64583, 0.00061>, <0.68973, -1.24794, -0.29882>, <0.73387, -1.24794, 0.00043> }
		triangle  { <1.08333, 1.64583, 0.00061>, <0.68973, -1.24794, -0.29882>, <1.01818, 1.64583, -0.44114> }
		triangle  { <0.73387, -1.24794, 0.00043>, <0.68973, -1.64583, -0.29882>, <0.73387, -1.64583, 0.00043> }
		triangle  { <0.73387, -1.24794, 0.00043>, <0.68973, -1.64583, -0.29882>, <0.68973, -1.24794, -0.29882> }
		triangle  { <0.73387, -1.64583, 0.00043>, <-0.65689, -1.64583, 0.28469>, <-0.69892, -1.64583, -0.00031> }
		triangle  { <0.73387, -1.64583, 0.00043>, <-0.65689, -1.64583, 0.28469>, <0.68973, -1.64583, -0.29882> }
		triangle  { <-0.69892, -1.64583, -0.00031>, <-0.65689, -1.28411, 0.28469>, <-0.69892, -1.28411, -0.00031> }
		triangle  { <-0.69892, -1.64583, -0.00031>, <-0.65689, -1.28411, 0.28469>, <-0.65689, -1.64583, 0.28469> }
		triangle  { <-0.69892, -1.28411, -0.00031>, <-0.98533, 1.60966, 0.42701>, <-1.04839, 1.60966, -0.00049> }
		triangle  { <-0.69892, -1.28411, -0.00031>, <-0.98533, 1.60966, 0.42701>, <-0.65689, -1.28411, 0.28469> }
		triangle  { <1.01818, 1.64583, -0.44114>, <0.56243, -1.24794, -0.56204>, <0.68973, -1.24794, -0.29882> }
		triangle  { <1.01818, 1.64583, -0.44114>, <0.56243, -1.24794, -0.56204>, <0.83025, 1.64583, -0.82970> }
		triangle  { <0.68973, -1.24794, -0.29882>, <0.56243, -1.64583, -0.56204>, <0.68973, -1.64583, -0.29882> }
		triangle  { <0.68973, -1.24794, -0.29882>, <0.56243, -1.64583, -0.56204>, <0.56243, -1.24794, -0.56204> }
		triangle  { <0.68973, -1.64583, -0.29882>, <-0.53565, -1.64583, 0.53537>, <-0.65689, -1.64583, 0.28469> }
		triangle  { <0.68973, -1.64583, -0.29882>, <-0.53565, -1.64583, 0.53537>, <0.56243, -1.64583, -0.56204> }
		triangle  { <-0.65689, -1.64583, 0.28469>, <-0.53565, -1.28411, 0.53537>, <-0.65689, -1.28411, 0.28469> }
		triangle  { <-0.65689, -1.64583, 0.28469>, <-0.53565, -1.28411, 0.53537>, <-0.53565, -1.64583, 0.53537> }
		triangle  { <-0.65689, -1.28411, 0.28469>, <-0.80347, 1.60966, 0.80303>, <-0.98533, 1.60966, 0.42701> }
		triangle  { <-0.65689, -1.28411, 0.28469>, <-0.80347, 1.60966, 0.80303>, <-0.53565, -1.28411, 0.53537> }
		triangle  { <0.83025, 1.64583, -0.82970>, <0.36730, -1.24794, -0.75747>, <0.56243, -1.24794, -0.56204> }
		triangle  { <0.83025, 1.64583, -0.82970>, <0.36730, -1.24794, -0.75747>, <0.54221, 1.64583, -1.11820> }
		triangle  { <0.56243, -1.24794, -0.56204>, <0.36730, -1.64583, -0.75747>, <0.56243, -1.64583, -0.56204> }
		triangle  { <0.56243, -1.24794, -0.56204>, <0.36730, -1.64583, -0.75747>, <0.36730, -1.24794, -0.75747> }
		triangle  { <0.56243, -1.64583, -0.56204>, <-0.34981, -1.64583, 0.72150>, <-0.53565, -1.64583, 0.53537> }
		triangle  { <0.56243, -1.64583, -0.56204>, <-0.34981, -1.64583, 0.72150>, <0.36730, -1.64583, -0.75747> }
		triangle  { <-0.53565, -1.64583, 0.53537>, <-0.34981, -1.28411, 0.72150>, <-0.53565, -1.28411, 0.53537> }
		triangle  { <-0.53565, -1.64583, 0.53537>, <-0.34981, -1.28411, 0.72150>, <-0.34981, -1.64583, 0.72150> }
		triangle  { <-0.53565, -1.28411, 0.53537>, <-0.52472, 1.60966, 1.08222>, <-0.80347, 1.60966, 0.80303> }
		triangle  { <-0.53565, -1.28411, 0.53537>, <-0.52472, 1.60966, 1.08222>, <-0.34981, -1.28411, 0.72150> }
		triangle  { <0.54221, 1.64583, -1.11820>, <0.12789, -1.24794, -0.86156>, <0.36730, -1.24794, -0.75747> }
		triangle  { <0.54221, 1.64583, -1.11820>, <0.12789, -1.24794, -0.86156>, <0.18879, 1.64583, -1.27185> }
		triangle  { <0.36730, -1.24794, -0.75747>, <0.12789, -1.64583, -0.86156>, <0.36730, -1.64583, -0.75747> }
		triangle  { <0.36730, -1.24794, -0.75747>, <0.12789, -1.64583, -0.86156>, <0.12789, -1.24794, -0.86156> }
		triangle  { <0.36730, -1.64583, -0.75747>, <-0.12180, -1.64583, 0.82063>, <-0.34981, -1.64583, 0.72150> }
		triangle  { <0.36730, -1.64583, -0.75747>, <-0.12180, -1.64583, 0.82063>, <0.12789, -1.64583, -0.86156> }
		triangle  { <-0.34981, -1.64583, 0.72150>, <-0.12180, -1.28411, 0.82063>, <-0.34981, -1.28411, 0.72150> }
		triangle  { <-0.34981, -1.64583, 0.72150>, <-0.12180, -1.28411, 0.82063>, <-0.12180, -1.64583, 0.82063> }
		triangle  { <-0.34981, -1.28411, 0.72150>, <-0.18270, 1.60966, 1.23092>, <-0.52472, 1.60966, 1.08222> }
		triangle  { <-0.34981, -1.28411, 0.72150>, <-0.18270, 1.60966, 1.23092>, <-0.12180, -1.28411, 0.82063> }
		triangle  { <0.18879, 1.64583, -1.27185>, <-0.12695, -1.24794, -0.86176>, <0.12789, -1.24794, -0.86156> }
		triangle  { <0.18879, 1.64583, -1.27185>, <-0.12695, -1.24794, -0.86176>, <-0.18740, 1.64583, -1.27215> }
		triangle  { <0.12789, -1.24794, -0.86156>, <-0.12695, -1.64583, -0.86176>, <0.12789, -1.64583, -0.86156> }
		triangle  { <0.12789, -1.24794, -0.86156>, <-0.12695, -1.64583, -0.86176>, <-0.12695, -1.24794, -0.86176> }
		triangle  { <0.12789, -1.64583, -0.86156>, <0.12090, -1.64583, 0.82082>, <-0.12180, -1.64583, 0.82063> }
		triangle  { <0.12789, -1.64583, -0.86156>, <0.12090, -1.64583, 0.82082>, <-0.12695, -1.64583, -0.86176> }
		triangle  { <-0.12180, -1.64583, 0.82063>, <0.12090, -1.28411, 0.82082>, <-0.12180, -1.28411, 0.82063> }
		triangle  { <-0.12180, -1.64583, 0.82063>, <0.12090, -1.28411, 0.82082>, <0.12090, -1.64583, 0.82082> }
		triangle  { <-0.12180, -1.28411, 0.82063>, <0.18136, 1.60966, 1.23120>, <-0.18270, 1.60966, 1.23092> }
		triangle  { <-0.12180, -1.28411, 0.82063>, <0.18136, 1.60966, 1.23120>, <0.12090, -1.28411, 0.82082> }
		triangle  { <-0.18740, 1.64583, -1.27215>, <-0.36648, -1.24794, -0.75804>, <-0.12695, -1.24794, -0.86176> }
		triangle  { <-0.18740, 1.64583, -1.27215>, <-0.36648, -1.24794, -0.75804>, <-0.54099, 1.64583, -1.11903> }
		triangle  { <-0.12695, -1.24794, -0.86176>, <-0.36648, -1.64583, -0.75804>, <-0.12695, -1.64583, -0.86176> }
		triangle  { <-0.12695, -1.24794, -0.86176>, <-0.36648, -1.64583, -0.75804>, <-0.36648, -1.24794, -0.75804> }
		triangle  { <-0.12695, -1.64583, -0.86176>, <0.34903, -1.64583, 0.72204>, <0.12090, -1.64583, 0.82082> }
		triangle  { <-0.12695, -1.64583, -0.86176>, <0.34903, -1.64583, 0.72204>, <-0.36648, -1.64583, -0.75804> }
		triangle  { <0.12090, -1.64583, 0.82082>, <0.34903, -1.28411, 0.72204>, <0.12090, -1.28411, 0.82082> }
		triangle  { <0.12090, -1.64583, 0.82082>, <0.34903, -1.28411, 0.72204>, <0.34903, -1.64583, 0.72204> }
		triangle  { <0.12090, -1.28411, 0.82082>, <0.52354, 1.60966, 1.08303>, <0.18136, 1.60966, 1.23120> }
		triangle  { <0.12090, -1.28411, 0.82082>, <0.52354, 1.60966, 1.08303>, <0.34903, -1.28411, 0.72204> }
		triangle  { <-0.54099, 1.64583, -1.11903>, <-0.56181, -1.24794, -0.56291>, <-0.36648, -1.24794, -0.75804> }
		triangle  { <-0.54099, 1.64583, -1.11903>, <-0.56181, -1.24794, -0.56291>, <-0.82935, 1.64583, -0.83098> }
		triangle  { <-0.36648, -1.24794, -0.75804>, <-0.56181, -1.64583, -0.56291>, <-0.36648, -1.64583, -0.75804> }
		triangle  { <-0.36648, -1.24794, -0.75804>, <-0.56181, -1.64583, -0.56291>, <-0.56181, -1.24794, -0.56291> }
		triangle  { <-0.36648, -1.64583, -0.75804>, <0.53506, -1.64583, 0.53620>, <0.34903, -1.64583, 0.72204> }
		triangle  { <-0.36648, -1.64583, -0.75804>, <0.53506, -1.64583, 0.53620>, <-0.56181, -1.64583, -0.56291> }
		triangle  { <0.34903, -1.64583, 0.72204>, <0.53506, -1.28411, 0.53620>, <0.34903, -1.28411, 0.72204> }
		triangle  { <0.34903, -1.64583, 0.72204>, <0.53506, -1.28411, 0.53620>, <0.53506, -1.64583, 0.53620> }
		triangle  { <0.34903, -1.28411, 0.72204>, <0.80259, 1.60966, 0.80427>, <0.52354, 1.60966, 1.08303> }
		triangle  { <0.34903, -1.28411, 0.72204>, <0.80259, 1.60966, 0.80427>, <0.53506, -1.28411, 0.53620> }
		triangle  { <-0.82935, 1.64583, -0.83098>, <-0.68941, -1.24794, -0.29989>, <-0.56181, -1.24794, -0.56291> }
		triangle  { <-0.82935, 1.64583, -0.83098>, <-0.68941, -1.24794, -0.29989>, <-1.01770, 1.64583, -0.44272> }
		triangle  { <-0.56181, -1.24794, -0.56291>, <-0.68941, -1.64583, -0.29989>, <-0.56181, -1.64583, -0.56291> }
		triangle  { <-0.56181, -1.24794, -0.56291>, <-0.68941, -1.64583, -0.29989>, <-0.68941, -1.24794, -0.29989> }
		triangle  { <-0.56181, -1.64583, -0.56291>, <0.65658, -1.64583, 0.28570>, <0.53506, -1.64583, 0.53620> }
		triangle  { <-0.56181, -1.64583, -0.56291>, <0.65658, -1.64583, 0.28570>, <-0.68941, -1.64583, -0.29989> }
		triangle  { <0.53506, -1.64583, 0.53620>, <0.65658, -1.28411, 0.28570>, <0.53506, -1.28411, 0.53620> }
		triangle  { <0.53506, -1.64583, 0.53620>, <0.65658, -1.28411, 0.28570>, <0.65658, -1.64583, 0.28570> }
		triangle  { <0.53506, -1.28411, 0.53620>, <0.98487, 1.60966, 0.42853>, <0.80259, 1.60966, 0.80427> }
		triangle  { <0.53506, -1.28411, 0.53620>, <0.98487, 1.60966, 0.42853>, <0.65658, -1.28411, 0.28570> }
		triangle  { <-1.01770, 1.64583, -0.44272>, <-0.73387, -1.24794, -0.00071>, <-0.68941, -1.24794, -0.29989> }
		triangle  { <-1.01770, 1.64583, -0.44272>, <-0.73387, -1.24794, -0.00071>, <-1.08333, 1.64583, -0.00107> }
		triangle  { <-0.68941, -1.24794, -0.29989>, <-0.73387, -1.64583, -0.00071>, <-0.68941, -1.64583, -0.29989> }
		triangle  { <-0.68941, -1.24794, -0.29989>, <-0.73387, -1.64583, -0.00071>, <-0.73387, -1.24794, -0.00071> }
		triangle  { <-0.68941, -1.64583, -0.29989>, <0.69892, -1.64583, 0.00077>, <0.65658, -1.64583, 0.28570> }
		triangle  { <-0.68941, -1.64583, -0.29989>, <0.69892, -1.64583, 0.00077>, <-0.73387, -1.64583, -0.00071> }
		triangle  { <0.65658, -1.64583, 0.28570>, <0.69892, -1.28411, 0.00077>, <0.65658, -1.28411, 0.28570> }
		triangle  { <0.65658, -1.64583, 0.28570>, <0.69892, -1.28411, 0.00077>, <0.69892, -1.64583, 0.00077> }
		triangle  { <0.65658, -1.28411, 0.28570>, <1.04839, 1.60966, 0.00113>, <0.98487, 1.60966, 0.42853> }
		triangle  { <0.65658, -1.28411, 0.28570>, <1.04839, 1.60966, 0.00113>, <0.69892, -1.28411, 0.00077> }

		translate < 12.75000, -2.64583, -3.93881>
		texture
		{
		Glass
		scale < 1.08333, 1.64583, 1.27215>
		translate < 12.75000, -2.64583, -3.93881> 
		}  /* End texture */
		pigment { quick_colour red 1.000000 green 1.000000 blue 1.000000 filter 0.000000}
	bounded_by { box { <11.66667, -4.29167, -5.21096>, <13.83333, -1.00000, -2.66667>}}
	}  /* End Shape or Object */
   } /*End object*/

	/*Start Definition of   Cube40*/

   object
   {
	box
		{<-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0> 
		scale < 3.33333, 0.16667, 3.50000>
		rotate < 0, 341, 0>
		translate < 1.12637, -9.66667, -10.72952> 
		texture
		{
		DMFWood4
		scale < 3.33333, 0.16667, 3.50000>
		rotate < 0, 341, 0>
		translate < 1.12637, -9.66667, -10.72952> 
		}  /* End texture */
		pigment { quick_colour red 1.000000 green 1.000000 blue 1.000000 filter 0.000000}
	 bounded_by { box { <-3.26667, -9.93333, -15.22572>, <13.93333, -0.90000, -2.56667>}}
	}  /* End Shape or Object */
   } /*End object*/

	/*Start Definition of   Cube41*/

   object
   {
	box
		{<-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0> 
		scale < 3.33333, 4.66667, 0.50000>
		rotate < 0, 341, 0>
		translate < 2.00000, -5.16667, -13.66667> 
		texture
		{
		DMFWood4
		scale < 3.33333, 4.66667, 0.50000>
		rotate < 0, 341, 0>
		translate < 2.00000, -5.16667, -13.66667> 
		}  /* End texture */
		pigment { quick_colour red 1.000000 green 1.000000 blue 1.000000 filter 0.000000}
	 bounded_by { box { <-1.41401, -9.93333, -15.32710>, <5.41401, -0.40000, -12.00623>}}
	}  /* End Shape or Object */
   } /*End object*/

	/*Start Definition of   CylY42*/

   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.66667, 3.66665, 0.83334>
		translate < -2.16667, -13.66667, -9.00000> 
		texture
		{
		DMFWood4
		scale < 0.66667, 3.66665, 0.83334>
		translate < -2.16667, -13.66667, -9.00000> 
		}  /* End texture */
		pigment { quick_colour red 1.000000 green 1.000000 blue 1.000000 filter 0.000000}
	 bounded_by { box { <-2.93333, -17.43333, -9.93333>, <-1.40000, -9.90000, -8.06667>}}
	}  /* End Shape or Object */
   } /*End object*/

	/*Start Definition of   CylY43*/

   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.66667, 3.66665, 0.83334>
		translate < 2.50000, -13.66667, -7.66667> 
		texture
		{
		DMFWood4
		scale < 0.66667, 3.66665, 0.83334>
		translate < 2.50000, -13.66667, -7.66667> 
		}  /* End texture */
		pigment { quick_colour red 1.000000 green 1.000000 blue 1.000000 filter 0.000000}
	 bounded_by { box { <1.73333, -17.43333, -8.60000>, <3.26667, -9.90000, -6.73333>}}
	}  /* End Shape or Object */
   } /*End object*/

	/*Start Definition of   CylY44*/

   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.66667, 3.66665, 0.83334>
		translate < -0.66667, -13.33333, -13.83333> 
		texture
		{
		DMFWood4
		scale < 0.66667, 3.66665, 0.83334>
		translate < -0.66667, -13.33333, -13.83333> 
		}  /* End texture */
		pigment { quick_colour red 1.000000 green 1.000000 blue 1.000000 filter 0.000000}
	 bounded_by { box { <-1.43333, -17.10000, -14.76667>, <0.10000, -9.56667, -12.90000>}}
	}  /* End Shape or Object */
   } /*End object*/

	/*Start Definition of   CylY45*/

   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.66667, 3.66665, 0.83334>
		translate < 4.16667, -13.33333, -12.16667> 
		texture
		{
		DMFWood4
		scale < 0.66667, 3.66665, 0.83334>
		translate < 4.16667, -13.33333, -12.16667> 
		}  /* End texture */
		pigment { quick_colour red 1.000000 green 1.000000 blue 1.000000 filter 0.000000}
	 bounded_by { box { <3.40000, -17.10000, -13.10000>, <4.93333, -9.56667, -11.23333>}}
	}  /* End Shape or Object */
   } /*End object*/


	/*Start Definition of   CylY35*/


   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.31625, 2.74374, 0.75312>
		rotate < 0, 0, 313>
		translate < 5.47356, 0.89883, 21.24688> 
		pigment
		{
		colour rgbf <1.000000, 0.000000, 0.000000, 0.000000>
		}  /* End Colour */
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   CylY36*/

   object
   {
	sphere
		{ <0.0, 0.0, 0.0> , 1.0
		scale < 15.99715, 13.14285, 5.71143>
		translate < 0.28286, 0.00000, 13.71714> 
		texture
		{
                Earth1
		scale < 15.99715, 13.14285, 5.71143>
		translate < 0.28286, 0.00000, 13.71714> 
		}  /* End texture */
                finish { ambient .4 diffuse .3 phong 0 }
		pigment { quick_colour red 1.000000 green 1.000000 blue 1.000000 filter 0.000000}
	 bounded_by { box { <-15.81429, -13.24285, 7.90572>, <16.38000, 13.24285, 19.52857>}}
	}  /* End Shape or Object */
   } /*End object*/

   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.31625, 2.74374, 0.75312>
		rotate < 0, 0, 313>
		translate < 25.22356, 17.14883, 21.05849> 
		pigment
		{
		colour rgbf <1.000000, 0.000000, 0.000000, 0.000000>
		}  /* End Colour */
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   CylY37*/

   object
   {
	cylinder
		{ <0.0, 1.0, 0.0>,<0.0, -1.0, 0.0>,1 
		scale < 0.31625, 2.74374, 0.75312>
		rotate < 0, 0, 313>
		translate < 19.47356, 12.64883, 21.24688> 
		pigment
		{
		colour rgbf <1.000000, 0.000000, 0.000000, 0.000000>
		}  /* End Colour */
		}  /* End Shape */
   } /*End object*/

	/*Start Definition of   CylY24*/

 /*End union*/
/* Frame Area */


/*+++++++++++++++++ Start Master ++++++++++++++++++++++++++*/

object { 
	Master
	} /* End Master Groupe */