#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "textures.inc"
#include "chars.inc"

camera { 
        location        <0.00101,1.08,0>
        direction       <0,0,1.2>
        up              <0,1,0>
        right           <1.3333,0,0 >
        sky             <0,1,0>
        look_at         <0,0,10>
}

object{
  light_source { <0,2000,-2000> color White}
}

object{
  light_source {<1000,-1000,1000> color White}
}

object{
  light_source { <1000,-2000,-2000> color Gray60}
}

object{
  light_source{ <1000, 2000, -2000> color Gray70}
}

#include "torpatch.inc"

object{Torus_Patch}

object{
  difference{
    cylinder{
      <0,1,-10>,
      <0.001,1.001,3.5>,
      0.05
    }     
    cylinder{
      <0,1,-10>,
      <0.001,1.001,3.5>,
      0.045
    }     
    box{
      <-0.5, 1.01, 0>,
      <0.5, 1.2, 1>
    }
  }
  texture{Torus_Patch_Texture}
}




#declare Tarmac =
  finish{
    ambient 0.1
    diffuse 0.9
    specular 0.1
    roughness 0.5
    crand 0.05
  }

#declare Paint =
  finish{
    ambient 0.05
    diffuse 0.9
    specular 0.8
    roughness 0.08
  }

#declare Road=
object{  //highway
  union{
    box{
      <-0.02, 0.99, -10>,
      <0.02, 1, 3.5>
      texture{
        pigment{Gray10}
        finish{Tarmac}
      }
    }
    box{        //pavement
      <-0.023, 0.99, -10>,
      <-0.02, 1.002, 3.5>
      texture{
        pigment{Gray30}
        finish{Tarmac}
      }
    }
    box{        //pavement
      <0.02, 0.99, -10>,
      <0.023, 1.002, 3.5>
      texture{
        pigment{Gray30}
        finish{Tarmac}
      }
    }
    box{        //centre line
      <-0.0005, 1, -10>,
      <-0.0001,1.00001, 3.5>
      texture{
        pigment{Yellow}
        finish{Paint}
      }
    }
    box{        //centre line
      <0.0001, 1, -10>,
      <0.0005,1.00001, 3.5>
      texture{
        pigment{Yellow}
        finish{Paint}
      }
    }
    box{        //dashed line (right)
      <0.0098, 1, -10>,
      <0.0102,1.00001, 3.5>
      texture{
        pigment{
          gradient z
          color_map {
            [0.00, 0.25  color White
                         color White]
            [0.25, 0.75  color Gray10
                         color Gray10]
            [0.75, 1.001 color White
                         color White]
          }
        }
        finish{Tarmac}
        scale <1 1 0.005>
      }
    }
    box{        //dashed line (left)
      <-0.0102, 1, -10>,
      <-0.0098,1.00001, 3.5>
      texture{
        pigment{
          gradient z
          color_map {
            [0.00, 0.25  color White
                         color White]
            [0.25, 0.75  color Gray10
                         color Gray10]
            [0.75, 1.001 color White
                         color White]
          }
        }
        finish{Tarmac}
        scale <1 1 0.005>
      }
    }
  }
  bounded_by{
    box{
      <-0.026, 0.99, -10>,
      <0.026, 1.01, 3.5>
    }
  }
}


#include "truck.inc"

#declare Truck1=
object{
  union{
    object{
      ZeroTruck
      scale<0.005, 0.005, 0.005>
      translate<0.0050, 1, 0.2>
    }
    object{
      OneTruck
      scale<0.005, 0.005, 0.005>
      translate<0.0050, 1, 0.32>
    }
    object{
      OneTruck
      scale<0.005, 0.005, 0.005>
      translate<0.0050, 1, 0.39>
    }
    object{
      ZeroTruck
      scale<0.005, 0.005, 0.005>
      translate<0.0050, 1, 0.52>
    }
    object{
      ZeroTruck
      scale<0.005, 0.005, 0.005>
      translate<0.0050, 1, 0.68>
    }
    object{
      OneTruck
      scale<0.005, 0.005, 0.005>
      translate<0.0050, 1, 0.95>
    }
    bounded_by{
      box{
        <0.0024, 1, 0>,
        <0.0076, 1.007, 1.1>
      }
    }
  }
}

#declare Truck2=
object{
  union{
    object{
      ZeroTruck
      scale<0.005, 0.005, 0.005>
      translate<0.0150, 1, 0.24>
    }
    object{
      ZeroTruck
      scale<0.005, 0.005, 0.005>
      translate<0.0150, 1, 0.34>
    }
    object{
      OneTruck
      scale<0.005, 0.005, 0.005>
      translate<0.0150, 1, 0.45>
    }
    object{
      ZeroTruck
      scale<0.005, 0.005, 0.005>
      translate<0.0150, 1, 0.54>
    }
    object{
      ZeroTruck
      scale<0.005, 0.005, 0.005>
      translate<0.0150, 1, 0.80>
    }
    object{
      OneTruck
      scale<0.005, 0.005, 0.005>
      translate<0.0150, 1, 0.90>
    }
    bounded_by{
      box{
        <0.0124, 1, 0>,
        <0.0176, 1.007, 1.1>
      }
    }
  }
}

#declare Truck3=
object{
  union{
    object{
      OneTruck
      rotate y*180
      scale<0.005, 0.005, 0.005>
      translate<-0.0150, 1, 0.17>
    }
    object{
      ZeroTruck
      rotate y*180
      scale<0.005, 0.005, 0.005>
      translate<-0.0150, 1, 0.25>
    }
    object{
      ZeroTruck
      rotate y*180
      scale<0.005, 0.005, 0.005>
      translate<-0.0150, 1, 0.45>
    }
    object{
      OneTruck
      rotate y*180
      scale<0.005, 0.005, 0.005>
      translate<-0.0150, 1, 0.56>
    }
    object{
      OneTruck
      rotate y*180
      scale<0.005, 0.005, 0.005>
      translate<-0.0150, 1, 0.70>
    }
    bounded_by{
      box{
        <-0.0176, 1, 0>,
        <-0.0124, 1.007, 1.1>
      }
    }
  }
}

#declare Truck4=
object{
  union{
    object{
      OneTruck
      rotate y*180
      scale<0.005, 0.005, 0.005>
      translate<-0.0050, 1, 0.27>
    }
    object{
      ZeroTruck
      rotate y*180
      scale<0.005, 0.005, 0.005>
      translate<-0.0050, 1, 0.35>
    }
    object{
      OneTruck
      rotate y*180
      scale<0.005, 0.005, 0.005>
      translate<-0.0050, 1, 0.48>
    }
    object{
      ZeroTruck
      rotate y*180
      scale<0.005, 0.005, 0.005>
      translate<-0.0050, 1, 0.62>
    }
    object{
      OneTruck
      rotate y*180
      scale<0.005, 0.005, 0.005>
      translate<-0.0050, 1, 0.68>
    }
    object{
      ZeroTruck
      rotate y*180
      scale<0.005, 0.005, 0.005>
      translate<-0.0050, 1, 0.98>
    }
    bounded_by{
      box{
        <-0.0076, 1, 0>,
        <-0.0024, 1.007, 1.1>
      }
    }
  }
}

#include "LampPost.inc"

#declare LampPost2=
object{
  LampPost
  scale<0.004, 0.004, 0.004>
  translate<-0.0215, 1, 0.0>
  }

#declare LampPost3=
object{
  LampPost2
  rotate y*180
}

#declare LampPostQuartet1=
union{
  object{
    LampPost2
  }
  object{
    LampPost2
    translate <0, 0, 0.075>
  }
  object{
    LampPost2
    translate <0, 0, 0.15>
  }
  object{
    LampPost2
    translate <0, 0, 0.225>
  }
  bounded_by{
    box{
      <-0.025, 1, -0.05>
      <-0.015, 1.015, 0.25>
    }
  }
}

#declare LampPostQuartet2=
union{
  object{
    LampPost3
  }
  object{
    LampPost3
    translate <0, 0, 0.075>
  }
  object{
    LampPost3
    translate <0, 0, 0.15>
  }
  object{
    LampPost3
    translate <0, 0, 0.225>
  }
  bounded_by{
    box{
      <0.015, 1, -0.05>
      <0.025, 1.015, 0.25>
    }
  }
}

#declare LeftLampPosts=
object{
  union{
    object{LampPostQuartet1 translate z*0}
    object{LampPostQuartet1 translate z*0.3}
    object{LampPostQuartet1 translate z*0.6}
    object{LampPostQuartet1 translate z*0.9}
    object{LampPostQuartet1 translate z*1.2}
    object{LampPostQuartet1 translate z*1.5}
    object{LampPostQuartet1 translate z*1.8}
    bounded_by{
      box{
        <-0.025, 1, -0.05>
        <-0.015, 1.015, 2.2>
      }
    }
  }
}

#declare RightLampPosts=
object{
  union{
    object{LampPostQuartet2 translate z*0}
    object{LampPostQuartet2 translate z*0.3}
    object{LampPostQuartet2 translate z*0.6}
    object{LampPostQuartet2 translate z*0.9}
    object{LampPostQuartet2 translate z*1.2}
    object{LampPostQuartet2 translate z*1.5}
    object{LampPostQuartet2 translate z*1.8}  
    bounded_by{
      box{
        <0.015, 1, -0.05>
        <0.025, 1.015, 2.2>
      }
    }
  }
}


object{
  union{
    object{Road}
    object{Truck1}
    object{Truck2}
    object{Truck3}
    object{Truck4}
    object{LeftLampPosts}
    object{RightLampPosts}
  }
  bounded_by{
    box{
      <-0.026, 0.99, -10>,
      <0.026, 1.015, 3.5>
    }
  }
}


object{
  union{
    intersection{
      sphere{ <0.5, 0.5, 0.5>, 0.7}
      box{
        <0, 0, -1>
        <1, 1, 0.2>
        texture{pigment{Clear}}
      }
    }
    sphere{ <0.5, 0.5, 0.5>, 0.6999
      pigment{Blue}
    }
    cone{
      <0.5, -0.199, 0.5>,  Minor_Radius,
      <0.5, -0.35, 0.5>, Minor_Radius*3
      pigment{Blue}
    }
    object{
      torus{    17.298095, Minor_Radius}
      rotate x*90
      bounded_by{
        box{
          <-17.315-Minor_Radius, -17.315-Minor_Radius, -Minor_Radius*1.001>
          <17.315+Minor_Radius, 17.315+Minor_Radius, Minor_Radius*1.001>
        }
      }
      translate<   -16.622262,    0.499269,   -0.207945>
      rotate y*(  -62.101961)
      rotate x*(    0.001019)
      texture{Torus_Patch_Texture}
      clipped_by{
          plane{ <    0.000010,   0.500000,    0.000010> 0
            translate <    0.500000,    0.500000,    0.500000>}
      }
    }
  }
  texture{
    pigment{
      image_map{
         gif "billg2.gif"
         interpolate 2
         filter 255,1
      }
    }
    finish{
      ambient 0.2
      diffuse 0.8
      specular 0
    }
  }  
  translate <-0.5, -0.5, -0.5>
  rotate y*15
  translate <5, 3.3, 15.5>
}


fog{
  colour Gray05
  distance 15
}
   

