#declare SolderingIron=
union   {
        cylinder {
                <0,0,0>,<7,0,0>,.75
                texture { Silver_Metal }
        }
        cylinder {
                <7,0,0>,<9,0,0>,.625
                texture { Silver_Metal }
        }
        sphere  {
                <9,0,0>,.625
                texture { Silver_Metal }
        }
        cylinder {
                <9.625,0,0>,<10.625,0,0>,.25
                texture { Silver_Metal }
        }
        cone    {
                <10.625,0,0>,.25,<11.5,0,0>,.05
                texture { Silver_Metal }
        }
        cone    {
                <0,0,0>,1.75,<-.75,0,0>,2
                texture {
                        Shiny
                        pigment { color Gray20 }
                }
        }
        cone    {
                <-.75,0,0>,2,<-2.75,0,0>,2.375
                texture {
                        Shiny
                        pigment { color Red }
                }
        }
        cone    {
                <-2.75,0,0>,2.375,<-3.25,0,0>,2.5
                texture {
                        Dull
                        pigment { color Gray20 }       
                }
        }
        cone    {
                <-3.25,0,0>,2.5,<-3.75,0,0>,1.875
                texture {
                        Dull
                        pigment { color Gray20 }
                }
        }
        cylinder {
                <-3.75,0,0>,<-9.75,0,0>,1.875
                texture {
                        Dull
                        pigment { color Gray20 }
                }
        }
        cone    {
                <-9.75,0,0>,1.875,<-10.25,0,0>,1.25
                texture {
                        Shiny
                        pigment { color Red }
                }
        }
        cone    {
                <-10.25,0,0>,1.25,<-21.25,0,0>,1
                texture {
                        Shiny
                        pigment { color Red }
                }
        }
        bounded_by {
                box { <-21.5,-2.75,-2.75>,<12,2.75,2.75> }
        }
}

#declare Rings =
union   {
        box     {
                <-15,-.25,-.75>,<0,0,.75>
                texture { Polished_Chrome }
        }
        torus   {
                2.5,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-14,2.5,0>
        }
        torus   {
                2.5,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-13,2.5,0>
        }
        torus   {
                2.5,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-12,2.5,0>
        }
        torus   {
                2.5,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-11,2.5,0>
        }
        torus   {
                2.5,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-10,2.5,0>
        }
        torus   {
                2.5,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-9,2.5,0>
        }
        torus   {
                2.5,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-8,2.5,0>
        }
        torus   {
                2.5,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-7,2.5,0>
        }
        torus   {
                2.5,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-6,2.5,0>
        }
        torus   {
                2.5,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-5,2.5,0>
        }
        torus   {
                2.5,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-4,2.5,0>
        }
        torus   {
                2.5,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-3,2.5,0>
        }
        torus   {
                2.5,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-2,2.5,0>
        }
        torus   {
                1,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-14.5,1.5,0>
        }
        torus   {
                1,.125
                texture { Polished_Chrome }
                rotate 90*x
                rotate 90*y
                translate <-9.5,1.5,0>
        }
        cylinder {
                <-14.5,0,0>,<-14.5,.5,0>,.5
                texture { Polished_Chrome }
        }
        cylinder {
                <-9.5,0,0>,<-9.5,.5,0>,.5
                texture { Polished_Chrome }
        }
        bounded_by {
                box { <-15,-.5,-1.5>,<.5,5,1.5> }
        }
}

#declare Base =
union   {
        box     {
                <-10,-4,-6>,<10,0,6>
                texture {
                        Shiny
                        pigment { color Gray10 }
                }
        }
        cone    {
                <-6.75,-4,-2.75>,1.25,<-6.75,-5,-2.75>,.875
                texture {
                        Dull
                        pigment { color Gray10 }
                }
        }
        cone    {
                <-6.75,-4,2.75>,1.25,<-6.75,-5,2.75>,.875
                texture {
                        Dull
                        pigment { color Gray10 }
                }
        }
        cone    {
                <6.75,-4,-2.75>,1.25,<6.75,-5,-2.75>,.875
                texture {
                        Dull
                        pigment { color Gray10 }
                }
        }
        cone    {
                <6.75,-4,2.75>,1.25,<6.75,-5,2.75>,.875
                texture {
                        Dull
                        pigment { color Gray10 }
                }
        }
        box     {
                <-1,0,-4>,<9,.1,4>
                texture {
                        Dull
                        pigment { color Orange }
                        normal  { bumps .4 }
                        scale .1
                }
        }
        box     {
                <-8,0,-.75>,<-7.75,3,.75>
                texture { Polished_Chrome }
        }
        bounded_by {
                box { <-11,-5.5,-6.5>,<11,3.5,6.5> }
        }
}

#declare Holder =
union   {
        object { Base }
        object  {
                Rings
                rotate <0,180,0>
                rotate <0,0,30>
                translate <-8,3,0>
        }
}

#declare Holder_Iron =
union   {
        object { Holder }
        object  {
                SolderingIron
                rotate <0,180,0>
                translate <0,1.5,0>
                rotate <0,0,30>
                translate <5,10.5,0>
        }
        translate <0,5,0>
}

#declare Resistor =
union   {
        blob {
                threshold .5
                component 2,.4,<-.5,0,0>
                component 2,.4,<.5,0,0>
                component 3,.25,<-.1,0,0>
                component 3,.25,<.1,0,0>
                component 4,.25,<0,0,0>
                component 2,.3,<-.25,0,0>
                component 2,.3,<.25,0,0>
        }
        cylinder { 
                <-1,-.25,0>,<-1,-2,0>,.05
                texture { Silver_Metal }
        }
        cylinder { 
                <1,-.25,0>,<1,-2,0>,.05
                texture { Silver_Metal }
        }
        torus   { 
                .25,.05 
                clipped_by { 
                        box { <-1.1,-1.1,1.1>,<0,1.1,0> } 
                }
                rotate -90*x
                translate <-.75,-.25,0>
                texture { Silver_Metal }
        }
        torus   {
                .25,.05
                clipped_by { 
                        box { <0,-1.1,0>,<1.1,1.1,1.1> } 
                }
                rotate -90*x
                translate <.75,-.25,0>
                texture { Silver_Metal }
        }
        bounded_by { 
                sphere { <0,-1,0>,1.5 } 
        }
}

#declare Diode =
union {
        cylinder { <-.5,0,0>,<.5,0,0>,.25 }
        cylinder { 
                <-.75,-.25,0>,<-.75,-2,0>,.05
                texture { Silver_Metal }
        }
        cylinder { 
                <.75,-.25,0>,<.75,-2,0>,.05 
                texture { Silver_Metal }
        }
        torus   {        
                .25,.05 
                clipped_by { 
                        box { <-1.1,-1.1,1.1>,<0,1.1,0> } 
                }
                rotate -90*x
                translate <-.5,-.25,0>
                texture { Silver_Metal }
        }
        torus   {
                .25,.05
                clipped_by { 
                        box { <0,-1.1,0>,<1.1,1.1,1.1> } 
                }
                rotate -90*x
                translate <.5,-.25,0>
                texture { Silver_Metal }
        }
        bounded_by { 
                sphere { <0,-1,0>,1.5 } 
        }
}

#declare Transistor =
union {
        difference {
                cylinder { <0,0,0>,<0,1.25,0>,.5 }
                plane   { z,-.2 }
                pigment { color Black }
        }
        cylinder { <0,0,0>,<0,-2,0>,.05 }
        cylinder { <-.3,0,0>,<-.4,-2,0>,.05 }
        cylinder { <.3,0,0>,<.4,-2,0>,.05 }
        texture { Silver_Metal }
        bounded_by {
                sphere { <0,-.375,0>,1.75 }
        }
}

#declare Dip8 =
union {       
        difference {
                box     { 
                        <-1,0,-.75>,<1,.5,.75>
                        pigment { color Gray20 }
                        finish { Shiny }
                }
                cylinder { 
                        <-.75,.45,-.65>,<-.75,.6,-.6>,.1
                        pigment { color White }
                }
        }
        box { <-.8,-.5,-.85>,<-.7,.05,-.75> }
        box { <-.3,-.5,-.85>,<-.2,.05,-.75> }
        box { <.2,-.5,-.85>,<.3,.05,-.75> }
        box { <.7,-.5,-.85>,<.8,.05,-.75> }
        box { <-.8,-.5,.75>,<-.7,.05,.85> }
        box { <-.3,-.5,.75>,<-.2,.05,.85> }
        box { <.2,-.5,.75>,<.3,.05,.85> }
        box { <.7,-.5,.75>,<.8,.05,.85> }
        texture { Silver_Metal }
        bounded_by {
                box { <-1.25,-.75,-1>,<1.25,.75,1> }
        }
}

#declare Led =
union {
        merge {
                sphere { <0,.5,0>,.35 }
                cylinder { <0,0,0>,<0,.5,0>,.35 }
                cylinder { <0,0,0>,<0,.05,0>,.375 }
                pigment { color Red filter .5 }
        }
        cylinder { <-.25,0,0>,<-.25,-2,0>,.05 }
        cylinder { <.25,0,0>,<.25,-2.1,0>,.05 }
        texture { Silver_Metal }
        bounded_by {
                box { <-.5,-2.25,-.5>,<.5,1,.5> }
        }
}

#declare Capacitor =
union   {
        difference {
                cylinder { <0,0,0>,<0,1,0>,.375 }
                cylinder { <0,.75,0>,<0,1.1,0>,.25 }
                pigment { color Black }
                finish { Shiny }
        }
        cylinder { <0,.8,0>,<0,1,0>,.25 }
        cylinder { <-.25,0,0>,<-.25,-2,0>,.05 }
        cylinder { <.25,0,0>,<.25,-2,0>,.05 }
        texture { Silver_Metal }
        bounded_by {
                   box { <-.5,1.25,-.5>,<.5,-2.25,.5> }
        }
}

#declare Traces =
union {
        cylinder { <-2.5,0,-1.6>,<-2.5,.01,-1.6>,.2 }
        cylinder { <-1.5,0,-1.6>,<-1.5,.01,-1.6>,.2 }
        cylinder { <-.5,0,-1.6>,<-.5,.01,-1.6>,.2 }
        cylinder { <.5,0,-1.6>,<.5,.01,-1.6>,.2 }
        cylinder { <-2.5,0,1.6>,<-2.5,.01,1.6>,.2 }
        cylinder { <-1.5,0,1.6>,<-1.5,.01,1.6>,.2 }
        cylinder { <-.5,0,1.6>,<-.5,.01,1.6>,.2 }
        cylinder { <.5,0,1.6>,<.5,.01,1.6>,.2 }
        cylinder { <-2.5,0,-3>,<-2.5,.01,-3>,.2 }
        cylinder { <-1.5,0,-3>,<-1.5,.01,-3>,.2 }
        cylinder { <.5,0,-2.5>,<.5,.01,-2.5>,.2 }
        cylinder { <2.5,0,-2.5>,<2.5,.01,-2.5>,.2 }
        cylinder { <1.5,0,-1>,<1.5,.01,-1>,.2 }
        cylinder { <1.5,0,1>,<1.5,.01,1>,.2 }
        cylinder { <2.5,0,-.5>,<2.5,.01,-.5>,.2 }
        cylinder { <2.5,0,.5>,<2.5,.01,.5>,.2 }
        cylinder { <.5,0,2.5>,<.5,.01,2.5>,.2 }
        cylinder { <.5,0,3.5>,<.5,.01,3.5>,.2 }
        cylinder { <-.5,0,3>,<-.5,.01,3>,.2 }
        cylinder { <-2.5,0,3>,<-2.5,.01,3>,.2 }
        box { <-2.6,0,-3>,<-2.4,.01,-1.5> }
        box { <-1.6,0,-3>,<-1.4,.01,-1.5> }
        box { <-1.6,0,-3.1>,<2.1,.01,-2.9> }
        box { <1.9,0,-3.1>,<2.1,.01,3.1> }
        box { <-.6,0,2.9>,<2.1,.01,3.1> }
        box { <-.6,0,1.6>,<-.4,.01,3.1> }
        box { <-.6,0,-1.6>,<-.4,.01,-2.6> }
        box { <-.6,0,-2.6>,<.5,.01,-2.4> }
        box { <2.4,0,-2.5>,<2.6,.01,-.5> }
        box { <2.4,0,.5>,<2.6,.01,3.6> }
        box { <-3.1,0,3.4>,<2.6,.01,3.6> }
        box { <-3.1,0,-2.6>,<-2.9,.01,3.6> }
        box { <-3.1,0,-2.6>,<-2.5,.01,-2.4> }
        box { <.4,0,1.6>,<.6,.01,2.5> }
        box { <-2.6,0,2.4>,<-2.4,.01,3> }
        box { <-2.6,0,2.4>,<-1.4,.01,2.6> }
        box { <-1.6,0,1.6>,<-1.4,.01,2.6> }
        box { <-1.6,0,.9>,<-1.4,.01,1.6> }
        box { <-1.6,0,.9>,<1.5,.01,1.1> }
        box { <-2.6,0,-.1>,<-2.4,.01,1.6> }
        box { <-2.6,0,-.1>,<.6,.01,.1> }
        box { <.4,0,-1.6>,<.6,.01,.1> }
        box { <.4,0,-1.1>,<1.5,.01,-.9> }
        texture { Copper_Metal }
}

#declare Resistor330 =
object  {     
        Resistor
        pigment {
                gradient x
                color_map {
                        [.1 color LightWood]
                        [.1 color Orange]
                        [.2 color Orange]
                        [.2 color LightWood]
                        [.3 color LightWood]
                        [.3 color Orange]
                        [.4 color Orange]
                        [.4 color LightWood]
                        [.5 color LightWood]
                        [.5 color Brown]
                        [.6 color Brown]
                        [.6 color LightWood]
                        [.8 color LightWood]
                        [.8 color Silver]
                        [.9 color Silver]
                        [.9 color LightWood]
                }
                translate -.5*x
                scale 1.5
        }
}

#declare Resistor1k =
object  {
        Resistor
        pigment {
                gradient x
                color_map {
                        [.1 color LightWood]
                        [.1 color Brown]
                        [.2 color Brown]
                        [.2 color LightWood]
                        [.3 color LightWood]
                        [.3 color Black]
                        [.4 color Black]
                        [.4 color LightWood]
                        [.5 color LightWood]
                        [.5 color Red]
                        [.6 color Red]
                        [.6 color LightWood]
                        [.8 color LightWood]
                        [.8 color Silver]
                        [.9 color Silver]
                        [.9 color LightWood]
                }
                translate -.5*x
                scale 1.5
        }
}

#declare Resistor1m =
object  {
        Resistor
        pigment {
                gradient x
                color_map {
                        [.1 color LightWood]
                        [.1 color Brown]
                        [.2 color Brown]
                        [.2 color LightWood]
                        [.3 color LightWood]
                        [.3 color Black]
                        [.4 color Black]
                        [.4 color LightWood]
                        [.5 color LightWood]
                        [.5 color Green]
                        [.6 color Green]
                        [.6 color LightWood]
                        [.8 color LightWood]
                        [.8 color Silver]
                        [.9 color Silver]
                        [.9 color LightWood]
                }
                translate -.5*x
                scale 1.5
        }
}

#declare Board=
union {
        box     { 
                <-4,-.25,-4>,<4,0,4>
                texture { 
                        Green_Glass 
                        pigment { color Green }
                }
        }
        object { Traces }
        bounded_by {
                box { <-4.25,-.5,-4>,<4.25,.25,4.25> }
        }
}

