/*  -----=====  A Virtual Reality Hammer (with other bits)  =====-----

                                   by
                    Kevin Thibedeau  <thibedek@wpi.edu>

                            November 27, 1994

    This is a scene that contains a high tech "virtual hammer" with its
accompanying VR (forgive the blatent use of that buzzword) helmet, the cable
that connects the hammer to the helmet, and plasma nails.  The entire scene
hand coded except for the cable which I made with a little help from Moray.
The image maps were drawn with NeoPaint.  You need the following files in
order to render this scene:

    ktvirham.pov   -   The main scene file.  It contains almost all objects.
    cable2.inc     -   The include file for the cable.
    lcd.gif        -   The LCD display on the hammer.  You can't see it well
                       in the sample image.  I had to compromise.
    steelpl2.gif   -   A VERY good IMHO bump map of the non-slip grip
                       pattern often pressed in to steel plates.
    arrow.gif      -   The arrow used on the buttons on the side of the 
                       hammer.

You are free to use and modify the objects and images in the files described
above.  I do request that you acknowledge any use of my objects or images
whether or not they have been modified.  If you create something interesting
with or improved what I have created I would be very interested in seeing
what you did to improve the scene or object and knowing what method you used
to make any significant improvements.  
    I have tried to make all of the objects so that one unit corresponds to
one centimeter.  I still don't have a really good "feel" for metric units,
though, so there might be some discrepancies.  I did use a metric ruler to
help make judgements so the size of the objects should be realistic.
*/

#include "colors.inc"
#include "textures.inc"

#declare Cable_Tex = texture {   // This texture is used in cable2.inc so it
                                 // must be defined here.
    pigment { color MediumOrchid }
    finish { specular 0.5 roughness 0.1 }
}

#include "cable2.inc"

#declare Handle_Color = color Gray50  // The color of the handle
#declare Grip_Color = color Orange    // The color of the grip of the handle
#declare Socket_Color = color Gray70  // The color of the Data Jacks
#declare Band_Color = color Gray70    // The color of the head bands 

#declare Grip_Scale = 0.65  // Scaling factor for the spheres in the grip
#declare Edjrad = 0.5

#declare Speckle_Enamel = texture {  // Blue with white specks

    pigment {
    bozo
    turbulence 0.1
    color_map {
        [0, 0.2 color White 
                color White ]
        [0.2 0.3 color White
                 color Blue ]
        [0.3, 1.001 color Blue 
                    color Blue ]
    }
    scale 0.1
    }
    finish { specular 1 roughness 0.1 }
}


#declare Cast_Iron = texture {  // A mottled cast iron with bumpiness
    
    pigment { Gray40 }
    finish { specular 0.4 roughness 0.05 }
    //finish { phong 0.7 phong_size 200 }
    normal { bumps 1 scale 0.1 }
}

#declare Metal_Grid = texture {
    
    pigment { color LightSteelBlue }
    normal { 
        bump_map { gif "steelpl2.gif"
            interpolate 2
            bump_size 2
        }
        scale 4
    }
    finish { specular 0.9 roughness 0.05 }
}    

camera {
    //location <21.5,17.25,-22>
    //look_at <16,7.25,0>
    //location <-15,15,18>
    //look_at <-13,8,25>
    
    //location <0,17,0>
    location <0,16,0>
    look_at <-20,7.25,0>
    rotate <0,60,0>
    translate <27.25,0,-16>
}

//light_source { <-15,38,-35> color White }
light_source { <28,38,-35> color White }

#declare Data_Jack = union {             // connector for VR data jack (tm)
        
    difference {
        cylinder { <0,0,0> <-1.2,0,0> 2.25
            pigment { color Socket_Color }
        }
        torus { 2.25, 0.2
            rotate <0,0,90>
            translate <-0.83333,0,0>
            texture { Copper_Metal }
        }
        bounded_by { cylinder { <0.01,0,0> <-1.21,0,0> 2.251 }}
    }
    difference {
        cylinder { <-1.2,0,0> <-1.8,0,0> 1.5 }
        cylinder { <-1.21,0,0> <-1.81,0,0> 1.4 }
        texture { Chrome_Metal }
    }
    cylinder { <-1.2,0,0> <-1.3,0,0> 1.4
        pigment { color White }
    }
}

#declare Virtual_Hammer = union {  // This is just the hammer part

    union {                                  //  the frame of a handle grip
        difference {
            cylinder { <0,0,0> <13,0,0> 1.75 }
            
            cylinder { <2.25,1.75,-2> <2.25,1.75,2> 1.25 }
            cylinder { <10.75,1.75,-2> <10.75,1.75,2> 1.25 }
            box { <2.25,0.5,-2> <10.75,2,2> }

            cylinder { <2.25,-1.75,-2> <2.25,-1.75,2> 1.25 }
            cylinder { <10.75,-1.75,-2> <10.75,-1.75,2> 1.25 }
            box { <2.25,-2,-2> <10.75,-0.5,2> }

            bounded_by { cylinder { <-0.1,0,0> <13.1,0,0> 1.751 }}
            pigment { color Handle_Color }
        }

        union {                          //  a row of spheres forming a grip
            sphere { <0,0,0> 1.75  
                scale <Grip_Scale,1,1> 
                translate <1 + (0 * 1.1),0,0> 
            }
            sphere { <0,0,0> 1.75  
                scale <Grip_Scale,1,1> 
                translate <1 + (1 * 1.1),0,0> 
            }
            sphere { <0,0,0> 1.75  
                scale <Grip_Scale,1,1> 
                translate <1 + (2 * 1.1),0,0> 
            }
            sphere { <0,0,0> 1.75  
                scale <Grip_Scale,1,1> 
                translate <1 + (3 * 1.1),0,0> 
            }
            sphere { <0,0,0> 1.75  
                scale <Grip_Scale,1,1> 
                translate <1 + (4 * 1.1),0,0> 
            }
            sphere { <0,0,0> 1.75  
                scale <Grip_Scale,1,1> 
                translate <1 + (5 * 1.1),0,0> 
            }
            sphere { <0,0,0> 1.75  
                scale <Grip_Scale,1,1> 
                translate <1 + (6 * 1.1),0,0> 
            }
            sphere { <0,0,0> 1.75  
                scale <Grip_Scale,1,1> 
                translate <1 + (7 * 1.1),0,0> 
            }
            sphere { <0,0,0> 1.75  
                scale <Grip_Scale,1,1> 
                translate <1 + (8 * 1.1),0,0> 
            }
            sphere { <0,0,0> 1.75  
                scale <Grip_Scale,1,1> 
                translate <1 + (9 * 1.1),0,0> 
            }
            sphere { <0,0,0> 1.75  
                scale <Grip_Scale,1,1> 
                translate <1 + (10 * 1.1),0,0> 
            }
            texture {
                pigment { color Grip_Color }
                finish { specular 0.7 roughness 0.08 }
            }
        }
    
        intersection {                      // some embellishment on the end
            sphere { <0,0,0> 1.75             
                scale <2,1,1>
                translate <13,0,0>
            }
            plane { -x, -13 }
            pigment { color Handle_Color }
        }

        scale <1,1,0.8>  // makes an oval grip ... much better to hold
    }
        
    object { Data_Jack 
        translate <-0.5,0,0>
    }
    
    cone { <0,0,0>, 1.4 <-0.5,0,0> 2.25    // connect the data jack to the 
        pigment { color Socket_Color }     // handle
    }
    cylinder { <0,0,0> <-0.5,0,0> 1.75
        scale <1,1,0.8>
        pigment { color Handle_Color }
    }
    
    // A shaft with fixed dimensions of 10 x 1.2 x 2.5
 union {
  cylinder {<13,1.25 -Edjrad,0.6 -Edjrad><23,1.25 -Edjrad,0.6 -Edjrad> Edjrad}
  cylinder {<13,1.25 -Edjrad,-0.6 +Edjrad><23,1.25 -Edjrad,-0.6 +Edjrad> Edjrad}        
  cylinder {<13,-1.25 +Edjrad,0.6 -Edjrad><23,-1.25 +Edjrad,0.6 -Edjrad> Edjrad}
  cylinder {<13,-1.25 +Edjrad,-0.6 +Edjrad><23,-1.25 +Edjrad,-0.6 +Edjrad> Edjrad}
        box { <13,-1.25,-0.6 + Edjrad> <23,1.25,0.6 - Edjrad> } 
        box { <13,-1.25 + Edjrad,-0.6> <23,1.25 - Edjrad,0.6> } 
        
        texture { Speckle_Enamel }
    }

    // A faceted joint for the shaft and hammer head.
    union {
        triangle { <23,1.35,-0.7> <23,-1.35,-0.7> <25,1.5,-1.5> } // vert -z
        triangle { <23,-1.35,-0.7> <25,1.5,-1.5> <25,-1.5,-1.5> }
        triangle { <23,1.35,0.7> <23,-1.35,0.7> <25,1.5,1.5> } // vert +z
        triangle { <23,-1.35,0.7> <25,1.5,1.5> <25,-1.5,1.5> }
        triangle { <23,1.35,-0.7> <25,1.5,-1.5> <25,1.5,1.5> } // horiz +y
        triangle { <23,1.35,-0.7> <23,1.35,0.7> <25,1.5,1.5> }
        triangle { <23,1.35,-0.7> <23,-1.35,-0.7> <23,-1.35,0.7> } // back
        triangle { <23,1.35,-0.7> <23,1.35,0.7> <23,-1.35,0.7> }
        triangle { <23,-1.35,-0.7> <25,-1.5,-1.5> <25,-3.5,0> } //fillet -
        triangle { <23,-1.35,0.7> <25,-1.5,1.5> <25,-3.5,0> } //fillet +
        triangle { <23,-1.35,0.7> <23,-1.35,-0.7> <25,-3.5,0> } //fillet mid
        texture { Cast_Iron }
    }
    
    // the hammer head
    intersection {
        plane { z, 1.5 }  // side +
        plane { -z, 1.5 } // side -
        plane { x, 28 }   // top
        plane { -x, -25 } // bottom
        plane { -y, 3.5}    // striking face
        plane { y, 0      // angled portion in the back
            rotate <0,0,55>
            translate <25,1.5,0>
        }
        bounded_by { box { <24.99,-5.1,-1.51> <28.1,6,1.51> }}
        texture { Cast_Iron }
    }
    
    // The head of the hammer
    intersection {
        sphere { <26.5,-3.5,0> 2.12132 
            texture { Chrome_Metal }
        }
        box { <25,-5.7,-1.51> <28,-3.5,1.51> 
            texture { Cast_Iron }
        }
    }
    difference {
        cylinder { <26.5,-3.5,0> <26.5,-6,0> 1.5
            texture { Chrome_Metal }
        }
        difference {
            box { <-0.5,-0.11,-0.5> <0.5,0,0.5> }
            box { <-0.3,-0.12,-0.3> <0.3,0.001,0.3> }
            texture { Copper_Metal }
            translate <26.5,-5.9,0>
        }
        sphere { <26.5,-6,0> 0.1
           texture { Copper_Metal }
        }
    }

    // Controls on side of hammer
    union {
        cylinder { <26.5,0,-1.5> <26.5,0,-1.7> 1 }
        cylinder { <26.5,-2,-1.5> <26.5,-2,-1.7> 1 }
        box { <25.5,-2,-1.7> <27.5,0,-1.5> }
        pigment { color SlateBlue }
        finish { specular 0.7 roughness 0.08 }
    }
    sphere { <0,0,0> 0.75
        texture {
            pigment { color Orange }
            finish { specular 0.7 roughness 0.08 }
        }
        texture {
            pigment {
                image_map { gif "arrow.gif" once
                    filter 255,1
                }
                translate <-0.5,-0.5,0>
            }
            finish { specular 0.7 roughness 0.08 }
        }
        scale <1,1,0.5>
        translate <26.5,0,-1.7>
    }
    sphere { <0,0,0> 0.75
        texture {
            pigment { color Orange }
            finish { specular 0.7 roughness 0.08 }
        }
        texture {
            pigment {
                image_map { gif "arrow.gif" once
                    filter 255,1
                }
                translate <-0.5,-0.5,0>
                rotate <0,0,180>
            }
            finish { specular 0.7 roughness 0.08 }
        }
        scale <1,1,0.5>
        translate <26.5,-2,-1.7>
    }

    // LCD display panel
    union {
        difference {                           // frame
            box { <1.3,0,-1.3> <5,0.2,1.3> }
            box { <1.5,-0.1,-1.1> <4.8,0.3,1.1> }
            texture { Speckle_Enamel }
        }
        plane { y, 0.1                         // display
            texture {
                pigment {  
                    image_map { gif "lcd.gif" once }
                    rotate <90,90,0>
                    scale <3.3,1,2.2>
                    translate <1.5,0,1.1>
                }
                finish { ambient 0.6 }
            }
            clipped_by { box { <1.4,0,-1.2> <4.9,0.2,1.2> }}
        }
        
                                     // buttons below the LCD
        sphere {  <0,0,0> 0.175      // top
            pigment { color Gray40 }
            finish { specular 0.7 roughness 0.08 }
            scale <1,1,2>
            translate <0.925,0,0>
        }
        sphere {  <0,0,0> 0.175      // bottom
            pigment { color Gray40 }
            finish { specular 0.7 roughness 0.08 }
            scale <1,1,2>
            translate <0.375,0,0>
        }
        sphere {  <0,0,0> 0.175      // right
            pigment { color Gray40 }
            finish { specular 0.7 roughness 0.08 }
            scale <1,1,2>
            translate <0.65,0,-0.75>
        }
        sphere {  <0,0,0> 0.175      // left
            pigment { color Gray40 }
            finish { specular 0.7 roughness 0.08 }
            scale <1,1,2>
            translate <0.65,0,0.75>
        }
        sphere { <0,0,0> 0.48
            pigment { color SlateBlue }
            finish { specular 0.7 roughness 0.08 }
            scale <1,0.186,2.3829>
            translate <0.65,0,0>
        }

        rotate <0,0,55>
        translate <25,1.5,0>
    }
}

#declare VR_Helmet = union {

    difference {                        // band from ear to ear
        cylinder { <0,-1,0> <0,1,0> 6.75 
            scale <(10.25 / 6.75),1,1>
        }
        cylinder { <0,-1.01,0> <0,1.01,0> 6.5 
            scale <(10 / 6.5),1,1>
        }
        plane { -x,0 }
        pigment { color Band_Color }
    }
                                            // some earmuffs
    cylinder { <0,0,-6.5> <0,0,-7.5> 2.5 
        pigment { color Turquoise }
    }
    sphere { <0,0,0> 2.5
        pigment { color Turquoise }
        scale <1,1,0.25>
        translate <0,0,-7.5>
    }
    cylinder { <0,0,6.5> <0,0,7.5> 2.5 
        pigment { color Turquoise }
    }
    sphere { <0,0,0> 2.5
        pigment { color Turquoise }
        scale <1,1,0.25>
        translate <0,0,7.5>
    }
    difference {                             // a band over the top
        cylinder { <0,0,-1> <0,0,1> 6.75
            scale <(10.25 / 6.75 ),((1.5 * 6.5) + 0.25) / 6.75,1>
            translate <0,0,0>
        }
        cylinder { <0,0,-1.01> <0,0,1.01> 6.5
            scale <(10 / 6.5),1.5,1>
            translate <0,0,0>
        } 
        plane { y,0 }
        box { <8,0,-1.01> <10.01,1.9,1.01> }
        pigment { color Band_Color }
    }
    
    object { Data_Jack                           //a data jack at the back
        translate <-10,0,0>
    }
    difference {    
        cone { <-10,0,0>, 2.25 <-8,0,0>, 3.25 }
        sphere { <0,0,0> 6.5
            scale <(10 / 6.5),1.5,1>
        }
        pigment { color Band_Color }
    }

    intersection {                               // the display housing
        box { <10,-2,-4.8> <10.751,2,4.8> }
        cylinder { <0,-2.01,0> <0,2.01,0> 10.75
            scale <1,1,1.4>
        }
        pigment { color Gray90 }
    }
    difference {                               // the shield around the edge
        box { <7,-1.9,-4.7> <10,1.9,4.7> }
        sphere { <0,0,0> 6.5
            scale <(10 / 6.5),1.5,1>
        }
        box { <6.99,-1.8,-4.6> <10.01,1.8,4.6> }
        pigment { color Gray40 }
    }
}

                                
#declare Dummy_Head = union {    
    
    sphere { <0,0,0> 6.5
        scale <(10 / 6.5),1.5,1>
    }
    cylinder { <0,-8,0> <0,-9.25,0> 4 }
    cylinder { <0,-9.25,0> <0,-10,0> 6 }
    texture { Red_Marble 
       finish { specular 0.8 roughness 0.03 }
       scale 4
    }
}

#declare Plasma_Nail = union {

    box { <-0.6,0,-0.6> <0.6,0.1,0.6>    // the top
        pigment { color Gray80 }
    }
    difference {                         // a copper contact
        box { <-0.5,0.1,-0.5> <0.5,0.2,0.5> }
        box { <-0.3,0.09,-0.3> <0.3,0.21,0.3> }
        texture { Copper_Metal }
    }
    sphere { <0,0.1,0> 0.1
        texture { Copper_Metal }
    }
    cylinder { <0,0,0> <0,-7,0> 0.15    // a copper shaft
        texture { Copper_Metal }
    }
    difference {                       // a shaft with three holes
        cylinder { <0,0,0> <0,-6,0> 0.25 }
        cylinder { <0,0,-0.26> <0,0,0.26> 0.15
            scale <1,3,1>
            translate <0,-1.5,0>
        }
        cylinder { <0,0,-0.26> <0,0,0.26> 0.15
            scale <1,3,1>
            translate <0,-3,0>
        }
        cylinder { <0,0,-0.26> <0,0,0.26> 0.15
            scale <1,3,1>
            translate <0,-4.5,0>
        }
        pigment { color Gray80 }
    }
}

#declare Data_Jack2 = union {

    difference {                    // the socket that connects to data jack
        cylinder { <-1.3,0,0> <-2.5,0,0> 2.25 
            pigment { Socket_Color }
        }
        torus { 2.25, 0.2
            rotate <0,0,90>
            translate <-1.6666,0,0>
            texture { Copper_Metal }
        }
        difference {
            cylinder { <-1.29,0,0> <-1.8,0,0> 1.5 }
            cylinder { <-1.28,0,0> <-1.81,0,0> 1.4 }
            pigment { Socket_Color }
        }
        bounded_by { cylinder { <-1.29,0,0> <-2.51,0,0> 2.251 }}
    }

    cone { <-2.5,0,0>,2.25 <-3,0,0>,0    //  beginning of cable of cones
        texture { Cable_Tex }
    }
    cone { <-2.5,0,0>,1.5 <-4,0,0>,0
        texture { Cable_Tex }
    }
}    

#declare Cable = union {  // the cable connecting the hammer to the helmet

    object { Data_Jack2
        translate <0,7.25,0>
    }
    object { Data_Jack2
         translate <-10,10,0>
         rotate <0,-15,0>
         translate <0,0,30>
    }
    object { Links }
}

plane { y,0                        //  metal planes to provide a background
    texture { Metal_Grid rotate <-90,0,0> }
}
plane { x,-20
    texture { Metal_Grid rotate <0,-90,0> }
}
plane { z,50
    texture { Metal_Grid }
}

cylinder { <19.75,0,0> <19.75,6,0> 3  // a dented cylinder that the hammer
    pigment { color SteelBlue }       // rests on
    normal { 
        dents 1
        scale 0.5
    }
    finish { specular 0.9 roughness 0.1 }
}

object { Virtual_Hammer 
    translate <0,7.25,0>
}

object { Plasma_Nail
    translate <18,3,-5>
} 

object { Plasma_Nail
    translate <0.6,0,0>
    rotate <0,0,86.66>
    rotate <0,-80,0>
    translate <15,0,-7>
}

object { VR_Helmet 
    rotate <0,-15,0>
    translate <0,10,30>
}

object { Dummy_Head 
    rotate <0,-15,0>
    translate <0,10,30>
} 

object { Cable }

