
#include "colors.inc"
#include "shapes.inc"

// From shapes2.inc
#declare Pyramid2 = intersection {
   plane { < 1, 0,  0>, 1  rotate <  0, 0,  40>}
   plane { <-1, 0,  0>, 1  rotate <  0, 0, -40>}
   plane { < 0, 0,  1>, 1  rotate <-40, 0,   0>}
   plane { < 0, 0, -1>, 1  rotate < 40, 0,   0>}
   plane { <0, -1, 0>, 0 }
   translate <0 ,-1, 0>
}

#declare TVTex =
texture{
    pigment{ color Gray30 }
}

#declare TVFin =
finish{ ambient .4 }

#declare VCRTex =
texture{
    pigment{ color Gray70 }
}

#declare VCRFin =
finish{ ambient .3 }

#declare CabinetTex =
texture{
    pigment{
        wood
        turbulence .025
        color_map{
            [0.0 0.8 color rgb <.725, .5, .3> color rgb <.53, .36, .11>]
            [0.8 1.0 color rgb <.53, .36, .11> color rgb <.52, .36, .11>]
        }
    }
    scale .1*<2, 1, 1>
    rotate x*90
}

#declare CabinetFin =
finish{ ambient .4 }

#declare BookTex =
texture{
    pigment{ color Scarlet }
}

#declare BookFin =
finish{ ambient .4 }

#declare BookFaceTex =
texture{
    pigment{ color rgb <.95, .95, 0> }
}

#declare BookFaceFin =
finish{ ambient .4 reflection .1 }

#include "tv.inc"
#include "vcr.inc"
#include "cabinet.inc"
#include "picture.inc"
#include "books.inc"
#include "calendar.inc"

camera{
    location <0, 0, -40>
    look_at <0, 0, 0>
    rotate y*-30
}

light_source{ <-25, 50, -75> color Gray60 }

/////////////////////////////////////////////////////////////////////

object{
    Cabinet
}

object{
    TV
    translate <-11, -.5, 0>
}

object{
    VCR
    translate <14, -7.25, 0>
}

// Wall
plane{
    z, 8
    pigment{ color rgb <1, 1, .75> }
    finish{ ambient .5 }
}

// Carpeting
plane{
    y, -34.3751
    pigment{ color rgb <.9, .3, .3> }
    finish{ ambient .4 }
    normal{ bumps .5 scale .25 }
}

// Wall-floor rim
union{
    box{ <-100, -35, 7> <100, -31, 9> }
    box{ <-100, -35, 7> <100, -30, 7.9> }
    cylinder{ <-100, -30, 8> <100, -30, 8> .75 }
    texture{
        pigment{
            granite
            color_map{
                [0.0 1.0 color rgb <.9, .9, .9> color White]
            }
        }
    }
    finish{ ambient .5 }
}

object{
    Picture
    scale 4*<1, 1, 1>
    translate <-60, 15, 8>
}

object{
    Books
    translate <-11.625, 18.824, -4>
}

object{
    Books
    translate <11.625, 18.824, -4>
}

object{
    Calendar
    rotate x*5
    rotate y*-10
    translate <16, -5.25, -2>
}
