/*

#include "colors.inc"
#include "shapes.inc"

camera{
    location <0, 15, -50>
    look_at <0, 0, 0>
}

// light_source{ <0, 0, -1000> color Gray50 }
light_source{ <1000, 1000, -1000> color White }

*/

//////////////////////////////////////////////////////////////////////

#declare TV_Frame =
object{
    union{
        // Main
        difference{
            box{ <10, 8.5, -20> <-10, -8.5, -13> }
            union{
                // Spaces for rounded edges
                union{
                    box{ <9, 7.5, -50> <11, 9.5, 50> }
                    box{ <-9, 7.5, -50> <-11, 9.5, 50> }
                    box{ <9, -7.5, -50> <11, -9.5, 50> }
                    box{ <-9, -7.5, -50> <-11, -9.5, 50> }
                }
                // Space for screen
                object{
                    Pyramid2
                    rotate x*90
                    scale <20, 15, 7.5>
                    translate <0, 1, -20>
                }
                // Space for panel
                box{
                    <4, -6.75, -50> <9.5, -50, 18>
                }
            }
        }
        // Rounded edges
        difference{
            union{
                cylinder{ <9, 7.5, -13> <9, 7.5, -20> 1 }
                cylinder{ <-9, 7.5, -13> <-9, 7.5, -20> 1 }
                difference{
                    union{
                        cylinder{ <9, -7.5, -13> <9, -7.5, -20> 1 }
                        cylinder{ <-9, -7.5, -13> <-9, -7.5, -20> 1 }
                    }
                    box{
                        <-9, -6.75, -50> <9, -50, 18>
                    }
                }
            }
            object{
                Pyramid2
                rotate x*90
                scale <20, 15, 7.5>
                translate <0, 1, -20>
            }
        }
    }
    texture{ TVTex }
    finish{ TVFin }
}

#declare TV_Back =
intersection{
    object{
        Pyramid2
        rotate x*90
    }
    plane{
        z, 0
    }
    translate <0, 0, .5>
    scale <5, 5, 5>
    translate <0, 0, -10.5>
    texture{ TVTex }
    finish{ TVFin }
}


#declare TV_Screen =
box{
    <8.25, 6.25, .01> <-8.25, -6.25, -.01>
    translate <0, 1, -19.5>
    texture{
        pigment{
            image_map{
                tga "enzo.tga" map_type 0 once
            }
            translate <-.5, -.5, 0>
            scale <16.5, 12.5, 1>
            translate <0, 1, 0>
        }
    }
    finish{ ambient .8 }
}

#declare TV_Panel_Button_Top =
union{
    union{
        box{ <-.25, -.05, -1> <.25, .05, .1> }
        cylinder{ <-.25, 0, .1> <-.25, 0, -1> .05 }
        cylinder{ <.25, 0, .1> <.25, 0, -1> .05 }
        pigment{ color CadetBlue }
        finish{ ambient 1 }
    }
    triangle{
        <1, 0, 0> <-1, 0, 0> <0, 1, 0>
        scale <.1, .1, .1>
        translate <0, -.1, 0>
        pigment{ color White }
        finish{ ambient 1 }
    }
}

#declare TV_Panel =
object{
    union{
        // "POV-RAY"
        box{
            <0, 0, 0> <1, 1, 1>
            texture{
                pigment{
                    image_map{
                        tga "povpanel.tga" map_type 0 once
                    }
                }
            }
            finish{
                ambient .25
                reflection .1
            }
            translate <-.5, -.5, -.5>
            scale <2.5, .5, .01>
            translate <0, -6.5, -20.01>
        }
        box{
            <4.05, -6.8, -19.99> <9.45, -9, -18>
            pigment{ color Black filter 1 }
            finish{ reflection .2 }
        }
    }
}

#declare TV =
union{
    object{ TV_Frame }
    object{ TV_Back }
    object{ TV_Screen }
    object{ TV_Panel }
    translate <0, 0, 14>
}

/*
object{
    TV
    scale 1.5*<1, 1, 1>
    rotate y*-30
}
*/
