
/*
#include "colors.inc"
#include "shapes.inc"

camera{
    location <0, 5, -20>
    look_at <0, 0, 0>
}

light_source{ <1000, 1000, -1000> color Gray50 }
*/

//////////////////////////////////////////////////////////////////////

#declare VCR=
object{
    union{
        // Back
        box{
            <-7.5, 0, 0> <7.5, 1.55, -10>
            pigment{ color Gray50 }
            finish{ VCRFin }
        }
        box{
            <-7.5, 0, 0> <7.5, -1.55, -10>
            texture{ VCRTex }
            finish{ VCRFin }
        }
        box{
            <-7.5, 1.54, -10.5> <7.5, -1, -9.9>
            texture{ VCRTex }
            finish{ VCRFin }
        }

        // Top panel
        difference{
            union{
                difference{
                    box{ <-7.5, -.45, -11> <7.5, 1.55, -10> }
                    union{
                        // Space for rounded edges
                        box{ <-8, 1.45, -10.9> <8, 2, -15> }
                        box{ <-8, -.45, -10.9> <8, -.55, -11.1> }
                        // Space for "clock" section
                        box{ <1.5, 5, -10.75> <6.5, -5, -12> }
                        // Tape slot
                        box{ <-6.5, 1.05, -10.5> <1, .05, -12> }
                    }
                }
                // Rounded edge
                difference{
                    cylinder{ <-7.5, 1.45, -10.9> <7.5, 1.45, -10.9> .0999 }
                    box{ <1.5, 5, -10.75> <6.5, -5, -12> }
                }
                // Tape slot cover
                box{ <-6.425, .975, -10.5> <0.875, -.15, -10.95> }
            }     
        texture{ VCRTex }
        finish{ VCRFin }
        }

        // "Clock" section of top panel
        union{
            difference{
                box{ <1.5, 1.55, -10.75> <6.5, -.45, -11> }
                box{ <-8, 1.45, -10.9> <8, 2, -15> }
            }
            // Rounded edge
            intersection{
                cylinder{ <-7.5, 1.45, -10.9> <7.5, 1.45, -10.9> .0999 }
                box{ <1.5, 5, -10.75> <6.5, -5, -12> }
            }
            // Display
            box{
                <0, 0, 0> <1, 1, 1>
                texture{
                    pigment{
                        image_map{ tga "vcrclock.tga" map_type 0 once }
                    }
                }
                finish{ ambient .9 }
                translate <-.5, -.5, -.5>
                scale <4, 1.5, .001>
                translate <3.75, .6, -11>
            }
        pigment{ color Black }
        finish{ VCRFin }
        }

        // Middle panel
        // Left
        difference{
            box{ <-7.5, -.5, -10.75> <-4.5, -1.25, -10> }
            box{ <-6.5, -.75, -11> <-5.05, -1, -10> }
            texture{ VCRTex }
            finish{ VCRFin }
        }
        union{
            box{ <-6.45, -.8, -10.76> <-5.83, -.95, -10> }
            box{ <-6.45, -.8, -10.76> <-5.83, -.95, -10>
                 translate <.7, 0, 0> }
            texture{ VCRTex }
            finish{ VCRFin }
        }
        // Right
        union{
            box{ <7.5, -.5, -10.75> <4.5, -1.25, -10> }
            box{
                <0, 0, 0> <1, 1, 1>
                texture{ pigment{ image_map{
                    tga "povpanel.tga" map_type 0 once
                }}}
                finish{ ambient .5 }
                scale <1.5, .3, .001>
                translate <5.4, -.975, -10.75001>
            }
            texture{ VCRTex }
            finish{ VCRFin }
        }
        // Center
        box{
            <-4.42, -.5, -10.75> <4.42, -1.5, -10>
            texture{ VCRTex }
            finish{ VCRFin }
        }

        // Bottom panel
        union{
            box{ <-7.5, -1.3, -10> <-5, -1.55, -10.5> }
            box{ <7.5, -1.3, -10> <5, -1.55, -10.5> }
            texture{ VCRTex }
            finish{ VCRFin }
        }

    }
    translate <0, 0, 5>
}

/*
object{
    VCR
    rotate y*30
}
*/
