/* POVRAY DESCRIPTION FILE
   SCENE DESCRIPTION : Two transformers engaged in combat some where in Mega
                       City.                       
   DATE CREATED : 10.11.95
   AUTHOR : Nathan O'Brien
            33/392 Jones St Ultimo 2007 Australia
            phone : 612 966 01102  (AH) 
            fax   : 612 261 8932
            email : no13@ozemail.com.au
  THANKS TO : Gennadiy Obukhov for his Head object (see head.inc)
                               and his fireworks   (see fire3.inc)         
*/


#include "colors.inc"
#include "trans1.inc"
#include "trans2.inc"

camera {
        location <2000,0,-6000>
        look_at  <0,0,0>
}

light_source {<2000,4000,-7000> color White}

#declare mullion=
box {<-7,0,0><7,3600,-90> pigment{color red .2 green .2 blue .5} finish{phong 1}}

#declare floor=
union {
        box {<-10000,-12,0><10000,12,-90> pigment{color red .2 green .2 blue .5} finish{phong 1}}
        box {<-10000,1788,0><10000,1812,-90> pigment{color red .2 green .2 blue .5} finish{phong 1}}
        
        box {<-10000,888,0><10000,912,-90> pigment{color red .2 green .2 blue .5} finish{phong 1}}
        box {<-10000,2688,0><10000,2712,-90> pigment{color red .2 green .2 blue .5} finish{phong 1}}
        
        object {mullion}
        object {mullion translate<-600,0,0>}
        object {mullion translate<-1200,0,0>}
        object {mullion translate<-1800,0,0>}
        object {mullion translate<-2400,0,0>}
        object {mullion translate<-3000,0,0>}
        object {mullion translate<-3600,0,0>}
        object {mullion translate<-4200,0,0>}
        object {mullion translate<-4800,0,0>}
        object {mullion translate<-5400,0,0>}
        object {mullion translate<-6000,0,0>}
        object {mullion translate<-6600,0,0>}
        object {mullion translate<-7200,0,0>}
        object {mullion translate<-7800,0,0>}
        object {mullion translate<-8400,0,0>}
        object {mullion translate<-9000,0,0>}
        object {mullion translate<-9600,0,0>}
        object {mullion translate<600,0,0>}
        object {mullion translate<1200,0,0>}
        object {mullion translate<1800,0,0>}
        object {mullion translate<2400,0,0>}
        object {mullion translate<3000,0,0>}
        object {mullion translate<3600,0,0>}
        object {mullion translate<4200,0,0>}
        object {mullion translate<4800,0,0>}
        object {mullion translate<5400,0,0>}
        object {mullion translate<6000,0,0>}
        object {mullion translate<6600,0,0>}
        object {mullion translate<7200,0,0>}
        object {mullion translate<7800,0,0>}
        object {mullion translate<8400,0,0>}
        object {mullion translate<9000,0,0>}
        object {mullion translate<9600,0,0>}

}

object {floor }
object {floor translate<0,3600,0>}
object {floor translate<0,7200,0>}
object {floor translate<0,10800,0>}
object {floor translate<0,14400,0>}
object {floor translate<0,-3600,0>}
object {floor translate<0,-7200,0>}
object {floor translate<0,-10800,0>}
object {floor translate<0,-14400,0>}

box {<-20000,-10000,-70><20000,20000,-80>
        pigment{color red .2 green .2 blue .4}
        normal{bumps .1 scale<5100,5100,5100>}
        finish{phong 1 reflection .8}
}

#declare city=
box {<0,0,0><1,1,1>
        texture{pigment{
        image_map{gif "sydney.gif" once}
        }}
        finish {ambient .5}
}

object {city scale<40000,40000,1> translate<-20000,-20000,-8000>}

object {transformer1 scale<3,3,3> rotate<-10,140,-5> translate<2000,-1200,-4500>}
object {transformer2 scale<3,3,3> rotate<10,-40,5> translate<-800,0,-2500>}
