#include "color2.inc"
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "mask.inc"
#include "hand.inc"
#include "flame.inc"

#declare Camera1 =
camera{
  location<0,-2.5,-9.5>
  look_at<0,0,0>
}

#declare Camera2 =
camera{
  location<0,1,-4>
  look_at<0,1,0>
}

camera{Camera1}

light_source{<0,1.5,-5> color rgb<1.5,1.5,1.5>}
light_source{<0,2,3> color rgb<1,1,1>}


#declare Body =
union{
  /*Top of torso*/
  object{
    Ellipsoid
    scale<.9,0.5,0.5>
    translate<0,0.95,0>
  }
  //chest plate
  cone{
    <0,0,0>, 0.25
    <0,-0.35,0>,0.1
    pigment{Black}
    translate<0,1,-0.5>
  }
  //right trap armor
  object{Ellipsoid
    translate<1,1.85,0> scale <0.4,0.51,0.4> pigment{Black}
  }
  //left trap armor
  object{Ellipsoid
    translate<-1,1.85,0> scale <0.4,0.51,0.4> pigment{Black}
  }

  /*Rib section below Top of torso*/
  object{
    Ellipsoid
    scale<0.85,0.68,0.5>
    translate<0,.75,0>
  }
  /*Main body section*/
  object{
    Ellipsoid
    clipped_by{plane{y,0.1}}
    scale <0.75,1.75,0.37>
    translate<0,0.75,0> //was <0,0.2,0>
  }
  /*Midsection*/
  cylinder{
    <0,-1,0>
    <0,1.2,0>
    .64
    scale<1,1,0.5>
    translate<0,-0.35,0>
  }
  /*Pectorals*/
  object{
    Ellipsoid
    scale <0.5,0.6,0.5>
    translate<-0.25,0.75,-0.055>
  }
  //armor
  difference{
    object{Ellipsoid scale <0.5,0.6,0.5> translate<-0.25,0.76,-0.07>}
    object{Ellipsoid scale <0.5,0.6,0.7> translate<-0.1,0.96,-0.07>}
    pigment{Black}
  }
  object{
    Ellipsoid
    scale <0.5,0.6,0.5>
    translate<0.25,0.75,-0.055>
  }
  //armor
  difference{
    object{Ellipsoid scale <0.5,0.6,0.5> translate<0.25,0.76,-0.07>}
    object{Ellipsoid scale <0.5,0.6,0.7> translate<0.1,0.96,-0.07>}
    pigment{Black}
  }

  /*Traps*/
  object{Ellipsoid scale<0.2,0.4,0.2> 
         rotate<0,0,30> translate<0.35,1.2,0>}
  object{Ellipsoid scale<0.2,0.4,0.2>
         rotate<0,0,-30> translate<-0.35,1.2,0>}

  /*Shoulders*/
  object{Ellipsoid
    translate<1.2,2.25,0> scale <0.45,0.4,0.3>
  }
    //armor
    object{Ellipsoid
      translate<1.4,2.85,0> scale <0.44,0.3,0.3> pigment{Black}
    }

  object{Ellipsoid
    translate<-1.2,2.25,0> scale <0.45,0.4,0.3>
  }
    //armor
    object{Ellipsoid
      translate<-1.4,2.85,0> scale <0.44,0.3,0.3> pigment{Black}
    }
}

#declare Arms =
union{
  /*Arms*/
  object{Ellipsoid scale<0.2,0.75,0.175> rotate<0,0,30>
       translate<0.95,0.5,0>}
  object{Ellipsoid scale<0.2,0.75,0.175> rotate<0,0,-30>
       translate<-0.95,0.5,0>}
  /*Triceps*/
  object{Ellipsoid scale<0.15,0.5,0.2> rotate<0,0,30> rotate<-10,0,0>
       translate<0.95,0.4,-0.01>}
  object{Ellipsoid scale<0.15,0.5,0.2> rotate<0,0,-30> rotate<-10,0,0>
       translate<-0.95,0.4,-0.01>}
  /*Left Forearms*/
  object{Ellipsoid scale<0.18,0.75,0.16> rotate<0,0,-30> rotate<0,0,6>
       translate<-1.4,-0.25,0>}
  object{Ellipsoid scale <0.18,0.55,0.17> rotate<0,0,-30>
       translate<-1.4,-0.15,0>}
  /*Right Forearms*/
  object{Ellipsoid scale<0.18,0.75,0.16> rotate<0,0,30> rotate<0,0,-6>
       translate<1.4,-0.25,0>}
  object{Ellipsoid scale <0.18,0.55,0.17> rotate<0,0,30> 
       translate<1.4,-0.15,0>}
  scale <1,1.25,1>
  translate<0,-0.25,0>
}

#declare Legs =
union
{
  /*Crotch*/
  cone{
    <0,0,0>, 0.45
    <0,-0.5,0>, 0.25
    translate<0,-1.3,0.05>
    clipped_by{plane{z,0.05}}
    pigment{Black}
  }
  /*Buttocks*/
    union{
      object{Ellipsoid scale <0.4,0.6,0.4> translate<0.25,-1.5, 0.05>}
      object{Ellipsoid scale <0.4,0.6,0.4> translate<-0.25,-1.5, 0.05>}
      clipped_by{plane{-z,0.01}}
      pigment{Black}
    }
  /*Upper Left leg*/
  object{Ellipsoid scale<0.4,1.6,0.35> rotate<0,0,4> translate<-0.37,-2.3,0>}
  //armor
  object{Ellipsoid scale<0.1,0.85,0.3> rotate<0,0,4>
         translate<-0.37,-2.2,-0.3> pigment{Black}}
  cylinder{<0,-2,0> <0,-2.25,0> 0.45 translate<-0.37,0,0> pigment{Black}}
  //knee armor
  object{Ellipsoid scale<0.2,0.5,0.3> rotate<0,0,4>
         translate<-0.37,-3.6,-0.1> pigment{Black}}

  /*Lower Left leg*/
  object{Ellipsoid scale<0.28,1.3,0.28> rotate<0,0,4> translate<-0.25,-4.75,0>}
  object{Ellipsoid scale<0.28,0.7,0.33> rotate<0,0,4>
         rotate<-5,0,0> translate<-0.25,-4.45,0.1>}
  //armor
  cone{<-0.25,-4.25,0>,0.29 <-0.25,-4.6,0>,0.3 pigment{Black} scale<1,1,1.35>}
  cone{<-0.25,-4.6,0>,0.16 <-0.25,-5,0>,0.1 translate<0,0,-0.15> pigment{Black}}
  cone{<-0.25,-5,0>,0.16 <-0.25,-5.5,0>,0.15 translate<0,0,-0.125> pigment{Black}}

  /*Upper Right leg*/
  object{Ellipsoid scale<0.4,1.6,0.35> rotate<0,0,-4> translate<0.37,-2.3,0>}
  //armor
  object{Ellipsoid scale<0.17,0.85,0.3> rotate<0,0,-4>
         translate<0.37,-2.2,-0.3> pigment{Black}}
  cylinder{<0,-2,0> <0,-2.25,0> 0.4 translate<0.37,0,0> pigment{Black}}
  //knee armor
  object{Ellipsoid scale<0.2,0.5,0.3> rotate<0,0,-4>
         translate<0.37,-3.6,-0.1> pigment{Black}}

  /*Lower Right leg*/
  object{Ellipsoid scale<0.28,1.3,0.28> rotate<0,0,-4> translate<0.25,-4.75,0>}
  object{Ellipsoid scale<0.28,0.7,0.33> rotate<0,0,-4>
         rotate<-5,0,0> translate<0.25,-4.45,0.1>}
  //armor
  cone{<0.25,-4.25,0>,0.29 <0.25,-4.6,0>,0.3 pigment{Black} scale<1,1,1.35>}
  cone{<0.25,-4.6,0>,0.16 <0.25,-5,0>,0.1 translate<0,0,-0.15> pigment{Black}}
  cone{<0.25,-5,0>,0.16 <0.25,-5.5,0>,0.15 translate<0,0,-0.125> pigment{Black}}
}

#declare RightFoot =
union{
  union{
    cone{
      <0,0,0>, 0.5
      <0,0.7,0>, 0.3
      pigment{Black}
    }
    cone{
      <0,0,0>, 0.49
      <0,0.5,0>, 0.05
      translate<-0.1,0.25,0>
    }
//    rotate<0,0,-45>
  }
  object{Ellipsoid scale<0.7,0.5,0.5> translate<-0.65,0,0>
         clipped_by{plane{-y,0}} pigment{Black}}
  object{Ellipsoid scale<0.5,0.5,0.45> rotate<0,0,0> translate<-0.45,0.2,0>
         clipped_by{plane{-y,-0.25}}}
  object{Ellipsoid scale<0.35,0.35,0.35> rotate<0,0,0> translate<-0.4,0.42,0>
         clipped_by{plane{-y,-0.25}} pigment{Black}}
  rotate<0,0,15>
}

#declare LeftFoot =
union{
  union{
    cone{
      <0,0,0>, 0.5
      <0,0.7,0>, 0.3
//original      <0,1,0>, 0
      pigment{Black}
    }
    cone{
      <0,0,0>, 0.49
      <0,0.5,0>, 0.05
      translate<-0.1,0.25,0>
    }
//    rotate<0,0,-45>
  }
  object{Ellipsoid scale<0.7,0.5,0.5> translate<-0.65,0,0>
         clipped_by{plane{-y,0}} pigment{Black}}
  object{Ellipsoid scale<0.5,0.5,0.45> rotate<0,0,0> translate<-0.45,0.2,0>
         clipped_by{plane{-y,-0.25}}}
  object{Ellipsoid scale<0.35,0.35,0.35> rotate<0,0,0> translate<-0.4,0.42,0>
         clipped_by{plane{-y,-0.25}} pigment{Black}}
  rotate<0,0,15>
}

#declare Abs =
union{
  /*Right Ribcage*/
  object{
    Ellipsoid
    scale <0.4,0.2,0.3>
    rotate<0,0,-30>
    rotate<0,-45,0>
    translate<0.35,0.05,-0.04>
    pigment{Black}
  }
  /*Left Ribcage*/
  object{
    Ellipsoid
    scale <0.4,0.2,0.3>
    rotate<0,0,30>
    rotate<0,45,0>
    translate<-0.35,0.05,-0.04>
    pigment{Black}
  }
  object{
    Ellipsoid
    scale 0.2
    translate<0,0.2,-0.28>
    pigment{Black}
  }
  /*Upper Abdomen muscles*/
  object{
    Ellipsoid
    scale <0.22,0.2,0.22>
    translate<-0.15,-0.125,-0.25>
    pigment{Black}
  }
  object{
    Ellipsoid
    scale <0.22,0.2,0.22>
    translate<0.15,-0.125,-0.25>
    pigment{Black}
  }
  /*Middle Abdomen muscles*/
  object{
    Ellipsoid
    scale <0.23,0.18, 0.18>
    translate<-0.15,-0.5,-0.25>
    pigment{Black}
  }
  object{
    Ellipsoid
    scale <0.23,0.18, 0.18>
    translate<0.15,-0.5,-0.25>
    pigment{Black}
  }
  /*Lower Abdomen muscles*/
  object{
    Ellipsoid
    scale <0.2,0.17,0.14>
    translate<-0.15,-0.8,-0.25>
    pigment{Black}
  }
  object{
    Ellipsoid
    scale <0.2,0.17,0.14>
    translate<0.15,-0.8,-0.25>
    pigment{Black}
  }
  object{
    Ellipsoid
    scale <0.18,0.19,0.22>
    translate<0,-1.05,-0.25>
    pigment{Black}
  }
}

/*Head*/
#declare UHead =
union{
  union{
    object{
      Ellipsoid
      scale <0.31,0.55,0.3>
//      rotate <7,0,0>
    }
    sphere{<0,.23,0>, 0.29
      translate<0,0,0.081>
    }
    rotate<14,0,0>
    translate <0,1.7,-0.25> scale <1.2,1.25,1.2>}
    /*Mask*/
    object{Mask scale <0.85,0.75,1> translate<0,1.7,-0.24>}
  }

/*union between head and neck*/
#declare Head =
  union{
    object{UHead}
    /*Neck*/
    cylinder{
      <0,1.5,0>
      <0,-1,0>
      0.25
      //0.168
    translate<0,0.75,0>
    }
  }

union{
  object{Head scale 0.9 translate<0,0.2,0>}
  object{Body}
  object{Arms}
  object{Abs translate<0,0,0.03>}
  object{Legs}
  object{LeftFoot scale <0.9,0.45,0.3> rotate<-90,0,0> rotate<0,-30,0>
         rotate<0,0,90> translate<-0.2,-5.95,0.4>}
  object{RightFoot scale <0.9,0.45,0.3> rotate<-90,0,0> rotate<0,-30,0>
         rotate<0,0,90> translate<0.2,-5.95,0.4>}
  object{RHand scale 0.37 rotate<0,-30,0> rotate<0,0,19>
         translate<1.7,-1.4,0>}
  object{LHand scale 0.37 rotate<0,30,0> rotate<0,0,-19>
         translate<-1.7,-1.4,0>}
  object{FlameWall translate<0,0,-4>}
  pigment{
             gradient x
                color_map{
                 [0.15  color  Orange filter 0]
                 [0.35  color MandarinOrange filter 0]
                 [0.55  color Banana filter 0]
                 [0.95  color Banana filter 0]
                 [1.0  color MandarinOrange filter 0]
             }
  }
  finish{diffuse 1 ambient 0.7 reflection 0.90} //ambient 0.6
//  rotate<0,-90,0>
  translate<0,2.75,0>
  no_shadow
}

//sphere{<0,0,0>, 1000 pigment{Midnight_Blue}}
