// Toronto's CN Tower
// Date - Thursday August 24th/1995 the release date of Microsoft's Windows 95

#include "colors.inc"    // The include files contain
#include "shapes.inc"    // pre-defined scene elements
#include "textures.inc"
//#include "building.inc"

// ***** Textures *****

#declare Concrete_Texture=
texture {
	pigment { color Gray70 }
        finish { crand 0.05 }
}

#declare Radial_Window=
pigment {
	radial
	color_map {
		[ 0.0 color Gray75 ]
		[ 0.1 color Gray75 ]
		[ 0.1 color rgb <0.3,0.3,0.6> ]
		[ 1.0 color rgb <0.3,0.3,0.6> ]
		}
	frequency 20
}

// ***** Camera *****

camera { location <0,10,-800>
        look_at <0,700,0>
	rotate y*-30
}

// ***** Light Sources *****

light_source { <5000,5000,-5000> color rgb <1,1,.95> }

light_source {
        <0,10,-800>
	color White
	rotate y*-30
}

// ***** The Sky & Clouds *****

sphere { <0,0,0>,11000			// The Sky
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.0 color rgb <.1,.1,.3> ]
				[ 1.0 color rgb <.3,.3,.6> ]
				}
			turbulence 0.1
			}
		finish { ambient 0.8 }
		scale 11000
		}
	no_shadow
}

// The Clouds

sphere { <0,0,0>,10000
	texture {
		pigment {
			bozo
			color_map { 
				[0.6 color Clear]
				[0.85 color red 0.8 green 0.9 blue 0.9]
				[1.0 color White]
			}
			turbulence 1.2
			scale 5000
		}
		finish {
			ambient 1.0
			diffuse 0.2
		}
	}
	rotate x*30
	no_shadow
}

// ***** Pieces of the Tower *****

#declare Elevator=
union {
	difference {
		cylinder { <0,0,0>,<0,1000,0>,35 }
		box { <0,0,-7>,<40,1000,7> rotate y*60 }
		box { <0,0,-7>,<40,1000,7> rotate y*180 }
		box { <0,0,-7>,<40,1000,7> rotate y*300 }
		texture { Concrete_Texture }
	}
	cylinder { <0,0,0>,<0,1000,0>,32 
		texture {
			pigment {
                                gradient y
				color_map {
                                        [0.0 color Gray70 ]
                                        [0.1 color Gray70 ]
                                        [0.1 color rgb<0.3,0.3,0.6> ]
                                        [1.0 color rgb<0.3,0.3,0.6> ]
				}
				scale 10
			}
		}
	}
}

#declare Tower_Third=
union{
	cylinder { <100,0,  0>,<10 ,1100,  0>, 20 }
	triangle { < 10,0,-20>,<100,   0,-20>,<10,1100,-20> }
	triangle { < 10,0, 20>,<100,   0, 20>,<10,1100, 20> }
        cylinder { < 90,200,0>,<120,200,0>,.5 }		// Aircraft Warning 200" Intervals
        cylinder { < 70,400,0>,<100,400,0>,.5 }
        cylinder { < 50,600,0>,<80,600,0>,.5 }
        cylinder { < 30,800,0>,<60,800,0>,.5 }
	texture { Concrete_Texture }
}

#declare Triangular_SkyPod_Brace=
union {
	triangle { <30,970,-1>,<30,990,-1>,<60,990,-1> }
	triangle { <30,970, 1>,<30,990, 1>,<60,990, 1> }
	cylinder { <30,970,0>,<60,990,0>,1 }
	texture { Concrete_Texture }
}

#declare SkyPod=
union {
      object {								// Microwave Ring
		torus {80,20 sturm}
		pigment { color White }
		translate <0,1000,0>
	}
	object {							// Microwave Ring Support
		torus {80,1 sturm}
		texture { Concrete_Texture }
		translate <0,980,0>
	}
	object { Triangular_SkyPod_Brace }
	object { Triangular_SkyPod_Brace rotate y*20 }
	object { Triangular_SkyPod_Brace rotate y*40 }
	object { Triangular_SkyPod_Brace rotate y*60 }
	object { Triangular_SkyPod_Brace rotate y*80 }
	object { Triangular_SkyPod_Brace rotate y*100 }
	object { Triangular_SkyPod_Brace rotate y*120 }
	object { Triangular_SkyPod_Brace rotate y*140 }
	object { Triangular_SkyPod_Brace rotate y*160 }
	object { Triangular_SkyPod_Brace rotate y*180 }
	object { Triangular_SkyPod_Brace rotate y*200 }
	object { Triangular_SkyPod_Brace rotate y*220 }
	object { Triangular_SkyPod_Brace rotate y*240 }
	object { Triangular_SkyPod_Brace rotate y*260 }
	object { Triangular_SkyPod_Brace rotate y*280 }
	object { Triangular_SkyPod_Brace rotate y*300 }
	object { Triangular_SkyPod_Brace rotate y*320 }
	object { Triangular_SkyPod_Brace rotate y*340 }
	cylinder { <0, 985,0>,<0,1020,0>,80      pigment { Black }            }  //Microwave Ring Interior
	cylinder { <0,1020,0>,<0,1075,0>,80      pigment { Gray50}            }  //SkyPod Core
	cylinder { <0,1000,0>,<0,1030,0>,105     texture { Concrete_Texture } }  //Below Level 1
	cone     { <0,1020,0>,100,<0,1040,0>,110 pigment { Radial_Window }    }  //Level 1 Observation Deck
	cylinder { <0,1040,0>,<0,1045,0>,110     texture { Concrete_Texture } }  //Divider
	cylinder { <0,1045,0>,<0,1060,0>,110     pigment { Radial_Window }    }  //Level 2 Observation Deck
	cylinder { <0,1075,0>,<0,1080,0>,110     pigment { White }            }  //Lower Ramp
	cone     { <0,1080,0>,100,<0,1110,0>,70  pigment { White }            }  //White Ramp
	cylinder { <0,1105,0>,<0,1110,0>,75      pigment { color red 1.0 }    }  //Upper Ramp Stripe
	cylinder { <0,1110,0>,<0,1150,0>,75      pigment { White }            }  //Upper Ramp
}

#declare Tower_Top=
union {
	cylinder { <0,1150,0>,<0,1425,0>,30    texture { Concrete_Texture } } // Grey Tower Base
	cone     { <0,1425,0>,30,<0,1450,0>,35 pigment { Radial_Window    } } // Windowed SpaceDeck
	cylinder { <0,1450,0>,<0,1470,0>,35    texture { Concrete_Texture } } // Middle SpaceDeck
	cone     { <0,1470,0>,35,<0,1490,0>,25 pigment { White }            } // Top SpaceDeck
	cylinder { <0,1490,0>,<0,1650,0>,25    pigment { White }            } // Lower Antennae
	cone     { <0,1650,0>,25,<0,1670,0>,20 pigment { Black }            } // Taper
	cylinder { <0,1670,0>,<0,1700,0>,20    pigment { White }            } // Middle Antennae
	cone     { <0,1700,0>,20,<0,1720,0>,10 pigment { Black }            } // Taper
	cylinder { <0,1720,0>,<0,1750,0>,10    pigment { White }            } // Upper Antennae
	cone     { <0,1750,0>,10,<0,1770,0>,3  pigment { Black }            } // Taper
	cylinder { <0,1770,0>,<0,1815,0>,3     pigment { Black }            } // Top 'o the Tower
}

// ***** The Actual Tower *****

union {
	object { Elevator }
	object { Tower_Third }			// Faces East
	object { Tower_Third rotate y*120 }     // Faces SW
	object { Tower_Third rotate y*240 }     // Faces NW
	object { SkyPod }
	object { Tower_Top }
}

// ***** Windows 95 Flag *****

box { <0,0,0>,<1,1,-1>
	texture {
		pigment {
			image_map { gif "95flag.gif" interpolate 2 }
			}
		normal { bumps 0.4 }
	}
	scale <50,500,1>
	translate <-25,465,-37>
	rotate y*-30
}
