camera {
   location <0, 5, -40>
   up <0,1,0>
   direction <0,0,1>
   right < 4/3,0,0>
   look_at <0,0,0>
   }

background { color rgb <0, 0.2, 0.3> }

#include "colors.inc"

// Make a spotlight with a visible outer surface
#declare throw_length = 20
#declare throw_radius = 10
#declare throw_offset = <0, 15, 0>
#declare throw_orientation = <0, 0, -90>

// Now from the definitions of the throw lamp, calculate
// the data needed to build the object
#declare spot_point = <throw_length, 0, 0>
//#declare throw_dist = x,y,z
//#declare throw_angle = atan(throw_radius / throw_length)

// Fudge for now - the rotation function is not yet defined.
// #declare throw_point  rotate(spot_point, throw_orientation) + throw_offset
#declare throw_point = <0, -5, 0>

// Build the texture for a spotlight with a fading exterior - the exterior
// shading is sensitive to visibility of the light source as well.
#declare fading_white =
texture {
   pigment {
   gradient x
      color_map {
   [0 1.001 color White color rgbf <1,1,1,1> ]} scale <20.1,20.1,20.1> }
   //color White filter 0.8 }
   finish { ambient 0.8 diffuse 0.2 }
   }
// The next two things are coupled together - the light source
// and the cone around it to make a visible border.
light_source {
throw_offset color White
spotlight
        point_at throw_point
        tightness 3
        radius 30
        falloff 31
}

cone { <0, 0, 0>, 0.1, spot_point, throw_radius
texture {   fading_white }
   rotate throw_orientation
   translate throw_offset
no_shadow
   }

// Add a couple of other things to complete the scene
   box { <-7, 1, -5>, <7, 2, 5>
   rotate <0, 70, 0>
texture { pigment { color red 1} }
   }
//
   sphere { <0, 5, 0>, 2
texture { pigment { color Gold } }
   }

plane { y, -5.05 texture {
pigment { checker color rgb <1,1,1> color rgb <0,0,0> scale <3,3,3> }
}
}
