#declare Goldish =  texture {
	pigment { color rgb <1, 0.984, 0.36> }
	finish {
		metallic
		ambient 0.2
		diffuse 0.7
		brilliance 1.5
		phong 1
		phong_size 80
   }
}

#declare D_color = texture {
	pigment { color rgbf <0.8, 0, 0, 0.3> }
	finish {ambient 0.2 diffuse 0.8 phong 1 phong_size 50}
}

#declare Diamond = union {
	difference {
		sphere { <0, 0, 0>, 0.34
			scale <0.5, 1, 0.5>
			translate -z*1.35
			rotate -x*40
		}
		sphere {<0, 0, 0>, 1.44}
		texture {D_color}
	}
	difference {
		sphere { <0, 0, 0>, 0.38
			scale <0.5, 1, 0.5>
			translate -z*1.45
			rotate -x*40
		}
		sphere {<0, 0, 0>, 1.43}
		sphere {<0, 0, 0>, 1.454 inverse}
		texture {Goldish}
	}
	translate y*1.8
}

#declare Diamonds = union {
	object {Diamond rotate y*0}
	object {Diamond rotate y*45}
	object {Diamond rotate y*90}
	object {Diamond rotate y*135}
	object {Diamond rotate y*180}
	object {Diamond rotate y*225}
	object {Diamond rotate y*270}
	object {Diamond rotate y*315}
}

#declare Leg = union {
	difference {
		union {
			sphere {<0, 0, 0> 0.7 scale <1, 0.06, 0.06>}
			sphere {<0, 0, 0> 0.3 scale <0.08, 0.5, 1> rotate y*10}
		}
		plane {y, 0}
	}
	cylinder {<0, 0, 0>, <0, 0.02, 0>, 0.09 translate -z*0.6}
	cylinder {<0, 0, 0>, <0, 0.02, 0>, 0.09 translate z*0.6}
	difference {
		union {
			sphere {<0, 0, 0>, 0.06 scale <1, 0.5, 1> translate <0, 0.02, -0.6>}
			sphere {<0, 0, 0>, 0.06 scale <1, 0.5, 1> translate <0, 0.02, 0.6>}
		}
		plane {y, 0.02}
		texture {D_color}
	}
	sphere {<0, 0, 0> 0.35 scale <0.1, 1, 0.3> translate y*0.35}
}

#declare Base = union {
	object {Leg rotate y*0}
	object {Leg rotate y*20}
	object {Leg rotate y*40}
	object {Leg rotate y*60}
	object {Leg rotate y*80}
	object {Leg rotate y*100}
	object {Leg rotate y*120}
	object {Leg rotate y*140}
	object {Leg rotate y*160}
	difference {
		sphere {<0, 1.8, 0>, 1.45}
		plane {y, 1.8-0.45 inverse}
		texture {
			pigment {
				image_map {
					gif "ornmnt1.gif"
					filter 0, 1
					map_type 2
					interpolate 2
					once
				}
			}
			finish {
				metallic
				ambient 0.2
				diffuse 0.7
				brilliance 1.5
				phong 1
				phong_size 80
			}
			normal {
				bump_map {
					gif "ornmnt1.gif"
					map_type 2
					interpolate 2
					once
					bump_size 10
				}
			}
			rotate -y*90
			translate y*0.35
		}
	}
	cylinder {<0, 1.35, 0>, <0, 1.4, 0>, 1.32}
	object {Diamonds}
}

#declare Half = difference {
	merge {
		sphere {<0, 1.8, 0>, 1.45}
		sphere {<0, 1.8, 0>, 1.45
			translate -y*1.8 scale <1, 1.9, 1> translate y*1.8
		}
	}
	merge {
		sphere {<0, 1.8, 0>, 1.446}
		sphere {<0, 1.8, 0>, 1.446
			translate -y*1.8 scale <1, 1.9, 1> translate y*1.8
		}
	}
	plane {y, 1.35}
	plane {x, 0}
	texture {
		pigment {
			image_map {
				gif "ornmnt2.gif"
				filter 0, 1
				map_type 2
				interpolate 2
				once
			}
		}
		finish {
			metallic
			ambient 0.18
			diffuse 0.7
			brilliance 1.5
			phong 1
			phong_size 80
		}
		normal {
			bump_map {
				gif "ornmnt2.gif"
				map_type 2
				interpolate 2
				once
				bump_size 4
			}
		}
		scale <1, 3.5, 1>
		rotate -y*90
		translate y*1.35
	}
}

#declare Egg = union {
	object {Base}
	object {Half translate -z*1.33 rotate -y*30 translate <0.15, 0, 1.33>}
	object {Half rotate y*180
		translate -z*1.33 rotate y*30 translate <-0.15, 0, 1.33>
	}
	texture {Goldish}
}








