
// GPBRIDGE.POV
// (c) 1995 Greg Pape (mstgreg@cencom.net)
// For the October 1995 PoV-Ray Competition
// Enjoy!

#include "colors.inc"
#include "shapes.inc"
#include "bridge.inc"

camera{
    location <0, 0, -1000>
    look_at <0, 0, 0>
    rotate x*10
    rotate y*-45
}

light_source{ <5000, 5000, -1000> color White }
light_source{ <-750, -100, 0> color Gray50 }

#declare WaterTex = texture{
   pigment{ color rgb <.4, .4, .6> } // .3, .3, .9
   normal{
      waves 0.06
      frequency 5000.0
      scale 1000.0
   }
   finish{
      ambient 0.2
      diffuse 0.1
      reflection 0.8
   }
}

#declare SkyTex =
texture{
	pigment{
		gradient y
		color_map{
            [0.0 0.2 color rgb <1, 0, 0> color rgb <0, 0, 1>]
            [0.2 1.0 color rgb <0, 0, 1> color rgb <0, 0, 1>]
		}
	}
}
texture{
	pigment{
		bozo
		turbulence 0.5
		lambda 6
		color_map  {
			[0.0 0.1 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
			[0.70 color rgbf <4/5, 4/5, 5/6, 0.65>]
			[1.0 color rgbf <1, 1, 1, 0.65>]
		}
	}
	finish { ambient 1 }
	scale 0.15
}


//////////////////////////////////////////////////////////////////////

object{
    Bridge
    finish{ ambient .5 }
    translate <250, 0, 0>
}

// Sky
sphere{
    <0, 0, 0> 100000
    texture{ SkyTex scale <300000, 100000, 100000>}
}

// Water
plane{
    y, -65
    texture{
        WaterTex
        scale 2.5*<100, 100, 100>
    }
}

#declare LandTex = texture{
pigment{
    marble
    turbulence 1
    color_map{
        [0.0 1.0 color rgb <.3, .5, .4> color rgb <.2, .4, .3>]
    }
}}

#declare Land = object{
height_field{
    gif "frac1.gif"
    translate <-.5, -.5, -.5>
    smooth
}
texture{ LandTex scale <500, 500, 500> }
}

object{
    Land
    finish{ ambient .5 }
    rotate z*-15
    scale <12000, 1000, 7000>
    translate <0, -300, 6000>
    rotate y*-60
}
