// This is a Persistence of Vision Ray Tracer (POV-Ray) Version 2.XXX Scene file
//             POV-Ray is (Copyrighted) 1994 POV-Ray Team!
// This file was created using "Mid Night Modeller" Version 2.0
//             MNM is (Copyright) 1994-95 David R.Taylor

// FILE CREATED 2-10-1995
// BY T. PAUL ALTHAUSER  paulalt@msn.com 





//****************** HEADER **********************
#include "colors.inc"
#include "textures.inc"


//****************** CAMERA **********************

camera {
    location <-15, 10, -30>
   direction <0, 0, 1.25>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.3333, 0, 0>
     look_at <0, 10, -1>
}

//****************** LIGHTS **********************


light_source {
   <5,20,-45> color White
   area_light 5*x 1*y 5,5
   jitter
}

light_source {
   <-5,35,-25> color White
   spotlight
   point_at <0,5,0>
   falloff 160
   radius 90
   tightness 25
}

//***************** TEXTURES *********************

#declare Grassy = texture {
			pigment { color DarkGreen}
			finish { ambient 0.4 crand 0.2}
}

#declare Dirt = texture {
			pigment { color DarkTan}
			finish { ambient 0.6 crand 0.6}
}


// Gold_Marble designed by T. Paul Althauser
// brown/tan/red marble with gold veining

#declare GldVein =
texture {
	pigment {
		marble
		turbulence 0.65
		color_map {
			[0.0, 0.02 color Gold color Gold]
			[0.02, 1.0 color Clear color Clear]
			}}
	finish { metallic }
}
#declare BrMarble =
texture {
    pigment {
	marble
	turbulence 0.9
	color_map {
	    [0  color Brown]
	    [0.01  color DarkTan]
	    [0.06  color Burnt_Sienna]
	    [0.08  color Sienna]
	    [0.1  color DarkTan]
	    [0.3  color Sienna]
	    [0.5  color Brown]
	    [0.8  color DarkTan]
	}
    }
}
#declare Crack =
texture {
	pigment {
		marble
		turbulence 0.75
		color_map {
			[0.0,0.125 color Clear color Clear]
			[0.125,0.15 color Black color Black]
			[0.15,1.0 color Clear color Clear]
			}
		}
}
#declare Gold_Marble =
texture { BrMarble scale <2,2,2>
      finish { phong 1.0 phong_size 250 }
		}
texture { Crack scale 0.65 rotate <5,25,-5>
	finish { specular 0.5 roughness 0.005 }
}
texture { GldVein scale 0.35 rotate <15,45,0>
	finish { specular 0.3 roughness 0.015 }

}


// Another Custom Texture
//Gray marble with a silver vein

#declare SilVein =
texture {
	pigment {
		marble
		turbulence 0.65
		color_map {
			[0.0, 0.03 color Silver color Black]
			[0.03, 1.0 color Clear color Clear]
			}}
	finish { metallic }
}
#declare GMarble =
 texture {
	pigment {
		marble
		turbulence .85
			color_map {
		[0.0, 0.4   color Slate_Grey_Dark  color Slate_Grey]
		[0.8, 0.9   color Slate_Grey_Light  color Slate_Grey]
		[0.9, 1.001 color Slate_Grey  color LightGrey]
		}}
    finish { specular 0.4 roughness 0.025}
}
#declare Gray_Marble =
  texture {GMarble scale 2 rotate <0,30,0>}
  texture {SilVein}

//These textures were taken from stones.inc

#declare Grnt22 =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.07 color White color White]
    [0.07, 0.2 color White color DimGray]
    [0.2, 0.3 color DimGray color Clear]
    [0.3, 0.7 color Clear color Clear]
    [0.7, 1.0 color Clear color DimGray]
   }
 }
 finish {
  crand 0.02
 }
 }

#declare Grnt25 =
texture {
pigment
 {marble
  turbulence 0.7
  color_map
   {[0.000, 0.168   color rgbf <0.824, 0.725, 0.584, 0.000>
                    color rgbf <0.514, 0.584, 0.533, 0.000>]
    [0.168, 0.301   color rgbf <0.514, 0.584, 0.533, 0.000>
                    color rgbf <0.298, 0.376, 0.318, 0.000>]
    [0.301, 0.398   color rgbf <0.298, 0.376, 0.318, 0.000>
                    color rgbf <0.263, 0.337, 0.282, 0.000>]
    [0.398, 0.558   color rgbf <0.263, 0.337, 0.282, 0.000>
                    color rgbf <0.431, 0.506, 0.451, 0.000>]
    [0.558, 0.655   color rgbf <0.431, 0.506, 0.451, 0.000>
                    color rgbf <0.529, 0.631, 0.471, 0.000>]
    [0.655, 0.735   color rgbf <0.529, 0.631, 0.471, 0.000>
                    color rgbf <0.333, 0.376, 0.318, 0.000>]
    [0.735, 0.823   color rgbf <0.333, 0.376, 0.318, 0.000>
                    color rgbf <0.298, 0.376, 0.318, 0.000>]
    [0.823, 0.876   color rgbf <0.298, 0.376, 0.318, 0.000>
                    color rgbf <0.416, 0.376, 0.318, 0.000>]
    [0.876, 0.929   color rgbf <0.416, 0.376, 0.318, 0.000>
                    color rgbf <0.416, 0.376, 0.318, 0.000>]
    [0.929, 1.001   color rgbf <0.416, 0.376, 0.318, 0.000>
                    color rgbf <0.824, 0.725, 0.584, 0.000>]
   }
 }
 }

#declare Grnt28 =
texture {
pigment
 {marble
  turbulence 0.7
  color_map
   {[0.000, 0.155   color rgbf <0.686, 0.235, 0.282, 0.000>
                    color rgbf <0.686, 0.235, 0.282, 0.000>]
    [0.155, 0.328   color rgbf <0.686, 0.235, 0.282, 0.000>
                    color rgbf <0.494, 0.243, 0.294, 0.000>]
    [0.328, 0.474   color rgbf <0.494, 0.243, 0.294, 0.000>
                    color rgbf <0.769, 0.329, 0.373, 0.000>]
    [0.474, 0.647   color rgbf <0.769, 0.329, 0.373, 0.000>
                    color rgbf <0.769, 0.329, 0.373, 0.000>]
    [0.647, 0.810   color rgbf <0.769, 0.329, 0.373, 0.000>
                    color rgbf <0.686, 0.235, 0.282, 0.000>]
    [0.810, 0.922   color rgbf <0.686, 0.235, 0.282, 0.000>
                    color rgbf <0.792, 0.388, 0.427, 0.000>]
    [0.922, 1.001   color rgbf <0.792, 0.388, 0.427, 0.000>
                    color rgbf <0.686, 0.235, 0.282, 0.000>]
   }
 }
 finish {
  crand 0.03
 }
 }

#declare Grnt3a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.153   color rgbf <0.831, 0.631, 0.569, 0.447>
                    color rgbf <0.925, 0.831, 0.714, 0.678>]
    [0.153, 0.297   color rgbf <0.925, 0.831, 0.714, 0.678>
                    color rgbf <0.871, 0.702, 0.659, 0.475>]
    [0.297, 0.441   color rgbf <0.871, 0.702, 0.659, 0.475>
                    color rgbf <0.831, 0.631, 0.569, 0.918>]
    [0.441, 0.763   color rgbf <0.831, 0.631, 0.569, 0.918>
                    color rgbf <0.937, 0.882, 0.820, 0.655>]
    [0.763, 1.001   color rgbf <0.937, 0.882, 0.820, 0.655>
                    color rgbf <0.831, 0.631, 0.569, 0.447>]
   }
 }
 }

#declare Grnt17a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.034   color rgbf <0.027, 0.012, 0.012, 0.000>
                    color rgbf <0.851, 0.812, 0.741, 0.235>]
    [0.034, 0.342   color rgbf <0.851, 0.812, 0.741, 0.235>
                    color rgbf <0.792, 0.694, 0.690, 0.839>]
    [0.342, 0.462   color rgbf <0.792, 0.694, 0.690, 0.839>
                    color rgbf <0.631, 0.506, 0.471, 0.608>]
    [0.462, 0.632   color rgbf <0.631, 0.506, 0.471, 0.608>
                    color rgbf <0.851, 0.812, 0.741, 0.922>]
    [0.632, 0.983   color rgbf <0.851, 0.812, 0.741, 0.922>
                    color rgbf <0.647, 0.655, 0.655, 0.282>]
    [0.983, 1.001   color rgbf <0.647, 0.655, 0.655, 0.282>
                    color rgbf <0.027, 0.012, 0.012, 0.000>]
   }
 }
 }

#declare Grnt23a =
texture {
pigment
 {granite
  color_map
   {[0.000, 0.168   color rgbf <0.824, 0.725, 0.584, 0.600>
                    color rgbf <0.514, 0.584, 0.533, 0.600>]
    [0.168, 0.301   color rgbf <0.514, 0.584, 0.533, 0.600>
                    color rgbf <0.298, 0.376, 0.318, 0.600>]
    [0.301, 0.398   color rgbf <0.298, 0.376, 0.318, 0.600>
                    color rgbf <0.263, 0.337, 0.282, 0.700>]
    [0.398, 0.558   color rgbf <0.263, 0.337, 0.282, 0.700>
                    color rgbf <0.431, 0.506, 0.451, 0.600>]
    [0.558, 0.655   color rgbf <0.431, 0.506, 0.451, 0.600>
                    color rgbf <0.529, 0.631, 0.471, 0.500>]
    [0.655, 0.735   color rgbf <0.529, 0.631, 0.471, 0.500>
                    color rgbf <0.333, 0.376, 0.318, 0.700>]
    [0.735, 0.823   color rgbf <0.333, 0.376, 0.318, 0.700>
                    color rgbf <0.298, 0.376, 0.318, 0.600>]
    [0.823, 0.876   color rgbf <0.298, 0.376, 0.318, 0.600>
                    color rgbf <0.416, 0.376, 0.318, 0.500>]
    [0.876, 0.929   color rgbf <0.416, 0.376, 0.318, 0.500>
                    color rgbf <0.416, 0.376, 0.318, 0.600>]
    [0.929, 1.001   color rgbf <0.416, 0.376, 0.318, 0.600>
                    color rgbf <0.824, 0.725, 0.584, 0.700>]
   }
 }
 }

#declare Crack4 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.03 color White filter 0.3 color White filter 1.0]
    [0.03, 0.97 color Black filter 0.70 color DimGray filter 0.90]
    [0.97, 1.001 color White filter 0.9 color White filter 1.0]
   }
 }
 }

#declare Stone10 =
texture{pigment{color Black}}
texture{Grnt17a scale <3, 6, 2> rotate <0, 0, 50>}
texture{Grnt3a scale <1, 2, 1> rotate <0, 0, -50>
        finish{phong 1.0 phong_size 90}
}

#declare Stone21 =
texture{Grnt28 scale <1.3, 2.5, 1.7> rotate <0, 0, 40>}
texture{Grnt22 scale <1, 2, 2> rotate <0, 0, 40>}
texture{Crack4 scale <1, 0.6, 1> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

#declare Stone24 =
texture{Grnt25 scale <1, 1, 2> rotate <0, 0, 50> rotate <20, 0, 30>}
texture{Grnt23a scale <2, 1, 2> rotate <40, 0, 0> rotate <0, 0, -30>}
texture{pigment{color Gray filter 0.8}
        finish{phong 1.0 phong_size 90} //   tint to liking
}


//****************** DEFINES *********************

#declare H1_Box = box { // LAYER: Environment
    <0.0, 0.0, 0.0>, <200, -1, 150>
    translate <-100, -2.5, -52>
}

#declare H2_Box = box { // LAYER: ColumnBases
    <0.0, 0.0, 0.0>, <2.5, 1, 2.5>
    translate <1.25, -1, -1.25>
}

#declare H3_Box = box { // LAYER: ColumnBases
    <0.0, 0.0, 0.0>, <2.5, 1, 2.5>
    translate <5.75, -1, -1.25>
}

#declare H4_Box = box { // LAYER: ColumnBases
    <0.0, 0.0, 0.0>, <2.5, 1, 2.5>
    translate <-3.75, -1, -1.25>
}

#declare H5_Box = box { // LAYER: ColumnBases
    <0.0, 0.0, 0.0>, <2.5, 1, 2.5>
    translate <-8.25, -1, -1.25>
}

#declare H6_Cone = cone { // LAYER: ColumnBases
    <0.0, 0.0, 0.0>, 1, <0.25, 0.0, 0.0>, 1
    rotate <.0, .0, -270>
    translate <2.5, 0, 0>
}

#declare H7_Torus = torus { // LAYER: ColumnBases
    1, 0.25 sturm
    translate <2.5, 0.5, 0>
}

#declare H8_Cone = cone { // LAYER: ColumnBases
    <0.0, 0.0, 0.0>, 1, <0.25, 0.0, 0.0>, 0.75
    rotate <.0, .0, -270>
    translate <2.5, 0.75, 0>
}

#declare H9_Torus = torus { // LAYER: ColumnBases
    0.75, 0.125 sturm
    translate <2.5, 1.125, 0>
}

#declare H10_Cone = cone { // LAYER: ColumnBases
    <0.0, 0.0, 0.0>, 1, <0.25, 0.0, 0.0>, 1
    rotate <.0, .0, -270>
    translate <7, 0, 0>
}

#declare H11_Cone = cone { // LAYER: ColumnBases
    <0.0, 0.0, 0.0>, 1, <0.25, 0.0, 0.0>, 1
    rotate <.0, .0, -270>
    translate <-2.5, 0, 0>
}

#declare H12_Torus = torus { // LAYER: ColumnBases
    1, 0.25 sturm
    translate <-2.5, 0.5, 0>
}

#declare H13_Cone = cone { // LAYER: ColumnBases
    <0.0, 0.0, 0.0>, 1, <0.25, 0.0, 0.0>, 0.75
    rotate <.0, .0, -270>
    translate <-2.5, 0.75, 0>
}

#declare H14_Torus = torus { // LAYER: ColumnBases
    0.75, 0.125 sturm
    translate <-7, 1.125, 0>
}

#declare H15_Cone = cone { // LAYER: ColumnBases
    <0.0, 0.0, 0.0>, 1, <0.25, 0.0, 0.0>, 0.75
    rotate <.0, .0, -270>
    translate <-7, 0.75, 0>
}

#declare H16_Torus = torus { // LAYER: ColumnBases
    1, 0.25 sturm
    translate <-7, 0.5, 0>
}

#declare H17_Cone = cone { // LAYER: ColumnBases
    <0.0, 0.0, 0.0>, 1, <0.25, 0.0, 0.0>, 1
    rotate <.0, .0, -270>
    translate <-7, 0, 0>
}

#declare H18_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.75, <3.75, 0.0, 0.0>, 0.75
    rotate <.0, .0, -270>
    translate <-7, 1.25, 0>
}

#declare H19_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-6.25, 2, 0>
}

#declare H20_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <-6.25, 2, 0>
}

#declare H21_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-7, 2, -0.75>
}

#declare H22_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <-7, 2, -0.75>
}

#declare H23_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-7, 2, 0.75>
}

#declare H24_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <-7, 2, 0.75>
}

#declare H25_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-7.7244, 2, -0.1941>
}

#declare H26_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <-7.7244, 2, -0.1941>
}

#declare H27_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-6.8059, 2, -0.7244>
}

#declare H28_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <-6.8059, 2, -0.7244>
}

#declare H29_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-6.2756, 2, 0.1941>
}

#declare H30_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <-6.2756, 2, 0.1941>
}

#declare H31_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-7.1941, 2, 0.7244>
}

#declare H32_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <-7.1941, 2, 0.7244>
}

#declare H33_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-7.375, 2, 0.6495>
}

#declare H34_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <-7.375, 2, 0.6495>
}

#declare H35_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-6.3505, 2, 0.375>
}

#declare H36_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <-6.3505, 2, 0.375>
}

#declare H37_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-6.625, 2, -0.6495>
}

#declare H38_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <-6.625, 2, -0.6495>
}

#declare H39_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-7.6495, 2, -0.375>
}

#declare H40_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <-7.6495, 2, -0.375>
}

#declare H41_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-6.4697, 2, 0.5303>
}

#declare H42_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <-6.4697, 2, 0.5303>
}

#declare H43_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-7.5303, 2, -0.5303>
}

#declare H44_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <-7.5303, 2, -0.5303>
}

#declare H45_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-7.5303, 2, 0.5303>
}

#declare H46_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <-7.5303, 2, 0.5303>
}

#declare H47_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-6.4697, 2, -0.5303>
}

#declare H48_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <-6.4697, 2, -0.5303>
}

#declare H49_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.6495, 2, 0.375>
}

#declare H50_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-7.6495, 2, 0.375>
}

#declare H51_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.3505, 2, -0.375>
}

#declare H52_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-6.3505, 2, -0.375>
}

#declare H53_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.625, 2, 0.6495>
}

#declare H54_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-6.625, 2, 0.6495>
}

#declare H55_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.375, 2, -0.6495>
}

#declare H56_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-7.375, 2, -0.6495>
}

#declare H57_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.7244, 2, 0.1941>
}

#declare H58_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-7.7244, 2, 0.1941>
}

#declare H59_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.2756, 2, -0.1941>
}

#declare H60_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-6.2756, 2, -0.1941>
}

#declare H61_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <-7.75, 2, 0>
}

#declare H62_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-7.75, 2, 0>
}

#declare H63_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.8059, 2, 0.7244>
}

#declare H64_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-6.8059, 2, 0.7244>
}

#declare H65_Sphere = sphere { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-7.1941, 2, -0.7244>
}

#declare H66_Cone = cone { // LAYER: ShaftSection1
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7, 1, 0>
}

#declare H67_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.75, <3, 0.0, 0.0>, 0.75
    rotate <.0, .0, -270>
    translate <-7, 5, 0>
}

#declare H68_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.1941, 5, -0.7244>
}

#declare H69_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.8059, 5, 0.7244>
}

#declare H70_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-7.75, 5, 0>
}

#declare H71_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.2756, 5, -0.1941>
}

#declare H72_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.7244, 5, 0.1941>
}

#declare H73_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.375, 5, -0.6495>
}

#declare H74_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.625, 5, 0.6495>
}

#declare H75_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.3505, 5, -0.375>
}

#declare H76_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.6495, 5, 0.375>
}

#declare H77_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-6.4697, 5, -0.5303>
}

#declare H78_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-7.5303, 5, 0.5303>
}

#declare H79_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-7.5303, 5, -0.5303>
}

#declare H80_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-6.4697, 5, 0.5303>
}

#declare H81_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-7.6495, 5, -0.375>
}

#declare H82_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-6.625, 5, -0.6495>
}

#declare H83_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-6.3505, 5, 0.375>
}

#declare H84_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-7.375, 5, 0.6495>
}

#declare H85_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-7.1941, 5, 0.7244>
}

#declare H86_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-6.2756, 5, 0.1941>
}

#declare H87_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-6.8059, 5, -0.7244>
}

#declare H88_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-7.7244, 5, -0.1941>
}

#declare H89_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-7, 5, 0.75>
}

#declare H90_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-7, 5, -0.75>
}

#declare H91_Cone = cone { // LAYER: ShaftSection2
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-6.25, 5, 0>
}

#declare H92_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-6.25, 8, 0>
}

#declare H93_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-7, 8, -0.75>
}

#declare H94_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-7, 8, 0.75>
}

#declare H95_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-7.7244, 8, -0.1941>
}

#declare H96_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-6.8059, 8, -0.7244>
}

#declare H97_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-6.2756, 8, 0.1941>
}

#declare H98_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-7.1941, 8, 0.7244>
}

#declare H99_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-7.375, 8, 0.6495>
}

#declare H100_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-6.3505, 8, 0.375>
}

#declare H101_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-6.625, 8, -0.6495>
}

#declare H102_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-7.6495, 8, -0.375>
}

#declare H103_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-6.4697, 8, 0.5303>
}

#declare H104_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-7.5303, 8, -0.5303>
}

#declare H105_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-7.5303, 8, 0.5303>
}

#declare H106_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-6.4697, 8, -0.5303>
}

#declare H107_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.6495, 8, 0.375>
}

#declare H108_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.3505, 8, -0.375>
}

#declare H109_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.625, 8, 0.6495>
}

#declare H110_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.375, 8, -0.6495>
}

#declare H111_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.7244, 8, 0.1941>
}

#declare H112_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.2756, 8, -0.1941>
}

#declare H113_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-7.75, 8, 0>
}

#declare H114_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.8059, 8, 0.7244>
}

#declare H115_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.1941, 8, -0.7244>
}

#declare H116_Cone = cone { // LAYER: ShaftSection3
    <0.0, 0.0, 0.0>, 0.75, <3, 0.0, 0.0>, 0.75
    rotate <.0, .0, -270>
    translate <-7, 8, 0>
}

#declare H117_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.75, <4, 0.0, 0.0>, 0.75
    rotate <.0, .0, -270>
    translate <-7, 11, 0>
}

#declare H118_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-7.1941, 14, -0.7244>
}

#declare H119_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-6.8059, 14, 0.7244>
}

#declare H120_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <-7.75, 14, 0>
}

#declare H121_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-6.2756, 14, -0.1941>
}

#declare H122_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-7.7244, 14, 0.1941>
}

#declare H123_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-7.375, 14, -0.6495>
}

#declare H124_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-6.625, 14, 0.6495>
}

#declare H125_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-6.3505, 14, -0.375>
}

#declare H126_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-7.6495, 14, 0.375>
}

#declare H127_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <-6.4697, 14, -0.5303>
}

#declare H128_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <-7.5303, 14, 0.5303>
}

#declare H129_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <-7.5303, 14, -0.5303>
}

#declare H130_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <-6.4697, 14, 0.5303>
}

#declare H131_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <-7.6495, 14, -0.375>
}

#declare H132_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <-6.625, 14, -0.6495>
}

#declare H133_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <-6.3505, 14, 0.375>
}

#declare H134_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <-7.375, 14, 0.6495>
}

#declare H135_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <-7.1941, 14, 0.7244>
}

#declare H136_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <-6.2756, 14, 0.1941>
}

#declare H137_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <-6.8059, 14, -0.7244>
}

#declare H138_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <-7.7244, 14, -0.1941>
}

#declare H139_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <-7, 14, 0.75>
}

#declare H140_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <-7, 14, -0.75>
}

#declare H141_Sphere = sphere { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <-6.25, 14, 0>
}

#declare H142_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.1941, 11, -0.7244>
}

#declare H143_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.8059, 11, 0.7244>
}

#declare H144_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-7.75, 11, 0>
}

#declare H145_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.2756, 11, -0.1941>
}

#declare H146_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.7244, 11, 0.1941>
}

#declare H147_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.375, 11, -0.6495>
}

#declare H148_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.625, 11, 0.6495>
}

#declare H149_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-6.3505, 11, -0.375>
}

#declare H150_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-7.6495, 11, 0.375>
}

#declare H151_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-6.4697, 11, -0.5303>
}

#declare H152_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-7.5303, 11, 0.5303>
}

#declare H153_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-7.5303, 11, -0.5303>
}

#declare H154_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-6.4697, 11, 0.5303>
}

#declare H155_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-7.6495, 11, -0.375>
}

#declare H156_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-6.625, 11, -0.6495>
}

#declare H157_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-6.3505, 11, 0.375>
}

#declare H158_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-7.375, 11, 0.6495>
}

#declare H159_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-7.1941, 11, 0.7244>
}

#declare H160_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-6.2756, 11, 0.1941>
}

#declare H161_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-6.8059, 11, -0.7244>
}

#declare H162_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-7.7244, 11, -0.1941>
}

#declare H163_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-7, 11, 0.75>
}

#declare H164_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-7, 11, -0.75>
}

#declare H165_Cone = cone { // LAYER: ShaftSection4
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-6.25, 11, 0>
}

#declare H166_Torus = torus { // LAYER: Capitals
    1.25, 0.0625 sturm
    translate <-2.5, 16.8125, 0>
}

#declare H167_Torus = torus { // LAYER: Capitals
    0.75, 0.0625 sturm
    translate <-2.5, 15.0625, 0>
}

#declare H168_Torus = torus { // LAYER: Capitals
    0.75, 0.0625 sturm
    translate <-2.5, 16.0625, 0>
}

#declare H169_Cone = cone { // LAYER: Capitals
    <0.0, 0.0, 0.0>, 0.75, <1.25, 0.0, 0.0>, 0.75
    rotate <.0, .0, -270>
    translate <-2.5, 15, 0>
}


#declare H171_Torus = torus { // LAYER: Capitals
    1.25, 0.0625 sturm
    translate <-7, 16.8125, 0>
}


#declare H173_Cone = cone { // LAYER: Capitals
    <0.0, 0.0, 0.0>, 0.75, <1.25, 0.0, 0.0>, 0.75
    rotate <.0, .0, -270>
    translate <-7, 15, 0>
}

#declare H174_Torus = torus { // LAYER: Capitals
    0.75, 0.0625 sturm
    translate <-7, 16.0625, 0>
}

#declare H175_Torus = torus { // LAYER: Capitals
    0.75, 0.0625 sturm
    translate <-7, 15.0625, 0>
}


#declare B2_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 1, 0.125>
    translate <-7.5, 18.125, 0.75>
}

#declare B3_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 1, 0.125>
    translate <-3, 18.125, 0.75>
}

#declare B4_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 1, 0.125>
    translate <-5.25, 18.125, 0.75>
}

#declare B5_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <0.25, 0.25, 0.5>
    translate <-7.125, 19.375, 0.75>
}

#declare B6_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <0.25, 0.25, 0.5>
    translate <-4.875, 19.375, 0.75>
}

#declare B7_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <0.25, 0.25, 0.5>
    translate <-2.625, 19.375, 0.75>
}

#declare B8_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 0.125, 0.25>
    translate <-7.5, 17.875, 0.625>
}

#declare B9_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 0.125, 0.25>
    translate <-5.25, 17.875, 0.625>
}

#declare B10_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 0.125, 0.25>
    translate <-3, 17.875, 0.625>
}

#declare B11_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-7.375, 17.75, 0.75>
}

#declare B12_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-7.125, 17.75, 0.75>
}

#declare B13_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-6.875, 17.75, 0.75>
}

#declare B14_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-6.625, 17.75, 0.75>
}

#declare B15_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-4.375, 17.75, 0.75>
}

#declare B16_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-4.625, 17.75, 0.75>
}

#declare B17_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-4.875, 17.75, 0.75>
}

#declare B18_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-5.125, 17.75, 0.75>
}

#declare B19_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-2.875, 17.75, 0.75>
}

#declare B20_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-2.625, 17.75, 0.75>
}

#declare B21_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-2.375, 17.75, 0.75>
}

#declare B22_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-2.125, 17.75, 0.75>
}

#declare B23_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <0.25, 0.25, 0.5>
    translate <-6, 19.375, 0.75>
}

#declare B24_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <0.25, 0.25, 0.5>
    translate <-3.75, 19.375, 0.75>
}

#declare B25_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <0.25, 0.25, 0.5>
    translate <-1.5, 19.375, 0.75>
}

#declare B26_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <0.25, 0.25, 0.5>
    translate <-1.5, 19.375, -1.25>
}

#declare B27_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <0.25, 0.25, 0.5>
    translate <-3.75, 19.375, -1.25>
}

#declare B28_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <0.25, 0.25, 0.5>
    translate <-6, 19.375, -1.25>
}

#declare B29_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <18, 0.5, 4>
    translate <-9, -1.5, -2>
}

#declare B30_Faces = union { // LAYER: Architrave
    smooth_triangle {<-8.375, 19.625, 1.125>, <-0.2812, -1.1719, 0.8906>,
                     <-8.125, 19.375, 0.875>, <-0.3333, -0.9271, 0.5938>,
                     <-1, 19.375, 0.875>, <0, -1.7812, 1.7812> }
    smooth_triangle {<-1, 19.375, 0.875>, <0, -1.8438, 1.8438>,
                     <-1, 19.625, 1.125>, <0, -1.8438, 1.8438>,
                     <-8.375, 19.625, 1.125>, <-0.2812, -1.2031, 0.9219> }
    smooth_triangle {<-8.375, 19.625, -1.125>, <-0.2188, -1.1406, -0.9219>,
                     <-8.125, 19.375, -0.875>, <-0.1458, -1.3542, -1.2083>,
                     <-8.125, 19.375, 0.875>, <-0.2188, -1.1094, 0.8906> }
    smooth_triangle {<-8.125, 19.375, 0.875>, <-0.2812, -1.1719, 0.8906>,
                     <-8.375, 19.625, 1.125>, <-0.1875, -1.3958, 1.2083>,
                     <-8.375, 19.625, -1.125>, <-0.2812, -1.2031, -0.9219> }
    smooth_triangle {<-8.125, 19.375, -0.875>, <-0.2188, -1.1406, -0.9219>,
                     <-8.375, 19.625, -1.125>, <-0.3333, -0.9479, -0.6146>,
                     <-1, 19.625, -1.125>, <0, -1.8438, -1.8438> }
    smooth_triangle {<-1, 19.625, -1.125>, <0, -1.7812, -1.7812>,
                     <-1, 19.375, -0.875>, <0, -1.7812, -1.7812>,
                     <-8.125, 19.375, -0.875>, <-0.2188, -1.1094, -0.8906> }
}

#declare B31_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <7.75, 0.125, 3>
    translate <-8.75, 19.625, -1.5>
}

#declare B32_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1.75, 0.25, -0.125>
    rotate <.0, 270, .0>
    translate <-8.125, 19.125, -0.875>
}

#declare B33_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 1, 0.125>
    rotate <.0, 90, .0>
    translate <-8.125, 18.125, 0.5>
}

#declare B34_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <0.25, 0.25, 0.5>
    rotate <.0, 90, .0>
    translate <-8.5, 19.375, 0.125>
}

#declare B35_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 0.125, 0.25>
    rotate <.0, 90, .0>
    translate <-8.125, 17.875, 0.5>
}

#declare B36_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    rotate <.0, 90, .0>
    translate <-8, 17.75, 0.375>
}

#declare B37_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    rotate <.0, 90, .0>
    translate <-8, 17.75, 0.125>
}

#declare B38_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    rotate <.0, 90, .0>
    translate <-8, 17.75, -0.125>
}

#declare B39_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    rotate <.0, 90, .0>
    translate <-8, 17.75, -0.375>
}

#declare B40_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-2.125, 17.75, -0.75>
}

#declare B41_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-2.375, 17.75, -0.75>
}

#declare B42_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-2.625, 17.75, -0.75>
}

#declare B43_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-2.875, 17.75, -0.75>
}

#declare B44_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-5.125, 17.75, -0.75>
}

#declare B45_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-4.875, 17.75, -0.75>
}

#declare B46_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-4.625, 17.75, -0.75>
}

#declare B47_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-4.375, 17.75, -0.75>
}

#declare B48_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-6.625, 17.75, -0.75>
}

#declare B49_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-6.875, 17.75, -0.75>
}

#declare B50_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-7.125, 17.75, -0.75>
}

#declare B51_Cone = cone { // LAYER: Architrave
    <0.0, 0.0, 0.0>, 0.125, <0.25, 0.0, 0.0>, 0
    rotate <.0, .0, -270>
    translate <-7.375, 17.75, -0.75>
}

#declare B52_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 0.125, 0.25>
    translate <-3, 17.875, -0.875>
}

#declare B53_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 0.125, 0.25>
    translate <-5.25, 17.875, -0.875>
}

#declare B54_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 0.125, 0.25>
    translate <-7.5, 17.875, -0.875>
}

#declare B55_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <7.125, 0.25, -0.125>
    translate <-8.125, 19.125, -0.75>
}

#declare B56_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <0.25, 0.25, 0.5>
    translate <-2.625, 19.375, -1.25>
}

#declare B57_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <0.25, 0.25, 0.5>
    translate <-4.875, 19.375, -1.25>
}

#declare B58_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <0.25, 0.25, 0.5>
    translate <-7.125, 19.375, -1.25>
}

#declare B59_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 1, 0.125>
    translate <-5.25, 18.125, -0.875>
}

#declare B60_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 1, 0.125>
    translate <-3, 18.125, -0.875>
}

#declare B61_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <1, 1, 0.125>
    translate <-7.5, 18.125, -0.875>
}

#declare B62_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <7, 1.5, 1.5>
    translate <-8, 18.125, -0.75>
}

#declare B63_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <7.25, 0.125, 2>
    translate <-8.25, 18, -1>
}

#declare B64_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <2.5, 0.375, 2.5>
    translate <-3.75, 16.875, -1.25>
}

#declare B65_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <2.5, 0.375, 2.5>
    translate <-8.25, 16.875, -1.25>
}

#declare B66_Box = box { // LAYER: Architrave
    <0.0, 0.0, 0.0>, <7, 0.75, 1.5>
    translate <-8, 17.25, -0.75>
}

#declare H215_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.75, <3.75, 0.0, 0.0>, 0.75
    rotate <.0, .0, -270>
    translate <2.5, 1.25, 0>
}

#declare H216_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <3.25, 2, 0>
}

#declare H217_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <3.25, 2, 0>
}

#declare H218_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <2.5, 2, -0.75>
}

#declare H219_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <2.5, 2, -0.75>
}

#declare H220_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <2.5, 2, 0.75>
}

#declare H221_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <2.5, 2, 0.75>
}

#declare H222_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <1.7756, 2, -0.1941>
}

#declare H223_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <1.7756, 2, -0.1941>
}

#declare H224_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <2.6941, 2, -0.7244>
}

#declare H225_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <2.6941, 2, -0.7244>
}

#declare H226_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <3.2244, 2, 0.1941>
}

#declare H227_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <3.2244, 2, 0.1941>
}

#declare H228_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <2.3059, 2, 0.7244>
}

#declare H229_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <2.3059, 2, 0.7244>
}

#declare H230_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <2.125, 2, 0.6495>
}

#declare H231_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <2.125, 2, 0.6495>
}

#declare H232_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <3.1495, 2, 0.375>
}

#declare H233_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <3.1495, 2, 0.375>
}

#declare H234_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <2.875, 2, -0.6495>
}

#declare H235_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <2.875, 2, -0.6495>
}

#declare H236_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <1.8505, 2, -0.375>
}

#declare H237_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <1.8505, 2, -0.375>
}

#declare H238_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <3.0303, 2, 0.5303>
}

#declare H239_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <3.0303, 2, 0.5303>
}

#declare H240_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <1.9697, 2, -0.5303>
}

#declare H241_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <1.9697, 2, -0.5303>
}

#declare H242_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <1.9697, 2, 0.5303>
}

#declare H243_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <1.9697, 2, 0.5303>
}

#declare H244_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <3.0303, 2, -0.5303>
}

#declare H245_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <3.0303, 2, -0.5303>
}

#declare H246_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <1.8505, 2, 0.375>
}

#declare H247_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <1.8505, 2, 0.375>
}

#declare H248_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <3.1495, 2, -0.375>
}

#declare H249_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <3.1495, 2, -0.375>
}

#declare H250_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <2.875, 2, 0.6495>
}

#declare H251_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <2.875, 2, 0.6495>
}

#declare H252_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <2.125, 2, -0.6495>
}

#declare H253_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <2.125, 2, -0.6495>
}

#declare H254_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <1.7756, 2, 0.1941>
}

#declare H255_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <1.7756, 2, 0.1941>
}

#declare H256_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <3.2244, 2, -0.1941>
}

#declare H257_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <3.2244, 2, -0.1941>
}

#declare H258_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <1.75, 2, 0>
}

#declare H259_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <1.75, 2, 0>
}

#declare H260_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <2.6941, 2, 0.7244>
}

#declare H261_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <2.6941, 2, 0.7244>
}

#declare H262_Sphere = sphere { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <2.3059, 2, -0.7244>
}

#declare H263_Cone = cone { // LAYER: Shaft1a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <2.3059, 2, -0.7244>
}

#declare H264_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.75, <3, 0.0, 0.0>, 0.75
    rotate <.0, .0, -270>
    translate <7, 5, 0>
}

#declare H265_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <6.8059, 5, -0.7244>
}

#declare H266_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <7.1941, 5, 0.7244>
}

#declare H267_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <6.25, 5, 0>
}

#declare H268_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <7.7244, 5, -0.1941>
}

#declare H269_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <6.2756, 5, 0.1941>
}

#declare H270_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <6.625, 5, -0.6495>
}

#declare H271_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <7.375, 5, 0.6495>
}

#declare H272_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <7.6495, 5, -0.375>
}

#declare H273_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <6.3505, 5, 0.375>
}

#declare H274_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <7.5303, 5, -0.5303>
}

#declare H275_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <6.4697, 5, 0.5303>
}

#declare H276_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <6.4697, 5, -0.5303>
}

#declare H277_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <7.5303, 5, 0.5303>
}

#declare H278_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <6.3505, 5, -0.375>
}

#declare H279_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <7.375, 5, -0.6495>
}

#declare H280_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <7.6495, 5, 0.375>
}

#declare H281_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <6.625, 5, 0.6495>
}

#declare H282_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <6.8059, 5, 0.7244>
}

#declare H283_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <7.7244, 5, 0.1941>
}

#declare H284_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <7.1941, 5, -0.7244>
}

#declare H285_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <6.2756, 5, -0.1941>
}

#declare H286_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <7, 5, 0.75>
}

#declare H287_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <7, 5, -0.75>
}

#declare H288_Cone = cone { // LAYER: Shaft2a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <7.75, 5, 0>
}

#declare H289_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <7.75, 8, 0>
}

#declare H290_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <7, 8, -0.75>
}

#declare H291_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <7, 8, 0.75>
}

#declare H292_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <6.2756, 8, -0.1941>
}

#declare H293_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <7.1941, 8, -0.7244>
}

#declare H294_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <7.7244, 8, 0.1941>
}

#declare H295_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <6.8059, 8, 0.7244>
}

#declare H296_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <6.625, 8, 0.6495>
}

#declare H297_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <7.6495, 8, 0.375>
}

#declare H298_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <7.375, 8, -0.6495>
}

#declare H299_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <6.3505, 8, -0.375>
}

#declare H300_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <7.5303, 8, 0.5303>
}

#declare H301_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <6.4697, 8, -0.5303>
}

#declare H302_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <6.4697, 8, 0.5303>
}

#declare H303_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <7.5303, 8, -0.5303>
}

#declare H304_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <6.3505, 8, 0.375>
}

#declare H305_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <7.6495, 8, -0.375>
}

#declare H306_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <7.375, 8, 0.6495>
}

#declare H307_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <6.625, 8, -0.6495>
}

#declare H308_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <6.2756, 8, 0.1941>
}

#declare H309_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <7.7244, 8, -0.1941>
}

#declare H310_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <6.25, 8, 0>
}

#declare H311_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <7.1941, 8, 0.7244>
}

#declare H312_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <6.8059, 8, -0.7244>
}

#declare H313_Cone = cone { // LAYER: Shaft3a
    <0.0, 0.0, 0.0>, 0.75, <3, 0.0, 0.0>, 0.75
    rotate <.0, .0, -270>
    translate <7, 8, 0>
}

#declare H314_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.75, <4, 0.0, 0.0>, 0.75
    rotate <.0, .0, -270>
    translate <-2.5, 11, 0>
}

#declare H315_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-2.6941, 14, -0.7244>
}

#declare H316_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-2.3059, 14, 0.7244>
}

#declare H317_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <-3.25, 14, 0>
}

#declare H318_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-1.7756, 14, -0.1941>
}

#declare H319_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-3.2244, 14, 0.1941>
}

#declare H320_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-2.875, 14, -0.6495>
}

#declare H321_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-2.125, 14, 0.6495>
}

#declare H322_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-1.8505, 14, -0.375>
}

#declare H323_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 285, .0>
    translate <-3.1495, 14, 0.375>
}

#declare H324_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <-1.9697, 14, -0.5303>
}

#declare H325_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <-3.0303, 14, 0.5303>
}

#declare H326_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <-3.0303, 14, -0.5303>
}

#declare H327_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 300, .0>
    translate <-1.9697, 14, 0.5303>
}

#declare H328_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <-3.1495, 14, -0.375>
}

#declare H329_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <-2.125, 14, -0.6495>
}

#declare H330_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <-1.8505, 14, 0.375>
}

#declare H331_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 315, .0>
    translate <-2.875, 14, 0.6495>
}

#declare H332_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <-2.6941, 14, 0.7244>
}

#declare H333_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <-1.7756, 14, 0.1941>
}

#declare H334_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <-2.3059, 14, -0.7244>
}

#declare H335_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 330, .0>
    translate <-3.2244, 14, -0.1941>
}

#declare H336_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <-2.5, 14, 0.75>
}

#declare H337_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <-2.5, 14, -0.75>
}

#declare H338_Sphere = sphere { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625
    rotate <.0, 345, .0>
    translate <-1.75, 14, 0>
}

#declare H339_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-2.6941, 11, -0.7244>
}

#declare H340_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-2.3059, 11, 0.7244>
}

#declare H341_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-3.25, 11, 0>
}

#declare H342_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-1.7756, 11, -0.1941>
}

#declare H343_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-3.2244, 11, 0.1941>
}

#declare H344_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-2.875, 11, -0.6495>
}

#declare H345_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-2.125, 11, 0.6495>
}

#declare H346_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-1.8505, 11, -0.375>
}

#declare H347_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 285, .0>
    translate <-3.1495, 11, 0.375>
}

#declare H348_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-1.9697, 11, -0.5303>
}

#declare H349_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-3.0303, 11, 0.5303>
}

#declare H350_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-3.0303, 11, -0.5303>
}

#declare H351_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 300, .0>
    translate <-1.9697, 11, 0.5303>
}

#declare H352_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-3.1495, 11, -0.375>
}

#declare H353_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-2.125, 11, -0.6495>
}

#declare H354_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-1.8505, 11, 0.375>
}

#declare H355_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 315, .0>
    translate <-2.875, 11, 0.6495>
}

#declare H356_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-2.6941, 11, 0.7244>
}

#declare H357_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-1.7756, 11, 0.1941>
}

#declare H358_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-2.3059, 11, -0.7244>
}

#declare H359_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 330, .0>
    translate <-3.2244, 11, -0.1941>
}

#declare H360_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-2.5, 11, 0.75>
}

#declare H361_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-2.5, 11, -0.75>
}

#declare H362_Cone = cone { // LAYER: Shaft4a
    <0.0, 0.0, 0.0>, 0.0625, <3, 0.0, 0.0>, 0.0625
    rotate <.0, .0, -270>
    rotate <.0, 345, .0>
    translate <-1.75, 11, 0>
}



//****************** ACTION **********************

// LAYER: Environment
object { H0_Mesh texture { Dirt}}

// LAYER: ColumnBases
object { H2_Box texture { Gold_Marble scale .5}}
object { H3_Box texture { Gold_Marble scale .5 rotate <0,15,0>}}
object { H4_Box texture { Gold_Marble scale .5 rotate <0,90,0>}}
object { H5_Box texture { Gold_Marble scale .5 rotate <0,-15,0>}}
object { H6_Cone texture { White_Marble scale .75}}
object { H7_Torus texture {Gold_Metal}}
object { H8_Cone texture { White_Marble scale .75 rotate <0,30,0>}}
object { H9_Torus texture { Gold_Metal}}
object { H10_Cone texture { White_Marble scale .75}}
object { H11_Cone texture { White_Marble scale .75}}
object { H12_Torus texture { Gold_Metal}}
object { H13_Cone texture { White_Marble scale .75 rotate <0,-30,0>}}
object { H14_Torus texture { Gold_Metal}}
object { H15_Cone texture { White_Marble scale .75 rotate <0,0,45>}}
object { H16_Torus texture { Gold_Metal}}
object { H17_Cone texture { White_Marble scale .75}}

// LAYER: ShaftSection1

difference {
    object { H18_Cone }
    object { H19_Cone }
    object { H20_Sphere }
    object { H21_Cone }
    object { H22_Sphere }
    object { H23_Cone }
    object { H24_Sphere }
    object { H25_Cone }
    object { H26_Sphere }
    object { H27_Cone }
    object { H28_Sphere }
    object { H29_Cone }
    object { H30_Sphere }
    object { H31_Cone }
    object { H32_Sphere }
    object { H33_Cone }
    object { H34_Sphere }
    object { H35_Cone }
    object { H36_Sphere }
    object { H37_Cone }
    object { H38_Sphere }
    object { H39_Cone }
    object { H40_Sphere }
    object { H41_Cone }
    object { H42_Sphere }
    object { H43_Cone }
    object { H44_Sphere }
    object { H45_Cone }
    object { H46_Sphere }
    object { H47_Cone }
    object { H48_Sphere }
    object { H49_Cone }
    object { H50_Sphere }
    object { H51_Cone }
    object { H52_Sphere }
    object { H53_Cone }
    object { H54_Sphere }
    object { H55_Cone }
    object { H56_Sphere }
    object { H57_Cone }
    object { H58_Sphere }
    object { H59_Cone }
    object { H60_Sphere }
    object { H61_Sphere }
    object { H62_Cone }
    object { H63_Cone }
    object { H64_Sphere }
    object { H65_Sphere }
    object { H66_Cone }
    texture { Gray_Marble scale 1.5}
}

// LAYER: ShaftSection2

difference {
    object { H67_Cone }
    object { H68_Cone }
    object { H69_Cone }
    object { H70_Cone }
    object { H71_Cone }
    object { H72_Cone }
    object { H73_Cone }
    object { H74_Cone }
    object { H75_Cone }
    object { H76_Cone }
    object { H77_Cone }
    object { H78_Cone }
    object { H79_Cone }
    object { H80_Cone }
    object { H81_Cone }
    object { H82_Cone }
    object { H83_Cone }
    object { H84_Cone }
    object { H85_Cone }
    object { H86_Cone }
    object { H87_Cone }
    object { H88_Cone }
    object { H89_Cone }
    object { H90_Cone }
    object { H91_Cone }
   texture { Gray_Marble scale 1.5 rotate <0,-45,0>}
}

// LAYER: ShaftSection3

difference {
object { H116_Cone }
object { H92_Cone }
object { H93_Cone }
object { H94_Cone }
object { H95_Cone }
object { H96_Cone }
object { H97_Cone }
object { H98_Cone }
object { H99_Cone }
object { H100_Cone }
object { H101_Cone }
object { H102_Cone }
object { H103_Cone }
object { H104_Cone }
object { H105_Cone }
object { H106_Cone }
object { H107_Cone }
object { H108_Cone }
object { H109_Cone }
object { H110_Cone }
object { H111_Cone }
object { H112_Cone }
object { H113_Cone }
object { H114_Cone }
object { H115_Cone }
texture { Gray_Marble scale 1.5 rotate <15,0,15>}
}

// LAYER: ShaftSection4

difference {
object { H117_Cone }
object { H118_Sphere }
object { H119_Sphere }
object { H120_Sphere }
object { H121_Sphere }
object { H122_Sphere }
object { H123_Sphere }
object { H124_Sphere }
object { H125_Sphere }
object { H126_Sphere }
object { H127_Sphere }
object { H128_Sphere }
object { H129_Sphere }
object { H130_Sphere }
object { H131_Sphere }
object { H132_Sphere }
object { H133_Sphere }
object { H134_Sphere }
object { H135_Sphere }
object { H136_Sphere }
object { H137_Sphere }
object { H138_Sphere }
object { H139_Sphere }
object { H140_Sphere }
object { H141_Sphere }
object { H142_Cone }
object { H143_Cone }
object { H144_Cone }
object { H145_Cone }
object { H146_Cone }
object { H147_Cone }
object { H148_Cone }
object { H149_Cone }
object { H150_Cone }
object { H151_Cone }
object { H152_Cone }
object { H153_Cone }
object { H154_Cone }
object { H155_Cone }
object { H156_Cone }
object { H157_Cone }
object { H158_Cone }
object { H159_Cone }
object { H160_Cone }
object { H161_Cone }
object { H162_Cone }
object { H163_Cone }
object { H164_Cone }
object { H165_Cone }
texture { Gray_Marble scale 1.5 rotate <30,15,-30>}
}

// LAYER: Capitals
union {
object { H170_Revolution texture {Stone21 scale 1.25}}
object { H172_Revolution texture {Stone21 scale 1.25 rotate <0,-15,0>}}
object { H166_Torus texture { Gold_Metal}}
object { H167_Torus texture { Gold_Metal}}
object { H168_Torus texture { Gold_Metal}}
object { H169_Cone texture {Stone21 scale 1.25}}
object { H171_Torus texture { Gold_Metal}}
object { H173_Cone texture {Stone21 scale 1.25 rotate <0,-15,0>}}
object { H174_Torus texture { Gold_Metal}}
object { H175_Torus texture { Gold_Metal}}
}

union {
object { H172_Revolution texture {Stone21 scale 1.25 rotate <0,15,0>} translate <14,0,0>}
object { H171_Torus texture { Gold_Metal} translate <14,0,0>}
object { H173_Cone texture {Stone21 scale 1.25 rotate <0,15,0>} translate <14,0,0>}
object { H174_Torus texture { Gold_Metal} translate <14,0,0>}
object { H175_Torus texture { Gold_Metal} translate <14,0,0>}
}

// LAYER: Architrave
union {
object { B30_Faces texture {Copper_Metal}
   finish {Shiny}
   }
object { B2_Box texture {White_Marble scale 1.5}}
object { B3_Box texture {White_Marble scale 1.5 rotate <0,30,0>}}
object { B4_Box texture {White_Marble scale 1.5 rotate <0,0,45>}}
object { B5_Box texture {DMFLightOak scale .5 rotate <-3,0,0>}}
object { B6_Box texture {DMFLightOak scale .5 rotate <-3,0,0>}}
object { B7_Box texture {DMFLightOak scale .5 rotate <-3,0,0>}}
object { B8_Box texture {Stone24 scale 0.5}}
object { B9_Box texture {Stone24 scale 0.5}}
object { B10_Box texture {Stone24 scale 0.5}}
object { B11_Cone texture {Gold_Metal}}
object { B12_Cone texture {Gold_Metal}}
object { B13_Cone texture {Gold_Metal}}
object { B14_Cone texture {Gold_Metal}}
object { B15_Cone texture {Gold_Metal}}
object { B16_Cone texture {Gold_Metal}}
object { B17_Cone texture {Gold_Metal}}
object { B18_Cone texture {Gold_Metal}}
object { B19_Cone texture {Gold_Metal}}
object { B20_Cone texture {Gold_Metal}}
object { B21_Cone texture {Gold_Metal}}
object { B22_Cone texture {Gold_Metal}}
object { B23_Box texture {DMFLightOak scale .5 rotate <-3,0,0>}}
object { B24_Box texture {DMFLightOak scale .5 rotate <-3,0,0>}}
object { B25_Box texture {DMFLightOak scale .5 rotate <-3,0,0>}}
object { B26_Box texture {DMFLightOak scale .5 rotate <-3,0,0>}}
object { B27_Box texture {DMFLightOak scale .5 rotate <-3,0,0>}}
object { B28_Box texture {DMFLightOak scale .5 rotate <-3,0,0>}}
object { B29_Box texture{
			tiles {
			texture { White_Marble scale 2}
			tile2
			texture { White_Marble scale 2 rotate <0,45,0>}
			}
		scale <1,1.5,1>
		}
	}
object { B31_Box texture {Gray_Marble scale 0.75}}
object { B32_Box texture {Stone24 scale 0.5}}
object { B33_Box texture {White_Marble scale 1.5}}
object { B34_Box texture {DMFLightOak scale .5 rotate <-3,0,0>}}
object { B35_Box texture {Stone24 scale 0.5}}
object { B36_Cone texture {Gold_Metal}}
object { B37_Cone texture {Gold_Metal}}
object { B38_Cone texture {Gold_Metal}}
object { B39_Cone texture {Gold_Metal}}
object { B40_Cone texture {Gold_Metal}}
object { B41_Cone texture {Gold_Metal}}
object { B42_Cone texture {Gold_Metal}}
object { B43_Cone texture {Gold_Metal}}
object { B44_Cone texture {Gold_Metal}}
object { B45_Cone texture {Gold_Metal}}
object { B46_Cone texture {Gold_Metal}}
object { B47_Cone texture {Gold_Metal}}
object { B48_Cone texture {Gold_Metal}}
object { B49_Cone texture {Gold_Metal}}
object { B50_Cone texture {Gold_Metal}}
object { B51_Cone texture {Gold_Metal}}
object { B52_Box texture {Stone24 scale 0.5}}
object { B53_Box texture {Stone24 scale 0.5}}
object { B54_Box texture {Stone24 scale 0.5}}
object { B55_Box texture {Gray_Marble scale 0.75}}
object { B56_Box texture {DMFLightOak scale .5 rotate <-3,0,0>}}
object { B57_Box texture {DMFLightOak scale .5 rotate <-3,0,0>}}
object { B58_Box texture {DMFLightOak scale .5 rotate <-3,0,0>}}
object { B59_Box texture {White_Marble scale 1.5}}
object { B60_Box 	texture {White_Marble scale 1.5 rotate <0,30,0>}}
object { B61_Box 	texture {White_Marble scale 1.5 rotate <0,0,45>}}
object { B62_Box texture {Gray_Marble scale 0.75}}
object { B63_Box texture {Gray_Marble scale 0.75}}
object { B64_Box texture {Stone24 scale 1.5}}
object { B65_Box texture {Stone24 scale 1.5}}
object { B66_Box texture {Gray_Marble scale 0.75}}
clipped_by {
	height_field {
		gif "plasma3.gif"
		scale <4,1,4>
      rotate <5,0,-89>
		translate <-2,20,-1.5>
      }
   }
}

// LAYER: Shaft1a
difference {
object { H215_Cone }
object { H216_Cone }
object { H217_Sphere }
object { H218_Cone }
object { H219_Sphere }
object { H220_Cone }
object { H221_Sphere }
object { H222_Cone }
object { H223_Sphere }
object { H224_Cone }
object { H225_Sphere }
object { H226_Cone }
object { H227_Sphere }
object { H228_Cone }
object { H229_Sphere }
object { H230_Cone }
object { H231_Sphere }
object { H232_Cone }
object { H233_Sphere }
object { H234_Cone }
object { H235_Sphere }
object { H236_Cone }
object { H237_Sphere }
object { H238_Cone }
object { H239_Sphere }
object { H240_Cone }
object { H241_Sphere }
object { H242_Cone }
object { H243_Sphere }
object { H244_Cone }
object { H245_Sphere }
object { H246_Cone }
object { H247_Sphere }
object { H248_Cone }
object { H249_Sphere }
object { H250_Cone }
object { H251_Sphere }
object { H252_Cone }
object { H253_Sphere }
object { H254_Cone }
object { H255_Sphere }
object { H256_Cone }
object { H257_Sphere }
object { H258_Sphere }
object { H259_Cone }
object { H260_Cone }
object { H261_Sphere }
object { H262_Sphere }
object { H263_Cone }
height_field {
	gif "plasma3.gif"
	scale <3,1,3>
   translate <2,3,-1.5>
inverse
}
texture { Gray_Marble scale 1.35 rotate <0,45,0>}
}

// LAYER: Shaft2a

difference {
object { H264_Cone }
object { H265_Cone }
object { H266_Cone }
object { H267_Cone }
object { H268_Cone }
object { H269_Cone }
object { H270_Cone }
object { H271_Cone }
object { H272_Cone }
object { H273_Cone }
object { H274_Cone }
object { H275_Cone }
object { H276_Cone }
object { H277_Cone }
object { H278_Cone }
object { H279_Cone }
object { H280_Cone }
object { H281_Cone }
object { H282_Cone }
object { H283_Cone }
object { H284_Cone }
object { H285_Cone }
object { H286_Cone }
object { H287_Cone }
object { H288_Cone }
height_field {
	pot "fract1.pot"
	scale <3,2,3>
   translate <6,6,-1.5>
}
texture { Gray_Marble scale 1.35 rotate <25,0,0>}
}

// LAYER: Shaft3a

difference {
object { H313_Cone }
object { H289_Cone }
object { H290_Cone }
object { H291_Cone }
object { H292_Cone }
object { H293_Cone }
object { H294_Cone }
object { H295_Cone }
object { H296_Cone }
object { H297_Cone }
object { H298_Cone }
object { H299_Cone }
object { H300_Cone }
object { H301_Cone }
object { H302_Cone }
object { H303_Cone }
object { H304_Cone }
object { H305_Cone }
object { H306_Cone }
object { H307_Cone }
object { H308_Cone }
object { H309_Cone }
object { H310_Cone }
object { H311_Cone }
object { H312_Cone }
height_field {
	pot "fract1.pot"
	scale <3,2,3>
	translate <6,10,-1.5>
	inverse
}
texture { Gray_Marble scale 1.45 rotate <45,0,0>}
}

// LAYER: Shaft4a
difference {
object { H314_Cone }
object { H315_Sphere }
object { H316_Sphere }
object { H317_Sphere }
object { H318_Sphere }
object { H319_Sphere }
object { H320_Sphere }
object { H321_Sphere }
object { H322_Sphere }
object { H323_Sphere }
object { H324_Sphere }
object { H325_Sphere }
object { H326_Sphere }
object { H327_Sphere }
object { H328_Sphere }
object { H329_Sphere }
object { H330_Sphere }
object { H331_Sphere }
object { H332_Sphere }
object { H333_Sphere }
object { H334_Sphere }
object { H335_Sphere }
object { H336_Sphere }
object { H337_Sphere }
object { H338_Sphere }
object { H339_Cone }
object { H340_Cone }
object { H341_Cone }
object { H342_Cone }
object { H343_Cone }
object { H344_Cone }
object { H345_Cone }
object { H346_Cone }
object { H347_Cone }
object { H348_Cone }
object { H349_Cone }
object { H350_Cone }
object { H351_Cone }
object { H352_Cone }
object { H353_Cone }
object { H354_Cone }
object { H355_Cone }
object { H356_Cone }
object { H357_Cone }
object { H358_Cone }
object { H359_Cone }
object { H360_Cone }
object { H361_Cone }
object { H362_Cone }
height_field {
   pot "fract1.pot"
	scale <3,1,3>
   rotate <5,0,5>
   translate <-3.5,12.5,-1.5>
}
texture { Gray_Marble scale 1.35 rotate <0,0,25>}
}

box { <-9,-1.5,-2> <9,-1,2>
	texture { White_Marble scale 2}
}

//SLOPES AROUND OBJECTS

// LAYER: Landforms
union {
object { B67_Mesh texture { Grassy}}
object { B68_Mesh texture { Grassy}}
object { B70_Mesh texture { Grassy}}
object { B72_Mesh texture { Grassy}}
object { B73_Mesh texture { Grassy}}
object { B74_Mesh texture { Grassy}}
no_shadow
}


//HEIGHT FIELDS

height_field {
   pot "fract1.pot"
   rotate <0,-45,0>
   scale <100, 35, 50>
   translate <50,-12,50>
   texture {
      pigment {
            gradient y
            color_map {
                  [0.0 0.1 color Brown color Slate_Grey]
                  [0.1 0.3 color Slate_Grey color Slate_Grey_Light]
                  [0.3 0.45 color Slate_Grey_Light color Gray]
                  [0.45 0.6 color DarkBrown color Slate_Grey_Dark]
                  [0.6 0.8 color Gray color Dim_Grey]
                  [0.8 0.9 color Dim_Grey color Warm_Grey]
                  [0.9 1.0 color DarkTan color DarkBrown]
                  }
         }
      scale 3
      turbulence 0.3
      }
   no_shadow
}

height_field {
   gif "plasma2.gif"
   scale <20, 15, 50>
   translate <-25,5,20>
   texture {
      pigment {
            gradient y
            color_map {
                  [0.0 0.1 color Brown color Slate_Grey]
                  [0.1 0.3 color Slate_Grey color Slate_Grey_Light]
                  [0.3 0.45 color Slate_Grey_Light color Gray]
                  [0.45 0.6 color DarkBrown color Slate_Grey_Dark]
                  [0.6 0.8 color Gray color Dim_Grey]
                  [0.8 0.9 color Dim_Grey color Warm_Grey]
                  [0.9 1.0 color DarkTan color DarkBrown]
            }
            turbulence 0.2
      }
      finish { ambient 0.4 crand 0.4}
      scale 5
   }
   no_shadow
}

height_field {
   gif "plasma2.gif"
   scale <20, 18, 50>
   translate <45,3,20>
   texture {
      pigment {
            gradient y
            color_map {
                  [0.0 0.1 color Brown color Slate_Grey]
                  [0.1 0.3 color Slate_Grey color Slate_Grey_Light]
                  [0.3 0.45 color Slate_Grey_Light color Gray]
                  [0.45 0.6 color DarkBrown color Slate_Grey_Dark]
                  [0.6 0.8 color Gray color Dim_Grey]
                  [0.8 0.9 color Dim_Grey color Warm_Grey]
                  [0.9 1.0 color DarkTan color DarkBrown]
            }
            turbulence 0.3
      }
      finish { ambient 0.4 crand 0.4}
      scale 5
   }
}



sphere {
   <0,0,0> 600
   texture { Blue_Sky2 scale <550,190,300>}
   }
