#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"

camera {
location <-50, 12, -27>
direction <0, 0, 1.4>
sky <0, 1, 0>
up <0, 1, 0>
right <1.33, 0, 0>
look_at <0, 3, 0>
}


light_source { <-50, 150, -150> color rgb <0.7, 0.7, 0.7> }


// Ground
height_field { tga "mountn02.tga"
texture {
Sandalwood
finish { ambient 0.4 }
normal { bumps 0.4 scale 0.01 }
scale <0.5, 10, 0.05>
rotate <5, 0, 10>
}
scale <5000, 600, 5000>
translate <-900, -2, -500>
}

#declare Star_Field =
texture {
finish { ambient 1.0 }
pigment {
granite color_map {
[0.00 color Black]
[0.72 color Black]
[0.72 color Gray20 ]
[0.75 color Gray40 ]
[0.75 color Gray40 ]
[0.78 color Gray60 ]
[0.78 color Gray60 ]
[0.81 color Gray80 ]
[0.81 color Gray80 ]
[0.85 color Gray95 ]
[0.85 color Gray95 ]
[0.91 color White ]
[0.91 color Black ]
[1.0 color Black ]
}
scale 0.01
}
}

// Night Sky
sphere { <0, 0, 0>, 1.5
texture { Star_Field }
scale 100000
}

// Clouds
plane { y, 2500
rotate <0.2, 0, -0.2>
texture { 
        pigment { bozo
                color_map { 
                        [ 0.0 color White filter 1.0 ]
                        [ 0.8 color White filter 1.0 ]
                        [ 1.0 color White filter 0.1 ]
                        }
                }
        finish { ambient 0.15 }
        scale 750
        }
}

declare Arch =
union {
blob {
threshold 0.01
component 1.0,               1.0000, <    15.0000 ,    0.0000 ,  0 >     //         0.000
component 1.0,               0.9950, <    14.9994 ,    0.1309 ,  0 >     //         0.500
component 1.0,               0.9900, <    14.9977 ,    0.2618 ,  0 >     //         1.000
component 1.0,               0.9850, <    14.9949 ,    0.3927 ,  0 >     //         1.500
component 1.0,               0.9800, <    14.9909 ,    0.5235 ,  0 >     //         2.000
component 1.0,               0.9750, <    14.9857 ,    0.6543 ,  0 >     //         2.500
component 1.0,               0.9700, <    14.9794 ,    0.7850 ,  0 >     //         3.000
component 1.0,               0.9650, <    14.9720 ,    0.9157 ,  0 >     //         3.500
component 1.0,               0.9600, <    14.9635 ,    1.0463 ,  0 >     //         4.000
component 1.0,               0.9550, <    14.9538 ,    1.1769 ,  0 >     //         4.500
component 1.0,               0.9500, <    14.9429 ,    1.3073 ,  0 >     //         5.000
component 1.0,               0.9450, <    14.9309 ,    1.4377 ,  0 >     //         5.500
component 1.0,               0.9400, <    14.9178 ,    1.5679 ,  0 >     //         6.000
component 1.0,               0.9350, <    14.9036 ,    1.6980 ,  0 >     //         6.500
component 1.0,               0.9300, <    14.8882 ,    1.8280 ,  0 >     //         7.000
component 1.0,               0.9250, <    14.8717 ,    1.9579 ,  0 >     //         7.500
component 1.0,               0.9200, <    14.8540 ,    2.0876 ,  0 >     //         8.000
component 1.0,               0.9150, <    14.8352 ,    2.2171 ,  0 >     //         8.500
component 1.0,               0.9100, <    14.8153 ,    2.3465 ,  0 >     //         9.000
component 1.0,               0.9050, <    14.7943 ,    2.4757 ,  0 >     //         9.500
component 1.0,               0.9000, <    14.7721 ,    2.6047 ,  0 >     //        10.000
component 1.0,               0.8950, <    14.7488 ,    2.7335 ,  0 >     //        10.500
component 1.0,               0.8900, <    14.7244 ,    2.8621 ,  0 >     //        11.000
component 1.0,               0.8850, <    14.6989 ,    2.9905 ,  0 >     //        11.500
component 1.0,               0.8800, <    14.6722 ,    3.1187 ,  0 >     //        12.000
component 1.0,               0.8750, <    14.6444 ,    3.2466 ,  0 >     //        12.500
component 1.0,               0.8700, <    14.6156 ,    3.3743 ,  0 >     //        13.000
component 1.0,               0.8650, <    14.5855 ,    3.5017 ,  0 >     //        13.500
component 1.0,               0.8600, <    14.5544 ,    3.6288 ,  0 >     //        14.000
component 1.0,               0.8550, <    14.5222 ,    3.7557 ,  0 >     //        14.500
component 1.0,               0.8500, <    14.4889 ,    3.8823 ,  0 >     //        15.000
component 1.0,               0.8450, <    14.4545 ,    4.0086 ,  0 >     //        15.500
component 1.0,               0.8400, <    14.4189 ,    4.1346 ,  0 >     //        16.000
component 1.0,               0.8350, <    14.3823 ,    4.2602 ,  0 >     //        16.500
component 1.0,               0.8300, <    14.3446 ,    4.3856 ,  0 >     //        17.000
component 1.0,               0.8250, <    14.3058 ,    4.5106 ,  0 >     //        17.500
component 1.0,               0.8200, <    14.2658 ,    4.6353 ,  0 >     //        18.000
component 1.0,               0.8150, <    14.2249 ,    4.7596 ,  0 >     //        18.500
component 1.0,               0.8100, <    14.1828 ,    4.8835 ,  0 >     //        19.000
component 1.0,               0.8050, <    14.1396 ,    5.0071 ,  0 >     //        19.500
component 1.0,               0.8000, <    14.0954 ,    5.1303 ,  0 >     //        20.000
component 1.0,               0.7950, <    14.0501 ,    5.2531 ,  0 >     //        20.500
component 1.0,               0.7900, <    14.0037 ,    5.3755 ,  0 >     //        21.000
component 1.0,               0.7850, <    13.9563 ,    5.4975 ,  0 >     //        21.500
component 1.0,               0.7800, <    13.9078 ,    5.6191 ,  0 >     //        22.000
component 1.0,               0.7750, <    13.8582 ,    5.7403 ,  0 >     //        22.500
component 1.0,               0.7700, <    13.8076 ,    5.8610 ,  0 >     //        23.000
component 1.0,               0.7650, <    13.7559 ,    5.9812 ,  0 >     //        23.500
component 1.0,               0.7600, <    13.7032 ,    6.1010 ,  0 >     //        24.000
component 1.0,               0.7550, <    13.6494 ,    6.2204 ,  0 >     //        24.500
component 1.0,               0.7500, <    13.5946 ,    6.3393 ,  0 >     //        25.000
component 1.0,               0.7450, <    13.5388 ,    6.4577 ,  0 >     //        25.500
component 1.0,               0.7400, <    13.4819 ,    6.5756 ,  0 >     //        26.000
component 1.0,               0.7350, <    13.4240 ,    6.6930 ,  0 >     //        26.500
component 1.0,               0.7300, <    13.3651 ,    6.8099 ,  0 >     //        27.000
component 1.0,               0.7250, <    13.3052 ,    6.9262 ,  0 >     //        27.500
component 1.0,               0.7200, <    13.2442 ,    7.0421 ,  0 >     //        28.000
component 1.0,               0.7150, <    13.1823 ,    7.1574 ,  0 >     //        28.500
component 1.0,               0.7100, <    13.1193 ,    7.2721 ,  0 >     //        29.000
component 1.0,               0.7050, <    13.0553 ,    7.3864 ,  0 >     //        29.500
component 1.0,               0.7000, <    12.9904 ,    7.5000 ,  0 >     //        30.000
component 1.0,               0.6950, <    12.9244 ,    7.6131 ,  0 >     //        30.500
component 1.0,               0.6900, <    12.8575 ,    7.7256 ,  0 >     //        31.000
component 1.0,               0.6850, <    12.7896 ,    7.8375 ,  0 >     //        31.500
component 1.0,               0.6800, <    12.7207 ,    7.9488 ,  0 >     //        32.000
component 1.0,               0.6750, <    12.6509 ,    8.0595 ,  0 >     //        32.500
component 1.0,               0.6700, <    12.5801 ,    8.1696 ,  0 >     //        33.000
component 1.0,               0.6650, <    12.5083 ,    8.2791 ,  0 >     //        33.500
component 1.0,               0.6600, <    12.4356 ,    8.3879 ,  0 >     //        34.000
component 1.0,               0.6550, <    12.3619 ,    8.4961 ,  0 >     //        34.500
component 1.0,               0.6500, <    12.2873 ,    8.6036 ,  0 >     //        35.000
component 1.0,               0.6450, <    12.2117 ,    8.7105 ,  0 >     //        35.500
component 1.0,               0.6400, <    12.1353 ,    8.8168 ,  0 >     //        36.000
component 1.0,               0.6350, <    12.0579 ,    8.9223 ,  0 >     //        36.500
component 1.0,               0.6300, <    11.9795 ,    9.0272 ,  0 >     //        37.000
component 1.0,               0.6250, <    11.9003 ,    9.1314 ,  0 >     //        37.500
component 1.0,               0.6200, <    11.8202 ,    9.2349 ,  0 >     //        38.000
component 1.0,               0.6150, <    11.7391 ,    9.3377 ,  0 >     //        38.500
component 1.0,               0.6100, <    11.6572 ,    9.4398 ,  0 >     //        39.000
component 1.0,               0.6050, <    11.5744 ,    9.5412 ,  0 >     //        39.500
component 1.0,               0.6000, <    11.4907 ,    9.6418 ,  0 >     //        40.000
component 1.0,               0.5950, <    11.4061 ,    9.7417 ,  0 >     //        40.500
component 1.0,               0.5900, <    11.3206 ,    9.8409 ,  0 >     //        41.000
component 1.0,               0.5850, <    11.2343 ,    9.9393 ,  0 >     //        41.500
component 1.0,               0.5800, <    11.1472 ,   10.0370 ,  0 >     //        42.000
component 1.0,               0.5750, <    11.0592 ,   10.1339 ,  0 >     //        42.500
component 1.0,               0.5700, <    10.9703 ,   10.2300 ,  0 >     //        43.000
component 1.0,               0.5650, <    10.8806 ,   10.3253 ,  0 >     //        43.500
component 1.0,               0.5600, <    10.7901 ,   10.4199 ,  0 >     //        44.000
component 1.0,               0.5550, <    10.6988 ,   10.5136 ,  0 >     //        44.500
component 1.0,               0.5500, <    10.6066 ,   10.6066 ,  0 >     //        45.000
component 1.0,               0.5450, <    10.5136 ,   10.6988 ,  0 >     //        45.500
component 1.0,               0.5400, <    10.4199 ,   10.7901 ,  0 >     //        46.000
component 1.0,               0.5350, <    10.3253 ,   10.8806 ,  0 >     //        46.500
component 1.0,               0.5300, <    10.2300 ,   10.9703 ,  0 >     //        47.000
component 1.0,               0.5250, <    10.1339 ,   11.0592 ,  0 >     //        47.500
component 1.0,               0.5200, <    10.0370 ,   11.1472 ,  0 >     //        48.000
component 1.0,               0.5150, <     9.9393 ,   11.2343 ,  0 >     //        48.500
component 1.0,               0.5100, <     9.8409 ,   11.3206 ,  0 >     //        49.000
component 1.0,               0.5050, <     9.7417 ,   11.4061 ,  0 >     //        49.500
component 1.0,               0.5000, <     9.6418 ,   11.4907 ,  0 >     //        50.000
component 1.0,               0.4950, <     9.5412 ,   11.5744 ,  0 >     //        50.500
component 1.0,               0.4900, <     9.4398 ,   11.6572 ,  0 >     //        51.000
component 1.0,               0.4850, <     9.3377 ,   11.7391 ,  0 >     //        51.500
component 1.0,               0.4800, <     9.2349 ,   11.8202 ,  0 >     //        52.000
component 1.0,               0.4750, <     9.1314 ,   11.9003 ,  0 >     //        52.500
component 1.0,               0.4700, <     9.0272 ,   11.9795 ,  0 >     //        53.000
component 1.0,               0.4650, <     8.9223 ,   12.0579 ,  0 >     //        53.500
component 1.0,               0.4600, <     8.8168 ,   12.1353 ,  0 >     //        54.000
component 1.0,               0.4550, <     8.7105 ,   12.2117 ,  0 >     //        54.500
component 1.0,               0.4500, <     8.6036 ,   12.2873 ,  0 >     //        55.000
component 1.0,               0.4450, <     8.4961 ,   12.3619 ,  0 >     //        55.500
component 1.0,               0.4400, <     8.3879 ,   12.4356 ,  0 >     //        56.000
component 1.0,               0.4350, <     8.2791 ,   12.5083 ,  0 >     //        56.500
component 1.0,               0.4300, <     8.1696 ,   12.5801 ,  0 >     //        57.000
component 1.0,               0.4250, <     8.0595 ,   12.6509 ,  0 >     //        57.500
component 1.0,               0.4200, <     7.9488 ,   12.7207 ,  0 >     //        58.000
component 1.0,               0.4150, <     7.8375 ,   12.7896 ,  0 >     //        58.500
component 1.0,               0.4100, <     7.7256 ,   12.8575 ,  0 >     //        59.000
component 1.0,               0.4050, <     7.6131 ,   12.9244 ,  0 >     //        59.500
component 1.0,               0.4000, <     7.5000 ,   12.9904 ,  0 >     //        60.000
component 1.0,               0.3950, <     7.3864 ,   13.0553 ,  0 >     //        60.500
component 1.0,               0.3900, <     7.2721 ,   13.1193 ,  0 >     //        61.000
component 1.0,               0.3850, <     7.1574 ,   13.1823 ,  0 >     //        61.500
component 1.0,               0.3800, <     7.0421 ,   13.2442 ,  0 >     //        62.000
component 1.0,               0.3750, <     6.9262 ,   13.3052 ,  0 >     //        62.500
component 1.0,               0.3700, <     6.8099 ,   13.3651 ,  0 >     //        63.000
component 1.0,               0.3650, <     6.6930 ,   13.4240 ,  0 >     //        63.500
component 1.0,               0.3600, <     6.5756 ,   13.4819 ,  0 >     //        64.000
component 1.0,               0.3550, <     6.4577 ,   13.5388 ,  0 >     //        64.500
component 1.0,               0.3500, <     6.3393 ,   13.5946 ,  0 >     //        65.000
component 1.0,               0.3450, <     6.2204 ,   13.6494 ,  0 >     //        65.500
component 1.0,               0.3400, <     6.1010 ,   13.7032 ,  0 >     //        66.000
component 1.0,               0.3350, <     5.9812 ,   13.7559 ,  0 >     //        66.500
component 1.0,               0.3300, <     5.8610 ,   13.8076 ,  0 >     //        67.000
component 1.0,               0.3250, <     5.7403 ,   13.8582 ,  0 >     //        67.500
component 1.0,               0.3200, <     5.6191 ,   13.9078 ,  0 >     //        68.000
component 1.0,               0.3150, <     5.4975 ,   13.9563 ,  0 >     //        68.500
component 1.0,               0.3100, <     5.3755 ,   14.0037 ,  0 >     //        69.000
component 1.0,               0.3050, <     5.2531 ,   14.0501 ,  0 >     //        69.500
component 1.0,               0.3000, <     5.1303 ,   14.0954 ,  0 >     //        70.000
component 1.0,               0.2950, <     5.0071 ,   14.1396 ,  0 >     //        70.500
component 1.0,               0.2900, <     4.8835 ,   14.1828 ,  0 >     //        71.000
component 1.0,               0.2850, <     4.7596 ,   14.2249 ,  0 >     //        71.500
component 1.0,               0.2800, <     4.6353 ,   14.2658 ,  0 >     //        72.000
component 1.0,               0.2750, <     4.5106 ,   14.3058 ,  0 >     //        72.500
component 1.0,               0.2700, <     4.3856 ,   14.3446 ,  0 >     //        73.000
component 1.0,               0.2650, <     4.2602 ,   14.3823 ,  0 >     //        73.500
component 1.0,               0.2600, <     4.1346 ,   14.4189 ,  0 >     //        74.000
component 1.0,               0.2550, <     4.0086 ,   14.4545 ,  0 >     //        74.500
component 1.0,               0.2500, <     3.8823 ,   14.4889 ,  0 >     //        75.000
component 1.0,               0.2450, <     3.7557 ,   14.5222 ,  0 >     //        75.500
component 1.0,               0.2400, <     3.6288 ,   14.5544 ,  0 >     //        76.000
component 1.0,               0.2350, <     3.5017 ,   14.5855 ,  0 >     //        76.500
component 1.0,               0.2300, <     3.3743 ,   14.6156 ,  0 >     //        77.000
component 1.0,               0.2250, <     3.2466 ,   14.6444 ,  0 >     //        77.500
component 1.0,               0.2200, <     3.1187 ,   14.6722 ,  0 >     //        78.000
component 1.0,               0.2150, <     2.9905 ,   14.6989 ,  0 >     //        78.500
component 1.0,               0.2100, <     2.8621 ,   14.7244 ,  0 >     //        79.000
component 1.0,               0.2050, <     2.7335 ,   14.7488 ,  0 >     //        79.500
component 1.0,               0.2000, <     2.6047 ,   14.7721 ,  0 >     //        80.000
component 1.0,               0.1950, <     2.4757 ,   14.7943 ,  0 >     //        80.500
component 1.0,               0.1900, <     2.3465 ,   14.8153 ,  0 >     //        81.000
component 1.0,               0.1850, <     2.2171 ,   14.8352 ,  0 >     //        81.500
component 1.0,               0.1800, <     2.0876 ,   14.8540 ,  0 >     //        82.000
component 1.0,               0.1750, <     1.9579 ,   14.8717 ,  0 >     //        82.500
component 1.0,               0.1700, <     1.8280 ,   14.8882 ,  0 >     //        83.000
component 1.0,               0.1650, <     1.6980 ,   14.9036 ,  0 >     //        83.500
component 1.0,               0.1600, <     1.5679 ,   14.9178 ,  0 >     //        84.000
component 1.0,               0.1550, <     1.4377 ,   14.9309 ,  0 >     //        84.500
component 1.0,               0.1500, <     1.3073 ,   14.9429 ,  0 >     //        85.000
component 1.0,               0.1450, <     1.1769 ,   14.9538 ,  0 >     //        85.500
component 1.0,               0.1400, <     1.0463 ,   14.9635 ,  0 >     //        86.000
component 1.0,               0.1350, <     0.9157 ,   14.9720 ,  0 >     //        86.500
component 1.0,               0.1300, <     0.7850 ,   14.9794 ,  0 >     //        87.000
component 1.0,               0.1250, <     0.6543 ,   14.9857 ,  0 >     //        87.500
component 1.0,               0.1200, <     0.5235 ,   14.9909 ,  0 >     //        88.000
component 1.0,               0.1150, <     0.3927 ,   14.9949 ,  0 >     //        88.500
component 1.0,               0.1100, <     0.2618 ,   14.9977 ,  0 >     //        89.000
component 1.0,               0.1050, <     0.1309 ,   14.9994 ,  0 >     //        89.500
component 1.0,               0.1000, <     0.0000 ,   15.0000 ,  0 >     //        90.000

texture {
Grnt0
finish { ambient 0.4 }
scale <0.5, 5, 0.5>
}

bounded_by { box { <-1, 16, -3>, <18, -3, 3> } }
}

cylinder { <14.975, 0, 0>, <14.975, 2, 0>, 0.985
texture { Spun_Brass
finish { ambient 0.4 }
scale <4, 0.4, 4>
}
}

} // end of union, end of declare


// 8 arches
union {
object { Arch }
object { Arch rotate <0, 45, 0> }
object { Arch rotate <0, 90, 0> }
object { Arch rotate <0, 135, 0> }
object { Arch rotate <0, 180, 0> }
object { Arch rotate <0, 225, 0> }
object { Arch rotate <0, 270, 0> }
object { Arch rotate <0, 315, 0> }
}

cylinder { <0, -2, 0>, <0,-1.5, 0>, 23
texture {
pigment { image_map { tga "stone02.tga" } scale 5 rotate <85, 0, 0> }
normal { bump_map { tga "stone02.tga" bump_size 4 } scale 5 rotate <85, 0, 0> }
finish { ambient 0.4 }
scale 2.5
}
}

cylinder { <0, -1.5, 0>, <0,-1, 0>, 22
texture {
pigment { image_map { tga "stone02.tga" } scale 5 rotate <85, 7, 0> }
normal { bump_map { tga "stone02.tga" bump_size 4 } scale 5 rotate <85, 7, 0> }
finish { ambient 0.4 }
scale 2.5
}
}

cylinder { <0, -1, 0>, <0,-0.5, 0>, 21
texture {
pigment { image_map { tga "stone02.tga" } scale 5 rotate <85, 21, 0> }
normal { bump_map { tga "stone02.tga" bump_size 4 } scale 5 rotate <85, 21, 0> }
finish { ambient 0.4 }
scale 2.5
}
}

cylinder { <0, -0.5, 0>, <0, 0, 0>, 20
texture {
pigment { image_map { tga "stone02.tga" } scale 5 rotate <85, 49, 0> }
normal { bump_map { tga "stone02.tga" bump_size 4 } scale 5 rotate <85, 49, 0> }
finish { ambient 0.4 }
scale 2.5
}
}

box { <-2, 0, -1>, <2, 2, 1>
        pigment { Gray15 }
        finish { ambient 0.2 }
        }

box { <-4.5, 2, -2>, <4.5, 3, 2>
        texture {
        pigment { image_map { tga "blood.tga"} rotate <90, 0, 0> scale <9, 1, 4> translate <-4.5, 0, -2> }
        finish { ambient 0.2 }
        }
}



blob {
threshold 0.01
// front blobs
component         0.1341,     0.1022, <   0.3791, 0,  2.3448>
component         0.0304,     0.1779, <  -3.9046, 0,  3.2147>
component         0.1955,     0.1386, <  -4.2612, 0,  2.2244>
component         0.1493,     0.0954, <  -2.0515, 0,  2.4806>
component         0.0156,     0.0363, <  -2.0760, 0,  2.1246>
component         0.0723,     0.0075, <  -3.2454, 0,  2.0655>
component         0.0442,     0.1661, <   1.4008, 0,  3.4944>
component         0.0579,     0.0250, <   1.4074, 0,  3.1763>
component         0.0945,     0.0587, <   4.1768, 0,  2.9956>
component         0.1081,     0.1336, <  -1.3952, 0,  2.9101>
component         0.0500,     0.1107, <   0.1479, 0,  2.2149>
component         0.0242,     0.0586, <  -2.5872, 0,  2.0847>
component         0.0988,     0.0719, <   0.3483, 0,  2.7882>
component         0.1621,     0.0528, <  -1.6197, 0,  2.2176>
component         0.0441,     0.1551, <   3.6870, 0,  2.9309>
component         0.0079,     0.0612, <   0.2494, 0,  2.4891>
component         0.1713,     0.1831, <  -1.3494, 0,  2.9282>
component         0.0350,     0.1709, <  -0.2819, 0,  2.2494>
component         0.0114,     0.1852, <   2.6843, 0,  3.2227>
component         0.1660,     0.0217, <   4.4948, 0,  3.4258>
component         0.1120,     0.0176, <  -3.9551, 0,  2.6713>
component         0.1632,     0.0321, <  -0.6481, 0,  3.1106>
component         0.1062,     0.1290, <  -3.5634, 0,  2.0051>
component         0.0489,     0.1708, <  -1.4916, 0,  3.0977>
component         0.0056,     0.0479, <   3.7211, 0,  3.4717>
component         0.0589,     0.1659, <   2.9009, 0,  2.1429>
component         0.0412,     0.1958, <   0.4084, 0,  3.3496>
component         0.0820,     0.0129, <  -2.8506, 0,  2.6328>
component         0.0059,     0.0810, <   3.2749, 0,  2.3851>
component         0.0727,     0.1414, <  -0.3894, 0,  3.0411>
component         0.1545,     0.1965, <  -2.7879, 0,  3.1047>
component         0.0999,     0.1904, <   3.9687, 0,  3.3688>
component         0.0888,     0.1910, <  -4.1006, 0,  2.4206>
component         0.0047,     0.0157, <  -0.5657, 0,  2.0603>
component         0.0848,     0.0811, <  -2.5689, 0,  3.1245>
component         0.1022,     0.1634, <   0.8222, 0,  3.4308>
component         0.1758,     0.0784, <   0.1797, 0,  2.1545>
component         0.1622,     0.0652, <  -2.4964, 0,  2.9537>
component         0.1223,     0.1398, <   3.1211, 0,  2.7273>
component         0.1109,     0.0595, <   2.2587, 0,  3.3000>
component         0.0920,     0.0185, <  -3.1177, 0,  2.6778>
component         0.1299,     0.1167, <   0.0204, 0,  3.4209>
component         0.1877,     0.1132, <  -3.9142, 0,  2.6334>
component         0.0910,     0.1277, <  -2.0155, 0,  2.4444>
component         0.0780,     0.0698, <   0.9571, 0,  3.0794>
component         0.0142,     0.0884, <   4.4605, 0,  2.5668>
component         0.0300,     0.0032, <  -3.3266, 0,  2.5445>
component         0.1348,     0.0530, <   2.6554, 0,  2.7172>
component         0.0648,     0.1553, <   3.8911, 0,  2.9903>
component         0.1544,     0.0690, <   0.5524, 0,  2.1288>
component         0.1055,     0.0397, <   2.8845, 0,  2.2721>
component         0.0592,     0.1290, <  -1.8544, 0,  2.0613>
component         0.0242,     0.0738, <   0.8947, 0,  2.9355>
component         0.1964,     0.1980, <  -3.5969, 0,  2.1303>
component         0.1494,     0.1062, <   4.2322, 0,  2.9443>
component         0.0018,     0.1294, <   3.9310, 0,  3.1579>
component         0.0613,     0.0379, <  -0.9177, 0,  2.9699>
component         0.0660,     0.0564, <  -4.0843, 0,  2.3117>
component         0.1739,     0.1845, <  -0.4959, 0,  3.1069>
component         0.1055,     0.0377, <   2.8065, 0,  2.9270>
component         0.0458,     0.0460, <  -0.6541, 0,  2.5327>
component         0.1894,     0.1826, <  -2.7994, 0,  3.4467>
component         0.1908,     0.0473, <  -2.0593, 0,  2.3723>
component         0.1197,     0.0550, <  -0.4947, 0,  3.4607>
component         0.1704,     0.1737, <  -2.0718, 0,  2.9240>
component         0.1825,     0.1630, <   1.8065, 0,  2.0960>
component         0.1922,     0.0025, <   1.4680, 0,  2.6884>
component         0.1283,     0.0883, <   0.8662, 0,  3.0384>
component         0.1754,     0.0841, <   3.9625, 0,  3.1969>
component         0.1301,     0.0081, <  -4.3709, 0,  3.1138>
component         0.0188,     0.1179, <  -1.5224, 0,  3.4231>
component         0.0796,     0.0686, <   1.3113, 0,  3.4257>
component         0.1287,     0.0522, <  -4.0561, 0,  3.3239>
component         0.1255,     0.0379, <  -3.3450, 0,  2.5768>
component         0.1235,     0.0615, <  -3.9291, 0,  3.0142>
component         0.0285,     0.1325, <   3.9331, 0,  2.6797>
component         0.1104,     0.1158, <  -1.0145, 0,  2.3782>
component         0.1433,     0.0853, <   1.0618, 0,  2.2527>
component         0.0830,     0.0912, <  -3.8196, 0,  3.1281>
component         0.1426,     0.0329, <  -2.2458, 0,  2.3755>
component         0.0157,     0.0193, <  -0.6448, 0,  2.6261>
component         0.0274,     0.0998, <  -1.0829, 0,  3.0243>
component         0.0137,     0.0828, <  -3.2162, 0,  2.9353>
component         0.0189,     0.1475, <  -1.2872, 0,  2.1895>
component         0.0206,     0.1501, <   1.6142, 0,  3.3372>
component         0.0400,     0.0567, <   3.4201, 0,  2.7040>
component         0.1574,     0.1744, <   3.1965, 0,  2.5842>
component         0.1655,     0.0113, <  -1.6827, 0,  2.0847>
component         0.1002,     0.1642, <  -3.9709, 0,  3.4690>
component         0.1089,     0.0394, <   4.4964, 0,  2.1910>
component         0.0583,     0.0327, <  -1.5170, 0,  3.0778>
component         0.0581,     0.1824, <  -1.7415, 0,  2.0263>
component         0.0682,     0.0548, <   1.9702, 0,  2.1780>
component         0.1370,     0.0375, <   2.9711, 0,  3.1955>
component         0.1712,     0.1518, <   2.6183, 0,  2.6355>
component         0.1715,     0.0174, <  -4.3563, 0,  3.0810>
component         0.1997,     0.0283, <  -2.1036, 0,  2.2046>
component         0.0382,     0.1228, <   2.1690, 0,  3.3711>
component         0.1117,     0.1972, <  -2.0964, 0,  2.0684>
component         0.0200,     0.0939, <   0.2596, 0,  3.2836>
component         0.0044,     0.0025, <   2.3046, 0,  2.3438>
// left blobs
component         0.0741,     0.1104, <  -4.5950, 0,  0.0678>
component         0.0383,     0.1707, <  -5.3540, 0,  0.3346>
component         0.0376,     0.1075, <  -4.7966, 0,  1.8671>
component         0.1672,     0.1109, <  -4.6494, 0, -1.5394>
component         0.0258,     0.0241, <  -4.6117, 0,  1.9608>
component         0.0054,     0.0336, <  -5.1466, 0, -0.3864>
component         0.1966,     0.1076, <  -5.1330, 0,  0.6705>
component         0.0014,     0.1166, <  -4.8387, 0, -0.5621>
component         0.1345,     0.0556, <  -4.5987, 0,  1.2003>
component         0.1615,     0.1202, <  -4.9216, 0,  1.4718>
component         0.0612,     0.1444, <  -5.4452, 0,  1.7312>
component         0.0395,     0.1938, <  -5.1956, 0,  0.9976>
component         0.0029,     0.0722, <  -4.5125, 0,  1.9548>
component         0.0359,     0.0993, <  -5.1267, 0,  1.0867>
component         0.1602,     0.1937, <  -4.5366, 0,  1.5604>
component         0.1812,     0.0642, <  -4.9237, 0,  1.8696>
component         0.0212,     0.0081, <  -4.7829, 0, -0.9298>
component         0.1771,     0.1452, <  -5.2149, 0, -1.8668>
component         0.0304,     0.1359, <  -4.5072, 0, -1.6615>
component         0.0691,     0.1410, <  -5.3680, 0, -0.9120>
component         0.0858,     0.1813, <  -4.8621, 0,  1.9511>
component         0.0151,     0.1976, <  -5.3720, 0, -1.9680>
component         0.1634,     0.1464, <  -5.3344, 0, -0.5560>
component         0.1267,     0.0397, <  -5.1323, 0, -1.5247>
component         0.0257,     0.0905, <  -4.8713, 0, -0.0676>
component         0.1285,     0.1058, <  -5.0549, 0,  1.8109>
component         0.1682,     0.0521, <  -4.9813, 0, -1.2297>
component         0.0983,     0.1373, <  -5.0891, 0, -1.7058>
component         0.1256,     0.1147, <  -4.8272, 0, -0.8878>
component         0.1951,     0.0165, <  -4.6849, 0, -1.5966>
component         0.1485,     0.1661, <  -5.2467, 0,  0.2991>
component         0.0058,     0.1673, <  -4.7022, 0,  0.7434>
component         0.0003,     0.0215, <  -5.0156, 0,  0.9708>
component         0.0523,     0.0138, <  -4.9023, 0,  0.7066>
component         0.1328,     0.0888, <  -4.5824, 0, -0.8889>
component         0.0720,     0.0212, <  -4.7309, 0,  0.5157>
component         0.0003,     0.1032, <  -5.1926, 0, -0.2086>
component         0.1195,     0.0388, <  -4.7839, 0,  1.3281>
component         0.0960,     0.0989, <  -4.6031, 0, -0.0747>
component         0.0370,     0.1369, <  -5.3501, 0,  1.7318>
component         0.1331,     0.1270, <  -4.5934, 0, -0.4688>
component         0.1502,     0.1870, <  -5.3315, 0, -0.8861>
component         0.0295,     0.0644, <  -5.2590, 0,  0.4406>
component         0.1012,     0.1060, <  -4.8000, 0,  0.0086>
component         0.1789,     0.0395, <  -5.3467, 0, -0.2703>
component         0.1923,     0.0206, <  -5.1539, 0, -1.3139>
component         0.1461,     0.0161, <  -5.0175, 0, -1.4078>
component         0.0445,     0.1470, <  -5.4203, 0,  1.4345>
component         0.1536,     0.1199, <  -5.1783, 0, -1.1984>
component         0.0553,     0.0667, <  -5.1472, 0,  1.8344>
component         0.1141,     0.1553, <  -5.1941, 0,  1.3659>
component         0.0856,     0.1051, <  -4.5138, 0, -1.5196>
component         0.1449,     0.1386, <  -5.0266, 0, -1.0848>
component         0.0349,     0.1968, <  -5.2198, 0, -1.3269>
component         0.1924,     0.1903, <  -4.7469, 0, -1.9411>
component         0.1677,     0.0297, <  -4.5279, 0,  1.1502>
component         0.1479,     0.0454, <  -4.8448, 0,  1.5509>
component         0.1136,     0.0725, <  -4.9862, 0, -1.9885>
component         0.0743,     0.1533, <  -5.0737, 0,  1.0188>
component         0.0048,     0.0645, <  -5.3431, 0,  0.5566>
component         0.0448,     0.0368, <  -4.7020, 0, -0.1092>
component         0.1072,     0.0826, <  -4.5941, 0, -0.9103>
component         0.1605,     0.1733, <  -5.3052, 0,  1.7966>
component         0.1860,     0.0712, <  -5.4334, 0,  1.2851>
component         0.1949,     0.0494, <  -5.1723, 0,  0.9260>
component         0.0631,     0.0203, <  -4.9053, 0,  0.4128>
component         0.0428,     0.1512, <  -4.9122, 0, -1.0704>
component         0.1271,     0.1572, <  -4.7379, 0, -0.5753>
component         0.0517,     0.0625, <  -5.3719, 0, -0.0322>
component         0.1068,     0.1769, <  -5.1828, 0, -0.2615>
component         0.1526,     0.0115, <  -4.9615, 0, -0.8645>
component         0.0244,     0.0929, <  -4.7628, 0, -0.6844>
component         0.0458,     0.0728, <  -5.0933, 0,  1.5456>
component         0.1055,     0.0150, <  -4.9712, 0,  0.0168>
component         0.1839,     0.1924, <  -4.5423, 0, -1.7256>
component         0.1899,     0.0858, <  -4.8665, 0, -1.2174>
component         0.1410,     0.1448, <  -4.6250, 0,  0.1276>
component         0.0104,     0.0502, <  -4.7331, 0, -0.8482>
component         0.0109,     0.0070, <  -4.9098, 0,  0.2807>
component         0.1670,     0.1866, <  -4.5675, 0,  0.8126>
component         0.1556,     0.0159, <  -4.6791, 0,  0.9910>
component         0.1816,     0.0249, <  -5.4151, 0,  1.0465>
component         0.0504,     0.1038, <  -4.8740, 0, -1.0472>
component         0.1322,     0.1734, <  -5.1136, 0, -1.2085>
component         0.1187,     0.1549, <  -4.9354, 0, -0.8249>
component         0.0760,     0.0390, <  -4.9520, 0, -0.2807>
component         0.1280,     0.0081, <  -5.3559, 0,  0.0666>
component         0.0597,     0.0183, <  -4.6651, 0,  1.5612>
component         0.1801,     0.0278, <  -5.1168, 0, -0.2535>
component         0.0579,     0.0248, <  -5.4931, 0,  1.0518>
component         0.0412,     0.1069, <  -5.2330, 0,  1.3523>
component         0.1657,     0.0730, <  -4.9615, 0, -1.1031>
component         0.0685,     0.0241, <  -4.9863, 0, -0.8645>
component         0.0454,     0.0346, <  -5.1727, 0, -1.2984>
component         0.1502,     0.0764, <  -4.7456, 0,  0.6910>
component         0.0563,     0.1174, <  -4.9264, 0,  1.0636>
component         0.0180,     0.0745, <  -5.3609, 0, -0.0178>
component         0.0256,     0.0424, <  -5.1106, 0,  0.4018>
component         0.0264,     0.1530, <  -5.2307, 0,  1.9004>
component         0.1160,     0.1440, <  -5.3374, 0, -0.5952>
component         0.0477,     0.1544, <  -5.2833, 0, -1.7046>
// right blobs
component         0.0557,     0.0717, <   5.3368, 0,  0.8670>
component         0.1296,     0.0562, <   5.1238, 0,  1.1731>
component         0.1900,     0.0242, <   4.9989, 0, -1.0219>
component         0.1507,     0.1077, <   4.5624, 0,  0.2433>
component         0.0330,     0.1729, <   4.5197, 0, -1.8971>
component         0.1477,     0.1047, <   4.9670, 0, -0.1831>
component         0.0422,     0.1460, <   4.5523, 0,  1.5130>
component         0.1228,     0.1829, <   4.7017, 0,  0.7570>
component         0.0853,     0.0292, <   4.9911, 0, -1.4588>
component         0.1810,     0.0851, <   4.7625, 0, -1.8250>
component         0.1891,     0.1094, <   4.9896, 0, -0.5728>
component         0.0610,     0.0059, <   4.6493, 0,  0.8923>
component         0.1207,     0.0652, <   5.1485, 0, -0.2251>
component         0.0256,     0.1381, <   4.8146, 0, -1.2150>
component         0.1281,     0.1335, <   5.4606, 0,  0.9151>
component         0.1026,     0.0265, <   4.7756, 0,  1.5922>
component         0.1785,     0.1425, <   5.2510, 0, -0.9653>
component         0.1408,     0.0628, <   5.3708, 0, -1.6369>
component         0.1250,     0.0199, <   4.9692, 0, -0.4772>
component         0.0156,     0.0258, <   4.8666, 0, -1.6103>
component         0.0203,     0.1860, <   5.4198, 0, -0.5124>
component         0.1107,     0.1646, <   4.7431, 0, -1.4946>
component         0.0246,     0.1840, <   4.8036, 0,  0.7079>
component         0.1341,     0.1623, <   4.6853, 0,  0.2514>
component         0.1856,     0.1337, <   4.5716, 0, -0.8917>
component         0.0830,     0.1643, <   4.6590, 0, -0.1129>
component         0.0921,     0.0465, <   5.0076, 0, -0.1566>
component         0.0439,     0.0820, <   5.0997, 0,  1.7853>
component         0.0338,     0.1876, <   5.2509, 0, -0.6833>
component         0.1876,     0.1930, <   5.1679, 0, -1.7111>
component         0.1037,     0.0541, <   4.9550, 0,  0.0127>
component         0.1662,     0.1645, <   5.0755, 0,  0.8085>
component         0.1497,     0.1697, <   4.6326, 0,  0.8199>
component         0.1409,     0.1588, <   5.3420, 0,  1.6297>
component         0.1998,     0.1512, <   4.9144, 0, -1.4444>
component         0.0872,     0.1014, <   4.7893, 0, -0.8984>
component         0.0051,     0.1429, <   5.0222, 0, -1.8242>
component         0.1454,     0.1956, <   5.2299, 0, -1.5812>
component         0.1064,     0.1477, <   4.9104, 0,  1.8470>
component         0.1237,     0.0601, <   5.2004, 0, -1.1343>
component         0.1368,     0.1684, <   4.5317, 0,  1.9342>
component         0.1431,     0.1372, <   5.4718, 0, -0.1834>
component         0.0947,     0.1632, <   5.1957, 0, -0.1150>
component         0.0472,     0.1154, <   5.1084, 0, -0.7730>
component         0.1521,     0.1736, <   4.8680, 0,  1.7052>
component         0.0679,     0.1691, <   5.3273, 0,  1.8693>
component         0.0685,     0.0283, <   4.6528, 0, -0.1708>
component         0.0570,     0.0182, <   5.2834, 0, -1.9284>
component         0.1888,     0.0597, <   5.3476, 0, -1.2787>
component         0.0249,     0.1908, <   4.8092, 0, -1.9176>
component         0.1052,     0.1798, <   5.2058, 0, -0.7201>
component         0.1539,     0.0673, <   5.2605, 0,  0.0696>
component         0.1168,     0.1985, <   4.8094, 0,  1.0731>
component         0.0716,     0.0648, <   4.5758, 0,  1.6667>
component         0.1901,     0.1810, <   5.2870, 0, -0.8249>
component         0.0702,     0.0395, <   4.6085, 0, -1.7895>
component         0.1964,     0.1090, <   5.0765, 0,  1.0507>
component         0.0732,     0.1720, <   5.2716, 0, -1.2549>
component         0.1094,     0.1682, <   5.2792, 0, -0.8267>
component         0.0061,     0.0037, <   4.6690, 0,  1.8745>
component         0.0167,     0.0745, <   4.5298, 0, -1.9128>
component         0.0482,     0.1872, <   5.1060, 0,  0.9063>
component         0.1580,     0.1185, <   5.0185, 0,  0.6209>
component         0.0412,     0.0265, <   5.3417, 0, -0.6597>
component         0.1983,     0.0845, <   5.4015, 0, -0.4008>
component         0.1380,     0.1434, <   5.1933, 0, -1.7328>
component         0.0448,     0.1664, <   4.6127, 0, -1.1766>
component         0.1546,     0.0599, <   5.1380, 0, -0.4113>
component         0.1756,     0.0605, <   5.4984, 0, -0.3668>
component         0.0384,     0.1908, <   5.0450, 0,  0.3286>
component         0.0996,     0.0367, <   5.2038, 0, -1.3811>
component         0.1485,     0.1284, <   4.7177, 0,  0.0421>
component         0.0378,     0.1929, <   4.5918, 0,  0.8214>
component         0.0789,     0.0376, <   5.3730, 0,  0.9048>
component         0.0512,     0.0805, <   5.4928, 0, -0.2229>
component         0.1110,     0.0544, <   4.8655, 0, -0.1254>
component         0.1544,     0.0681, <   5.0836, 0,  1.2470>
component         0.0629,     0.0903, <   5.2746, 0, -1.9015>
component         0.1866,     0.0850, <   4.8360, 0, -1.2228>
component         0.0803,     0.0423, <   5.2673, 0,  1.5666>
component         0.0280,     0.0103, <   5.1182, 0, -0.1028>
component         0.0576,     0.0739, <   5.2758, 0,  1.4998>
component         0.0275,     0.1740, <   4.7637, 0, -1.4814>
component         0.0960,     0.0632, <   4.5087, 0, -1.7601>
component         0.0666,     0.0645, <   4.8194, 0, -0.8632>
component         0.0713,     0.0170, <   4.8915, 0,  0.7865>
component         0.1647,     0.0302, <   4.8589, 0, -1.6570>
component         0.0536,     0.1544, <   4.9137, 0,  0.5999>
component         0.1342,     0.1316, <   4.7252, 0,  0.5923>
component         0.0093,     0.1245, <   4.6547, 0,  1.0425>
component         0.0559,     0.0283, <   5.2734, 0, -1.1100>
component         0.0894,     0.1488, <   5.3439, 0,  1.9248>
component         0.1242,     0.0895, <   5.0152, 0, -0.6935>
component         0.1895,     0.0248, <   5.1396, 0, -1.8545>
component         0.0681,     0.1037, <   5.2807, 0, -1.6393>
component         0.1763,     0.0910, <   4.7088, 0, -1.0943>
component         0.1908,     0.0291, <   4.5775, 0,  1.6695>
component         0.1264,     0.1453, <   4.5866, 0, -0.0607>
component         0.1355,     0.0963, <   5.0209, 0, -1.8553>
component         0.1182,     0.1891, <   4.7837, 0,  1.5927>
component         0.0606,     0.1673, <   5.0997, 0, -0.3328>
// back blobs
component         0.1019,     0.0382, <  -1.4585, 0, -2.1667>
component         0.0598,     0.1529, <   2.4963, 0, -2.7558>
component         0.0696,     0.1616, <   1.9630, 0, -2.1516>
component         0.1630,     0.0568, <   0.2287, 0, -2.7985>
component         0.0450,     0.1526, <  -0.9429, 0, -2.1627>
component         0.1577,     0.0819, <  -2.9850, 0, -2.4885>
component         0.1085,     0.1712, <  -2.5777, 0, -2.7241>
component         0.0053,     0.1038, <   4.3610, 0, -3.0048>
component         0.1568,     0.0287, <  -1.8049, 0, -2.6627>
component         0.1936,     0.1908, <   3.2672, 0, -2.9291>
component         0.1914,     0.1435, <   1.9849, 0, -2.2535>
component         0.0830,     0.0531, <   0.3084, 0, -2.7598>
component         0.1207,     0.1702, <   2.8960, 0, -2.3358>
component         0.1375,     0.0715, <   1.7555, 0, -2.5722>
component         0.0713,     0.0335, <  -3.6102, 0, -2.2987>
component         0.0401,     0.0228, <  -4.4479, 0, -2.8320>
component         0.0626,     0.0580, <   0.3451, 0, -3.4618>
component         0.1615,     0.0270, <   2.0788, 0, -2.7794>
component         0.0363,     0.1046, <  -1.6405, 0, -3.0501>
component         0.0619,     0.0947, <  -3.0198, 0, -2.4325>
component         0.0225,     0.1169, <  -1.3683, 0, -3.2137>
component         0.0433,     0.0006, <  -1.9627, 0, -2.4332>
component         0.1214,     0.1351, <  -0.1073, 0, -3.4565>
component         0.0023,     0.1958, <   2.9300, 0, -2.1000>
component         0.1511,     0.1464, <  -2.3432, 0, -2.6916>
component         0.0774,     0.1431, <   3.2706, 0, -2.2830>
component         0.0085,     0.1212, <  -3.8352, 0, -2.5355>
component         0.0693,     0.1737, <  -0.8255, 0, -3.1629>
component         0.0303,     0.1162, <   2.1003, 0, -3.3630>
component         0.0437,     0.0309, <   4.0033, 0, -2.8274>
component         0.0755,     0.1691, <  -2.2066, 0, -2.5467>
component         0.1378,     0.0806, <  -2.6890, 0, -2.5021>
component         0.0930,     0.0214, <  -1.2395, 0, -2.4289>
component         0.0458,     0.0268, <   3.1785, 0, -2.3458>
component         0.1821,     0.0086, <   2.3472, 0, -2.0220>
component         0.1428,     0.1577, <  -0.6167, 0, -3.4789>
component         0.1435,     0.0797, <  -1.3896, 0, -2.8706>
component         0.0770,     0.1550, <  -2.1425, 0, -3.0302>
component         0.0044,     0.0010, <  -0.4561, 0, -3.2605>
component         0.1599,     0.0489, <  -3.0493, 0, -3.2535>
component         0.1579,     0.0843, <  -3.2022, 0, -2.9687>
component         0.1885,     0.0634, <   2.6939, 0, -2.0959>
component         0.1636,     0.0145, <  -0.2526, 0, -2.7594>
component         0.0856,     0.0323, <  -0.1444, 0, -3.1258>
component         0.1752,     0.0725, <  -3.6366, 0, -2.8090>
component         0.0315,     0.0574, <   1.0608, 0, -2.4484>
component         0.0624,     0.0189, <  -3.2410, 0, -2.7453>
component         0.0292,     0.0477, <  -1.1661, 0, -3.1191>
component         0.1041,     0.0068, <   0.9909, 0, -2.0656>
component         0.0209,     0.0908, <   1.0078, 0, -2.4396>
component         0.0799,     0.0337, <  -0.8775, 0, -3.2286>
component         0.0691,     0.0670, <   3.6231, 0, -3.2825>
component         0.1652,     0.1392, <   1.6972, 0, -2.6841>
component         0.0205,     0.0530, <  -0.8545, 0, -3.0876>
component         0.0811,     0.1396, <  -2.1426, 0, -3.0779>
component         0.1496,     0.0591, <  -3.4790, 0, -2.5780>
component         0.1319,     0.0846, <  -3.6265, 0, -2.5245>
component         0.1965,     0.0492, <   3.7898, 0, -3.1752>
component         0.0415,     0.0213, <  -1.4897, 0, -2.5098>
component         0.1050,     0.0293, <  -1.5841, 0, -3.0985>
component         0.1855,     0.1951, <   3.7410, 0, -3.3597>
component         0.1102,     0.0412, <   3.1776, 0, -2.0712>
component         0.0302,     0.0536, <  -0.8123, 0, -3.4939>
component         0.1968,     0.1377, <  -0.0385, 0, -3.1127>
component         0.0530,     0.0382, <  -3.8851, 0, -3.1831>
component         0.1249,     0.0929, <  -1.3345, 0, -2.0721>
component         0.0508,     0.1248, <  -3.8673, 0, -2.9132>
component         0.0690,     0.1405, <  -2.5980, 0, -2.9497>
component         0.1871,     0.1375, <  -0.9430, 0, -2.8786>
component         0.1911,     0.0730, <  -4.2735, 0, -2.1251>
component         0.0333,     0.1297, <   0.3308, 0, -3.2307>
component         0.0279,     0.1013, <  -3.3496, 0, -2.4782>
component         0.0058,     0.0066, <   1.2503, 0, -3.1201>
component         0.0950,     0.0284, <   2.4958, 0, -2.6793>
component         0.0159,     0.1814, <   4.2101, 0, -2.3536>
component         0.1621,     0.1039, <   4.4004, 0, -2.0542>
component         0.0427,     0.0492, <  -1.9560, 0, -3.2077>
component         0.1134,     0.0263, <   1.5399, 0, -3.1313>
component         0.0696,     0.0531, <  -1.9111, 0, -2.1532>
component         0.1578,     0.1772, <   2.5340, 0, -2.2333>
component         0.0290,     0.0824, <   4.0649, 0, -2.2720>
component         0.0323,     0.1227, <   3.8479, 0, -3.4170>
component         0.0375,     0.0626, <   2.7773, 0, -2.9649>
component         0.0993,     0.0634, <   4.4515, 0, -2.7700>
component         0.1714,     0.0022, <  -2.1038, 0, -3.3674>
component         0.0264,     0.0200, <   1.7159, 0, -2.9619>
component         0.0774,     0.0128, <   2.8723, 0, -2.6127>
component         0.0397,     0.1747, <   0.9294, 0, -2.8760>
component         0.1008,     0.1699, <  -4.1906, 0, -2.6153>
component         0.1655,     0.0692, <  -0.4869, 0, -2.9305>
component         0.1500,     0.1561, <  -4.1705, 0, -2.5982>
component         0.1524,     0.1060, <  -2.4937, 0, -2.5077>
component         0.0491,     0.0982, <  -1.3079, 0, -2.9186>
component         0.0661,     0.1920, <  -3.0743, 0, -3.3801>
component         0.0428,     0.0432, <   1.4795, 0, -3.4704>
component         0.0222,     0.0605, <   2.0826, 0, -3.2083>
component         0.0946,     0.1224, <  -0.0551, 0, -2.0282>
component         0.1599,     0.1442, <  -0.9118, 0, -2.5351>
component         0.1984,     0.1633, <   2.9326, 0, -2.4247>
component         0.1927,     0.1572, <   4.3594, 0, -2.6619>
component         0.0549,     0.0637, <  -0.9681, 0, -2.2939>

texture {
pigment { red 0.6 green 0.0 blue 0.01 }
finish { ambient 0.2 }
}

bounded_by { box { <-6, -0.5, -3.5>, <6, 3.5, 3.5> } }

}

#declare BloodMetal = 
pigment { bozo 
        color_map { [ 0.0 color Gray60 ]
                    [ 0.4 color Gray60 ]
                    [ 0.5 color red 0.6 ]
                    [ 1.0 color red 0.6 ]
                  }
        }

#declare Mount_Ring = 
torus { 0.3, 0.05 rotate <0, 0, 90> texture { BloodMetal scale 0.05 } }

object { Mount_Ring translate <-4.2, 2.6, -2> }
object { Mount_Ring translate <-4.2, 2.6, 2> }
object { Mount_Ring translate <4.2, 2.6, -2> }
object { Mount_Ring translate <4.2, 2.6, 2> }

#declare LinkEnd =         
torus { 0.15, 0.05
        clipped_by { plane { x, 0 } }
        }
#declare Link = 
union {
        object { LinkEnd }
        object { LinkEnd rotate <0, 0, 180> translate <0.2, 0, 0> }
        cylinder { <0, 0, 0.15>, <0.2, 0, 0.15>, 0.05 }
        cylinder { <0, 0, -0.15>, <0.2, 0, -0.15>, 0.05 }
        
        texture { BloodMetal scale 0.05 }
        }

#declare Manacle =
union {
        object { LinkEnd translate <1.2, 0, 0> }
        difference {
                cylinder { <1.5, 0, -0.2>, <1.5, 0, 0.2>, 0.3 }
                cylinder { <1.5, 0, -0.4>, <1.5, 0, 0.4>, 0.25 }
                }
        texture { BloodMetal scale 0.05 }
        }

#declare Chain =
union {
        object { Link }
        object { Link rotate <90, 0, 0> translate <0.4, 0, 0> }
        object { Link translate <0.8, 0, 0> }
        object { Manacle }
        }

object {
        Chain
        rotate <90, 0, -90>
        translate <-4.2, 2.4, -2.05>
        }

object {
        Chain
        rotate <90, 0, -90>
        translate <4.2, 2.4, -2.05>
        }

object {
        Chain
        rotate <90, 0, -90>
        translate <-4.2, 2.4, 2.05>
        }

object {
        Chain
        rotate <90, 0, -90>
        translate <4.2, 2.4, 2.05>
        }

/* Knife
union {
difference {
        cone { <0,0,0>, 0 <0,0,1>, 1
                scale <0.050000, 2.500000, 15.000000>
                }
        cylinder { <0,0,1>, <0,0,0>, 1
                scale <5.000000, 5.000000, 15.000000>
                translate <-5.010000, 0.000000, 0.000000>
                }
        cylinder { <0,0,1>, <0,0,0>, 1
                scale <5.000000, 5.000000, 15.000000>
                translate <5.010000, 0.000000, 0.000000>
                }
        texture {
                pigment { bozo 
                        color_map { [ 0.0 color Gray30 ]
                                    [ 0.4 color Gray30 ]
                                    [ 0.5 color red 0.6 ]
                                    [ 1.0 color red 0.6 ]
                                  }
                        }
                finish {
                        ambient 0.1
                        diffuse 0.7
                        brilliance 6.0
                        reflection 0.4
                        phong 0.8
                        phong_size 120
                        }
                scale 0.05
                }
        }

difference {
        cylinder { <0,0,1>, <0,0,0>, 1
                scale <8.000000, 8.000000, 1.500000>
                rotate <0.000000, -90.000000, 0.000000>
                translate <0.750000, 0.000000, 7.750000>
                }
        cylinder { <0,0,1>, <0,0,0>, 1
                scale <12.000000, 12.000000, 2.000000>
                rotate <0.000000, -90.000000, 0.000000>
                translate <1.000000, 0.000000, 3.000000>
                }
        texture { Polished_Brass }
        }

difference {
        cylinder { <0,0,1>, <0,0,0>, 1
                scale <0.750000, 1.000000, 10.000000>
                translate <0.000000, 0.000000, 15.000000>
                }
        torus { 1.350, 0.650
                rotate -x*90
                scale <1.000000, 1.000000, 0.500000>
                translate <0.000000, 0.000000, 17.000000>
                }
        torus { 1.350, 0.650
                rotate -x*90
                scale <1.000000, 1.000000, 0.500000>
                translate <0.000000, 0.000000, 18.000000>
                }
        torus { 1.350, 0.650
                rotate -x*90
                scale <1.000000, 1.000000, 0.500000>
                translate <0.000000, 0.000000, 19.000000>
                }
        torus { 1.350, 0.650
                rotate -x*90
                scale <1.000000, 1.000000, 0.500000>
                translate <0.000000, 0.000000, 20.000000>
                }
        torus { 1.350, 0.650
                rotate -x*90
                scale <1.000000, 1.000000, 0.500000>
                translate <0.000000, 0.000000, 21.000000>
                }
        torus { 1.350, 0.650
                rotate -x*90
                scale <1.000000, 1.000000, 0.500000>
                translate <0.000000, 0.000000, 22.000000>
                }
        torus { 1.350, 0.650
                rotate -x*90
                scale <1.000000, 1.000000, 0.500000>
                translate <0.000000, 0.000000, 23.000000>
                }
        torus { 1.350, 0.650
                rotate -x*90
                scale <1.000000, 1.000000, 0.500000>
                translate <0.000000, 0.000000, 16.000000>
                }
        texture { Dark_Wood }

}

sphere { <0,0,0>, 1
        texture { Polished_Brass }
        scale <1.000000, 1.250000, 1.000000>
        translate <0.000000, 0.000000, 25.000000>
        }

scale 0.2
rotate <0, 0, 90>
rotate <0, 30, 0>
translate <0, 3.0305, -1>

} // end union

*/ 

