/*** Arches object *********************************************/

#declare ArchTex = texture { Stone7 scale 1/2 }

#declare ArchesTopTex = texture { Stone9 scale 2 }

#declare ArchTopDecorTex = texture { Stone10 scale 1/2 }

#declare ArchSupport = box { <-0.60, 8.00, -0.60>, <0.60, 8.10, 0.60> }

#declare ArchTorus =
  intersection {
    torus { 12.55, 0.05 rotate (x * 90) translate (y * -3.9) }
    plane { -y, 0 translate (y * 8.1) }

    bounded_by { box { <-3.9, 8.1, -0.05>, <3.9, 8.7, 0.05> } }
  } // intersection

#declare Arch =
  union {
    object { ArchTorus translate (z * -0.55) }
    object { ArchTorus translate (z *  0.55) }

    intersection {
      cylinder { <0, -3.9, -0.55>, <0, -3.9, 0.55>, 12.6 }
      cylinder { <0, -3.9, -0.60>, <0, -3.9, 0.60>, 12.5 inverse }
      plane { -y, 0 translate (y * 8.1) }
    } // intersection

    object { ArchSupport translate (x * -4) }

    texture { ArchTex }

    bounded_by { box { <-4.6, 8.0, -0.6>, <3.9, 8.7, 0.6> } }
  } // union

#declare ArchTopDecor =
  union {
    box { <-3.80, 9.50, -0.05>, < 3.80, 9.60, 0.00> }
    box { <-3.80, 8.40, -0.05>, <-3.70, 9.50, 0.00> }
    box { < 3.70, 8.40, -0.05>, < 3.80, 9.50, 0.00> }

    intersection {
      cylinder { <0, -3.90, -0.05>, <0, -3.90, 0.00>, 12.90 }
      cylinder { <0, -3.90, -0.10>, <0, -3.90, 0.10>, 12.80 inverse }
      plane { -x, 3.80 }
      plane {  x, 3.80 }
    } // intersection

    texture { ArchTopDecorTex }

    bounded_by { box { <-3.80, 8.30, -0.05>, <3.80, 9.60, 0.00> } }
  } // union

#declare ArchesTop =
  difference {
    box { <-12.00, 8.10, -0.55>, <12.00, 10.00, 0.55> }

    cylinder { <-8, -3.90, -0.60>, <-8, -3.90, 0.60>, 12.60 }
    cylinder { < 0, -3.90, -0.60>, < 0, -3.90, 0.60>, 12.60 }
    cylinder { < 8, -3.90, -0.60>, < 8, -3.90, 0.60>, 12.60 }

    texture { ArchesTopTex }
  } // difference

#declare Arches =
  union {
    object { ArchesTop }

    object { ArchTopDecor translate <-8, 0, -0.55> }
    object { ArchTopDecor translate < 0, 0, -0.55> }
    object { ArchTopDecor translate < 8, 0, -0.55> }

    object { Arch translate (x * -8) }
    object { Arch translate (x *  0) }
    object { Arch translate (x *  8) }

    bounded_by { box { <-12.60, 8.00, -0.60>, <12.0, 10.00, 0.60> } }
  } // union
