/*** IonicColumn object ************************************/

#declare ICBase =
  union {
    union {
      cylinder { (y * 0.00), (y * 0.13), 0.60 }
      torus { 0.60, 0.05 translate (y * 0.05) }

      bounded_by { cylinder { (y * 0.00), (y * 0.13), 0.65 } }
    } // union

    difference {
      cylinder { (y * 0.13), (y * 0.26), 0.57 }
      torus { 0.57, 0.05 translate (y * 0.18) }

      bounded_by { cylinder { (y * 0.13), (y * 0.26), 0.57 } }
    } // difference

    union {
      cylinder { (y * 0.26), (y * 0.38), 0.52 }
      torus { 0.52, 0.05 translate (y * 0.31) }

      bounded_by { cylinder { (y * 0.26), (y * 0.38), 0.57 } }
    } // union

    difference {
      cylinder { (y * 0.38), (y * 0.40), 0.52 }
      torus { 0.52, 0.02 translate (y * 0.40) }

      bounded_by { cylinder { (y * 0.38), (y * 0.40), 0.52 } }
    } // difference

    bounded_by { cylinder { (y * 0.00), (y * 0.40), 0.65 } }
  } // union

#declare ICFlute =
  union {
    sphere { <0.49963235, 0.45, 0>, 0.03500000 }
    sphere { <0.45036765, 7.15, 0>, 0.03156833 }
    cone { <0.49963222, 0.45001793, 0>, 0.035, <0.45036753, 7.15001617, 0>, 0.03156832 }

    bounded_by { box { <0.41, 0.4, -0.04>, <0.54, 7.19, 0.04> } }
  } // union

#declare ICSixFlutes =
  union {
    object { ICFlute rotate (y *  -0) }
    object { ICFlute rotate (y * -15) }
    object { ICFlute rotate (y * -30) }
    object { ICFlute rotate (y * -45) }
    object { ICFlute rotate (y * -60) }
    object { ICFlute rotate (y * -75) }

    bounded_by {
      box {
        <0, 0.4, 0>, <0.23308160, 7.19, 0.70225229>

        rotate (y * -38.13651934)
        translate <0.46592384, 0, -0.08851891>
      } // box
    } // bounded_by
  } // union

#declare ICShaft =
  difference {
    cone { (y * 0.40), 0.50, (y * 7.20), 0.45 }

    object { ICSixFlutes rotate (y *   -0) }
    object { ICSixFlutes rotate (y *  -90) }
    object { ICSixFlutes rotate (y * -180) }
    object { ICSixFlutes rotate (y * -270) }

    bounded_by { cone { (y * 0.40), 0.50, (y * 7.20), 0.45 } }
  } // difference

#declare ICVolute =
  union {
    // Left 'half'

    union {
      // Body

      intersection {
        box { <0.275, 7.7, -0.50>, <0.55, 7.93, 0.50> }
        cylinder { <0.55, 6.96875, -1>, <0.55, 6.96875, 1>, 0.78125 inverse }
      } // intersection

      intersection {
        cylinder { (z * -0.50), (z * 0.50), 0.23 }
        plane { x, 0 }

        translate <0.55, 7.50, 0>
      } // intersection

      // Contour

      intersection {
        cylinder { <0.55, 6.96875, -0.55>, <0.55, 6.96875, 0.55>, 0.78125 }
        cylinder { <0.55, 6.96875, -1.00>, <0.55, 6.96875, 1.00>, 0.76125 inverse }
        plane { x, 0 translate (x * 0.55) }
        plane { y, 0 rotate (z * 110.60969294) translate <0.55, 6.96875, 0> }
      } // intersection

      intersection {
        union {
          intersection {
            cylinder { (z * -0.55), (z * 0.55), 0.25 }
            cylinder { (z * -1.00), (z * 1.00), 0.23 inverse }
          } // intersection

          intersection {
            cylinder { (z * -0.55), (z * 0.55), 0.15 }
            cylinder { (z * -1.00), (z * 1.00), 0.13 inverse }
          } // intersection
        } // union

        plane { x, 0 }

        translate <0.55, 7.50, 0>
      } // intersection

      bounded_by { box { <0.27, 7.25, -0.55>, <0.55, 7.93, 0.55> } }
    } // union

    // Right 'half'

    union {
      // Body

      intersection {
        cylinder { (z * -0.50), (z * 0.50), 0.33 }
        plane { -x, 0 }

        translate <0.55, 7.60, 0>
      } // intersection

      // Contour

      intersection {
        union {
          intersection {
            cylinder { (z * -0.55), (z * 0.55), 0.35 }
            cylinder { (z * -1.00), (z * 1.00), 0.33 inverse }

            translate <0.55, 7.60, 0>
          } // intersection

          intersection {
            cylinder { (z * -0.55), (z * 0.55), 0.20 }
            cylinder { (z * -1.00), (z * 1.00), 0.18 inverse }

            translate <0.55, 7.55, 0>
          } // intersection
        } // union

        plane { -x, 0 translate (x * 0.55) }
      } // intersection

      bounded_by { box { <0.55, 7.25, -0.55>, <0.90, 7.95, 0.55> } }
    } // union

    // Center ball of volute

    cylinder { (z * -0.55), (z * 0.55), 0.10 translate <0.55, 7.55, 0> }

    bounded_by { box { <0.27, 7.25, -0.55>, <0.90, 7.95, 0.55> } }
  } // union

#declare ICEOvum =
  union {
    sphere { <0, 0, 0>, 1 scale <0.08, 0.08, 0.05> }

    intersection {
      sphere { <0, 0, 0>, 1 scale <0.08, 0.20, 0.05> }
      plane { y, 0 }
    } // intersection

    bounded_by { box { <-0.08, -0.20, -0.05>, <0.08, 0.08, 0.05> } }

    translate <0, 7.46, -0.45>
  } // union

#declare ICESphere = sphere { <0, 7.57, -0.45>, 0.03 }

#declare ICEOva =
  union {
    object { ICEOvum rotate (y *  20.28708873 * 0) }
    object { ICEOvum rotate (y *  20.28708873 * 1) }
    object { ICEOvum rotate (y * -20.28708873 * 1) }
    object { ICEOvum rotate (y *  20.28708873 * 2) }
    object { ICEOvum rotate (y * -20.28708873 * 2) }
    object { ICEOvum rotate (y *  20.28708873 * 3) }
    object { ICEOvum rotate (y * -20.28708873 * 3) }

    object { ICESphere rotate (y *  10.14354437 * 0) }
    object { ICESphere rotate (y *  10.14354437 * 1) }
    object { ICESphere rotate (y * -10.14354437 * 1) }
    object { ICESphere rotate (y *  10.14354437 * 2) }
    object { ICESphere rotate (y * -10.14354437 * 2) }
    object { ICESphere rotate (y *  10.14354437 * 3) }
    object { ICESphere rotate (y * -10.14354437 * 3) }
    object { ICESphere rotate (y *  10.14354437 * 4) }
    object { ICESphere rotate (y * -10.14354437 * 4) }
    object { ICESphere rotate (y *  10.14354437 * 5) }
    object { ICESphere rotate (y * -10.14354437 * 5) }
    object { ICESphere rotate (y *  10.14354437 * 6) }
    object { ICESphere rotate (y * -10.14354437 * 6) }

    bounded_by { box { <-0.46, 7.26, -0.50>, <0.46, 7.60, -0.14> } }
  } // union

#declare ICETorus =
  torus {
    0.45, 0.01

    bounded_by { cylinder { (y * -0.01), (y * 0.01), 0.46 } }
  } // torus

#declare ICEcchinus =
  union {
    cylinder { (y * 7.23), (y * 7.75), 0.45 }

    object { ICEOva rotate (y *   0) }
    object { ICEOva rotate (y * 180) }

    object { ICETorus translate (y * 7.245) }
    object { ICETorus translate (y * 7.615) }

    bounded_by { cylinder { (y * 7.23), (y * 7.75), 0.50 } }
  } // union

#declare ICCapital =
  union {
    cylinder { (y * 7.20), (y * 7.23), 0.48 }

    object { ICEcchinus }

    union {
      intersection {
        box { <-0.275, 7.65, -0.50>, <0.275, 7.93, 0.50> }
        cylinder { <0, 8.43125, -1>, <0, 8.43125, 1>, 0.78125 }
      } // intersection

      intersection {
        cylinder { <0, 8.43125, -0.55>, <0, 8.43125, 0.55>, 0.80125 }
        cylinder { <0, 8.43125, -1>, <0, 8.43125, 1>, 0.78125 inverse }
        plane { -y, 0 rotate (z * 110.60969294) translate <0, 8.43125, 0> }
        plane {  y, 0 rotate (z *  69.39030706) translate <0, 8.43125, 0> }
      } // intersection

      bounded_by { box { <-0.29, 7.63, -0.55>, <0.29, 7.93, 0.55> } }
    } // union

    box { <-0.55, 7.93, -0.55>, <0.55, 7.95, 0.55> }

    object { ICVolute rotate (y *   0) }
    object { ICVolute rotate (y * 180) }

    cylinder { (y * 7.95), (y * 8.00), 0.50 }

    intersection {
      torus { 0.50, 0.05 }
      plane { y, 0.00 }

      bounded_by { cylinder { (y * -0.05), (y * 0.00), 0.55 } }

      translate (y * 8.00)
    } // intersection

    bounded_by { box { <-0.90, 7.20, -0.55>, <0.90, 8.00, 0.55> } }
  } // union

#declare IonicColumn =
  union {
    object { ICBase }
    object { ICShaft }
    object { ICCapital }

    bounded_by { box { <-0.9, 0, -0.65>, <0.9, 8, 0.65> } }
  } // union
