#declare LightColor = color rgb <0.1, 0.1, 0.09>

#declare LightTex =
  texture {
    pigment { color rgb <1.0, 1.0, 0.90> }
    finish {
      ambient 0.6
      diffuse 0.4
      phong 0.7
      phong_size 80
      reflection 0.20
    } // finish
  } // texture

#declare StairPaintedMetalTex =
  texture {
    pigment { color DarkGreen }
    normal { bumps 0.2 }
    finish {
      ambient 0.2
      diffuse 0.6
      phong 0.4
      phong_size 30
      reflection 0.05
    } // finish
  } // texture

#declare StairBrassTex = texture { Brass_Metal }

#declare StairHandleTex = texture { EMBWood1 rotate (x * 90) rotate (z * 25) }

#declare StairStepTex = texture { Stone7 scale 2 }

#declare StairFloorTex = texture { Stone4 scale 2 }

/*** StairSupport object ***************************************/

#declare SSTorus =
  torus {
    0.225, 0.025

    bounded_by { cylinder { (y * -0.025), (y * 0.025), 0.25 } }

    rotate (x * 90)
  } // torus

#declare SSupDecor =
  union {
    object { SSTorus translate (y * 1.15) }
    object { SSTorus translate (y * 1.65) }
    object { SSTorus translate (y * 2.15) }

    sphere { <-0.20, 0.15, 0.00>, 0.05 }
    cylinder { <-0.20, 0.15, 0.00>, <0.20, 0.15, 0.00>, 0.05 }
    sphere { <0.20, 0.15, 0.00>, 0.05 }

    sphere { <-0.20, 2.85, 0.00>, 0.05 }
    cylinder { <-0.20, 2.85, 0.00>, <0.20, 2.85, 0.00>, 0.05 }
    sphere { <0.20, 2.85, 0.00>, 0.05 }

    texture { StairBrassTex }

    bounded_by { box { <-0.25, 0.10, -0.05>, <0.25, 2.90, 0.05> } }
  } // union

#declare SSupBevel =
  intersection {
    box { <-0.35, 0.00, -0.35>, <0.35, 0.05, 0.35> }

    plane { y, 0 rotate (z * -45) translate (x * 0.35) rotate (y *   0) }
    plane { y, 0 rotate (z * -45) translate (x * 0.35) rotate (y *  90) }
    plane { y, 0 rotate (z * -45) translate (x * 0.35) rotate (y * 180) }
    plane { y, 0 rotate (z * -45) translate (x * 0.35) rotate (y * 270) }
  } // intersection

#declare SSupBody =
  union {
    box { <-0.30, 0.00, -0.30>, <0.30, 3.00, 0.30> }

    object { SSupBevel }
    object { SSupBevel rotate (x * 180) translate (y * 3.00) }

    texture { StairPaintedMetalTex }
  } // union

#declare SSupBottom =
  union {
    object { SSupBody }

    object { SSupDecor translate (z * 0.30) rotate (y *   0) }
    object { SSupDecor translate (z * 0.30) rotate (y *  90) }
    object { SSupDecor translate (z * 0.30) rotate (y * 180) }
    object { SSupDecor translate (z * 0.30) rotate (y * 270) }

    bounded_by { box { <-0.35, 0.00, -0.35>, <0.35, 3.00, 0.35> } }
  } // union

#declare SSupLight =
  union {
    sphere {
      <0, 0, 0>, 0.30

      texture { LightTex }

      no_shadow
    } // sphere

    light_source { <0, 0, 0> color LightColor }
  } // union

#declare SSupLampFlute =
  union {
    sphere { (y * 3.15), 0.05 }
    cylinder { (y * 3.15), (y * 4.55), 0.05 }
    sphere { (y * 4.55), 0.05 }

    bounded_by { box { <-0.05, -3.10, -0.05>, <0.05, 4.60, 0.05> } }

    translate (x * 0.20)
  } // union

#declare SSupLamp =
  union {
    union {
      cone { (y * 3.00), 0.25, (y * 3.05), 0.20 }

      difference {
        cylinder { (y * 3.05), (y * 4.65), 0.20 }

        object { SSupLampFlute rotate (y *   0) }
        object { SSupLampFlute rotate (y *  45) }
        object { SSupLampFlute rotate (y *  90) }
        object { SSupLampFlute rotate (y * 135) }
        object { SSupLampFlute rotate (y * 180) }
        object { SSupLampFlute rotate (y * 225) }
        object { SSupLampFlute rotate (y * 270) }
        object { SSupLampFlute rotate (y * 315) }

        bounded_by { cylinder { (y * 3.05), (y * 4.65), 0.20 } }
      } // difference

      cone { (y * 4.65), 0.20, (y * 4.70), 0.25 }

      texture { StairPaintedMetalTex }
    } // union

    cylinder { (y * 4.70), (y * 4.75), 0.15 texture { StairBrassTex } }

    object { SSupLight translate (y * 5.00) }

    bounded_by { box { <-0.30, 3.00, -0.30>, <0.30, 5.30, 0.30> } }
  } // union

#declare StairSupport =
  union {
    object { SSupBottom }
    object { SSupLamp }

    bounded_by { box { <-0.35, 0.00, -0.35>, <0.35, 5.30, 0.35> } }
  } // union

/*** StairBlock object *****************************************/

#declare SHandle =
  union {
    intersection {
      plane {  y, 0 rotate (z * 30.76271953) translate <0.30, 2.70, 0.00> }
      plane { -y, 0 rotate (z * 30.76271953) translate <0.30, 2.60, 0.00> }
      plane {  z, 0 translate (z *  0.20) }
      plane { -z, 0 translate (z * -0.20) }
      plane {  x, 0 translate (x * 8.70) }
      plane { -x, 0 translate (x * 0.30) }
    } // intersection

    cylinder { <0.27802428, 2.63691921, -0.20>, <8.72197572, 7.66308079, -0.20>, 0.04296464 }
    cylinder { <0.27802428, 2.63691921,  0.20>, <8.72197572, 7.66308079,  0.20>, 0.04296464 }

    texture { StairHandleTex }

    bounded_by {
      box {
        <0, 0, -0.25>, <9.82662791, 0.08592929, 0.25>
        rotate (z * 30.76271953)
        translate <0.30, 2.60, 0.00>
      } // box
    } // bounded_by
  } // union

#declare SRailBottom =
  union {
    intersection {
      plane {  y, 0 rotate (z * 30.76271953) translate <0.30, 0.70, 0.00> }
      plane { -y, 0 rotate (z * 30.76271953) translate <0.30, 0.30, 0.00> }
      plane {  z, 0 translate (z *  0.10) }
      plane { -z, 0 translate (z * -0.10) }
      plane {  x, 0 translate (x * 8.70) }
      plane { -x, 0 translate (x * 0.30) }
    } // intersection

    intersection {
      plane {  y, 0 rotate (z * 30.76271953) translate <0.30, 0.75, 0.00> }
      plane { -y, 0 rotate (z * 30.76271953) translate <0.30, 0.70, 0.00> }
      plane {  z, 0 translate (z *  0.20) }
      plane { -z, 0 translate (z * -0.20) }
      plane {  x, 0 translate (x * 8.70) }
      plane { -x, 0 translate (x * 0.30) }
    } // intersection

    cylinder { <0.28901214, 0.71845961, -0.20>, <8.71098786, 5.73154039, -0.20>, 0.02148232 }
    cylinder { <0.28901214, 0.71845961,  0.20>, <8.71098786, 5.73154039,  0.20>, 0.02148232 }

    texture { StairPaintedMetalTex }

    bounded_by {
      box {
        <0, 0, -0.23>, <10.00564726, 0.38668180, 0.23>
        rotate (z * 30.76271953)
        translate <0.30, 0.30, 0.00>
      } // box
    } // bounded_by
  } // union

#declare SRDecor =
  union {
    cylinder {
      <1.000, 1.125, 0.000>, <1.000, 3.050, 0.000>, 0.050

      texture { StairPaintedMetalTex }
    } // cylinder

    torus {
      0.425, 0.025

      texture { StairBrassTex }

      bounded_by { cylinder { (y * -0.025), (y * 0.025), 0.450 } }
      rotate (x * 90)
      translate <1.000, 2.075, 0.000>
    } // torus

    bounded_by { box { <0.550, 1.125, -0.050>, <1.450, 3.050, 0.050> } }
  } // union

#declare SRailing =
  union {
    object { SHandle }
    object { SRailBottom }

    object { SRDecor translate <0, 0.59523810 * 0, 0> }
    object { SRDecor translate <1, 0.59523810 * 1, 0> }
    object { SRDecor translate <2, 0.59523810 * 2, 0> }
    object { SRDecor translate <3, 0.59523810 * 3, 0> }
    object { SRDecor translate <4, 0.59523810 * 4, 0> }
    object { SRDecor translate <5, 0.59523810 * 5, 0> }
    object { SRDecor translate <6, 0.59523810 * 6, 0> }
    object { SRDecor translate <7, 0.59523810 * 7, 0> }

    bounded_by {
      box {
        <0, 0, -0.25>, <11.00304079, 2.06230292, 0.25>
        rotate (z * 30.76271953)
        translate <0.30, 0.30, 0.00>
      } // box
    } // bounded_by
  } // union

#declare SStep =
  union {
    box { <-0.44, 0.20, -2.90>, <0.08, 0.25, 2.90> }
    cylinder { <-0.44, 0.225, -2.90>, <-0.44, 0.225, 2.90>, 0.025 }

    bounded_by { box { <-0.47, 0.20, -2.90>, <0.08, 0.25, 2.90> } }
  } // union

#declare SSteps =
  union {
    object { SStep translate <0.42 *  0, 0.25 *  0, 0> }
    object { SStep translate <0.42 *  1, 0.25 *  1, 0> }
    object { SStep translate <0.42 *  2, 0.25 *  2, 0> }
    object { SStep translate <0.42 *  3, 0.25 *  3, 0> }
    object { SStep translate <0.42 *  4, 0.25 *  4, 0> }
    object { SStep translate <0.42 *  5, 0.25 *  5, 0> }
    object { SStep translate <0.42 *  6, 0.25 *  6, 0> }
    object { SStep translate <0.42 *  7, 0.25 *  7, 0> }
    object { SStep translate <0.42 *  8, 0.25 *  8, 0> }
    object { SStep translate <0.42 *  9, 0.25 *  9, 0> }
    object { SStep translate <0.42 * 10, 0.25 * 10, 0> }
    object { SStep translate <0.42 * 11, 0.25 * 11, 0> }
    object { SStep translate <0.42 * 12, 0.25 * 12, 0> }
    object { SStep translate <0.42 * 13, 0.25 * 13, 0> }
    object { SStep translate <0.42 * 14, 0.25 * 14, 0> }
    object { SStep translate <0.42 * 15, 0.25 * 15, 0> }
    object { SStep translate <0.42 * 16, 0.25 * 16, 0> }
    object { SStep translate <0.42 * 17, 0.25 * 17, 0> }
    object { SStep translate <0.42 * 18, 0.25 * 18, 0> }
    object { SStep translate <0.42 * 19, 0.25 * 19, 0> }

    texture { StairStepTex }

    bounded_by {
      box {
        <0, 0, -2.90>, <9.77132495, 0.31245393, 2.90>
        rotate (z * 30.76271953)
        translate <-0.31445428, -0.03479421, 0>
      } // box
    } // bounded_by
  } // union

#declare StairBlock =
  union {
    object { StairSupport translate (z *  3.00) }
    object { StairSupport translate (z * -3.00) }

    object { SRailing translate (z *  3.00) }
    object { SRailing translate (z * -3.00) }

    object { SSteps }

    bounded_by { box { <-0.50, 0.00, -3.35>, <8.80, 7.75, 3.35> } }
  } // union

/*** StairFloor object *****************************************/

#declare SFCyl = cylinder { <-3.40, 4.90, -3.40>, <3.40, 4.90, -3.40>, 0.10 }

#declare StairFloor =
  union {
    box { <-3.40, 4.80, -3.40>, <3.40, 5.00, 3.40> }

    object { SFCyl rotate (y *   0) }
    object { SFCyl rotate (y *  90) }
    object { SFCyl rotate (y * 180) }
    object { SFCyl rotate (y * 270) }

    texture { StairFloorTex }

    bounded_by { box { <-3.50, 4.80, -3.50>, <3.50, 5.00, 3.50> } }
  } // union
