// Scene File: jcegg.pov

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "shaker.inc"
#include "egg4.inc"
#include "eggstnd.inc"

 camera {
   up <0,1,0>
   right <4/3, 0, 0>
   direction <0, 0, 3.156876>
   location <-.45, .9, -2.2>
   look_at <.13, .15, -.4>
}

light_source {
   <-5, 2, -3.5>
   color White
 }

light_source {
   <0, 5, 0>
   color White
   spotlight
   point_at <0, 0, .1>
   tightness 50
   radius 11
   falloff 25
}

object {
 shaker
clipped_by {
 plane {y,.3} 
 }
 translate <-.15, 0, -.5>
}

object {
 shaker
clipped_by {
 plane {y,.3} 
 }
 translate <.08, 0, -.075>
}

union {
 object {
  egg
   texture {pigment {color red 1 green .98 blue .92}
     finish { 
      ambient 0.4
       crand .06     
    }   
   }
    rotate y*90
}

 object {
  eggstand
  texture {Silver1}
 }
 torus {0.12, 0.004
  translate <0.0, 0.259, 0.0>
  texture {Silver1}
 }
 cone { <0, -0.4, 0>, 0.08, <0, 0, 0>, 0
  scale <1.0, 1.25, 1.0>
  translate <0.0, 0.33, 0.0>
  texture {Silver1}
 }
 torus {0.055, 0.004
  translate <0, 0.016, 0.0>
  texture {Silver1}
 }
  translate <.2, 0, -.7>
}

plane {y,.0025
  pigment {color White}
}

plane {z,.21
  scale <5, 1, 0.01>
  translate <0.0, 0, 0.21>
 texture {
  pigment {
   image_map {
    gif "tilepat3.gif"
  }
 } 
     finish { ambient .8}
     scale .15
 }
}

declare tile =
union {
  box { <-1, -1, -1>, <1, 1, 1>
  texture {
   pigment {color SlateBlue}
    finish {reflection .1}
  }
  scale <0.195, 0.01, 0.195>
}

cylinder {<0, -0.19, 0>, <0, 0.19, 0>, 0.01
  rotate <90.0, 0.0, 0.0>
  translate <0.19, 0.0, 0.0>
  texture {pigment {color rgb <.75 .82 .75>}}
}
cylinder {<0, -0.19, 0>, <0, 0.19, 0>, 0.01
  rotate <90.0, 0.0, 0.0>
  translate <-0.19, 0.0, 0.0>
  texture {pigment {color rgb <.75 .82 .75>}}
}
cylinder {<0, -0.19, 0>, <0, 0.19, 0>, 0.01
  rotate <0.0, 0.0, 90.0>
  translate <0.0, 0.0, 0.19>
  texture {pigment {color rgb <.75 .82 .75>}}
}
cylinder {<0, -0.19, 0>, <0, 0.19, 0>, 0.01
  rotate <0.0, 0.0, 90.0>
  translate <0.0, 0.0, -0.19>
  texture {pigment {color rgb <.75 .82 .75>}}
}
sphere {<0.19, 0.0, 0.19>, 0.01
  texture {pigment {color rgb <.75 .82 .75>}}
}
sphere {<0.19, 0.0, -0.19>, 0.01
  texture {pigment {color rgb <.75 .82 .75>}}
}
sphere {<-0.19, 0.0, -0.19>, 0.01
  texture {pigment {color rgb <.75 .82 .75>}}
}
sphere {<-0.19, 0.0, 0.19>, 0.01
  texture {pigment {color rgb <.75 .82 .75>}}
 }
  scale <.975, .975, .975>
}

object {
  tile
}

object {
  tile
  translate <0, 0.0, -.4> //#2
}

object {
  tile
  translate <.4, 0.0, 0> //#3
}

object {
  tile
  translate <.4, 0, -.4> //#4
}

object {
  tile
  translate <-.4, 0, 0> //#5
}

object {
  tile
  translate <-.4, 0, -.4> //#6
}

object {
  tile
  translate <-.8, 0, 0> //#7
}

object {
  tile
  translate <-.8, 0, -.4> //#8
}

object {
  tile
  translate <.8, 0, 0> //#9
}

object {
  tile
  translate <.8, 0, -.4> //#10
}

object {
  tile
  translate <-.8, 0, .4> //#11
}

object {
  tile
  translate <-.4, 0, .4> //#12
}

object {
  tile
  translate <0, 0, .4> //#13
}

object {
  tile
  translate <.4, 0, .4> //#14
}

object {
  tile
  translate <.8, 0, .4> //#15
}
//frontrow
object {
  tile
  translate <0, 0.0, -.8> //#16
}

object {
  tile
  translate <.4, 0.0, -.8> //#17
}

object {
  tile
  translate <-.4, 0.0, -.8> //#18
}