#declare coffee_lid = union {
	union {
		difference {
			object {
				sphere { <0, 0, 0> 0.5 }
				scale <10, 1, 10>
				translate <0, 0.35, 0>
			}
			plane { <0, 1, 0> 0.25 }
		}
		difference {
			cylinder { <0, 0, 0> <0, 0.25, 0> 4.5 }
			cylinder { <0, -1, 0> <0, 1, 0> 4.3 }
		}
		texture { coffee_tex }
	}
	object {
		sphere { <0, 1.3, 0> 0.7 }
		texture { gold_tex }
	}
}

#declare coffee_main = union {
	difference {
		object {
			cylinder { <0, 0.3, 0> <0, 10, 0> 4.7 }
			texture { coffee_tex }
			texture { coffee_tex
				pigment {
					image_map { gif "coffee.gif"
						    map_type 2
						    interpolate 2
						    once
						    filter 0, 1
					}
					scale <1, 10, 1>
					rotate <0, 200, 0>
				}
			}
		}
		object {
			cylinder { <0, -1, 0> <0, 11, 0> 4.5 }
		}
	}
	cylinder { <0, 0, 0> <0, 0.3, 0> 4.9 }
	texture { coffee_tex }
}
	
#declare coffee_jar = union {
	object { coffee_lid
		translate <1, 10, 0>
	}
	object { coffee_main }
}
