
// This is include file for sink.jpg by Timo Ettanen

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"


#declare longwood =
  difference{
    union{
      box{<-3,0,-1><3,58,1>}
      cylinder{<-3,0,0><-3,58,0>,1}
      cylinder{<3,0,0><3,58,0>,1}
    }
    plane{y,0 rotate<0,0,45> translate<0,4,0>}
    plane{y,0 rotate<0,0,-45> translate<0,54,0> inverse}
    texture{DMFWood4 scale 3 rotate<90.5,1,0> translate<0,0,5>
              finish {specular 0.4 roughness 0.02}
    }
    bounded_by{box{<-4.01,-0.01,-1.01><4.01,58.01,1.01>}}
  }

#declare shortwood =
  difference{
    union{
      box{<-3,0,-1><3,37,1>}
      cylinder{<-3,0,0><-3,37,0>,1}
      cylinder{<3,0,0><3,37,0>,1}
    }
    plane{y,0 rotate<0,0,45> translate<0,4,0>}
    plane{y,0 rotate<0,0,-45> translate<0,33,0> inverse}
    texture{DMFWood4 scale 3 rotate<89.5,0,1> translate<0,0,-4>
              finish {specular 0.4 roughness 0.02}
    }
    bounded_by{box{<-4.01,-0.01,-1.01><4.01,37.01,1.01>}}
  }

#declare Knob =
  union{
    sphere{<0,0,0>,2 scale<1,1,0.7>}
    cylinder{<0,0,0><0,0,3>,1.3}
    texture{DMFWood4 scale 4.5 rotate<1,0,1> translate<4,4,0>
              finish {specular 0.4 roughness 0.02}
    }
  }

#declare Doors =
  union{
    box{<-40,0,2><40,60,4> pigment{Gray60}}
    box{<-36,4,1><-5,56,2> pigment{Gray90}}
    box{<5,4,1><36,56,2> pigment{Gray90}}
    object{longwood translate<-34,1,0> }
    object{longwood rotate<0,180,0> translate<-5,1,0> }
    object{longwood translate<5,1,0> }
    object{longwood rotate<0,180,0> translate<34,1,0> }
    object{shortwood rotate<0,0,-90> translate<-38,55,0> }
    object{shortwood rotate<0,0,-90> translate<1,55,0> }
    object{shortwood rotate<0,180,0> rotate<0,0,-90> translate<-38,5,0> }
    object{shortwood rotate<0,180,0> rotate<0,0,-90> translate<1,5,0> }
    object{Knob translate<-6.5,6.5,-3>}
    object{Knob rotate<0,0,100> translate<6.5,6.5,-3> }
  }

