#declare Backgrnd = texture {
	pigment {
		gradient y
		color_map {
			[0.0 0.9 color rgb <1, 0, 0> color rgb <0, 0, 1>]
			[0.9 1.0 color rgb <0, 0, 1> color rgb <0, 0, 0.2>]
		}
	}
}
texture {
	pigment {
		bozo
		turbulence 0.5
		lambda 6
		color_map  {
			[0.0 0.1 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
			[0.70 color rgbf <4/5, 4/5, 5/6, 0.65>]
			[1.0 color rgbf <1, 1, 1, 0.65>]
		}
	}
	finish { ambient 1 }
	scale 0.15
}

#declare Sunset = sphere {
	<0, 0, 0>, 1
	texture { Backgrnd }
	scale <2500, 1000, 2000>
	rotate -x*4
}

#declare Skyline = object {
	union {
		smooth_triangle {
		<0, 0, 0>, <0, 0, -1>,
		<0, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
		smooth_triangle {
		<0, 1, 0>, <0, 0, -1>,
		<1, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
	}
	texture {
		pigment {
			image_map {
				gif "skyline.gif"
				once
				map_type 0
				filter 0, 1
				interpolate 2
			}
		}
		finish { ambient 1 diffuse 0 phong 0 }
	}
	no_shadow
	scale <1.333, 1, 1>
	scale 5
	rotate y*45
	translate <0, -1, 6>
}


#declare Cabin = object {
	difference {
		box {<-3, -2, -4>, <4, 3.1, 2>}
		box {<-2.9, -1.9, -3.9>, <3.9, 3, 1.9>}
		box {<-1, 0.1, -1>, <1, 2.1, 3>}
	}
	pigment {color rgb <0.05, 0, 0>}
	finish {ambient 0.2 diffuse 0.5 phong 0}
}

#declare Strip = object {
	box {<-1.2, 0, -0.1>, <1.2, 0.01, 0>}
	rotate -x*30
	translate <0, 0.1, 1.8>
}

#declare Bolt_head = object {
	difference {
		sphere {<0, 0, 0>, 1}
		plane {y, 0}
		box {<-0.125, 0.25, -2>, <0.125, 1.5, 2>}
	}
	texture {
		pigment {color rgb <0.9, 0.9, 1>}
		finish { Metal }
	}
	scale <0.02, 0.015, 0.02>
	rotate y*45
	rotate -x*90
	translate <0, 0.05, 1.85>
}

#declare Curtain = object {
	union {
		object { Strip translate y*0.1 }
		object { Strip translate y*0.2 }
		object { Strip translate y*0.3 }
		object { Strip translate y*0.4 }
		object { Strip translate y*0.5 }
		object { Strip translate y*0.6 }
		object { Strip translate y*0.7 }
		object { Strip translate y*0.8 }
		object { Strip translate y*0.9 }
		object { Strip translate y*1.0 }
		object { Strip translate y*1.1 }
		object { Strip translate y*1.2 }
		object { Strip translate y*1.3 }
		object { Strip translate y*1.4 }
		object { Strip translate y*1.5 }
		object { Strip translate y*1.6 }
		object { Strip translate y*1.7 }
		object { Strip translate y*1.8 }
		object { Strip translate y*1.9 }
		object { Strip translate y*2.0 }
		cylinder {<1.1, -0.4, 1.75>, <1.1, 24, 1.75>, 0.005}
	}
	texture {
		pigment {color rgb <0.8, 0.9, 1>}
		finish { Metal }
	}
}

#declare Window = object {
	box {<-1, 0.1, 1.94>, <1, 2.1, 1.96>}
	pigment {color rgbf <1, 1, 1, 1>}
	finish {phong 0 reflection 0.2}
}

#declare Table = object {
	box {<-0.8, -0.2, -1>, <0.8, 0, 2>}
	texture {
		Stone9
		finish {reflection 0.15}
		scale 0.3
	}
}

#declare Part = object {
	box {<0, 0, 1.85>, <1.6, 0.1, 2.05>}
	texture {
		pigment {color rgb <0.9, 0.9, 1>}
		finish { Metal }
	}
}

#declare Frame = union {
	object { Part translate <-0.79, 0.01, 0> }
	object { Part scale <1.2, 1, 1> rotate z*90 translate <1.09, 0.31, 0>}
	object {
		difference {
			cylinder { <0, 0, 0>, <0, 0.2, 0>, 0.3 }
			cylinder { <0, -0.1, 0>, <0, 0.3, 0>, 0.2 }
			plane {-z, 0}
			plane {x, 0}
		}
		rotate -x*90
		translate <0.79, 0.31, 2.05>
		texture {
			pigment {color rgb <0.9, 0.9, 1>}
			finish { Metal }
		}
	}
	object {Bolt_head translate x*0.1}
	object {Bolt_head translate x*0.5}
	object {Bolt_head translate -x*0.3}
	object {Bolt_head translate <1.05, 0.5, 0>}
	object {Bolt_head translate <1.05, 0.9, 0>}
	object {Bolt_head translate <1.05, 1.3, 0>}
	object {Bolt_head translate <1.05, 1.7, 0>}
}

#declare Environment = union {
	object {Sunset}
	object {Skyline}
	object {Cabin}
	object {Curtain}
	object {Window}
	object {Frame}
}