#declare For_cut = object {
	box {
		<0, 0, 0>, <1.3, 1.3, 0.1>
		translate <-0.15, -0.15, 0>
	}
	texture {
		pigment { color rgb <0.85, 0.85, 0.85>}
		pigment {
			gradient z
			color_map {
				[0 0.7 color rgb <0.85, 0.85, 0.85> color rgb <0.85, 0.85, 0.85>]
				[0.7 1 color rgb <0.75, 0.75, 0.75> color rgb <0.75, 0.75, 0.75>]
			}
			frequency 30
		}
		finish { ambient 0.3 phong 1 }
		scale 0.3
	}
	texture {
		pigment {
			image_map {
				gif "dlf.gif"
				once
				map_type 0
				interpolate 2
			}
		}
		finish { ambient 0.3 phong 1 }
	}
	translate <0.15, 0.15, -0.1>
	scale <1, 0.5, 1>
	rotate x*90
}

#declare Cut_base = union {
	difference {
		box {<0, 0, 0>, <1.7, 0.15, 0.6>}
		box {<-0.1, -0.1, 0.1>, <1.8, 0.08, 0.5>}
		box {<0.2, -0.1, -0.1>, <1.5, 0.02, 1.3>}
		box {<-0.1, 0.05, -0.1>, <1.8, 0.2, 0.034>}
	}
	cylinder {<0.1, 0.15, 0.3>, <0.1, 0.2, 0.3>, 0.06}
	cylinder {<1.6, 0.15, 0.3>, <1.6, 0.2, 0.3>, 0.06}

	difference {
		cylinder {<1.6, 0.15, 0.034>, <1.6, 0.15, 0.08>, 0.1}
		plane {y, 0.15}
	}

	texture {Dark_metal}
}

#declare Blade = union {
	cylinder {<1.6, 0.15, 0>, <1.6, 0.15, 0.03>, 0.1}
	difference {
		sphere {<0, 0, 0>, 0.03}
		plane {-z, 0}
		box {<-0.01, -0.1, -0.1>, <0.01, 0.1, -0.015>}
		scale <1, 1, 0.5>
		translate <1.6, 0.15, 0>
	}
	difference {
		box {<-0.2, 0.05, 0.01>, <1.6, 0.2, 0.03>}
		plane {y, 0 rotate x*76 translate <0, 0.05, 0.03>}
	}
	union {
		sphere {<0.00, 0, 0>, 0.125}
		sphere {<0.15, 0, 0>, 0.125}
		sphere {<0.30, 0, 0>, 0.125}
		sphere {<0.45, 0, 0>, 0.125}
		sphere {<0.60, 0, 0>, 0.125}
		sphere {<0.75, 0, 0>, 0.125}
		rotate z*180
		scale <0.5, 1, 0.5>
		translate <-0.1, 0.125, 0.02>
		pigment {color rgb <0.4, 0.2, 0>}
		finish {ambient 0.2 phong 0.6}
	}

	translate <-1.6, -0.15, 0>
	rotate -z*45
	translate <1.6, 0.15, 0>

	texture {My_chrome}
}

#declare Frame = union {
	union {
		cylinder {<0.1, 0.15, 0.6>, <0.1, 1.3, 0.6>, 0.03}
		cylinder {<1.6, 0.15, 0.6>, <1.6, 1.3, 0.6>, 0.03}
		texture {My_chrome}
	}

	cylinder {<0.1, 1.25, 0.6>, <0.1, 1.35, 0.6>, 0.045}
	cylinder {<1.6, 1.25, 0.6>, <1.6, 1.35, 0.6>, 0.045}

	box {<0.14, 1.26, 0.59>, <1.56, 1.34, 0.61>}
	cylinder {<0.85, 1.2, 0.6>, <0.85, 1.4, 0.6>, 0.1}

	texture {Dark_metal}
	translate -z*0.3
}

#declare Plate = union {
	cylinder {<0.1, 0.4, 0.6>, <0.1, 0.47, 0.6>, 0.05}
	cylinder {<1.6, 0.4, 0.6>, <1.6, 0.47, 0.6>, 0.05}

	difference {
		union {
			cylinder {<0.2, 0.42, 0.6>, <0.2, 0.45, 0.6>, 0.1}
			cylinder {<1.5, 0.42, 0.6>, <1.5, 0.45, 0.6>, 0.1}
		}
		box {<0.2, 0.35, 0.4>, <1.5, 0.55, 0.8>}
	}
	box {<0.2, 0.42, 0.5>, <1.5, 0.45, 0.7>}

	cylinder {<0.85, 0.45, 0.6>, <0.85, 0.5, 0.6>, 0.08}

	texture {Dark_metal}
	translate -z*0.3
}

#declare Step = union {
	cone {<0, 0, 0>, 0.03, <0, 0.01, 0>, 0.05}
	cylinder {<0, 0.01, 0>, <0, 0.02, 0>, 0.05}
	cone {<0, 0.02, 0>, 0.05, <0, 0.03, 0>, 0.03}
	texture {My_chrome}
	rotate x*10
}

#declare Section = union {
	object {Step translate <0.85, 0.00, 0.6>}
	object {Step translate <0.85, 0.03, 0.6>}
	object {Step translate <0.85, 0.06, 0.6>}
	object {Step translate <0.85, 0.09, 0.6>}
	object {Step translate <0.85, 0.12, 0.6>}
}

#declare Screw = union {
	object {Section translate <0, 0.5+0.00, 0>}
	object {Section translate <0, 0.5+0.15, 0>}
	object {Section translate <0, 0.5+0.30, 0>}
	object {Section translate <0, 0.5+0.45, 0>}
	object {Section translate <0, 0.5+0.60, 0>}
	object {Section translate <0, 0.5+0.75, 0>}
	object {Section translate <0, 0.5+0.90, 0>}
	object {Section translate <0, 0.5+1.05, 0>}
	object {Section translate <0, 0.5+1.20, 0>}

	difference {
		cylinder {<0.85, 1.8, 0.6>, <0.85, 2.0, 0.6>, 0.1}
		cylinder {<0.5, 1.91, 0.6>, <1.7, 1.91, 0.6>, 0.04}
	}
	cylinder {<0.5, 1.9, 0.6>, <1.7, 1.9, 0.6>, 0.03}
	sphere {<1.7, 1.9, 0.6>, 0.06}
	torus {0.03, 0.02 rotate <90, 90, 0> translate <0.52, 1.9, 0.6>}

	texture {My_chrome}
	translate <-0.85, 0, -0.6>
	rotate -y*90
	translate <0.85, -0.05, 0.6>
	translate -z*0.3
}

#declare Cutter = union {
	object {For_cut translate <0.2, 0.15, -0.045>}
	object {Cut_base}
	object {Frame}
	object {Plate translate -y*0.17}
	object {Screw translate -y*0.17}
	object {Blade}

	rotate y*80
	translate <-1.6, 0, 1.8>
}

