/*
Include file for BILL&TED.POV
*/

////////////First some texture definitions

#declare metal = texture {
        pigment {color rgb<.8,.8,.85>*.3}
        finish  {diffuse .6
                specular 1
                roughness .1
                metallic
                reflection .3}

        normal  {bumps .025 scale <20,30,20>}
}

#declare orange =
pigment {marble turbulence <1.5,.8,1.8> octaves 8 omega .6
        color_map {
        [0.00 0.80 color Clear color Clear]
        [0.80 0.90 color Clear color rgbf<1,.4,.1,.2>]
        [0.90 1.00 color rgbf<1,.4,.1,.2> color rgbf<1,.4,.1,.2>]}
scale <.05,1,.5>
rotate <10,45,0>
}


#declare orange_grad = texture {
pigment {gradient y turbulence .4/230
        pigment_map {
        [0.0 orange]
        [0.35 orange]
        [0.5 color Clear]
        [1.0 color Clear]}
        scale 230}
        finish  {ambient 1}
}

#declare RedGlass = texture {
        pigment {color rgb <.1,0,0>}
        finish  {specular 1
                roughness .02
                reflection .1}
        normal  {bumps .02 scale 60}
}

#declare Glass = texture {
        pigment {color rgbf <1,1,1,.97>}
        finish  {specular 1
                roughness .02
                refraction 1
                ior 1.8
                diffuse .2}
        normal  {bumps .02
                scale 60}
}


#declare oldmarb = pigment {
        marble turbulence .8 color_map {
        [0.0 0.4 color White color White]
        [0.4 0.8 color White color White*.9]
        [0.8 1.0 color White*.9 color White*.8]}
}


///////////////Now the objects

#declare sign =
        box {<-40,206,-49.02>,<40,215,-49>
        pigment {image_map {gif "phone.gif" once interpolate 2 filter all 1}
        scale <80,9,1>
        translate <-40,206,0>}
        no_shadow hollow
}

#declare ldoor =
union {
        box {<-46.25,1,-2>,<-43.25,199,0>}
        box {<-4,1,-2>,<0,199,0>}
        difference {
            box {<-43.25,1,-2>,<0,30,0>}
            box {<-40,4,-3>,<3,27,-1.5>}}
        box {<-43.25,113,-2>,<0,117,0>}
        box {<-43.25,196,-2>,<0,199,0>}
        box {<-43.25,10,-1>,<-3,196,-.7> texture {Glass}}

        texture {metal}
}

#declare rdoor =
union {
        box {<-46.25,1,-2>,<-42.25,199,0>}
        box {<-3,1,-2>,<0,199,0>}
        difference {
            box {<-43.25,1,-2>,<0,30,0>}
            box {<-40,4,-3>,<3,27,-1.5>}}
        box {<-43.25,113,-2>,<0,117,0>}
        box {<-43.25,196,-2>,<0,199,0>}
        box {<-43.25,10,-1>,<-3,196,-.7> texture {Glass}}

        texture {metal}
}


#declare antenna = union {
  cylinder {<0,0,0>,<0,15,0>,.65}
#declare rot = 0
#while (rot<360)
        cylinder {<0,11,0>,<-15,16,0>,.2 rotate <0,rot,0>}
        cylinder {<-15,16,0>,<-24,13,0>,.2 rotate <0,rot,0>}
        cylinder {<-15,16,0>,<0,14,0>,.2 rotate <0,rot,0>}
        #declare rot=rot+45
#end

pigment {color rgb <.3,.2,.2>}
finish  {diffuse .6
        specular 1
        roughness .1
        metallic}
translate <0,230,0>
}

#declare cell =
union {
        box {<-48,0,-48>,<48,7,48>}
        difference {
                difference  {
                          box {<-50,0,-50>,<50,30,50>}
                          box {<-47,-10,-90>,<47,40,47>}
                            }
                box {<-90,5,-45>,<-49,25,45>}
                box {<-90,5,-45>,<-49,25,45> rotate <0,90,0>}
                box {<-90,5,-45>,<-49,25,45> rotate <0,180,0>}
                }
        box {<-49,0,-50>,<-47,200,-47>}
        box {<-49,0,-50>,<-47,200,-47> rotate <0,90,0>}
        box {<-49,0,-50>,<-47,200,-47> rotate <0,180,0>}
        box {<-49,0,-50>,<-47,200,-47> rotate <0,270,0>}

        box {<-49,0,47>,<-47,200,50> rotate <0,0,0>}
        box {<-49,0,47>,<-47,200,50> rotate <0,90,0>}
        box {<-49,0,47>,<-47,200,50> rotate <0,180,0>}
        box {<-49,0,47>,<-47,200,50> rotate <0,270,0>}

        box {<-49,0,-17>,<-47,200,-15> rotate <0,0,0>}
        box {<-49,0,15>,<-47,200,17> rotate <0,0,0>}
        box {<-49,0,-17>,<-47,200,-15> rotate <0,90,0>}
        box {<-49,0,15>,<-47,200,17> rotate <0,90,0>}
        box {<-49,0,-17>,<-47,200,-15> rotate <0,180,0>}
        box {<-49,0,15>,<-47,200,17> rotate <0,180,0>}

        box {<-49,114,-47>,<-47,116,47>}
        box {<-49,114,-47>,<-47,116,47> rotate <0,90,0>}
        box {<-49,114,-47>,<-47,116,47> rotate <0,180,0>}

        box {<-48.3,30,-47>,<-48,200,-17> texture {RedGlass}}
        box {<-48.3,30,-47>,<-48,200,-17> texture {RedGlass} rotate <0,90,0>}
        box {<-48.3,30,-47>,<-48,200,-17> texture {RedGlass} rotate <0,180,0>}

        box {<-48.3,30,17>,<-48,200,47> texture {RedGlass}}
        box {<-48.3,30,17>,<-48,200,47> texture {RedGlass} rotate <0,90,0>}
        box {<-48.3,30,17>,<-48,200,47> texture {RedGlass} rotate <0,180,0>}

        box {<-48.3,30,-15>,<-48,200,15> texture {Glass}}
        box {<-48.3,30,-15>,<-48,200,15> texture {Glass} rotate <0,90,0>}
        box {<-48.3,30,-15>,<-48,200,15> texture {Glass} rotate <0,180,0>}

        difference {
                box {<-50,200,-50>,<50,230,50>}
                        box {<-90,205,-45>,<-49,220,45>}
                        box {<-90,205,-45>,<-49,220,45> rotate <0,90,0>}
                        box {<-90,205,-45>,<-49,220,45> rotate <0,180,0>}
                        box {<-90,205,-45>,<-49,220,45> rotate <0,270,0>}

                        box {<-40,206,-100>,<40,215,100>}
                        box {<-40,206,-100>,<40,215,100> rotate <0,90,0>}

        }

        object {sign rotate <0,0,0>}
        object {sign rotate <0,90,0>}
        object {sign rotate <0,180,0>}
        object {sign rotate <0,270,0>}
        box {<-40,206,-48.99>,<40,215,48.99>
                pigment {gradient x turbulence .3 color_map {
                        [0 .8 color rgb <1,1,.9> color Gray50]
                        [.8 1 color Gray50 color Gray25]}
                scale 50}
                finish  {ambient 1}
                no_shadow}
        box {<-40,206,-48.99>,<40,215,48.99>
                pigment {gradient x turbulence .3 color_map {
                        [0 .8 color rgb <1,1,.9> color Gray50]
                        [.8 1 color Gray50 color Gray25]}
                scale 50}
                finish  {ambient 1}
                no_shadow
                rotate 90*y}

        box {<-51,225,-51>,<51,228,51>}

        difference {
                box {<-22,199.5,-22>,<22,200,22>}
                box {<-20,199.5,-20>,<20,200,20>}
                }
        box {<-20,199.3,-20>,<20,200,20>
                pigment {color White*.75}
                finish  {reflection .025}
                }
texture {metal}
}



#declare energy = difference {
union {
        box {<-48,0,-48>,<48,7,48>}
        difference {
                difference  {
                          box {<-50,0,-50>,<50,30,50>}
                          box {<-47,-10,-90>,<47,40,47>}
                            }
                box {<-90,5,-45>,<-49,25,45>}
                box {<-90,5,-45>,<-49,25,45> rotate <0,90,0>}
                box {<-90,5,-45>,<-49,25,45> rotate <0,180,0>}
                }
        box {<-49,0,-50>,<-47,200,-47>}
        box {<-49,0,-50>,<-47,200,-47> rotate <0,90,0>}
        box {<-49,0,-50>,<-47,200,-47> rotate <0,180,0>}
        box {<-49,0,-50>,<-47,200,-47> rotate <0,270,0>}

        box {<-49,0,47>,<-47,200,50> rotate <0,0,0>}
        box {<-49,0,47>,<-47,200,50> rotate <0,90,0>}
        box {<-49,0,47>,<-47,200,50> rotate <0,180,0>}
        box {<-49,0,47>,<-47,200,50> rotate <0,270,0>}

        box {<-49,0,-17>,<-47,200,-15> rotate <0,0,0>}
        box {<-49,0,15>,<-47,200,17> rotate <0,0,0>}
        box {<-49,0,-17>,<-47,200,-15> rotate <0,90,0>}
        box {<-49,0,15>,<-47,200,17> rotate <0,90,0>}
        box {<-49,0,-17>,<-47,200,-15> rotate <0,180,0>}
        box {<-49,0,15>,<-47,200,17> rotate <0,180,0>}

        box {<-49,114,-47>,<-47,116,47>}
        box {<-49,114,-47>,<-47,116,47> rotate <0,90,0>}
        box {<-49,114,-47>,<-47,116,47> rotate <0,180,0>}
}
box {<-48.9,.1,-48.9>,<48.9,240,48.9>}
texture {orange_grad}
scale 1.00001
no_shadow
}

#declare lenergy =
difference {
union {
        box {<-46.25,1,-2>,<-43.25,199,0>}
        box {<-4,1,-2>,<0,199,0>}
        difference {
          box {<-43.25,1,-2>,<0,30,0>}
          box {<-40,4,-3>,<3,27,-1.5>}}
        box {<-43.25,113,-2>,<0,117,0>}
        box {<-43.25,196,-2>,<0,199,0>}
}
box {<-50,0,-1.4>,<1,200,1>}
texture {orange_grad}
}

#declare Saeule =
difference {
cylinder {<0,-50,0>,<0,50,0>,70}
union {
        #declare counter=0
        #while (counter<20)
                cylinder {<0,-51,0>,<0,51,0>,4
                scale <1,1,2>
                translate <-70,0,0>
                rotate <0,18*counter,0>}
        #declare counter=counter+1
        #end

height_field {gif "hf_stone.gif"
        translate <-.5,0,-.5>
        scale <140,10,140>
        translate -y*51.5}
      }
      pigment {oldmarb
              scale 60}
      normal  {wrinkles .6 scale 20}
}


#declare oldstone = difference {
box {0,1}

height_field    {gif "hf_stone.gif"
    scale <1,.1,1>
    rotate <0,0,0>
    translate <0,-.0001,0>}
height_field    {gif "hf_stone.gif"
    scale <1,.1,1>
    rotate <90,0,0>
    translate <0,1,0>}
height_field    {gif "hf_stone.gif"
    scale <1,.1,1>
    rotate <-90,0,0>
    translate <0,0,1>}
height_field    {gif "hf_stone.gif"
    scale <1,.1,1>
    rotate <-180,0,0>
    translate <0,1,1>}
height_field    {gif "hf_stone.gif"
    scale <1,.1,1>
    rotate <0,0,90>
    translate <1,0,0>}
height_field    {gif "hf_stone.gif"
    scale <1,.1,1>
    rotate <0,0,-90>
    translate <0,1,0>}

      pigment {oldmarb}
translate <-.5,-.5,-.5>
scale 60
}

#declare dusty =
difference {
sphere {0,170}
box {<-50,-230,-50>,<50,230,50>}
        pigment {color rgbt 1}
        halo {
        dust
        linear
        spherical_mapping
        samples 15
        turbulence .8
        color_map {[0 rgbt 1]
                  [1 rgbt <.9,.7,.6,.994>]}
        scale 110
        rotate <0,180,0>
        translate <30,0,0>
        }
hollow
scale <1,.25,1>
}