/*
Scene file for the Internet Raytracing Competition
Topic: Time
Christian Schulz, Germany
email: geordi@netzservice.de
*/


#include "colors.inc"
#include "bill&ted.inc"
#include "skies.inc"

global_settings {
        max_trace_level 9
        assumed_gamma 2.2}

camera  {location <-140,380,-80>
        right <4/3,0,0>
        angle 50
        look_at  <0,130,30>
}



//first of all: the sand

height_field {tga "hf_sand.tga"
        pigment {color rgb <.9,.7,.6>}
        finish  {phong 0
                diffuse .9
                crand .05}
        scale <1500,20,1000>
        translate <-750,0,-300>
}

//now some stones and

object {oldstone
    scale <3,1,2>
    rotate <-20,0,10>
    translate <50,10,250>}

object {oldstone
    scale <2,1,2>
    rotate <10,-15,10>
    translate <-150,0,250>}

object {oldstone
    scale <2,3,2>
    rotate <25,15,10>
    translate <500,50,75>}


object {Saeule
        rotate <150,20,0>
        translate <300,0,0>}

object {Saeule
        scale .7
        rotate <250,-20,0>
        translate <50,-10,-100>}

object {Saeule
        scale .7
        rotate <160,30,0>
        translate <-160,-20,60>}


//the phone cell

union {
    object  {energy}
    object  {cell}
    object  {antenna}
    object  {rdoor
            rotate <0,-75,0>
            translate <47,0,-47>}
    union   {object {ldoor}
            object {lenergy}
            rotate <0,75,0>
            translate <47-cos(75*pi/180)*47,0,-47-sin(75*pi/180)*47>}
    object  {dusty
            translate <0,20,0>}

rotate <0,-10,0>
translate <0,9,60>
}


//a sky sphere from skies.inc

sky_sphere {S_Cloud1}

//lightsources

light_source {<1500,450,-700>
        color rgb <1,.95,.87>*.9
        }

light_source {<-500,1200,-200>
        color White*.28
        shadowless}