//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 6 lights, 34 textures and 693 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 05/29/1996    (29.05.1996)
//

#max_trace_level 5

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





camera {  //  Camera camera01
  location  <31.500, -41.900, 14.800>
  direction <0.0,     0.0,  1.1547>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <18.900, -1.100, 7.300>
}

// *******  L I G H T S *******
light_source {   // LightLight
  <10.400, -5.000, 13.400>
  color rgb <1.000, 0.804, 0.455>
  fade_power 2
  fade_distance 8
}

light_source { // ALight5
  <14.800, -44.500, 8.300>
  color  rgb<0.204, 0.204, 0.204>
  area_light <22.400, 0.000, 0.000>, <0.000, 0.000, -11.400>, 8, 4
  adaptive 1
  jitter
  fade_power 2
  fade_distance 40
}


light_source { // ALight4
  <6.000, 30.000, 26.500>
  color  rgb<0.204, 0.204, 0.204>
  area_light <12.800, 0.000, 0.000>, <0.000, 5.000, 0.000>, 8, 4
  adaptive 1
  jitter
  fade_power 2
  fade_distance 40

}


light_source { // ALight3
  <36.000, 30.000, 26.500>
  color  rgb<0.204, 0.204, 0.204>
  area_light <12.800, 0.000, 0.000>, <0.000, 5.000, 0.000>, 8, 4
  adaptive 1
  jitter
  fade_power 2
  fade_distance 40

}


light_source { // ALight2
  <36.000, -19.200, 26.500>
  color  rgb<0.204, 0.204, 0.204>
  area_light <12.800, 0.000, 0.000>, <0.000, 5.000, 0.000>, 8, 4
  adaptive 1
  jitter
  fade_power 2
  fade_distance 40

}


light_source { // ALight1
  <6.300, -19.200, 26.500>
  color  rgb<0.204, 0.204, 0.204>
  area_light <12.800, 0.000, 0.000>, <0.000, 5.000, 0.000>, 8, 4
  adaptive 1
  jitter
  fade_power 2
  fade_distance 40

}



// ********  TEXTURES  *******
//

#include "carcomp.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

box { // Plate11
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SteelPipe
  }
  scale <2.4, 4.1, 0.1>
  rotate -90.0*y
  translate  <35.700001, 0.0, 4.6>
}


box { // Plate10
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SteelPipe
  }
  scale <1.0, 1.4, 2.9>
  rotate 11.5*y
  translate  <34.100001, 0.0, 5.2>
}


box { // Plate9
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SteelPipe
  }
  scale <2.0, 3.5, 0.1>
  translate  <25.0, 0.0, 13.5>
}


box { // Plate8
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SteelPipe
  }
  scale <4.5, 1.0, 0.1>
  rotate 5.0*z
  translate  <31.3, -3.5, 2.0>
}


box { // Plate7
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SteelPipe
  }
  scale <4.5, 1.0, 0.1>
  rotate -5.0*z
  translate  <31.3, 3.5, 2.0>
}


box { // Plate6
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SteelPipe
  }
  scale <6.5, 4.0, 0.1>
  translate  <29.25, 0.0, 2.0>
}


#declare WSpoke25 = intersection {
  cone { // WSpoke24
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut13
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
}
#declare WSpoke27 = intersection {
  cone { // WSpoke26
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut14
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate -30.0*z
}
#declare WSpoke29 = intersection {
  cone { // WSpoke28
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut15
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate -60.0*z
}
#declare WSpoke31 = intersection {
  cone { // WSpoke30
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut16
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate -90.0*z
}
#declare WSpoke33 = intersection {
  cone { // WSpoke32
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut17
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate -120.0*z
}
#declare WSpoke35 = intersection {
  cone { // WSpoke34
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut18
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate -150.0*z
}
#declare WSpoke37 = intersection {
  cone { // WSpoke36
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut19
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate 180.0*z
}
#declare WSpoke39 = intersection {
  cone { // WSpoke38
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut20
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate 150.0*z
}
#declare WSpoke41 = intersection {
  cone { // WSpoke40
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut21
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate 120.0*z
}
#declare WSpoke43 = intersection {
  cone { // WSpoke42
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut22
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate 90.0*z
}
#declare WSpoke45 = intersection {
  cone { // WSpoke44
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut23
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate 60.0*z
}
#declare WSpoke47 = intersection {
  cone { // WSpoke46
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut24
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate 30.0*z
}
#declare WBolts2 = union {
  cylinder { // WBolt9
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    translate  <0.0, 0.8, 0.15>
  }
  cylinder { // WBolt10
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate -45.0*z
    translate  <0.565685, 0.565685, 0.15>
  }
  cylinder { // WBolt11
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate -135.0*z
    translate  <0.565685, -0.565685, 0.15>
  }
  cylinder { // WBolt12
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate -90.0*z
    translate  <0.8, 0.0, 0.15>
  }
  cylinder { // WBolt13
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate 180.0*z
    translate  <0.0, -0.8, 0.15>
  }
  cylinder { // WBolt14
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate 135.0*z
    translate  <-0.565685, -0.565685, 0.15>
  }
  cylinder { // WBolt15
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate 90.0*z
    translate  <-0.8, 0.0, 0.15>
  }
  cylinder { // WBolt16
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate 45.0*z
    translate  <-0.565685, 0.565685, 0.15>
  }
}
#declare Wrim2 = difference {
  cylinder { // WRim3
    <0,0,1>, <0,0,0>, 1 
    scale <5.25, 5.25, 1.25>
    rotate <90.0, 0.0, 0.0>
    translate  <21.5, -5.775, 3.7>
  }
  cylinder { // WRim4
    <0,0,1>, <0,0,0>, 1 
    scale <4.725, 4.725, 1.5>
    rotate <90.0, 0.0, 0.0>
    translate  <21.5, -5.65, 3.7>
  }
  scale <0.571429, 0.8, 0.571429>
  rotate <-90.0, 0.0, 0.0>
  translate  <-12.285714, -2.114286, -5.12>
}
union { // MWheelL
  cylinder { // MW_WAxle3
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
  }
  cylinder { // MW_WAxle4
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 0.8>
    translate  -0.4*z
  }
  cylinder { // CBar3
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    translate  <0.0, -0.7, 0.3>
  }
  cylinder { // CBar4
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.6>
    translate  <0.0, 0.3, 1.1>
  }
  cylinder { // CrossBar2
    <0,0,1>, <0,0,0>, 1 
    scale <0.14, 0.08, 1.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 1.2>
  }
  object { WSpoke25 }
  object { WSpoke27 }
  object { WSpoke29 }
  object { WSpoke31 }
  object { WSpoke33 }
  object { WSpoke35 }
  object { WSpoke37 }
  object { WSpoke39 }
  object { WSpoke41 }
  object { WSpoke43 }
  object { WSpoke45 }
  object { WSpoke47 }
  object { WBolts2 }
  object { Wrim2 }
  texture {
    Simple_Copper
  }
  scale <1.75, 1.75, 1.25>
  rotate <-90.0, -180.0, -180.0>
  translate  <21.5, 6.4, 3.7>
}


union { // REDRod2
  sphere { // Control_Ball2
    <0,0,0>,1
    texture {
      Blue_plastic
    }
    scale 0.3
    translate  <8.2, 0.0, 10.0>
  }
  cylinder { // Control_rod2
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.1, 0.1, 4.0>
    translate  <8.2, 0.0, 6.0>
  }
  rotate 5.0*y
  translate  <-0.7, -3.8, 0.0>
}


union { // REDRod1
  sphere { // Control_Ball1
    <0,0,0>,1
    texture {
      Red_plastic
    }
    scale 0.3
    translate  <8.2, 0.0, 10.0>
  }
  cylinder { // Control_rod1
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.1, 0.1, 4.0>
    translate  <8.2, 0.0, 6.0>
  }
  rotate -15.0*y
  translate  <1.7, -4.2, -2.1>
}


difference { // TubeBend1
  torus { // TubeRound1
    1.5, 0.15  rotate -x*90
    texture {
      BumpyBronze1
    }
    rotate -90.0*x
    translate  <12.0, 0.0, 9.7>
  }
  plane { // SomeCut1
    z,0
    texture {
      BumpyBronze1
    }
    rotate -90.0*y
    translate  <12.0, 0.0, 10.0>
  }
  texture {
    BumpyBronze1
  }
  translate  -1.6*y
}




#declare BWUnion1 = union {
  cylinder { // BWhell5
    <0,0,1>, <0,0,0>, 1 
    scale <6.5, 6.5, 4.0>
    rotate 90.0*x
  }
  cylinder { // BWhell6
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*x
    translate  0.5*y
  }
  torus { // BWRound4
    6.0, 0.5  rotate -x*90
    rotate -90.0*x
  }
  torus { // BWRound5
    6.0, 0.5  rotate -x*90
    rotate -90.0*x
    translate  -4.0*y
  }
}
#declare BWCut2 = difference {
  object { BWUnion1 }
  cylinder { // BWhell7
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.5>
    rotate 90.0*x
    translate  0.75*y
  }
  cylinder { // BWhell8
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 1.0>
    rotate 90.0*x
    translate  -4.0*y
  }
}
union { // BackWheelL
  object { BWCut2 }
  torus { // BWRound6
    1.5, 0.5  rotate -x*90
    rotate -90.0*x
    translate  -4.0*y
  }
  texture {
    Stone
  }
  scale 0.8
  translate  <0.0, 10.0, 3.75>
}


box { // Control_panel
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BumpyBronze1
  }
  scale <2.0, 2.5, 3.0>
  translate  <12.0, 0.0, 7.0>
}


cylinder { // BS_Pipe1
  <0,0,1>, <0,0,0>, 1 
  texture {
    BumpyBronze1
  }
  scale <0.15, 0.15, 6.5>
  rotate -90.0*y
  translate  <18.5, -1.6, 11.2>
}


#declare BBar7 = intersection {
  torus { // Bend13
    1.5, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut12
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  translate  -1.5*x
}
#declare BBar8 = intersection {
  torus { // Bend14
    1.5, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut13
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  translate  -0.9*x
}
#declare BBar9 = intersection {
  torus { // Bend15
    1.5, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut14
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  translate  -0.3*x
}
#declare BBar10 = intersection {
  torus { // Bend16
    1.5, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut15
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  translate  0.3*x
}
#declare BBar11 = intersection {
  torus { // Bend17
    1.5, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut16
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  translate  0.9*x
}
#declare BBar12 = intersection {
  torus { // Bend18
    1.5, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut17
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  translate  1.5*x
}
#declare BBars2 = union {
  object { BBar7 }
  object { BBar8 }
  object { BBar9 }
  object { BBar10 }
  object { BBar11 }
  object { BBar12 }
  rotate -180.0*z
  translate  50.0*x
}
#declare Hbars2 = union {
  cylinder { // Grid11
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <23.5, -5.0, 7.0>
  }
  cylinder { // Grid12
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <24.1, -5.0, 7.0>
  }
  cylinder { // Grid13
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <24.7, -5.0, 7.0>
  }
  cylinder { // Grid14
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <25.3, -5.0, 7.0>
  }
  texture {
    SteelPipe
  }
  scale <1.0, 1.0, 0.8>
  rotate -90.0*y
  translate  <32.5, 0.0, -16.0>
}
#declare Vbars2 = union {
  cylinder { // Grid15
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <23.5, -5.0, 7.0>
  }
  cylinder { // Grid16
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <24.1, -5.0, 7.0>
  }
  cylinder { // Grid17
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <24.7, -5.0, 7.0>
  }
  cylinder { // Grid18
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <25.3, -5.0, 7.0>
  }
  cylinder { // Grid19
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <25.9, -5.0, 7.0>
  }
  cylinder { // Grid20
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <26.5, -5.0, 7.0>
  }
  texture {
    SteelPipe
  }
}
union { // CarBars2
  object { BBars2 }
  object { Hbars2 }
  object { Vbars2 }
  rotate -180.0*z
  translate  50.0*x
}


#declare BBar1 = intersection {
  torus { // Bend7
    1.5, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut6
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  translate  -1.5*x
}
#declare BBar2 = intersection {
  torus { // Bend8
    1.5, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut7
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  translate  -0.9*x
}
#declare BBar3 = intersection {
  torus { // Bend9
    1.5, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut8
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  translate  -0.3*x
}
#declare BBar4 = intersection {
  torus { // Bend10
    1.5, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut9
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  translate  0.3*x
}
#declare BBar5 = intersection {
  torus { // Bend11
    1.5, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut10
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  translate  0.9*x
}
#declare BBar6 = intersection {
  torus { // Bend12
    1.5, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut11
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  translate  1.5*x
}
#declare BBars1 = union {
  object { BBar1 }
  object { BBar2 }
  object { BBar3 }
  object { BBar4 }
  object { BBar5 }
  object { BBar6 }
  rotate -180.0*z
  translate  50.0*x
}
#declare Hbars1 = union {
  cylinder { // Grid7
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <23.5, -5.0, 7.0>
  }
  cylinder { // Grid8
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <24.1, -5.0, 7.0>
  }
  cylinder { // Grid9
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <24.7, -5.0, 7.0>
  }
  cylinder { // Grid10
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <25.3, -5.0, 7.0>
  }
  texture {
    SteelPipe
  }
  scale <1.0, 1.0, 0.8>
  rotate -90.0*y
  translate  <32.5, 0.0, -16.0>
}
#declare Vbars1 = union {
  cylinder { // Grid1
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <23.5, -5.0, 7.0>
  }
  cylinder { // Grid2
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <24.1, -5.0, 7.0>
  }
  cylinder { // Grid3
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <24.7, -5.0, 7.0>
  }
  cylinder { // Grid4
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <25.3, -5.0, 7.0>
  }
  cylinder { // Grid5
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <25.9, -5.0, 7.0>
  }
  cylinder { // Grid6
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.06, 5.0>
    translate  <26.5, -5.0, 7.0>
  }
  texture {
    SteelPipe
  }
}
union { // CarBars1
  object { BBars1 }
  object { Hbars1 }
  object { Vbars1 }
}


box { // Plate5
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SteelPipe
  }
  scale <2.0, 2.5, 0.1>
  rotate -90.0*x
  translate  <25.0, -5.0, 4.5>
}


difference { // StandSpace
  box { // SSpaceOut
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BeamWood
    }
    scale <3.0, 4.5, 2.0>
    translate  <8.0, 0.0, 4.5>
  }
  box { // SSpaceIn
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BeamWood
    }
    scale <2.8, 4.3, 2.0>
    translate  <8.0, 0.0, 4.6>
  }
  texture {
    BeamWood
  }
}


cylinder { // Holder1
  <0,0,1>, <0,0,0>, 1 
  texture {
    BumpyBronze
  }
  scale <0.1, 0.1, 1.0>
  rotate 90.0*y
  translate  <10.0, -5.0, 14.9>
}


box { // Plate4
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SteelPipe
  }
  scale <4.5, 2.5, 0.1>
  rotate <-90.0, 0.0, -5.0>
  translate  <31.5, 4.6, 4.5>
}


#declare TBend4 = intersection {
  torus { // Bend5
    1.5, 0.3  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut4
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  rotate 180.0*z
  translate  50.0*x
}
#declare TBend5 = intersection {
  torus { // Bend6
    1.5, 0.3  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut5
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
}
union { // UBend3
  cylinder { // STube13
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 5.0>
    translate  <25.0, -5.0, 7.0>
  }
  cylinder { // STube14
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 5.0>
    translate  <25.0, 5.0, 7.0>
  }
  cylinder { // STube15
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 7.0>
    rotate -90.0*x
    translate  <25.0, -3.5, 13.5>
  }
  object { TBend4 }
  object { TBend5 }
  texture {
    SteelPipe
  }
  scale <1.0, 0.85, 1.0>
  translate  <10.7, 0.0, -5.0>
}


box { // Plate3
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SteelPipe
  }
  scale <4.5, 2.5, 0.1>
  rotate <-90.0, 0.0, 5.0>
  translate  <31.5, -4.6, 4.5>
}


box { // Plate2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SteelPipe
  }
  scale <2.0, 2.5, 0.1>
  rotate -90.0*x
  translate  <25.0, 5.0, 4.5>
}


cylinder { // STube12
  <0,0,1>, <0,0,0>, 1 
  texture {
    SteelPipe
  }
  scale <0.3, 0.3, 10.0>
  rotate -60.0*y
  translate  <35.7, 3.0, 8.48>
}


cylinder { // STube11
  <0,0,1>, <0,0,0>, 1 
  texture {
    SteelPipe
  }
  scale <0.3, 0.3, 10.0>
  rotate -60.0*y
  translate  <35.7, -3.0, 8.48>
}


box { // Plate1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SteelPipe
  }
  scale <2.0, 5.0, 0.1>
  translate  <25.0, 0.0, 2.0>
}


#declare TBend2 = intersection {
  torus { // Bend3
    1.5, 0.3  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut2
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  rotate 180.0*z
  translate  50.0*x
}
#declare TBend3 = intersection {
  torus { // Bend4
    1.5, 0.3  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut3
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
}
union { // UBend2
  cylinder { // STube4
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 10.0>
    translate  <25.0, -5.0, 2.0>
  }
  cylinder { // STube5
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 10.0>
    translate  <25.0, 5.0, 2.0>
  }
  cylinder { // STube6
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 7.0>
    rotate -90.0*x
    translate  <25.0, -3.5, 13.5>
  }
  object { TBend2 }
  object { TBend3 }
  cylinder { // STube7
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 4.0>
    rotate -90.0*y
    translate  <25.0, -5.0, 10.0>
  }
  cylinder { // STube8
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 4.0>
    rotate -90.0*y
    translate  <25.0, -5.0, 7.0>
  }
  cylinder { // STube9
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 4.0>
    rotate -90.0*y
    translate  <25.0, 5.0, 7.0>
  }
  cylinder { // STube10
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 4.0>
    rotate -90.0*y
    translate  <25.0, 5.0, 10.0>
  }
  cylinder { // STube16
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 4.5>
    rotate -90.0*y
    translate  <25.0, -5.0, 2.0>
  }
  cylinder { // STube17
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 9.0>
    rotate <0.0, -90.0, -174.5>
    translate  <25.0, -5.0, 2.0>
  }
  cylinder { // STube18
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 9.0>
    rotate <0.0, -90.0, -174.5>
    translate  <25.0, -5.0, 7.0>
  }
  cylinder { // STube19
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 9.0>
    rotate <0.0, -90.0, -185.5>
    translate  <25.0, 5.0, 7.0>
  }
  texture {
    SteelPipe
  }
  translate  2.0*x
}


#declare TBend1 = intersection {
  torus { // Bend2
    1.5, 0.3  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut1
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
  rotate 180.0*z
  translate  50.0*x
}
#declare TBend = intersection {
  torus { // Bend1
    1.5, 0.3  rotate -x*90
    rotate -90.0*y
    translate  <25.0, 3.5, 12.0>
  }
  box { // BendCut
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <25.0, 5.0, 13.5>
  }
  texture {
    SteelPipe
  }
}
union { // UBend1
  cylinder { // STube1
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 10.0>
    translate  <25.0, -5.0, 2.0>
  }
  cylinder { // STube2
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 10.0>
    translate  <25.0, 5.0, 2.0>
  }
  cylinder { // STube3
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.3, 0.3, 7.0>
    rotate -90.0*x
    translate  <25.0, -3.5, 13.5>
  }
  object { TBend1 }
  object { TBend }
  texture {
    SteelPipe
  }
  translate  -2.0*x
}


union { // Binding8
  torus { // Loop113
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.625>
  }
  torus { // Loop114
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.55>
  }
  torus { // Loop115
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.475>
  }
  torus { // Loop116
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.4>
  }
  torus { // Loop117
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.25>
  }
  torus { // Loop118
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.325>
  }
  torus { // Loop119
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.175>
  }
  torus { // Loop120
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.1>
  }
  torus { // Loop121
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.025>
  }
  torus { // Loop122
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.95>
  }
  torus { // Loop123
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.875>
  }
  torus { // Loop124
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.8>
  }
  torus { // Loop125
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.725>
  }
  torus { // Loop126
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.65>
  }
  torus { // Loop127
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.575>
  }
  torus { // Loop128
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.5>
  }
  texture {
    String
  }
  rotate -90.0*y
  translate  <10.1, 9.75, 10.0>
}


union { // Binding7
  torus { // Loop97
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.625>
  }
  torus { // Loop98
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.55>
  }
  torus { // Loop99
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.475>
  }
  torus { // Loop100
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.4>
  }
  torus { // Loop101
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.25>
  }
  torus { // Loop102
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.325>
  }
  torus { // Loop103
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.175>
  }
  torus { // Loop104
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.1>
  }
  torus { // Loop105
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.025>
  }
  torus { // Loop106
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.95>
  }
  torus { // Loop107
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.875>
  }
  torus { // Loop108
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.8>
  }
  torus { // Loop109
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.725>
  }
  torus { // Loop110
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.65>
  }
  torus { // Loop111
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.575>
  }
  torus { // Loop112
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.5>
  }
  texture {
    String
  }
  rotate -90.0*y
  translate  <20.1, 9.75, 10.0>
}


union { // Binding6
  torus { // Loop81
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.625>
  }
  torus { // Loop82
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.55>
  }
  torus { // Loop83
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.475>
  }
  torus { // Loop84
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.4>
  }
  torus { // Loop85
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.25>
  }
  torus { // Loop86
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.325>
  }
  torus { // Loop87
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.175>
  }
  torus { // Loop88
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.1>
  }
  torus { // Loop89
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.025>
  }
  torus { // Loop90
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.95>
  }
  torus { // Loop91
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.875>
  }
  torus { // Loop92
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.8>
  }
  torus { // Loop93
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.725>
  }
  torus { // Loop94
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.65>
  }
  torus { // Loop95
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.575>
  }
  torus { // Loop96
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.5>
  }
  texture {
    String
  }
  rotate -90.0*y
  translate  <20.1, 0.25, 10.0>
}


union { // Binding5
  torus { // Loop65
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.625>
  }
  torus { // Loop66
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.55>
  }
  torus { // Loop67
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.475>
  }
  torus { // Loop68
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.4>
  }
  torus { // Loop69
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.25>
  }
  torus { // Loop70
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.325>
  }
  torus { // Loop71
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.175>
  }
  torus { // Loop72
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.1>
  }
  torus { // Loop73
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.025>
  }
  torus { // Loop74
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.95>
  }
  torus { // Loop75
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.875>
  }
  torus { // Loop76
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.8>
  }
  torus { // Loop77
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.725>
  }
  torus { // Loop78
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.65>
  }
  torus { // Loop79
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.575>
  }
  torus { // Loop80
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.5>
  }
  texture {
    String
  }
  rotate -90.0*y
  translate  <10.1, 0.25, 10.0>
}


union { // Binding4
  torus { // Loop49
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.625>
  }
  torus { // Loop50
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.55>
  }
  torus { // Loop51
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.475>
  }
  torus { // Loop52
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.4>
  }
  torus { // Loop53
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.25>
  }
  torus { // Loop54
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.325>
  }
  torus { // Loop55
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.175>
  }
  torus { // Loop56
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.1>
  }
  torus { // Loop57
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.025>
  }
  torus { // Loop58
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.95>
  }
  torus { // Loop59
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.875>
  }
  torus { // Loop60
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.8>
  }
  torus { // Loop61
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.725>
  }
  torus { // Loop62
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.65>
  }
  torus { // Loop63
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.575>
  }
  torus { // Loop64
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.5>
  }
  texture {
    String
  }
  translate  <-10.0, 10.0, 0.0>
}


union { // Binding3
  torus { // Loop33
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.625>
  }
  torus { // Loop34
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.55>
  }
  torus { // Loop35
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.475>
  }
  torus { // Loop36
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.4>
  }
  torus { // Loop37
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.25>
  }
  torus { // Loop38
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.325>
  }
  torus { // Loop39
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.175>
  }
  torus { // Loop40
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.1>
  }
  torus { // Loop41
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.025>
  }
  torus { // Loop42
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.95>
  }
  torus { // Loop43
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.875>
  }
  torus { // Loop44
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.8>
  }
  torus { // Loop45
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.725>
  }
  torus { // Loop46
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.65>
  }
  torus { // Loop47
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.575>
  }
  torus { // Loop48
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.5>
  }
  texture {
    String
  }
  translate  10.0*y
}


union { // Binding2
  torus { // Loop17
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.625>
  }
  torus { // Loop18
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.55>
  }
  torus { // Loop19
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.475>
  }
  torus { // Loop20
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.4>
  }
  torus { // Loop21
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.25>
  }
  torus { // Loop22
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.325>
  }
  torus { // Loop23
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.175>
  }
  torus { // Loop24
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.1>
  }
  torus { // Loop25
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.025>
  }
  torus { // Loop26
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.95>
  }
  torus { // Loop27
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.875>
  }
  torus { // Loop28
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.8>
  }
  torus { // Loop29
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.725>
  }
  torus { // Loop30
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.65>
  }
  torus { // Loop31
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.575>
  }
  torus { // Loop32
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.5>
  }
  texture {
    String
  }
  translate  -10.0*x
}


union { // Binding1
  torus { // Loop16
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.625>
  }
  torus { // Loop15
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.55>
  }
  torus { // Loop14
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.475>
  }
  torus { // Loop13
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.4>
  }
  torus { // Loop11
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.25>
  }
  torus { // Loop12
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.325>
  }
  torus { // Loop10
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.175>
  }
  torus { // Loop9
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.1>
  }
  torus { // Loop8
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 15.025>
  }
  torus { // Loop7
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.95>
  }
  torus { // Loop6
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.875>
  }
  torus { // Loop5
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.8>
  }
  torus { // Loop4
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.725>
  }
  torus { // Loop3
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.65>
  }
  torus { // Loop2
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.575>
  }
  torus { // Loop1
    0.275, 0.025  rotate -x*90
    texture {
      String
    }
    translate  <5.0, -5.0, 14.5>
  }
  texture {
    String
  }
}


torus { // ChimneyTop
  1.625, 0.375  rotate -x*90
  texture {
    DullGreyMetal
    rotate 90.0*x
  }
  scale <1.0, 1.0, 1.5>
  translate  <16.5, 0.0, 16.75>
}


torus { // ChmnyTop
  1.375, 0.375  rotate -x*90
  texture {
    DullGreyMetal
    rotate 90.0*x
  }
  translate  <16.5, 0.0, 16.0>
}


cylinder { // Chimney
  <0,0,1>, <0,0,0>, 1 
  texture {
    Red_Crusty_Pnt
  }
  scale <1.25, 1.25, 6.0>
  rotate <180.0, 0.0, 180.0>
  translate  <16.5, 0.0, 16.0>
}


box { // Stove
  <-1, -1, -1>, <1, 1, 1>
  texture {
    DullGreyMetal
  }
  scale <4.0, 4.0, 2.0>
  translate  <14.0, 0.0, 4.0>
}


union { // Rivets2
  sphere { // sphere0_7
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 15.0*x
    translate  <0.0, 3.863703, 1.035276>
  }
  sphere { // sphere1_8
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 45.0*x
    translate  <0.0, 2.828427, 2.828427>
  }
  sphere { // sphere2_9
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 30.0*x
    translate  <0.0, 3.464102, 2.0>
  }
  sphere { // sphere3_10
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 60.0*x
    translate  <0.0, 2.0, 3.464102>
  }
  sphere { // sphere4_11
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 75.0*x
    translate  <0.0, 1.035276, 3.863703>
  }
  sphere { // sphere5_12
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 90.0*x
    translate  4.0*z
  }
  sphere { // sphere6_13
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 105.0*x
    translate  <0.0, -1.035276, 3.863703>
  }
  sphere { // sphere7_14
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 120.0*x
    translate  <0.0, -2.0, 3.464102>
  }
  sphere { // sphere8_15
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 135.0*x
    translate  <0.0, -2.828427, 2.828427>
  }
  sphere { // sphere9_16
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 150.0*x
    translate  <0.0, -3.464102, 2.0>
  }
  sphere { // sphere10_17
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 165.0*x
    translate  <0.0, -3.863703, 1.035276>
  }
  sphere { // sphere11_18
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 180.0*x
    translate  -4.0*y
  }
  sphere { // sphere12_19
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 195.0*x
    translate  <0.0, -3.863703, -1.035276>
  }
  sphere { // sphere13_20
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 210.0*x
    translate  <0.0, -3.464102, -2.0>
  }
  sphere { // sphere14_21
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 225.0*x
    translate  <0.0, -2.828427, -2.828427>
  }
  sphere { // sphere15_22
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 240.0*x
    translate  <0.0, -2.0, -3.464102>
  }
  sphere { // sphere16_23
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 255.0*x
    translate  <0.0, -1.035276, -3.863703>
  }
  sphere { // sphere17_24
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 270.0*x
    translate  -4.0*z
  }
  sphere { // sphere18_25
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 285.0*x
    translate  <0.0, 1.035276, -3.863703>
  }
  sphere { // sphere19_26
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 300.0*x
    translate  <0.0, 2.0, -3.464102>
  }
  sphere { // sphere20_27
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 315.0*x
    translate  <0.0, 2.828427, -2.828427>
  }
  sphere { // sphere21_28
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 330.0*x
    translate  <0.0, 3.464102, -2.0>
  }
  sphere { // sphere22_29
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 345.0*x
    translate  <0.0, 3.863703, -1.035276>
  }
  sphere { // sphere23_30
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    translate  4.0*y
  }
  texture {
    RivetMetal
  }
  translate  <21.0, 0.0, 7.0>
}


torus { // Boiler_Band2
  3.95, 0.15  rotate -x*90
  texture {
    BumpyBronze1
    rotate 90.0*x
  }
  scale <1.0, 1.0, 4.0>
  rotate -90.0*y
  translate  <21.0, 0.0, 7.0>
}


union { // Rivets1
  sphere { // sphere24_33
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 15.0*x
    translate  <0.0, 3.863703, 1.035276>
  }
  sphere { // sphere25_34
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 45.0*x
    translate  <0.0, 2.828427, 2.828427>
  }
  sphere { // sphere26_35
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 30.0*x
    translate  <0.0, 3.464102, 2.0>
  }
  sphere { // sphere27_36
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 60.0*x
    translate  <0.0, 2.0, 3.464102>
  }
  sphere { // sphere28_37
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 75.0*x
    translate  <0.0, 1.035276, 3.863703>
  }
  sphere { // sphere29_38
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 90.0*x
    translate  4.0*z
  }
  sphere { // sphere30_39
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 105.0*x
    translate  <0.0, -1.035276, 3.863703>
  }
  sphere { // sphere31_40
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 120.0*x
    translate  <0.0, -2.0, 3.464102>
  }
  sphere { // sphere32_41
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 135.0*x
    translate  <0.0, -2.828427, 2.828427>
  }
  sphere { // sphere33_42
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 150.0*x
    translate  <0.0, -3.464102, 2.0>
  }
  sphere { // sphere34_43
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 165.0*x
    translate  <0.0, -3.863703, 1.035276>
  }
  sphere { // sphere35_44
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 180.0*x
    translate  -4.0*y
  }
  sphere { // sphere36_45
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 195.0*x
    translate  <0.0, -3.863703, -1.035276>
  }
  sphere { // sphere37_46
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 210.0*x
    translate  <0.0, -3.464102, -2.0>
  }
  sphere { // sphere38_47
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 225.0*x
    translate  <0.0, -2.828427, -2.828427>
  }
  sphere { // sphere39_48
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 240.0*x
    translate  <0.0, -2.0, -3.464102>
  }
  sphere { // sphere40_49
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 255.0*x
    translate  <0.0, -1.035276, -3.863703>
  }
  sphere { // sphere41_50
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 270.0*x
    translate  -4.0*z
  }
  sphere { // sphere42_51
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 285.0*x
    translate  <0.0, 1.035276, -3.863703>
  }
  sphere { // sphere43_52
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 300.0*x
    translate  <0.0, 2.0, -3.464102>
  }
  sphere { // sphere44_53
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 315.0*x
    translate  <0.0, 2.828427, -2.828427>
  }
  sphere { // sphere45_54
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 330.0*x
    translate  <0.0, 3.464102, -2.0>
  }
  sphere { // sphere46_55
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    rotate 345.0*x
    translate  <0.0, 3.863703, -1.035276>
  }
  sphere { // sphere47_56
    <0,0,0>,1
    texture {
      RivetMetal
    }
    scale 0.25
    translate  4.0*y
  }
  texture {
    RivetMetal
  }
  translate  <14.0, 0.0, 7.0>
}


torus { // Boiler_Band1
  3.95, 0.15  rotate -x*90
  texture {
    BumpyBronze
    rotate 90.0*x
  }
  scale <1.0, 1.0, 4.0>
  rotate -90.0*y
  translate  <14.0, 0.0, 7.0>
}


union { // Poles
  cylinder { // rod1
    <0,0,1>, <0,0,0>, 1 
    texture {
      RodSupportWood
    }
    scale <0.25, 0.25, 12.0>
    rotate <0.596809, 90.0, 90.596809>
    translate  <-4.75, -6.0, 15.5>
  }
  cylinder { // rod2
    <0,0,1>, <0,0,0>, 1 
    texture {
      RodSupportWood
    }
    scale <0.25, 0.25, 12.0>
    rotate <0.596809, 90.0, 90.596809>
    translate  <4.75, -6.0, 15.5>
  }
  cylinder { // rod3
    <0,0,1>, <0,0,0>, 1 
    texture {
      RodSupportWood
    }
    scale <0.25, 0.25, 16.0>
    rotate 90.0*y
    translate  <-6.0, -4.75, 15.0>
  }
  cylinder { // rod4
    <0,0,1>, <0,0,0>, 1 
    texture {
      RodSupportWood
    }
    scale <0.25, 0.25, 12.0>
    rotate 90.0*y
    translate  <-6.0, 4.75, 15.0>
  }
  cylinder { // rod5
    <0,0,1>, <0,0,0>, 1 
    texture {
      RodSupportWood
    }
    scale <0.25, 0.25, 15.0>
    rotate <180.0, 0.0, 180.0>
    translate  <5.0, 5.0, 17.0>
  }
  cylinder { // rod6
    <0,0,1>, <0,0,0>, 1 
    texture {
      RodSupportWood
    }
    scale <0.25, 0.25, 15.0>
    rotate <180.0, 0.0, 180.0>
    translate  <5.0, -5.0, 17.0>
  }
  cylinder { // rod7
    <0,0,1>, <0,0,0>, 1 
    texture {
      RodSupportWood
    }
    scale <0.25, 0.25, 15.0>
    rotate <180.0, 0.0, 180.0>
    translate  <-5.0, -5.0, 17.0>
  }
  cylinder { // rod8
    <0,0,1>, <0,0,0>, 1 
    texture {
      RodSupportWood
    }
    scale <0.25, 0.25, 15.0>
    rotate <180.0, 0.0, 180.0>
    translate  <-5.0, 5.0, 17.0>
  }
  texture {
    RodSupportWood
  }
}


difference { // SkinTop
  box { // box9_204
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.02, 5.0>
    translate  <0.0, -4.6, 10.0>
  }
  cylinder { // cylinde9_205
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.4, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-4.5, -3.8, 14.4>
  }
  cylinder { // cylinde10_206
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.8, 1.0>
    rotate <270.0, 10.0, 180.0>
    translate  <-5.2, -3.8, 11.5>
  }
  cylinder { // cylinde11_207
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.4, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-5.1, -3.8, 8.1>
  }
  cylinder { // cylinde12_208
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.1, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-1.9, -3.8, 14.5>
  }
  cylinder { // cylinde13_209
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.3, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <1.1, -3.8, 14.9>
  }
  cylinder { // cylinde14_210
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 1.0, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.7, -3.8, 11.9>
  }
  cylinder { // cylinde15_211
    <0,0,1>, <0,0,0>, 1 
    scale <1.9, 1.5, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.8, -3.8, 14.7>
  }
  cylinder { // cylinde16_212
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 1.0, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.9, -3.8, 9.5>
  }
  cylinder { // cylinde17_213
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.9, -3.8, 6.9>
  }
  cylinder { // cylinde18_214
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.1, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-3.3, -3.8, 5.7>
  }
  cylinder { // cylinde19_215
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.3, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <2.5, -3.8, 5.0>
  }
  cylinder { // cylinde20_216
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.3, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-0.6, -3.8, 4.5>
  }
  texture {
    Skin
  translate <23.700001, 0.000000, 24.500000>
  }
  rotate 270.0*x
  translate  <0.0, -10.0, 10.6>
}


difference { // SkinBack
  box { // box11_218
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.02, 5.0>
    translate  <0.0, -4.6, 10.0>
  }
  cylinder { // cylinde21_219
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.4, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-4.5, -3.8, 14.4>
  }
  cylinder { // cylinde22_220
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.8, 1.0>
    rotate <270.0, 10.0, 180.0>
    translate  <-5.2, -3.8, 11.5>
  }
  cylinder { // cylinde23_221
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.4, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-5.1, -3.8, 8.1>
  }
  cylinder { // cylinde24_222
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.1, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-1.9, -3.8, 14.5>
  }
  cylinder { // cylinde25_223
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.3, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <1.1, -3.8, 14.9>
  }
  cylinder { // cylinde26_224
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 1.0, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.7, -3.8, 11.9>
  }
  cylinder { // cylinde27_225
    <0,0,1>, <0,0,0>, 1 
    scale <1.9, 1.5, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.8, -3.8, 14.7>
  }
  cylinder { // cylinde28_226
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 1.0, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.9, -3.8, 9.5>
  }
  cylinder { // cylinde29_227
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.9, -3.8, 6.9>
  }
  texture {
    Skin
  translate <23.700001, 0.000000, 24.500000>
  }
  rotate 270.0*z
  translate  -0.25*x
}


difference { // SkinLeft
  box { // box13_229
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.02, 5.0>
    translate  <0.0, -4.6, 10.0>
  }
  cylinder { // cylinde30_230
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.4, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-4.5, -3.8, 14.4>
  }
  cylinder { // cylinde31_231
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.8, 1.0>
    rotate <270.0, 10.0, 180.0>
    translate  <-5.2, -3.8, 11.5>
  }
  cylinder { // cylinde32_232
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.4, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-5.1, -3.8, 8.1>
  }
  cylinder { // cylinde33_233
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.1, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-1.9, -3.8, 14.5>
  }
  cylinder { // cylinde34_234
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.3, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <1.1, -3.8, 14.9>
  }
  cylinder { // cylinde35_235
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 1.0, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.7, -3.8, 11.9>
  }
  cylinder { // cylinde36_236
    <0,0,1>, <0,0,0>, 1 
    scale <1.9, 1.5, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.8, -3.8, 14.7>
  }
  cylinder { // cylinde37_237
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 1.0, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.9, -3.8, 9.5>
  }
  cylinder { // cylinde38_238
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.9, -3.8, 6.9>
  }
  texture {
    Skin
  translate <23.700001, 0.000000, 24.500000>
  }
  rotate 180.0*z
  translate  0.25*y
}


difference { // SkinRight
  box { // box15_240
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.02, 5.0>
    translate  <0.0, -4.6, 10.0>
  }
  cylinder { // cylinde39_241
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.4, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-4.5, -3.8, 14.4>
  }
  cylinder { // cylinde40_242
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.8, 1.0>
    rotate <270.0, 10.0, 180.0>
    translate  <-5.2, -3.8, 11.5>
  }
  cylinder { // cylinde41_243
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.4, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-5.1, -3.8, 8.1>
  }
  cylinder { // cylinde42_244
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.1, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <-1.9, -3.8, 14.5>
  }
  cylinder { // cylinde43_245
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.3, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <1.1, -3.8, 14.9>
  }
  cylinder { // cylinde44_246
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 1.0, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.7, -3.8, 11.9>
  }
  cylinder { // cylinde45_247
    <0,0,1>, <0,0,0>, 1 
    scale <1.9, 1.5, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.8, -3.8, 14.7>
  }
  cylinder { // cylinde46_248
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 1.0, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.9, -3.8, 9.5>
  }
  cylinder { // cylinde47_249
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 1.0>
    rotate <270.0, 0.0, 180.0>
    translate  <4.9, -3.8, 6.9>
  }
  texture {
    Skin
  }
  translate  -0.25*y
}


union { // Boiler
  cylinder { // cylinde48_251
    <0,0,1>, <0,0,0>, 1 
    texture {
      Red_Crusty_Pnt
    }
    scale <4.0, 4.0, 10.0>
    rotate 90.0*y
    translate  <10.0, 0.0, 7.0>
  }
  sphere { // sphere48_252
    <0,0,0>,1
    texture {
      Red_Crusty_Pnt
    }
    scale <2.0, 4.0, 4.0>
    translate  <10.0, 0.0, 7.0>
  }
  sphere { // sphere49_253
    <0,0,0>,1
    texture {
      Red_Crusty_Pnt
    }
    scale <2.0, 4.0, 4.0>
    translate  <20.0, 0.0, 7.0>
  }
  texture {
    Red_Crusty_Pnt
  }
  translate  2.5*x
}


box { // Beam1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BeamWood
    rotate <9.079468, 4.208542, 65.334305>
  }
  scale <5.0, 0.5, 0.8>
  rotate 270.0*z
  translate  <20.0, 0.0, 2.0>
}


box { // Beam4
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BeamWood
    rotate <9.079468, 4.208542, 65.334305>
  }
  scale <5.0, 0.5, 0.8>
  rotate 270.0*z
  translate  <5.0, 0.0, 2.0>
}


box { // Beam5
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BeamWood
    rotate <9.079468, 4.208542, 65.334305>
  }
  scale <5.0, 0.5, 0.8>
  rotate 270.0*z
  translate  <5.0, 0.0, 6.0>
}


box { // Beam7
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BeamWood
    rotate <9.079468, 4.208542, 65.334305>
  }
  scale <14.0, 0.5, 0.8>
  translate  <9.0, 5.0, 2.0>
}


box { // Beam8
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BeamWood
    rotate <9.079468, 4.208542, 65.334305>
  }
  scale <14.0, 0.5, 0.8>
  translate  <9.0, -5.0, 2.0>
}


box { // Beam9
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BeamWood
    scale 1.9
    rotate <351.992249, 35.447155, 79.276794>
  }
  scale <14.0, 0.5, 0.8>
  translate  <9.0, 5.0, 6.0>
}


box { // Beam10
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BeamWood
    rotate <9.079468, 4.208542, 65.334305>
  }
  scale <14.0, 0.5, 0.8>
  translate  <9.0, -5.0, 6.0>
}


union { // AxleBack
  cone { // Peg2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.4, 0.4, 3.5>
    rotate <0.0, 35.0, 0.0>
    translate  <-1.1, -8.8, 3.3>
  }
  cylinder { // MainAxle
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 22.0>
    rotate <270.0, 0.0, 180.0>
    translate  <0.0, 12.0, 4.9>
  }
  texture {
    Wood_axle
  }
  scale <1.0, 1.05, 1.0>
  translate  <0.0, -1.7, -1.25>
}


#declare L_BS = intersection {
  cone { // L_Base
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.0>
    rotate 180.0*x
  }
  plane { // L_BaseCut
    z,0
    translate  -1.2*z
  }
  texture {
    SmoothBronze
  }
}
#declare G_Outside = merge {
  sphere { // Glass
    <0,0,0>,1
    scale 0.8
  }
  cone { // Glass2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.7, 0.7, 2.0>
    rotate 180.0*x
    translate  2.4*z
  }
}
#declare G_Inside = merge {
  sphere { // Glass1
    <0,0,0>,1
    scale 0.75
  }
  cone { // Glass3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.65, 0.65, 1.857143>
    rotate 180.0*x
    translate  2.2*z
  }
  texture {
    Simp_Glass
  }
}
#declare Glass_Cover = difference {
  object { G_Outside }
  object { G_Inside }
  texture {
    Simp_Glass
  }
}
#declare Lamp_Glass = intersection {
  object { Glass_Cover }
  plane { // G_cut
    z,0
    translate  1.0*z
  }
  texture {
    Simp_Glass
  }
  translate  -0.6*z
}
union { // OilLamp
  cylinder { // Wick
    <0,0,1>, <0,0,0>, 1 
    texture {
      SmoothBronze
    }
    scale <0.15, 0.15, 0.4>
    translate  -1.2*z
  }
  torus { // Lamp_Ring1
    0.35, 0.05  rotate -x*90
    texture {
      SmoothBronze
    }
    rotate -90.0*x
    translate  1.2*z
  }
  torus { // L_BRound4
    0.55, 0.05  rotate -x*90
    texture {
      SmoothBronze
    }
    translate  0.9*z
  }
  object { L_BS }
  object { Lamp_Glass }
  torus { // L_BRound3
    0.65, 0.05  rotate -x*90
    texture {
      SmoothBronze
    }
    translate  -1.2*z
  }
  cylinder { // Lamp_Top1
    <0,0,1>, <0,0,0>, 1 
    texture {
      SmoothBronze
    }
    scale 0.5
    translate  0.4*z
  }
  torus { // L_BRound2
    1.05, 0.05  rotate -x*90
    texture {
      SmoothBronze
    }
    translate  -2.0*z
  }
  torus { // L_BRound1
    0.55, 0.05  rotate -x*90
    texture {
      SmoothBronze
    }
    translate  0.4*z
  }
  texture {
    Simp_Glass
  }
  scale 0.8
  rotate -90.0*z
  translate  <10.4, -5.0, 13.8>
}


box { // Control_Box1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BumpyBronze
  }
  scale <2.0, 2.0, 1.0>
  translate  <20.5, 0.0, 10.5>
}


cylinder { // Pend_Base
  <0,0,1>, <0,0,0>, 1 
  texture {
    BumpyBronze
  }
  scale <0.6, 0.6, 1.0>
  translate  <20.6, 0.0, 11.0>
}


union { // Pendulum
  cylinder { // Pend_Cyl1
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 5.0>
  }
  cylinder { // Pend_Cyl2
    <0,0,1>, <0,0,0>, 1 
    texture {
      BumpyBronze
    }
    scale <0.1, 0.1, 4.0>
    rotate -30.0*y
    translate  <2.0, 0.0, 1.5>
  }
  cylinder { // Pend_Cyl3
    <0,0,1>, <0,0,0>, 1 
    texture {
      BumpyBronze
    }
    scale <0.1, 0.1, 4.0>
    rotate 30.0*y
    translate  <-2.0, 0.0, 1.5>
  }
  sphere { // Pend_ball1
    <0,0,0>,1
    texture {
      BumpyBronze
    }
    scale 0.7
    translate  <-2.0, 0.0, 1.5>
  }
  sphere { // Pend_ball2
    <0,0,0>,1
    texture {
      BumpyBronze
    }
    scale 0.7
    translate  <2.0, 0.0, 1.5>
  }
  sphere { // Pend_ball3
    <0,0,0>,1
    texture {
      BumpyBronze
    }
    scale 0.7
    translate  4.9*z
  }
  box { // Pend_Band1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.1, 0.2>
    rotate -15.0*y
    translate  <0.6, 0.2, 1.2>
  }
  box { // Pend_Band2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.1, 0.2>
    rotate 15.0*y
    translate  <-0.6, -0.2, 1.2>
  }
  cylinder { // Support1
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.6>
    rotate -90.0*x
    translate  <0.0, -0.3, 0.7>
  }
  texture {
    BumpyBronze
  }
  scale 0.6
  rotate -20.0*z
  translate  <20.6, 0.0, 12.0>
}


#declare Bolts1 = union {
  cylinder { // Fake_Bolt13
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 0.0, 2.3>
  }
  cylinder { // Fake_Bolt14
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.15, 1.991858>
  }
  cylinder { // Fake_Bolt15
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 2.3, 0.0>
  }
  cylinder { // Fake_Bolt16
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.991858, 1.15>
  }
  cylinder { // Fake_Bolt17
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.15, -1.991858>
  }
  cylinder { // Fake_Bolt18
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 0.0, -2.3>
  }
  cylinder { // Fake_Bolt19
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.15, -1.991858>
  }
  cylinder { // Fake_Bolt20
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.991858, -1.15>
  }
  cylinder { // Fake_Bolt21
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.991858, -1.15>
  }
  cylinder { // Fake_Bolt22
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -2.3, 0.0>
  }
  cylinder { // Fake_Bolt23
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.991858, 1.15>
  }
  cylinder { // Fake_Bolt24
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.15, 1.991858>
  }
  texture {
    SteelPipe
  }
  translate  7.55*x
}
#declare Bolts = union {
  cylinder { // Fake_Bolt1
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 0.0, 2.3>
  }
  cylinder { // Fake_Bolt2
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.15, 1.991858>
  }
  cylinder { // Fake_Bolt4
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 2.3, 0.0>
  }
  cylinder { // Fake_Bolt3
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.991858, 1.15>
  }
  cylinder { // Fake_Bolt6
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.15, -1.991858>
  }
  cylinder { // Fake_Bolt7
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 0.0, -2.3>
  }
  cylinder { // Fake_Bolt8
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.15, -1.991858>
  }
  cylinder { // Fake_Bolt5
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.991858, -1.15>
  }
  cylinder { // Fake_Bolt9
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.991858, -1.15>
  }
  cylinder { // Fake_Bolt10
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -2.3, 0.0>
  }
  cylinder { // Fake_Bolt11
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.991858, 1.15>
  }
  cylinder { // Fake_Bolt12
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.15, 1.991858>
  }
  texture {
    SteelPipe
  }
}
#declare DCylinder = union {
  object { Bolts1 }
  object { Bolts }
  cylinder { // Piston_Cyl1
    <0,0,1>, <0,0,0>, 1 
    texture {
      BumpyBronze
    }
    scale <2.0, 2.0, 7.0>
    rotate 90.0*y
  }
  cylinder { // Piston_Cyl2
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <2.6, 2.6, 0.5>
    rotate 90.0*y
  }
  cylinder { // Piston_Cyl3
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <2.6, 2.6, 0.5>
    rotate <-180.0, 90.0, 0.0>
    translate  -0.15*x
  }
  sphere { // Piston_Sph1
    <0,0,0>,1
    texture {
      DullBumpyBronze
    }
    scale 1.9
    translate  0.8*x
  }
  cylinder { // Piston_Cyl4
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <2.6, 2.6, 0.5>
    rotate 90.0*y
    translate  7.0*x
  }
  cylinder { // Piston_Cyl5
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <2.6, 2.6, 0.5>
    rotate 90.0*y
    translate  7.6*x
  }
  texture {
    Simple_Copper
  }
}
#declare Bolts2 = union {
  cylinder { // Fake_Bolt25
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 0.0, 2.3>
  }
  cylinder { // Fake_Bolt26
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.15, 1.991858>
  }
  cylinder { // Fake_Bolt27
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 2.3, 0.0>
  }
  cylinder { // Fake_Bolt28
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.991858, 1.15>
  }
  cylinder { // Fake_Bolt29
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.15, -1.991858>
  }
  cylinder { // Fake_Bolt30
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 0.0, -2.3>
  }
  cylinder { // Fake_Bolt31
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.15, -1.991858>
  }
  cylinder { // Fake_Bolt32
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.991858, -1.15>
  }
  cylinder { // Fake_Bolt33
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.991858, -1.15>
  }
  cylinder { // Fake_Bolt34
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -2.3, 0.0>
  }
  cylinder { // Fake_Bolt35
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.991858, 1.15>
  }
  cylinder { // Fake_Bolt36
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.15, 1.991858>
  }
  texture {
    DullBumpyBronze
  }
  translate  7.55*x
}
#declare Bolts3 = union {
  cylinder { // Fake_Bolt37
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 0.0, 2.3>
  }
  cylinder { // Fake_Bolt38
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.15, 1.991858>
  }
  cylinder { // Fake_Bolt39
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 2.3, 0.0>
  }
  cylinder { // Fake_Bolt40
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.991858, 1.15>
  }
  cylinder { // Fake_Bolt41
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.15, -1.991858>
  }
  cylinder { // Fake_Bolt42
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 0.0, -2.3>
  }
  cylinder { // Fake_Bolt43
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.15, -1.991858>
  }
  cylinder { // Fake_Bolt44
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, 1.991858, -1.15>
  }
  cylinder { // Fake_Bolt45
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.991858, -1.15>
  }
  cylinder { // Fake_Bolt46
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -2.3, 0.0>
  }
  cylinder { // Fake_Bolt47
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.991858, 1.15>
  }
  cylinder { // Fake_Bolt48
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate -90.0*y
    translate  <0.75, -1.15, 1.991858>
  }
  texture {
    DullBumpyBronze
  }
}
#declare Valve_Cyl = union {
  object { Bolts2 }
  object { Bolts3 }
  cylinder { // Piston_Cyl7
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <2.0, 2.0, 7.0>
    rotate 90.0*y
  }
  cylinder { // Piston_Cyl8
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <2.6, 2.6, 0.5>
    rotate 90.0*y
  }
  cylinder { // Piston_Cyl9
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <2.6, 2.6, 0.5>
    rotate <-180.0, 90.0, 0.0>
    translate  -0.15*x
  }
  cylinder { // Piston_Cyl10
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <2.6, 2.6, 0.5>
    rotate 90.0*y
    translate  7.0*x
  }
  cylinder { // Piston_Cyl11
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <2.6, 2.6, 0.5>
    rotate 90.0*y
    translate  7.6*x
  }
  texture {
    Simple_Copper
  }
  scale <0.6, 0.75, 0.75>
  translate  <1.5, 0.0, 4.5>
}
#declare G_Rail1 = difference {
  box { // SlideRail1
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 0.5, 0.5>
    translate  <10.0, 0.0, -1.9>
  }
  box { // SlideRail4
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.25, 0.5>
    translate  <10.0, 0.0, -1.5>
  }
  texture {
    DullBumpyBronze
  }
  scale <1.2, 1.0, 1.0>
}
#declare G_Rail2 = difference {
  box { // SlideRail2
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.5, 0.8>
    translate  <10.0, 0.0, 2.3>
  }
  box { // SlideRail5
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.25, 0.5>
    translate  <10.0, 0.0, 1.5>
  }
  box { // SlideRail6
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.25, 0.5>
    translate  <10.0, 0.0, 3.0>
  }
  texture {
    DullBumpyBronze
  }
}
#declare G_Rail3 = difference {
  box { // SlideRail3
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.5, 0.5>
    translate  <10.0, 0.0, 6.4>
  }
  box { // SlideRail7
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.25, 0.5>
    translate  <10.0, 0.0, 6.0>
  }
  texture {
    DullBumpyBronze
  }
}
#declare Bar1 = union {
  box { // Slider8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DullBumpyBronze
    }
    scale <1.0, 0.8, 6.0>
    rotate -90.0*y
    translate  25.7*x
  }
  box { // Slider7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DullBumpyBronze
    }
    scale <1.0, 0.25, 3.0>
    rotate -90.0*y
    translate  <16.7, 0.6, 0.0>
  }
  box { // Slider6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DullBumpyBronze
    }
    scale <1.0, 0.25, 3.0>
    rotate -90.0*y
    translate  <16.7, -0.6, 0.0>
  }
  cylinder { // Pist_Peg7
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <2.0, 2.0, 1.5>
    rotate -90.0*x
    translate  <30.0, -0.75, 0.0>
  }
  cylinder { // Pist_Peg9
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.4, 0.4, 4.0>
    translate  <31.4, 10.0, -2.0>
  }
  cylinder { // Pist_Peg10
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.4, 0.4, 4.0>
    translate  <28.8, 10.0, -2.0>
  }
}
#declare Driver1 = difference {
  object { Bar1 }
  box { // Slider9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DullBumpyBronze
    }
    scale <0.5, 0.25, 3.0>
    rotate -90.0*y
    translate  <24.0, -0.6, 0.0>
  }
  cylinder { // Pist_Peg5
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <0.5, 0.5, 2.5>
    rotate -90.0*x
    translate  <21.0, -2.85, 0.0>
  }
  cylinder { // Pist_Peg6
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <0.5, 0.5, 2.5>
    rotate -90.0*x
    translate  <27.0, -2.85, 0.0>
  }
  rotate 8.0*y
  translate  <0.1, 0.0, 2.1>
}
#declare Bar2 = union {
  box { // Slider10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DullBumpyBronze
    }
    scale <1.0, 0.8, 6.0>
    rotate -90.0*y
    translate  25.7*x
  }
  box { // Slider11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DullBumpyBronze
    }
    scale <1.0, 0.25, 3.0>
    rotate -90.0*y
    translate  <16.7, 0.6, 0.0>
  }
  box { // Slider12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DullBumpyBronze
    }
    scale <1.0, 0.25, 3.0>
    rotate -90.0*y
    translate  <16.7, -0.6, 0.0>
  }
  cylinder { // Pist_Peg11
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <2.0, 2.0, 1.5>
    rotate -90.0*x
    translate  <30.0, -0.75, 0.0>
  }
  cylinder { // Pist_Peg13
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.4, 0.4, 4.0>
    translate  <31.4, 10.0, -2.0>
  }
  cylinder { // Pist_Peg14
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.4, 0.4, 4.0>
    translate  <28.8, 10.0, -2.0>
  }
}
#declare Driver2 = difference {
  object { Bar2 }
  box { // Slider13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DullBumpyBronze
    }
    scale <0.5, 0.25, 3.0>
    rotate -90.0*y
    translate  <24.0, -0.6, 0.0>
  }
  cylinder { // Pist_Peg15
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <0.5, 0.5, 2.5>
    rotate -90.0*x
    translate  <21.0, -2.85, 0.0>
  }
  cylinder { // Pist_Peg16
    <0,0,1>, <0,0,0>, 1 
    texture {
      DullBumpyBronze
    }
    scale <0.5, 0.5, 2.5>
    rotate -90.0*x
    translate  <27.0, -2.85, 0.0>
  }
  scale <0.75, 0.7, 0.7>
  rotate 3.0*y
  translate  <7.3, -1.5, 2.625>
}
union { // PISTON
  object { DCylinder }
  object { Valve_Cyl }
  object { G_Rail1 }
  object { G_Rail2 }
  object { G_Rail3 }
  cylinder { // Piston_Cyl12
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.5, 0.5, 3.0>
    rotate <-180.0, -90.0, 0.0>
    translate  <6.0, 0.0, 4.5>
  }
  cylinder { // Piston_Cyl6
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.8, 0.8, 5.0>
    rotate <-180.0, -90.0, 0.0>
    translate  8.0*x
  }
  box { // Joiner1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DullBumpyBronze
    }
    scale <1.4, 1.0, 1.0>
    translate  <3.75, 0.0, 2.5>
  }
  box { // Slider1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BumpyBronze
    }
    scale <2.0, 0.25, 2.0>
    translate  14.0*x
  }
  box { // Slider2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BumpyBronze1
    }
    scale <2.0, 0.25, 2.0>
    translate  <10.5, 0.0, 4.5>
  }
  box { // ArmBase
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DullBumpyBronze
    }
    scale <1.5, 0.5, 1.0>
    translate  <17.5, 0.0, -3.4>
  }
  box { // Arm1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BumpyBronze1
    }
    scale <0.75, 0.25, 6.0>
    rotate 10.0*y
    translate  <18.2, -1.5, 0.9>
  }
  box { // Arm2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BumpyBronze1
    }
    scale <0.75, 0.25, 5.5>
    rotate <180.0, -85.0, 180.0>
    translate  <15.0, -0.75, 4.8>
  }
  cylinder { // Pist_Peg1
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.5, 0.5, 3.5>
    rotate -90.0*x
    translate  <17.5, -2.5, -3.4>
  }
  cylinder { // Pist_Peg2
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.5, 0.5, 3.5>
    rotate -90.0*x
    translate  <10.8, -2.5, 4.5>
  }
  cylinder { // Pist_Peg3
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.5, 0.5, 2.5>
    rotate -90.0*x
    translate  <19.0, -2.5, 5.1>
  }
  cylinder { // Pist_Peg4
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.75, 0.75, 2.5>
    rotate -90.0*x
    translate  <14.7, -1.2, 0.0>
  }
  object { Driver1 }
  object { Driver2 }
  cylinder { // Pist_Peg17
    <0,0,1>, <0,0,0>, 1 
    texture {
      SteelPipe
    }
    scale <0.5, 0.5, 2.5>
    rotate -90.0*x
    translate  <18.4, -2.5, 2.0>
  }
  scale 0.5
  translate  <6.6, -7.5, 3.5>
}


#declare WSpoke = intersection {
  cone { // WSpoke1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut1
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
}
#declare WSpoke3 = intersection {
  cone { // WSpoke2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut2
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate -30.0*z
}
#declare WSpoke5 = intersection {
  cone { // WSpoke4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut3
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate -60.0*z
}
#declare WSpoke7 = intersection {
  cone { // WSpoke6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut4
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate -90.0*z
}
#declare WSpoke9 = intersection {
  cone { // WSpoke8
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut5
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate -120.0*z
}
#declare WSpoke11 = intersection {
  cone { // WSpoke10
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut6
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate -150.0*z
}
#declare WSpoke13 = intersection {
  cone { // WSpoke12
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut7
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate 180.0*z
}
#declare WSpoke15 = intersection {
  cone { // WSpoke14
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut8
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate 150.0*z
}
#declare WSpoke17 = intersection {
  cone { // WSpoke16
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut9
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate 120.0*z
}
#declare WSpoke19 = intersection {
  cone { // WSpoke18
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut10
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate 90.0*z
}
#declare WSpoke21 = intersection {
  cone { // WSpoke20
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut11
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate 60.0*z
}
#declare WSpoke23 = intersection {
  cone { // WSpoke22
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 5.0>
    rotate 90.0*x
    translate  5.5*y
  }
  plane { // SpokeCut12
    z,0
    rotate -90.0*x
    translate  2.9*y
  }
  rotate 30.0*z
}
#declare WBolts1 = union {
  cylinder { // WBolt1
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    translate  <0.0, 0.8, 0.15>
  }
  cylinder { // WBolt2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate -45.0*z
    translate  <0.565685, 0.565685, 0.15>
  }
  cylinder { // WBolt4
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate -135.0*z
    translate  <0.565685, -0.565685, 0.15>
  }
  cylinder { // WBolt3
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate -90.0*z
    translate  <0.8, 0.0, 0.15>
  }
  cylinder { // WBolt5
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate 180.0*z
    translate  <0.0, -0.8, 0.15>
  }
  cylinder { // WBolt6
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate 135.0*z
    translate  <-0.565685, -0.565685, 0.15>
  }
  cylinder { // WBolt7
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate 90.0*z
    translate  <-0.8, 0.0, 0.15>
  }
  cylinder { // WBolt8
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate 45.0*z
    translate  <-0.565685, 0.565685, 0.15>
  }
}
#declare Wrim1 = difference {
  cylinder { // WRim1
    <0,0,1>, <0,0,0>, 1 
    scale <5.25, 5.25, 1.25>
    rotate <90.0, 0.0, 0.0>
    translate  <21.5, -5.775, 3.7>
  }
  cylinder { // WRim2
    <0,0,1>, <0,0,0>, 1 
    scale <4.725, 4.725, 1.5>
    rotate <90.0, 0.0, 0.0>
    translate  <21.5, -5.65, 3.7>
  }
  scale <0.571429, 0.8, 0.571429>
  rotate <-90.0, 0.0, 0.0>
  translate  <-12.285714, -2.114286, -5.12>
}
union { // MWheelR
  cylinder { // MW_WAxle1
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
  }
  cylinder { // MW_WAxle2
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 0.8>
    translate  -0.4*z
  }
  cylinder { // CBar1
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    translate  <0.0, -0.7, 0.3>
  }
  cylinder { // CBar2
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.6>
    translate  <0.0, 0.3, 1.1>
  }
  cylinder { // CrossBar1
    <0,0,1>, <0,0,0>, 1 
    scale <0.14, 0.08, 1.0>
    rotate -90.0*x
    translate  <0.0, -0.7, 1.2>
  }
  object { WSpoke }
  object { WSpoke3 }
  object { WSpoke5 }
  object { WSpoke7 }
  object { WSpoke9 }
  object { WSpoke11 }
  object { WSpoke13 }
  object { WSpoke15 }
  object { WSpoke17 }
  object { WSpoke19 }
  object { WSpoke21 }
  object { WSpoke23 }
  object { WBolts1 }
  object { Wrim1 }
  texture {
    Simple_Copper
  }
  scale <1.75, 1.75, 1.25>
  rotate <-90.0, -180.0, -180.0>
  translate  <21.5, -6.4, 3.7>
}


#declare BWUnion = union {
  cylinder { // BWhell1
    <0,0,1>, <0,0,0>, 1 
    scale <6.5, 6.5, 4.0>
    rotate 90.0*x
  }
  cylinder { // BWhell2
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*x
    translate  0.5*y
  }
  torus { // BWRound1
    6.0, 0.5  rotate -x*90
    rotate -90.0*x
  }
  torus { // BWRound2
    6.0, 0.5  rotate -x*90
    rotate -90.0*x
    translate  -4.0*y
  }
}
#declare BWCut1 = difference {
  object { BWUnion }
  cylinder { // BWhell3
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.5>
    rotate 90.0*x
    translate  0.75*y
  }
  cylinder { // BWhell4
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 1.0>
    rotate 90.0*x
    translate  -4.0*y
  }
}
union { // BackWheelR
  object { BWCut1 }
  torus { // BWRound3
    1.5, 0.5  rotate -x*90
    rotate -90.0*x
    translate  -4.0*y
  }
  texture {
    Stone
  }
  scale 0.8
  translate  <0.0, -6.5, 3.75>
}


#declare BBLayer1 = union {
  box { // BB_Front1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 5.0, 1.0>
    translate  <38.0, 0.0, 5.0>
  }
  cylinder { // BB_round1
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    translate  <38.0, 5.0, 4.0>
  }
  cylinder { // BB_round2
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    translate  <38.0, -5.0, 4.0>
  }
  box { // BB_Front2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.0, 1.0>
    rotate -83.0*z
    translate  <36.07, -5.74, 5.0>
  }
  box { // BB_Front3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.0, 1.0>
    rotate -97.0*z
    translate  <36.07, 5.74, 5.0>
  }
  texture {
    BB_wood
    scale <2.0, 1.272727, 0.454545>
    rotate <47.759281, -13.72765, -158.899628>
  translate <37.000000, 0.800000, 6.300000>
  }
}
#declare BBLayer2 = union {
  box { // BB_Front4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BB_Metal
    }
    scale <1.0, 5.0, 1.0>
    translate  <38.0, 0.0, 5.0>
  }
  cylinder { // BB_round3
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    translate  <38.0, 5.0, 4.0>
  }
  cylinder { // BB_round4
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    translate  <38.0, -5.0, 4.0>
  }
  box { // BB_Front5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.0, 1.0>
    rotate -83.0*z
    translate  <36.07, -5.74, 5.0>
  }
  box { // BB_Front6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.0, 1.0>
    rotate -97.0*z
    translate  <36.07, 5.74, 5.0>
  }
  texture {
    BB_Metal
  }
  scale <1.0, 1.0, 0.1>
  translate  5.6*z
}
#declare BBLayer3 = union {
  box { // BB_Front7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 5.0, 1.0>
    translate  <38.0, 0.0, 5.0>
  }
  cylinder { // BB_round5
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    translate  <38.0, 5.0, 4.0>
  }
  cylinder { // BB_round6
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    translate  <38.0, -5.0, 4.0>
  }
  box { // BB_Front8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.0, 1.0>
    rotate -83.0*z
    translate  <36.07, -5.74, 5.0>
  }
  box { // BB_Front9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.0, 1.0>
    rotate -97.0*z
    translate  <36.07, 5.74, 5.0>
  }
  texture {
    BB_Metal
  }
  scale <1.0, 1.0, 0.1>
  translate  3.4*z
}
#declare BB_Rivets1 = union {
  sphere { // BB_Rivet1
    <0,0,0>,1
    scale 0.25
    translate  <38.0, -5.0, 6.2>
  }
  sphere { // BB_Rivet2
    <0,0,0>,1
    scale 0.25
    translate  <38.0, -3.0, 6.2>
  }
  sphere { // BB_Rivet3
    <0,0,0>,1
    scale 0.25
    translate  <38.0, -1.0, 6.2>
  }
  sphere { // BB_Rivet4
    <0,0,0>,1
    scale 0.25
    translate  <38.0, 1.0, 6.2>
  }
  sphere { // BB_Rivet5
    <0,0,0>,1
    scale 0.25
    translate  <38.0, 3.0, 6.2>
  }
  sphere { // BB_Rivet6
    <0,0,0>,1
    scale 0.25
    translate  <38.0, 5.0, 6.2>
  }
  sphere { // BB_Rivet7
    <0,0,0>,1
    scale 0.25
    translate  <34.6, 5.9, 6.2>
  }
  sphere { // BB_Rivet8
    <0,0,0>,1
    scale 0.25
    translate  <34.6, -5.9, 6.2>
  }
  texture {
    BB_Metal
  }
}
#declare BB_spikes = union {
  cone { // BB_Spike1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.4, 0.4, 1.2>
    rotate -90.0*y
    translate  <40.0, -5.0, 5.0>
  }
  cone { // BB_Spike2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.4, 0.4, 1.2>
    rotate -90.0*y
    translate  <40.0, -3.0, 5.0>
  }
  cone { // BB_Spike3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.4, 0.4, 1.2>
    rotate -90.0*y
    translate  <40.0, -1.0, 5.0>
  }
  cone { // BB_Spike4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.4, 0.4, 1.2>
    rotate -90.0*y
    translate  <40.0, 1.0, 5.0>
  }
  cone { // BB_Spike5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.4, 0.4, 1.2>
    rotate -90.0*y
    translate  <40.0, 3.0, 5.0>
  }
  cone { // BB_Spike6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.4, 0.4, 1.2>
    rotate -90.0*y
    translate  <40.0, 5.0, 5.0>
  }
  cone { // BB_Spike7
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.4, 0.4, 1.2>
    rotate <0.0, -90.0, -83.0>
    translate  <34.800001, -7.5, 5.0>
  }
  cone { // BB_Spike8
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.4, 0.4, 1.2>
    rotate <0.0, -90.0, -277.0>
    translate  <34.800001, 7.5, 5.0>
  }
  cone { // BB_Spike9
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.4, 0.4, 1.2>
    rotate <0.0, -90.0, -83.0>
    translate  <37.400001, -7.2, 5.0>
  }
  cone { // BB_Spike10
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.4, 0.4, 1.2>
    rotate <0.0, -90.0, -277.0>
    translate  <37.400001, 7.2, 5.0>
  }
  texture {
    BB_Metal
  }
}
union { // BullBar
  object { BBLayer1 }
  object { BBLayer2 }
  object { BBLayer3 }
  object { BB_Rivets1 }
  object { BB_spikes }
}


#declare SW_Support1 = difference {
  box { // SW_Arm1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.25, 0.5>
    translate  <30.0, 0.0, 7.9>
  }
  cylinder { // SW_Cut1
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate -90.0*y
    translate  <30.06, 0.0, 8.0>
  }
  cylinder { // SW_Cut2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.2>
    rotate -90.0*y
    translate  <30.06, 0.0, 7.65>
  }
  texture {
    Dark_Steel
  }
  scale <0.5, 1.0, 1.0>
  rotate 10.0*y
  translate  <14.7, 0.0, 2.6>
}
#declare SW_Support2 = difference {
  box { // SW_Arm2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.25, 0.5>
    translate  <30.0, 0.0, 7.9>
  }
  cylinder { // SW_Cut3
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate -90.0*y
    translate  <30.06, 0.0, 8.0>
  }
  cylinder { // SW_Cut4
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.2>
    rotate -90.0*y
    translate  <30.06, 0.0, 7.65>
  }
  texture {
    Dark_Steel
  }
  scale <0.5, 1.0, 1.0>
  rotate <180.0, -10.0, 0.0>
  translate  <14.7, 0.0, 14.2>
}
union { // SWheel
  torus { // SteeringWHL1
    1.1, 0.1  rotate -x*90
    texture {
      Leather1
    }
    rotate -90.0*y
    translate  <30.7, 0.0, 8.4>
  }
  object { SW_Support1 }
  object { SW_Support2 }
  cylinder { // SW_Horn1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Dash_Plastic
    }
    scale 0.35
    rotate -90.0*y
    translate  <31.1, 0.0, 8.4>
  }
  sphere { // SW_Horn2
    <0,0,0>,1
    texture {
      Dash_Plastic
    }
    scale <0.1, 0.35, 0.35>
    translate  <30.75, 0.0, 8.4>
  }
  cylinder { // SW_Horn3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Dash_Plastic
    }
    scale <0.15, 0.15, 1.2>
    rotate -90.0*y
    translate  <32.2, 0.0, 8.3>
  }
  rotate <-85.0, 10.0, 0.0>
  translate  <2.0, -8.4, 12.8>
}


box { // WindShield
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WindSHG
  }
  scale <5.0, 2.8, 0.1>
  rotate 30.0*y
  translate  <31.4, 0.0, 11.0>
}


#declare SUnit = union {
  box { // U_Box1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
  }
  cylinder { // U_Cyl1
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <1.0, 1.0, 0.0>
  }
  cylinder { // U_Cyl2
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <1.0, -1.0, 0.0>
  }
  cylinder { // U_Cyl3
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <1.0, 1.0, 0.0>
  }
  cylinder { // U_Cyl4
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-1.0, 1.0, 0.0>
  }
  sphere { // U_sph1
    <0,0,0>,1
    scale 0.25
    translate  <1.0, 1.0, 0.0>
  }
  sphere { // U_sph2
    <0,0,0>,1
    scale 0.25
    translate  <-1.0, 1.0, 0.0>
  }
  sphere { // U_sph3
    <0,0,0>,1
    scale 0.25
    translate  <-1.0, -1.0, 0.0>
  }
  sphere { // U_sph4
    <0,0,0>,1
    scale 0.25
    translate  <1.0, -1.0, 0.0>
  }
  texture {
    Seat_material
  }
  scale <2.0, 1.8, 2.0>
  translate  <30.0, 0.0, 5.0>
}
#declare SUnit1 = union {
  box { // U_Box2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
  }
  cylinder { // U_Cyl5
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <1.0, 1.0, 0.0>
  }
  cylinder { // U_Cyl6
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <1.0, -1.0, 0.0>
  }
  cylinder { // U_Cyl7
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <1.0, 1.0, 0.0>
  }
  cylinder { // U_Cyl8
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-1.0, 1.0, 0.0>
  }
  sphere { // U_sph5
    <0,0,0>,1
    scale 0.25
    translate  <1.0, 1.0, 0.0>
  }
  sphere { // U_sph6
    <0,0,0>,1
    scale 0.25
    translate  <-1.0, 1.0, 0.0>
  }
  sphere { // U_sph7
    <0,0,0>,1
    scale 0.25
    translate  <-1.0, -1.0, 0.0>
  }
  sphere { // U_sph8
    <0,0,0>,1
    scale 0.25
    translate  <1.0, -1.0, 0.0>
  }
  texture {
    Seat_material
  }
  scale <1.8, 1.4, 2.0>
  rotate <180.0, -70.0, 180.0>
  translate  <26.8, 0.0, 7.2>
}
#declare SUnit2 = union {
  box { // U_Box3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
  }
  cylinder { // U_Cyl9
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <1.0, 1.0, 0.0>
  }
  cylinder { // U_Cyl10
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <1.0, -1.0, 0.0>
  }
  cylinder { // U_Cyl11
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <1.0, 1.0, 0.0>
  }
  cylinder { // U_Cyl12
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-1.0, 1.0, 0.0>
  }
  sphere { // U_sph9
    <0,0,0>,1
    scale 0.25
    translate  <1.0, 1.0, 0.0>
  }
  sphere { // U_sph10
    <0,0,0>,1
    scale 0.25
    translate  <-1.0, 1.0, 0.0>
  }
  sphere { // U_sph11
    <0,0,0>,1
    scale 0.25
    translate  <-1.0, -1.0, 0.0>
  }
  sphere { // U_sph12
    <0,0,0>,1
    scale 0.25
    translate  <1.0, -1.0, 0.0>
  }
  texture {
    Seat_material
  }
  scale <0.7, 0.8, 1.0>
  rotate <180.0, -75.0, 180.0>
  translate  <25.6, 0.0, 10.5>
}
#declare SUnit3 = union {
  box { // U_Box4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
  }
  cylinder { // U_Cyl13
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <1.0, 1.0, 0.0>
  }
  cylinder { // U_Cyl14
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <1.0, -1.0, 0.0>
  }
  cylinder { // U_Cyl15
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <1.0, 1.0, 0.0>
  }
  cylinder { // U_Cyl16
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-1.0, 1.0, 0.0>
  }
  sphere { // U_sph13
    <0,0,0>,1
    scale 0.25
    translate  <1.0, 1.0, 0.0>
  }
  sphere { // U_sph14
    <0,0,0>,1
    scale 0.25
    translate  <-1.0, 1.0, 0.0>
  }
  sphere { // U_sph15
    <0,0,0>,1
    scale 0.25
    translate  <-1.0, -1.0, 0.0>
  }
  sphere { // U_sph16
    <0,0,0>,1
    scale 0.25
    translate  <1.0, -1.0, 0.0>
  }
  texture {
    Seat_material
  }
  scale <0.75, 0.75, 1.0>
  rotate <150.0, -70.0, 180.0>
  translate  <27.1, 1.4, 6.7>
}
#declare SUnit4 = union {
  box { // U_Box5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
  }
  cylinder { // U_Cyl17
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <1.0, 1.0, 0.0>
  }
  cylinder { // U_Cyl18
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <1.0, -1.0, 0.0>
  }
  cylinder { // U_Cyl19
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <1.0, 1.0, 0.0>
  }
  cylinder { // U_Cyl20
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-1.0, 1.0, 0.0>
  }
  sphere { // U_sph17
    <0,0,0>,1
    scale 0.25
    translate  <1.0, 1.0, 0.0>
  }
  sphere { // U_sph18
    <0,0,0>,1
    scale 0.25
    translate  <-1.0, 1.0, 0.0>
  }
  sphere { // U_sph19
    <0,0,0>,1
    scale 0.25
    translate  <-1.0, -1.0, 0.0>
  }
  sphere { // U_sph20
    <0,0,0>,1
    scale 0.25
    translate  <1.0, -1.0, 0.0>
  }
  texture {
    Seat_material
  }
  scale <0.75, 0.75, 1.0>
  rotate <-150.0, -70.0, 180.0>
  translate  <27.1, -1.4, 6.7>
}
union { // Seat1
  object { SUnit }
  object { SUnit1 }
  object { SUnit2 }
  object { SUnit3 }
  object { SUnit4 }
  cylinder { // HR_Cyl1
    <0,0,1>, <0,0,0>, 1 
    texture {
      HR_Pipe
    }
    scale <0.1, 0.1, 1.0>
    rotate -20.0*y
    translate  <26.1, -0.5, 9.0>
  }
  cylinder { // HR_Cyl2
    <0,0,1>, <0,0,0>, 1 
    texture {
      HR_Pipe
    }
    scale <0.1, 0.1, 1.0>
    rotate -20.0*y
    translate  <26.1, 0.5, 9.0>
  }
}


union { // OldColumn
  cylinder { // SmoothColumn
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 30.0>
  }
  sphere { // ColumnAdd1
    <0,0,0>,1
    scale <1.0, 1.0, 12.0>
    translate  <3.0, 0.0, 15.0>
  }
  sphere { // ColumnAdd2
    <0,0,0>,1
    scale <1.0, 1.0, 12.0>
    rotate -45.0*z
    translate  <2.12132, -2.12132, 15.0>
  }
  sphere { // ColumnAdd3
    <0,0,0>,1
    scale <1.0, 1.0, 12.0>
    rotate -90.0*z
    translate  <0.0, -3.0, 15.0>
  }
  sphere { // ColumnAdd4
    <0,0,0>,1
    scale <1.0, 1.0, 12.0>
    rotate -135.0*z
    translate  <-2.12132, -2.12132, 15.0>
  }
  sphere { // ColumnAdd5
    <0,0,0>,1
    scale <1.0, 1.0, 12.0>
    rotate 180.0*z
    translate  <-3.0, 0.0, 15.0>
  }
  sphere { // ColumnAdd6
    <0,0,0>,1
    scale <1.0, 1.0, 12.0>
    rotate 135.0*z
    translate  <-2.12132, 2.12132, 15.0>
  }
  sphere { // ColumnAdd7
    <0,0,0>,1
    scale <1.0, 1.0, 12.0>
    rotate 90.0*z
    translate  <0.0, 3.0, 15.0>
  }
  sphere { // ColumnAdd8
    <0,0,0>,1
    scale <1.0, 1.0, 12.0>
    rotate 45.0*z
    translate  <2.12132, 2.12132, 15.0>
  }
  torus { // ColumnTorus1
    3.0, 1.0  rotate -x*90
    translate  1.0*z
  }
  torus { // ColumnTorus2
    3.0, 0.5  rotate -x*90
    translate  2.25*z
  }
  torus { // ColumnTorus3
    3.0, 1.0  rotate -x*90
    translate  28.5*z
  }
  torus { // ColumnTorus4
    3.0, 0.5  rotate -x*90
    translate  27.25*z
  }
  texture {
    Sapphire_Agat1
  }
  scale <0.9, 0.9, 1.0>
  translate  <9.1, 17.9, 0.0>
}


box { // Step1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Bitumen
  }
  scale <32.200001, 10.8, 1.0>
  translate  <13.7, -26.6, -0.5>
}


box { // LampCover4
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Total_White
  }
  no_shadow
  scale <6.8, 2.8, 1.0>
  translate  <6.3, -19.3, 27.1>
}


box { // LampCover3
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Total_White
  }
  no_shadow
  scale <6.8, 2.8, 1.0>
  translate  <35.900001, -19.0, 27.1>
}


box { // LampCover2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Total_White
  }
  no_shadow
  scale <6.8, 2.8, 1.0>
  translate  <36.000001, 29.9, 27.1>
}


box { // LampCover1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Total_White
  }
  no_shadow
  scale <6.8, 2.8, 1.0>
  translate  <6.0, 29.9, 27.1>
}










box { // Ceiling_edge1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Green_plastic
  }
  scale <1.0, 30.0, 1.0>
  rotate -90.0*z
  translate  <20.9, 42.600001, 28.9>
}


box { // Ceiling_edge
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Green_plastic
  }
  scale <1.0, 43.600002, 1.0>
  translate  <-8.2, 0.0, 28.9>
}


box { // Ceiling_Inside
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_plastic
  }
  scale <30.0, 42.0, 1.0>
  translate  <22.2, 1.2, 30.0>
}


#declare Post = difference {
  cylinder { // Post1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Green_plastic
    }
    scale <1.0, 1.0, 25.0>
    translate  <33.5, 17.6, 0.0>
  }
  plane { // Post_cut1
    z,0
    rotate -90.0*y
    translate  <33.5, 17.6, 0.0>
  }
  texture {
    Green_plastic
  }
}
#declare Post3 = difference {
  cylinder { // Post2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Green_plastic
    }
    scale <1.0, 1.0, 25.0>
    translate  <33.5, 17.6, 0.0>
  }
  plane { // Post_cut2
    z,0
    rotate -90.0*y
    translate  <33.5, 17.6, 0.0>
  }
  texture {
    Green_plastic
  }
  rotate 180.0*z
  translate  <72.200001, 35.200001, 0.0>
}
union { // Vpost1
  object { Post }
  object { Post3 }
superellipsoid {
     <0.25,0.25>
    texture {
      Green_plastic
    }
    scale <2.5, 1.0, 13.0>
    translate  <36.100001, 17.6, 13.0>
  }
superellipsoid {
     <0.25,0.25>
    texture {
      Green_plastic
    }
    scale <2.75, 0.8, 13.0>
    translate  <36.100001, 17.6, 13.0>
  }
  scale <1.0, 1.0, 1.25>
}


union { // Platform1
  cylinder { // Cround1
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 2.0>
    translate  <9.0, 17.9, -1.0>
  }
  cylinder { // Cround2
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 2.0>
    translate  <41.0, 17.9, -1.0>
  }
superellipsoid {
     <0.25,0.25>
    scale <16.0, 4.0, 1.0>
    translate  <25.0, 17.9, 0.0>
  }
  texture {
    Concrete
  }
  translate  -0.5*z
}


superellipsoid {
     <0.25,0.25>
  texture {
    Concrete
  }
  scale <10.0, 1.25, 1.0>
  translate  <33.600001, -14.7, -0.5>
}


union { // Edg1
superellipsoid {
     <0.25,0.25>
    scale <2.5, 1.25, 1.0>
    rotate -3.0*z
    translate  <-12.5, -12.9, -0.5>
  }
superellipsoid {
     <0.25,0.25>
    scale <2.5, 1.25, 1.0>
    rotate 1.0*z
    translate  <-7.5, -12.9, -0.5>
  }
superellipsoid {
     <0.25,0.25>
    scale <2.5, 1.25, 1.0>
    rotate 1.5*z
    translate  <-2.5, -12.9, -0.5>
  }
superellipsoid {
     <0.25,0.25>
    scale <2.5, 1.25, 1.0>
    rotate -0.5*z
    translate  <2.5, -12.9, -0.5>
  }
superellipsoid {
     <0.25,0.25>
    scale <2.5, 1.25, 1.0>
    rotate -0.5*z
    translate  <7.5, -12.9, -0.5>
  }
superellipsoid {
     <0.25,0.25>
    scale <2.5, 1.25, 1.0>
    rotate -2.0*z
    translate  <12.5, -12.9, -0.5>
  }
superellipsoid {
     <0.25,0.25>
    scale <2.5, 1.25, 1.0>
    rotate 0.5*z
    translate  <17.5, -12.9, -0.5>
  }
superellipsoid {
     <0.25,0.25>
    scale <2.5, 1.25, 1.0>
    rotate -2.0*z
    translate  <22.5, -12.9, -0.5>
  }
  texture {
    PStone1
  }
  translate  <-1.4, -1.7, 0.0>
}


plane { // Floor
  z,0
  texture {
    Bitumen
  }
  scale <25.0, 25.0, 1.0>
  translate  -1.5*z
}




