/* File     : Analogue.inc
 *
 * Purpose  : Take internal_clock and produce an analogue clock face
 *            Displaying the correct time.
 * Author   : (C)1996 Matthew Hunter
 * Version  : 0.01 (25 June 1996)
 *            0.02 (27 June 1996)
 *              Release version.
 */


/* Input state
 *
 * internal_clock must have been set up by clock.inc.
 *
 * Analogue_TFace must be set and is the texture of the hour
 * markers (Analogue will not produce the face back)
 *
 * Analogue_THands must be set and is the texture of the clock
 * hands.
 *
 */

/* Output state
 *
 * Analogue_Time will contain the object definition for the clock
 */

// Check that all the needed input values are available, scream if not
#ifndef (internal_clock)
  #error "internal_clock must be defined before analogue.inc can be used\n"
#end

#ifndef (Analogue_TFace)
  #error "Analogue_TFace must be defined before analogue.inc can be used\n"
#end

#ifndef (Analogue_THands)
  #error "Analogue_THands must be defined before analogue.inc can be used\n"
#end

// Calculate the rotation for the hour hand
#declare Analogue_Hours = mod(div(internal_clock,100),12)
#declare Analogue_Hours_Angle = ((Analogue_Hours*360)/12)

// Calculate the rotation for the minute hand
#declare Analogue_Minutes = mod(internal_clock,100)
#declare Analogue_Minutes_Angle = (Analogue_Minutes*6)

#declare Analogue_Time = union {

  // the clock face ********************************************************
  union {

    // the "12 o'clock" sphere, slightly larger than the other hour
    // markers to make it obvious which way up the clock is.
    sphere {
      <0,0,0>,1
      hollow
      texture { Analogue_TFace }
      scale <3,3,3>      // scale and translate last so that the texture is
      translate <0,20,0> // transformed as well.
    }

    // the hour spheres, rotated around the origin to build the clock face
    #declare AHour = 1
    #while (AHour<12)
      sphere {
        <0,0,0> 1
        hollow
        texture { Analogue_TFace }
        scale <2,2,2>
        translate <0,20,0>
        rotate <0,0,AHour*30>
      }
      #declare AHour=AHour+1
    #end
  }

  // the clock hands *******************************************************
  union {

    // The minute hand
    cylinder {
      <0,0,0>
      <0,1,0>
      1
      hollow
      texture { Analogue_THands }
      scale <1,18,1>
      translate <0,0,-3>
      rotate <0,0,-Analogue_Minutes_Angle>
    }

    // The hour hand
    cylinder {
      <0,0,0>
      <0,1,0>
      1
      hollow
      texture { Analogue_THands }
      scale <1,12,1>
      translate <0,0,-3>
      rotate <0,0,-Analogue_Hours_Angle>
    }
  }
}


