/* File     : Clock.pov
 *
 * Purpose  : Cosmic clocks for irtc #1
 * Author   : (C) 1996 Matthew Hunter
 * Version  : 0.02 (25 June 1996)
 *            0.03 (27 June 1996)
 *              Release version.
 */

/* Input state
 *
 * clock value can be set by the command line or ini file to set the time
 * displayed on the clocks.
 *
 * for values of clock between 0 and 1 then the time will be clock% of the
 * way through the day.
 *
 * alternatively the clock can be set manually using clock = -time where
 * time is the time to display, eg 1234
 *
 * Camera aspect ratio is 4:3
 */

/* Output state
 *
 * If all goes well you should now have a pretty picture...
 */

// camera location, looking towards the sun, so everything is back lit
camera {
  location <0,10,-80>
  sky <0,1,0>
  up <0,1,0>
  right <1.33,0,0>
  look_at <0,10,0>
}


#declare internal_clock = clock

// break the clock value into it's constituent parts
#include "clock.inc"

// load the definitions for the LCD display
#declare LCD_Thickness = 2
#include "LCD.INC"

// define the texture for the lit LCD display
#declare Maketime_TOn = texture {
  pigment {
    colour rgb <0.2,0.3,1>
  }
  finish {
    ambient 0.3 // give it bit more of a glow
    diffuse 0.4
    metallic
    phong 1
    phong_size 60
    reflection 0.5
  }
}

// define the texture for the unlit segments
#declare Maketime_TOff = texture {
  pigment {
    colour rgb <0.1,0.15,0.5> // just a darker version of the lit segments
  }
}

#declare Maketime_Off = 1    // we want to show the unlit segments too
#declare Maketime_Pad = 0    // don't put a leading 0 on times before 10am
#declare Maketime_Space = 24 // space out the numbers a little more

// build the time from internal_clock
#include "Maketime.inc"

union {
  object {
    Maketime_Time
  }
  object { // add a glass box to contain the display.
    box {
      <-55,-25,-8>
      < 55, 25, 8>
    }
    texture {
      pigment {
        colour rgbf <0.8,0.8,1,0.8>
      }
      finish {
        reflection 0.2
        ior 1.52
      }
    }
  }
  scale <0.5,0.5,0.5>
  rotate <20,40,0>
  translate <20,15,10> // move the display into place
}

object { // spotlight aimed at the digital display
  light_source {
    <-10,50,-60>
    colour rgb <1,1,1>
    spotlight
    point_at <20,15,10>
    radius 10
    falloff 20
  }
}


// texture for the face of the analogue clock
#declare Analogue_TFace = texture {
  pigment {
    colour rgbf <1,0,0,0.8> // red glass
  }
  finish {
    ambient 0.3
    diffuse 0.4
    metallic
    phong 1
    phong_size 60
    reflection 0.5
    ior 1.7
  }
}

// texture for the hands of the analogue clock
#declare Analogue_THands = texture {
  pigment {
    colour rgbf <0,1,0,0.8> // green glass
  }
  finish {
    ambient 0.3
    diffuse 0.4
    metallic
    phong 1
    phong_size 60
    reflection 0.5
    ior 1.7
  }
}

// build the clock face
#include "Analogue.inc"

object {
  Analogue_Time
  rotate <20,-40,0>
  translate <-40,25,30> // move the analogue clock into position
}

// star sphere
object {
  sphere {
    <0,0,0>
    10000
  }
  hollow // must be hollow otherwise the halo's disappear
  texture {
    pigment {
      bozo
      colour_map {
        [0 colour rgb <0,0,0>]
        [0.99 colour rgb <0,0,0>]
        [1 colour rgb <1,1,1>]
      }
    }
    finish {
      ambient 1
      diffuse 0 // don't let shadows or anything fall on the stars
    }
  }
}

// declarations for the sun
#declare sun_colour = <1,1,0.7>
#declare sun_location = <0,180,1000>
#declare sun_size = 160

// include the sun object
#include "Sun.inc"

// add a lightsource to represent the sun
object {
  light_source {
    sun_location
    colour rgb sun_colour
  }
}

// work out the time on the planets surface so we can rotate the planet
// as time passes
#declare planet_time = (((hour_1*10)+hour_2)*60)+((minute_1*10)+minute_2)

#declare planet_size = 60
#declare planet_position = <-60,-20,140>
#declare planet_rotation = <0,(planet_time*360)/(24*60),0>

#include "Planet.inc"

object { Planet }

