/* File     : Clock.pov
 *
 * Purpose  : Simple table clock
 * Author   : (C) 1996 Matthew Hunter
 * Version  : 0.01 (25 June 1996)
 *            0.01a(25 June 1996)
 *            Early version, before going down the space route
 *            Floor looks quite good though.
 */


#declare internal_clock = clock

#include "clock.inc"

#declare LCD_Thickness = 2

#include "LCD.INC"

#declare LCD_Ext_Number = minute_2
#include "LCD_Ext.inc"

#declare Maketime_TOn = texture {
  pigment {
    colour rgb <0.2,0.3,1>
  }
  finish {
    metallic
    phong 1
    phong_size 60
    reflection 0.5
  }
}

#declare Maketime_TOff = texture {
  pigment {
    colour rgb <0.1,0.15,0.5>
  }
}

#declare Maketime_Off = 1
#declare Maketime_Pad = 0
#declare Maketime_Space = 24

#include "Maketime.inc"

union {
  object {
    Maketime_Time
  }
  object {
    box {
      <-55,-25,-8>
      < 55, 25, 8>
    }
    texture {
      pigment {
        colour rgbf <0.8,0.8,1,0.8>
      }
      finish {
        reflection 0.2
        ior 1.52
      }
    }
  }
  scale <0.5,0.5,0.5>
  rotate <20,40,0>
  translate <20,15,10>
}


#declare Analogue_TFace = texture {
  pigment {
    colour rgb <1,0,0>
  }
  finish {
    metallic
    phong 1
    phong_size 60
    reflection 0.5
  }
}

#declare Analogue_THands = texture {
  pigment {
    colour rgb <0,1,0>
  }
  finish {
    metallic
    phong 1
    phong_size 60
    reflection 0.5
  }
}

#include "Analogue.inc"

union {
  object {
    Analogue_Time
  }
  object {
    cylinder {
      <0,0,0>
      <0,0,2>, 24
      texture {
        pigment {
          colour rgb <0,0.5,0>
        }
      }
    }
  }
  rotate <20,-40,0>
  translate <-40,25,30>
}

object {
  plane {
   <0,1,0>,-2
  }
  texture {
    pigment {  // obligatory checked floor
      checker
      colour rgb <1,1,1>
      colour rgb <0,0,0>
    }
    finish {
      reflection 0.4
    }
  }
  scale <4,4,4>
}

/*
object {
  sphere {
    <0,0,0>
    81
  }
  texture {
    pigment {
      colour rgb <1,1,1>
    }
  }
}
*/

camera {
  location <0,0,-80>
  sky <0,1,0>
  up <0,1,0>
  right <1.33,0,0>
  look_at <0,0,0>
}

object {
  light_source {
    <0,15,0>
    colour rgb <1,1,1>
  }
}

