/* File     : LCD.INC
 *
 * Purpose  : Definitions for an LCD-7 numeric display
 * Author   : (C)1996 Matthew Hunter
 * Version  : 0.01 (25 June 1996)
 *            0.02 (27 June 1996)
 *              Release version.
 */

/* Input state
 *
 * LCD_Thickness gives half the width of the segments. Defaults
 * to 2.
 */

/* Output state
 *
 * LCD_Segment contains a generic horizontal segment
 * LCD_SegmentV contains a generic vertical segment
 *
 * LCD_Segment0...LCD_Segment6 contain the individual segments
 * to make up a digit, layed out as follows:
 *
 *     2
 *   5   6
 *     1
 *   3   4
 *     0
 *
 * LCD_Segment1 is centred at <0,0,0>. Horizontally the character will
 * go from -(9+LCD_Thickness) to (9+LCD_Thickness) and vertically it will
 * range from (-18+LCD_Thickness) to (18+LCD_Thickness). The best option
 * if you wish to use the segments directly is to build the character in
 * place, then scale/rotate/translate it into place.
 *
 * LCD_Digit0...LCD_Digit9 contain prebuilt characters for the digits.
 * LCD_Digit0_off...LCD_Digit9_off contain the segments that are not used
 * for each digit, the union of LCD_DigitX and LCD_DigitX_off will always
 * be all seven segments. This is useful if you still want to see the
 * unlit segments, just use a different texture.
 *
 * NOTE: Some of the LCD_DigitX_off objects will raise warnings because
 *       there are less than two objects in CSG (LCD_Digit8_off will
 *       also raise a degenerate bounding box warning). These warnings
 *       will not cause any problems however and I thought it was better
 *       to declare them all consistantly.
 *
 * LCD_Colon contains the two dots used to seperate hours from minutes
 * in a time.
 */

#ifndef (LCD_Thickness)
  #declare LCD_Thickness = 2
#end

#declare LCDt = LCD_Thickness
#declare LCDtw = LCD_Thickness*2

#declare LCD_Segment = difference {
  box {
    <-8,-LCDt,-1>
    < 8, LCDt, 1>
  }
  box {
    <-LCDtw,0,-2>
    < 0,LCDtw, 2>
    rotate <0,0,-45>
    translate <-8,0,0>
  }
  box {
    <-LCDtw,0,-2>
    < 0,LCDtw, 2>
    rotate <0,0,-45>
    translate <-8,0,0>
    scale <-1,1,1>
  }
  box {
    <-LCDtw,0,-2>
    < 0,LCDtw, 2>
    rotate <0,0,-45>
    translate <-8,0,0>
    scale <-1,-1,1>
  }
  box {
    <-LCDtw,0,-2>
    < 0,LCDtw, 2>
    rotate <0,0,-45>
    translate <-8,0,0>
    scale <1,-1,1>
  }
}

#declare LCD_SegmentV = object {
  LCD_Segment
  rotate <0,0,90>
}

#declare LCD_Segment0 = object { /* bottom, horizontal */
  LCD_Segment
  translate <0,-18,0>
}

#declare LCD_Segment1 = object { /* middle, horizontal */
  LCD_Segment
  translate <0,0,0>
}

#declare LCD_Segment2 = object { /* top, horizontal */
  LCD_Segment
  translate <0,18,0>
}

#declare LCD_Segment3 = object { /* bottom-left, vertical */
  LCD_SegmentV
  translate <-9,-9,0>
}

#declare LCD_Segment4 = object { /* bottom-right, vertical */
  LCD_SegmentV
  translate <9,-9,0>
}

#declare LCD_Segment5 = object { /* top-left, vertical */
  LCD_SegmentV
  translate <-9,9,0>
}

#declare LCD_Segment6 = object { /* top-right, vertical */
  LCD_SegmentV
  translate <9,9,0>
}

#declare LCD_Digit0 = union {
  object { LCD_Segment0 }
  object { LCD_Segment2 }
  object { LCD_Segment3 }
  object { LCD_Segment4 }
  object { LCD_Segment5 }
  object { LCD_Segment6 }
}

#declare LCD_Digit0_off = union {
  object { LCD_Segment1 }
}

#declare LCD_Digit1 = union {
  object { LCD_Segment4 }
  object { LCD_Segment6 }
}

#declare LCD_Digit1_off = union {
  object { LCD_Segment0 }
  object { LCD_Segment1 }
  object { LCD_Segment2 }
  object { LCD_Segment3 }
  object { LCD_Segment5 }
}

#declare LCD_Digit2 = union {
  object { LCD_Segment0 }
  object { LCD_Segment1 }
  object { LCD_Segment2 }
  object { LCD_Segment3 }
  object { LCD_Segment6 }
}

#declare LCD_Digit2_off = union {
  object { LCD_Segment4 }
  object { LCD_Segment5 }
}

#declare LCD_Digit3 = union {
  object { LCD_Segment0 }
  object { LCD_Segment1 }
  object { LCD_Segment2 }
  object { LCD_Segment4 }
  object { LCD_Segment6 }
}

#declare LCD_Digit3_off = union {
  object { LCD_Segment3 }
  object { LCD_Segment5 }
}

#declare LCD_Digit4 = union {
  object { LCD_Segment1 }
  object { LCD_Segment4 }
  object { LCD_Segment5 }
  object { LCD_Segment6 }
}

#declare LCD_Digit4_off = union {
  object { LCD_Segment0 }
  object { LCD_Segment2 }
  object { LCD_Segment3 }
}

#declare LCD_Digit5 = union {
  object { LCD_Segment0 }
  object { LCD_Segment1 }
  object { LCD_Segment2 }
  object { LCD_Segment4 }
  object { LCD_Segment5 }
}

#declare LCD_Digit5_off = union {
  object { LCD_Segment3 }
  object { LCD_Segment6 }
}

#declare LCD_Digit6 = union {
  object { LCD_Segment0 }
  object { LCD_Segment1 }
  object { LCD_Segment2 }
  object { LCD_Segment3 }
  object { LCD_Segment4 }
  object { LCD_Segment5 }
}

#declare LCD_Digit6_off = union {
  object { LCD_Segment6 }
}

#declare LCD_Digit7 = union {
  object { LCD_Segment2 }
  object { LCD_Segment4 }
  object { LCD_Segment6 }
}

#declare LCD_Digit7_off = union {
  object { LCD_Segment0 }
  object { LCD_Segment1 }
  object { LCD_Segment3 }
  object { LCD_Segment5 }
}

#declare LCD_Digit8 = union {
  object { LCD_Segment0 }
  object { LCD_Segment1 }
  object { LCD_Segment2 }
  object { LCD_Segment3 }
  object { LCD_Segment4 }
  object { LCD_Segment5 }
  object { LCD_Segment6 }
}

#declare LCD_Digit8_off = union {
}

#declare LCD_Digit9 = union {
  object { LCD_Segment0 }
  object { LCD_Segment1 }
  object { LCD_Segment2 }
  object { LCD_Segment4 }
  object { LCD_Segment5 }
  object { LCD_Segment6 }
}

#declare LCD_Digit9_off = union {
  object { LCD_Segment3 }
}

#declare LCD_Colon = union {
  box {
    <-LCDt,-LCDt,-1>
    < LCDt, LCDt, 1>
    rotate <0,0,45>
    translate <0,9,0>
  }
  box {
    <-LCDt,-LCDt,-1>
    < LCDt, LCDt, 1>
    rotate <0,0,45>
    translate <0,-9,0>
  }
}

