/* File     : LCD_Ext.inc
 *
 * Purpose  : Extension to LCD.inc to allow mapping of numbers to the
 *            Appropriate LCD digit.
 * Author   : (C)1996 Matthew Hunter
 * Version  : 0.01 (25 June 1996)
 *            0.02 (27 June 1996)
 *              Release version.
 */

/* Input State
 *
 * Integer value LCD_Ext_Number, in the range 0-9
 */

/* Ouput State
 *
 * #declares two objects
 *
 * LCD_Ext_Digit contains the 'lit' segments for the specified value.
 *
 * LCD_Ext_Digit_off contains the 'unlit' segments for the specified
 * value.
 */

#ifndef (LCD_Segment)
  #error "You must #include "LCD.inc" before using LCD_Ext.inc\n"
#end

#ifndef (LCD_Ext_Number)
  #error "You must #declare LCD_Ext_Number = <value>\n"
#end

#declare LCD_Ext_Number = int(LCD_Ext_Number)

#switch (LCD_Ext_Number)
  #case (1)
    #declare LCD_Ext_Digit = object { LCD_Digit1 }
    #declare LCD_Ext_Digit_off = object { LCD_Digit1_off }
  #break
  #case (2)
    #declare LCD_Ext_Digit = object { LCD_Digit2 }
    #declare LCD_Ext_Digit_off = object { LCD_Digit2_off }
  #break
  #case (3)
    #declare LCD_Ext_Digit = object { LCD_Digit3 }
    #declare LCD_Ext_Digit_off = object { LCD_Digit3_off }
  #break
  #case (4)
    #declare LCD_Ext_Digit = object { LCD_Digit4 }
    #declare LCD_Ext_Digit_off = object { LCD_Digit4_off }
  #break
  #case (5)
    #declare LCD_Ext_Digit = object { LCD_Digit5 }
    #declare LCD_Ext_Digit_off = object { LCD_Digit5_off }
  #break
  #case (6)
    #declare LCD_Ext_Digit = object { LCD_Digit6 }
    #declare LCD_Ext_Digit_off = object { LCD_Digit6_off }
  #break
  #case (7)
    #declare LCD_Ext_Digit = object { LCD_Digit7 }
    #declare LCD_Ext_Digit_off = object { LCD_Digit7_off }
  #break
  #case (8)
    #declare LCD_Ext_Digit = object { LCD_Digit8 }
    #declare LCD_Ext_Digit_off = object { LCD_Digit8_off }
  #break
  #case (9)
    #declare LCD_Ext_Digit = object { LCD_Digit9 }
    #declare LCD_Ext_Digit_off = object { LCD_Digit9_off }
  #break
  #else
    #declare LCD_Ext_Digit = object { LCD_Digit0 }
    #declare LCD_Ext_Digit_off = object { LCD_Digit0_off }
#end
