/*****************
Frozen Time
by Ulrich Goeltner and Patrick Baur
Santiago de Chile
June 1996
*/

#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "textures.inc"
#declare Datei="copy.gif"
#include "frozen.inc"

#default {texture {pigment {rgb <1,0.2,0.3>}
finish {ambient 0}}}

#declare C1=camera
{location <0,0,-20> look_at <0,0,0>}//vorne
        
camera {C1}
        
light_source {<10,-5,-5> color White}
light_source {<0,-2,-8> color White}

//Watch in ice-cube
union {object {Watch
scale 0.4
finish {ambient 1}}
superellipsoid {<0.3,0.3>
pigment {rgbt<0.5,0.5,0.5,0.7>}
finish{reflection 0.2 refraction 1 ior 2.4 phong 1}
scale 4}
no_shadow 
scale 0.9
rotate <10,-30,10>
translate <5,0,0>
}

//landscape
#declare A=6.8
#declare X1=7.29
#declare Y1=4.86
#declare Schnee=box {<0,0,0>,<X1,Y1,0>
pigment{image_map {gif "frozen.gif"}scale <X1,Y1,1>}
finish {ambient 0}
scale <A,A,1>
translate <-2.8*X1,-3.2*Y1,10>}

object {Schnee}
object {Schnee
rotate <0,-90,0>
translate <-13,0,-10>}
object {Schnee
rotate <0,90,0>
translate <13,0,10>}
object {Schnee
translate <0,0,-31>}

//Signature
object{Feld
texture {pigment {P_Brass4}
finish {F_MetalD ambient 0.8}}
scale <2,2,4>
rotate y*-30
translate <-10.3,-7.5,0>
}

plane {y,18
pigment {rgb<32/255,152/255,223/255>}
}
plane {y,-18
pigment {rgb<216/255,218/255,220/255>}
}
