/* Gregory Drake Wilson's Sundial       */
/* 5/21/96  created on a Zeos 486DX266  */

#version 3.0
#include "colors.inc"
#include "skies.inc"
#include "stones1.inc"

global_settings { assumed_gamma 1.2}

camera {
      location <-37.0, 26.0, -70>
      direction z*1.3
      look_at <0.0, 15.00, -2>}

light_source { <-119.00, 81.00, -100.00> color rgb<.2,.2,.2> }   light_source { <-120.00, 80.00, -100.00> color rgb<.7,.7,.5> }
light_source { <-121.00, 80.00, -100.00> color rgb<.7,.6,.6> }   light_source { <-120.00, 79.00, -100.00> color rgb<.6,.7,.6> }

#declare SteelTex1= texture{    pigment{ color rgb < 0.75, 0.75, 0.75      >}    normal{ wrinkles 0.60 scale<.051,30,.051> rotate z*45}   finish{ specular .7 diffuse .4 brilliance 6 roughness .0082 reflection .32}  }
#declare SteelTex2= texture{    pigment{ color rgb < 0.80, 0.80, 0.80      >}    normal{ wrinkles 0.60 scale<.051,30,.051> rotate z*45}   finish{ specular .7 diffuse .4 brilliance 7 roughness .0052 reflection .32}  }
#declare Water1 =       texture{    pigment{ color rgbf< 0.40, 0.50, 1.00, 0.95>}    normal{ ripples  0.55        frequency 5             }   finish{ reflection 0.5  refraction 1  ior 1.33    }}
#declare Water2 =       texture{    pigment{ color rgbf< 0.60, 0.60, 1.00, 0.90>}    normal{ ripples  0.10        frequency 5             }   finish{ reflection 0.5  refraction 1  ior 1.33    }}

//debugging textures
/*
#declare FRAMETEX = texture{pigment{Blue}}
#declare DETAILS  = texture{pigment{White}}
#declare BASETEX  = texture{pigment{Red}}
#declare MAPTEX   = texture{pigment{Brown}}
#declare GROUNDTEX= texture{pigment{Green}}
*/

#declare FRAMETEX = texture{SteelTex1 scale 1.25}
#declare DETAILS  = texture{SteelTex2}
#declare BASETEX  = texture{T_Grnt19   normal {  quilted 5    control0 .5   control1 1  }}
#declare MAPTEX   = texture{T_Stone4}
#declare GROUNDTEX= texture{T_Stone7}

#declare dial=union{
//mainframe
 union{ difference{   sphere{<0,0,0>1 scale 10.25}      sphere{<0,0,0>1 scale 10}         box{<-10.3,-10.3, -1.2><10.3,2,1.2>inverse}}
        difference{   sphere{<0,0,0>1 scale 10.5}       sphere{<0,0,0>1 scale 10.25}      box{<-.75,-11, -10.6><.75,2,10.6>inverse}}
//arrow
    cylinder{<0,1,-12.5><0,1,12.25>.125}
    cone{<0,1,12.25>,.125<0,1,13.25>.75 scale<.25,1,1>}    cone{<0,1,12.25>,.125<0,1,13.25>.25 scale<1,1,1>}
    cone{<0,1,13.25>,.75 <0,1,15.50> 0  scale<.25,1,1>}    cone{<0,1,13.25>,.25 <0,1,15.50> 0  scale<1,1,1>}
//fins
    sphere{<0,1,-13.02>.125}
    cylinder{<0,1,-11.5><0,1.95,-12.0>.11 scale<.25,1,1>}    cylinder{<0,1,-11.7><0,1.95,-12.2>.11 scale<.25,1,1>}    cylinder{<0,1,-11.9><0,1.95,-12.4>.11 scale<.25,1,1>}    cylinder{<0,1,-12.1><0,1.95,-12.6>.11 scale<.25,1,1>}
    cylinder{<0,1,-12.3><0,1.95,-12.8>.11 scale<.25,1,1>}    cylinder{<0,1,-12.5><0,1.95,-13.0>.11 scale<.25,1,1>}    cylinder{<0,1,-12.7><0,1.95,-13.2>.11 scale<.25,1,1>}    cylinder{<0,1,-12.9><0,1.95,-13.4>.11 scale<.25,1,1>}
    cylinder{<0,1,-11.5><0,0.15,-12.0>.11 scale<.25,1,1>}    cylinder{<0,1,-11.7><0,0.15,-12.2>.11 scale<.25,1,1>}    cylinder{<0,1,-11.9><0,0.15,-12.4>.11 scale<.25,1,1>}    cylinder{<0,1,-12.1><0,0.15,-12.6>.11 scale<.25,1,1>}
    cylinder{<0,1,-12.3><0,0.15,-12.8>.11 scale<.25,1,1>}    cylinder{<0,1,-12.5><0,0.15,-13.0>.11 scale<.25,1,1>}    cylinder{<0,1,-12.7><0,0.15,-13.2>.11 scale<.25,1,1>}    cylinder{<0,1,-12.9><0,0.15,-13.4>.11 scale<.25,1,1>}
//stuff
    union{
        difference{  torus{10.00, .1 rotate 90*x}    box{<-10.2,2, -.2><10.2,10.2,.2>}    translate .875*z      }
        difference{  torus{10.00, .1 rotate 90*x}    box{<-10.2,2, -.2><10.2,10.2,.2>}    translate -.875*z      }
        difference{  torus{10.25, .1 rotate 90*z}    box{<-.11,-10.4, -10.6><.11,2,10.6>inverse}}
     texture{DETAILS}}
 }
//Roman numerals on dial -- Bernhard Modern Bold  -- may need to change
 union{
    text{ttf "Tt0838m_.ttf","VII",.5,0  translate -.50*x scale <1.4,1.4,.7> rotate 90*x translate <0,-9.75,-.5> rotate -82.5*z}    text{ttf "Tt0838m_.ttf","VIII",.5,0 translate -.85*x scale <1.4,1.4,.7> rotate 90*x translate <0,-9.75,-.5> rotate -67.5*z}    text{ttf "Tt0838m_.ttf","IX",.5,0   translate -.50*x scale <1.4,1.4,.7> rotate 90*x translate <0,-9.75,-.5> rotate -52.5*z}    text{ttf "Tt0838m_.ttf","X",.5,0    translate -.40*x scale <1.4,1.4,.7> rotate 90*x translate <0,-9.75,-.5> rotate -37.5*z}   //BernhardMod BT
    text{ttf "Tt0838m_.ttf","XI",.5,0   translate -.50*x scale <1.4,1.4,.7> rotate 90*x translate <0,-9.75,-.5> rotate -22.5*z}    text{ttf "Tt0838m_.ttf","XII",.5,0  translate -.7*x  scale <1.4,1.4,.7> rotate 90*x translate <0,-9.75,-.5> rotate  -7.5*z}    text{ttf "Tt0838m_.ttf","I",.5,0    translate -.16*x scale <1.4,1.4,.7> rotate 90*x translate <0,-9.75,-.5> rotate   7.5*z}    text{ttf "Tt0838m_.ttf","II",.5,0   translate -.31*x scale <1.4,1.4,.7> rotate 90*x translate <0,-9.75,-.5> rotate  22.5*z}
    text{ttf "Tt0838m_.ttf","III",.5,0  translate -.58*x scale <1.4,1.4,.7> rotate 90*x translate <0,-9.75,-.5> rotate  37.5*z}    text{ttf "Tt0838m_.ttf","IV",.5,0   translate -.30*x scale <1.4,1.4,.7> rotate 90*x translate <0,-9.75,-.5> rotate  52.5*z}    text{ttf "Tt0838m_.ttf","V",.5,0    translate -.20*x scale <1.4,1.4,.7> rotate 90*x translate <0,-9.75,-.5> rotate  67.5*z}    text{ttf "Tt0838m_.ttf","VI",.5,0   translate -.45*x scale <1.4,1.4,.7> rotate 90*x translate <0,-9.75,-.5> rotate  82.5*z}
    sphere{<0,0,0>.05 translate <0,-10.01, .9125> rotate  75*y}    sphere{<0,0,0>.05 translate <0,-10.01, .9125> rotate  45*y}    sphere{<0,0,0>.05 translate <0,-10.01, .9125> rotate  15*y}    sphere{<0,0,0>.05 translate <0,-10.01, .9125> rotate -15*y}
    sphere{<0,0,0>.05 translate <0,-10.01, .9125> rotate -45*y}    sphere{<0,0,0>.05 translate <0,-10.01, .9125> rotate -75*y}    sphere{<0,0,0>.05 translate <0,-10.01,-.9125> rotate  75*y}    sphere{<0,0,0>.05 translate <0,-10.01,-.9125> rotate  45*y}
    sphere{<0,0,0>.05 translate <0,-10.01,-.9125> rotate  15*y}    sphere{<0,0,0>.05 translate <0,-10.01,-.9125> rotate -15*y}    sphere{<0,0,0>.05 translate <0,-10.01,-.9125> rotate -45*y}    sphere{<0,0,0>.05 translate <0,-10.01,-.9125> rotate -75*y}
    texture{DETAILS scale 5}
   }
   texture{FRAMETEX scale 5}
rotate -45*x  translate 10.35*y
}

//corinthian type column for a stand
#declare stand=  union{ difference{
           cylinder{<0,-49,0><0,-1.001,0>3}
           cylinder{<0,-49,0><0,-1,0>1 translate 2.5*z rotate   0*y}     cylinder{<0,-49,0><0,-1,0>1 translate 2.5*z rotate  30*y}           cylinder{<0,-49,0><0,-1,0>1 translate 2.5*z rotate  60*y}           cylinder{<0,-49,0><0,-1,0>1 translate 2.5*z rotate  90*y}     cylinder{<0,-49,0><0,-1,0>1 translate 2.5*z rotate 120*y}           cylinder{<0,-49,0><0,-1,0>1 translate 2.5*z rotate 150*y}
           cylinder{<0,-49,0><0,-1,0>1 translate 2.5*z rotate 180*y}     cylinder{<0,-49,0><0,-1,0>1 translate 2.5*z rotate 210*y}           cylinder{<0,-49,0><0,-1,0>1 translate 2.5*z rotate 240*y}           cylinder{<0,-49,0><0,-1,0>1 translate 2.5*z rotate 270*y}     cylinder{<0,-49,0><0,-1,0>1 translate 2.5*z rotate 300*y}           cylinder{<0,-49,0><0,-1,0>1 translate 2.5*z rotate 330*y}         }
         cone{<0,-44,0>,7<0,-41,0>,4}    cone{<0,-2,0>,2<0,-.5,0>4}
         cylinder{<0,-48,0><0,-44,0>7}   cylinder{<0,-.5,0><0,0,0>4}     torus{4,.25 translate -.25*y}
     texture{FRAMETEX scale 5} }

#declare WATER    = plane{<0,1,0>0 translate -50*y texture{Water1  translate <20,5,40> scale <28,3,28>}}
#declare ground   = plane{<0,1,0>0 translate -52*y texture{GROUNDTEX scale 50}}

//near hill
#declare hills    = height_field {    tga "bumpmap1.tga"    translate <-.5, -.5, -.5>    scale <1740, 230, 1740>    rotate -10*y    translate< 0,-31,1230>  texture{MAPTEX} smooth}
//far mountain
#declare mountain = height_field {    tga "bumpmap2.tga"    translate <-.5, -.5, -.5>    scale <1250, 600, 1250>    rotate   0*y    translate<50,  0,2200>  texture{MAPTEX} smooth}
//ground surface for the stand
#declare standbase= height_field {    tga "bumpmap3.tga"    translate <-.5, -.5, -.5>    scale < 300,   8,  300>    rotate   5*y    translate< 0,-50,   0>  texture{GROUNDTEX scale 25} smooth}

/*.............THE MAIN SCENE..............*/
object{dial}
object{stand}
object{standbase}
object{WATER}
object{ground}
object{hills}
object{mountain}
object{O_Cloud2 scale 24 hollow} // Darin Dugger's DD_Cloud_Sky texture mapped onto a pair of planes

background{color rgb<.2,.2,.8>}
fog { distance 1100    colour rgbt<0.8, 0.8, 0.8,.3>    fog_type 2    fog_offset -11    fog_alt 20    turbulence 0.1    turb_depth 0.2  }
fog { distance 600    colour rgbf<0.7, 0.7, 0.8,.1>    fog_type 2    fog_offset -24    fog_alt 14    turbulence 0.5    turb_depth 0.3  }
