#include "element.inc"
#include "chars.inc"
#include "colors.inc"
#include "textures.inc"
#include "stones1.inc"

#declare HandTex = texture { T_Stone15 scale<2,2,2> }

#declare NumberTex = texture {
   T_Stone21
   scale <3,3,3>
}

#declare Hour = 5
#declare Minute = 45

#declare Clock = union {
   torus {     //Border
      5, 1
      texture { T_Stone18 scale <5,5,5> }
      rotate <0,0,90>
   }
   sphere {    //Face
      <0,0,0> , 5
      scale <0.3,1,1>
      texture { Glass3 }
      finish { ior 1.333 refraction 1 }
      normal { ripples 0.8 }
   }
   union {     //Minute Hand
      cylinder { <0,0,0>, <0,3.5,0>, 0.2 }
      cone { <0,0.5,0>, 0.2, <0,-0.5,0>, 0.5 }
      cone { <0,3.5,0>, 0.2, <0,3.7,0>, 0 }
      texture { HandTex }
      rotate <Minute*6,0,0>
   }
   union {     //Hour Hand
      cylinder { <0,-1,0>, <0,2.5,0>, 0.2 }
      cone { <0,-0.5,0>, 0.2, <0,-1.5,0>, 0.5 }
      cone { <0,2.5,0>, 0.2, <0,2.7,0>, 0 }
      texture { HandTex }
      rotate <Hour*30+Minute/2,0,0>
   }
   union {        //12
      object {
         char_1
         scale <0.5,0.5,0.5>
         rotate <0,-90,0>
         translate <0,6.6,-0.75>
      }
      object {
         char_2
         scale <0.5,0.5,0.5>
         rotate <0,-90,0>
         translate <0,6.6,0.75>
      }
      texture { NumberTex }
   }
   object {       //6
      char_6
      scale <0.5,0.5,0.5>
      rotate <0,-90,0>
      translate <0,-8.8,0>
      texture { NumberTex }
   }
   object {       //3
      char_3
      scale <0.5,0.5,0.5>
      rotate <0,-90,0>
      translate <0,-1.5,7.2>
      texture { NumberTex }
   }
   object {       //9
      char_9
      scale <0.5,0.5,0.5>
      rotate <0,-90,0>
      translate <0,-1.5,-7.2>
      texture { NumberTex }
   }
}

object { Clock rotate<0,-10,0> }
object { Clock rotate<45,30,-30> translate<-20,6,-25> }
object { Clock rotate<60,-45,45> translate<-30,7,8> }
object { Clock rotate<-30,60,60> translate<9,9,-16> }

plane {
   <0,1,0>, -15
   texture { Earth_Tex scale<20,20,20> }
}   //Ground

plane {
   <10,0.01,0>, 700
   texture { Sky_Tex scale<175,175,175> }
   rotate <0,170,0>
   hollow
} //Sky

fog {
   fog_type 2
   fog_offset -14
   fog_alt 5
   colour rgbft<0.90,0.91,0.98,0,0.3>
   distance 60
   turbulence 0.8
}

light_source {
	<10,19,5>
	color rgb<1,1,1>
}

camera {
	location <27,2,9>
	look_at <0,0,0>
}
