#declare Bld1_wall = texture {
	pigment {
		brick
		pigment {color rgb <0.7, 0.7, 0.65>}, pigment {color rgb <0.7, 0.2, 0>}
		brick_size <0.025, 0.01, 0.015>
		mortar 0.004
	}
	normal {
		brick
		normal {bumps 0.1 scale 0.01}, normal {bumps 0.08 scale 0.01}
		brick_size <0.025, 0.01, 0.015>
		mortar 0.004
	}
	finish {ambient 0.12 diffuse 0.85 phong 0.1 phong_size 85}
}

#declare Bld1_gr = texture {
	pigment {color rgb <0.8, 0.8, 0.75>}
	normal {granite 0.06 scale 0.01}
	finish {ambient 0.12 diffuse 0.8 phong 0.01 phong_size 85}
}

#declare Window_light1 = texture {	// bright
	pigment {color rgb <1, 1, 0.8>}
	finish {ambient 0.9 diffuse 0.6}
}

#declare Window_light2 = texture {	// dark
	pigment {color rgb <0.7, 0.65, 0.6>}
	finish {ambient 0.9 diffuse 0.6}
}

#declare Frame_1 = texture {
	pigment {color rgb <0.3, 0, 0>}
	finish {ambient 0.12 diffuse 0.8 phong 0.2 phong_size 85}
}

#declare Strips = texture {
	pigment {
		gradient x
		color_map {
			[0 0.15 color rgb <0.6, 0, 0> color rgb <0.6, 0, 0>]
			[0.15 1 color rgb <0.8, 0, 0.1> color rgb <0.8, 0, 0.1>]
		}
		frequency 10
		scale 0.2
		translate x*0.015
	}
	finish {ambient 0.12 diffuse 0.8 phong 0.5}
}

#declare Face = union {
	#declare Cycle = 0
	#while (Cycle < 4)
		union {
			box { <-0.0018, 0.028, -0.001>, <0.0018, 0.046, 0>
				translate -z*0.05
			}
			box { <-0.0015, 0.032, -0.001>, <0.0015, 0.046, 0>
				translate -z*0.05
				rotate z*30
			}
			box { <-0.0015, 0.032, -0.001>, <0.0015, 0.046, 0>
				translate -z*0.05
				rotate z*60
			}
			rotate z*Cycle*90
		}
		#declare Cycle = Cycle + 1
	#end
	box {			// h.hand
		<-0.02, -0.0018, -0.001>, <0.004, 0.0018, 0>
		rotate -z*30
		translate -z*0.05
	}
	box {			// m.hand
		<-0.025, -0.0015, -0.001>, <0.004, 0.0015, 0>
		rotate -z*90
		translate -z*0.05
	}

	pigment {color rgb <0, 0.24, 0>}
	finish {ambient 0.9 phong 0}
}

#declare Clock = union {
	box{-0.05, 0.05}
	cylinder {<-0.1, 0, 0>, <-0.05, 0, 0>, 0.003
		pigment {color rgb 0.6}
		finish {ambient 0.12 diffuse 0.8 phong 0.8}
	}
	object {Face}
	object {Face rotate -y*90}

	pigment {color rgb <0.6, 0.9, 0.7>}
	finish {ambient 1 diffuse 0.7 phong 0.2}
	translate x*0.1
	scale 1.2
}

#declare My_box = union {
	box{0, <0.1, 0.1, 0.02>}
	cylinder {<-0.05, 0.05, 0.01>, <0, 0.05, 0.01>, 0.003
		pigment {color rgb 0.6}
		finish {ambient 0.12 diffuse 0.8 phong 0.8}
	}
	pigment {color rgb <1, 1, 0.4>}
	finish {ambient 1 diffuse 0.7 phong 0.2}
}

#declare E = text {
	ttf "timrom.ttf",
	"E", 0.2, 0
	scale 0.1
}

#declare F = text {
	ttf "timrom.ttf",
	"F", 0.2, 0
	scale 0.1
}

#declare A = text {
	ttf "timrom.ttf",
	"A", 0.2, 0
	scale 0.1
}

#declare C = text {
	ttf "timrom.ttf",
	"C", 0.2, 0
	scale 0.1
}

#declare Neon = union {
	object {My_box}
	object {E translate <0.017, 0.017, -0.005>}
	object {My_box translate y*0.12*1}
	object {F translate <0.017, 0.017+0.12*1, -0.005>}
	object {My_box translate y*0.12*2}
	object {A translate <0.017, 0.017+0.12*2, -0.005>}
	object {My_box translate y*0.12*3}
	object {C translate <0.017, 0.017+0.12*3, -0.005>}

	pigment {color rgb <0.9, 0, 0.1>}
	finish {ambient 1 diffuse 0.6 phong 0.1}
}

#declare Cafe = text {
	ttf "timrom.ttf",
	"CAFE", 0.2, 0

	pigment {color rgb <0.6, 0.8, 0.7>}
	finish {ambient 1 diffuse 0.6 phong 0.1}
	scale 0.07
}

#declare Restaurant = text {
	ttf "timrom.ttf",
	"RESTAURANT", 0.2, 0

	pigment {color rgb <0.9, 0.5, 0.7>}
	finish {ambient 1 diffuse 0.6 phong 0.1}
	scale <0.1, 0.07, 0.07>
}

#declare Small_window = union {
	// frame
	box {0, <-0.005, 0.15, -0.005>}
	box {<-0.05+0.002, 0, 0>, <-0.05-0.002, 0.15, -0.004>}
	box {<-0.1, 0, 0>, <-0.095, 0.15, -0.005>}

	box {0, <-0.1, 0.005, -0.005>}
	box {<0, 0.15, 0>, <-0.1, 0.145, -0.005>}
	box {<0, 0.05-0.002, 0>, <-0.1, 0.05+0.002, -0.004>}
	box {<0, 0.05-0.002, 0>, <-0.1, 0.05+0.002, -0.004> translate y*0.05}
	union {
		// bottom
		box {<0.01, 0, 0>, <-0.11, -0.01, -0.02>}
		box {<0, -0.01, 0>, <-0.1, -0.03, -0.01>}
		// top
		difference {
			box {<-0.11, 0.13, 0>, <0.01, 0.17, -0.01>}
			box {<-0.1, 0.1, 0.1>, <0, 0.15, -0.1>}
		}
		texture {Bld1_gr}
	}
	texture {Frame_1}
	translate z*0.01
}

#declare Large_window = union {
	// frame
	box {0, <-0.005, 0.15, -0.005>}
	box {<-0.05+0.002, 0, 0>, <-0.05-0.002, 0.15, -0.004>}
	box {<-0.1+0.002, 0, 0>, <-0.1-0.002, 0.15, -0.004>}
	box {<-0.15+0.002, 0, 0>, <-0.15-0.002, 0.15, -0.004>}
	box {<-0.2, 0, 0>, <-0.2+0.005, 0.15, -0.005>}

	box {0, <-0.2, 0.005, -0.005>}
	box {<0, 0.15, 0>, <-0.2, 0.145, -0.005>}
	box {<0, 0.05-0.002, 0>, <-0.2, 0.05+0.002, -0.004>}
	box {<0, 0.05-0.002, 0>, <-0.2, 0.05+0.002, -0.004> translate y*0.05}
	union {
		// bottom
		box {<0.01, 0, 0>, <-0.21, -0.01, -0.02>}
		box {<0, -0.01, 0>, <-0.2, -0.03, -0.01>}
		// top
		difference {
			box {<-0.21, 0.13, 0>, <0.01, 0.17, -0.01>}
			box {<-0.2, 0.1, 0.1>, <0, 0.15, -0.1>}
		}
		texture {Bld1_gr}
	}
	texture {Frame_1}
	translate z*0.01
}

#declare Large_window_1 = union {
	// frame
	box {0, <-0.005, 0.2, -0.005>}
	box {<-0.05+0.002, 0, 0>, <-0.05-0.002, 0.2, -0.004>}
	box {<-0.1+0.002, 0, 0>, <-0.1-0.002, 0.2, -0.004>}
	box {<-0.15, 0, 0>, <-0.15+0.005, 0.2, -0.005>}

	box {0, <-0.15, 0.005, -0.005>}
	box {<0, 0.2, 0>, <-0.15, 0.195, -0.005>}
	box {<0, 0.05-0.002, 0>, <-0.15, 0.05+0.002, -0.004>}

	cylinder {
		<0.01, 0.14, 0>, <-0.16, 0.14, 0>, 0.08
		clipped_by {plane {y, 0.14 inverse}}
		texture {Strips}
	}
	texture {Frame_1}
	translate z*0.01
}

#declare Small_w_dark = union {
	object {Small_window}
	// window light
	box {<-0.098, 0.002, 0>, <-0.002, 0.148, -0.001> texture {Window_light2}
		translate z*0.01
	}
}

#declare Small_w_bright = union {
	object {Small_window}
	// window light
	box {<-0.098, 0.002, 0>, <-0.002, 0.148, -0.001> texture {Window_light1}
		translate z*0.01
	}
}

#declare Large_w_bright = union {
	object {Large_window}
	// window light
	box {<-0.198, 0.002, 0>, <-0.002, 0.148, -0.001> texture {Window_light1}
		translate z*0.01
	}
}

#declare Large_w_1_bright = union {
	object {Large_window_1}
	// window light
	box {<-0.148, 0.002, 0>, <-0.002, 0.198, -0.001> texture {Window_light1}
		translate z*0.01
	}
}

#declare Door = union {
	difference {
		box {0, <-0.14, 0.25, -0.005>}
		box {<-0.01, 0.02, -0.1>, <-0.06, 0.24, 0.1>}
		box {<-0.01, 0.02, -0.1>, <-0.06, 0.24, 0.1> translate -x*0.07}
	}
	cylinder {<-0.07, 0, -0.005>, <-0.07, 0.25, -0.005>, 0.004}
	// handle
	box {<-0.065, 0.1, -0.01>, <-0.045, 0.13, -0.008>}
	box {<-0.065, 0.1, -0.01>, <-0.045, 0.13, -0.008> translate -x*0.03}
	// light
	box {<-0.13, 0.01, 0>, <-0.002, 0.245, -0.001> texture {Window_light1}}

	cylinder {
		<0.01, 0.2, 0>, <-0.15, 0.2, 0>, 0.08
		clipped_by {plane {y, 0.2 inverse}}
		texture {Strips}
	}
	texture {Frame_1}
	translate z*0.01
}

#declare Bld1 = union {
	difference {			// base
		box {<-3, 0, -0.01>, <0.01, 0.06, 2>}
		box {<-0.42, -0.1, -0.1>, <-0.28, 0.1, 0.2>}
		texture {Bld1_gr}
	}
	box {<-3, 0.06, 0.01>, <-0.01, 1.52, 2> texture {Bld1_wall}}	// main block
	union {
		box {<-0.05, 0.06, 0>, <0, 1.52, 0.05>}	// corner
		// corner bricks
		box {<-0.07, 0.09, -0.01>, <0.01, 0.12, 0.07>}
		box {<-0.07, 0.09, -0.01>, <0.01, 0.12, 0.07> translate y*0.06*1}
		box {<-0.07, 0.09, -0.01>, <0.01, 0.12, 0.07> translate y*0.06*2}
		box {<-0.07, 0.09, -0.01>, <0.01, 0.12, 0.07> translate y*0.06*3}
		// portal low
		box {<-3, 0.3, -0.01>, <0.01, 0.31, 2>}
		box {<-3, 0.31, -0.02>, <0.02, 0.32, 2>}
		box {<-3, 0.32, -0.03>, <0.03, 0.33, 2>}
			box {<-3, 0.33, -0.02>, <0.02, 0.4, 2>}
		box {<-3, 0.4, -0.03>, <0.03, 0.41, 2>}
		box {<-3, 0.41, -0.02>, <0.02, 0.42, 2>}
		box {<-3, 0.42, -0.01>, <0.01, 0.43, 2>}
		// portal high
		box {<-3, 0.75, -0.02>, <0.02, 0.76, 2>}
		box {<-3, 0.76, -0.01>, <0.01, 0.8, 2>}
		box {<-3, 0.8, -0.02>, <0.02, 0.81, 2>}

		box {<-3, 0.75, -0.02>, <0.02, 0.76, 2> translate y*0.4}
		box {<-3, 0.76, -0.01>, <0.01, 0.8, 2> translate y*0.4}
		box {<-3, 0.8, -0.02>, <0.02, 0.81, 2> translate y*0.4}

		box {<-3, 1.52, -0.01>, <0.01, 1.54, 2>}
		box {<-3, 1.54, -0.02>, <0.02, 1.55, 2>}

		texture {Bld1_gr}
	}
	// roof
	difference {
		plane {-z, 0 rotate x*(degrees(acos(2/sqrt(13))))}
		plane {y, 0}
		plane {y, 0.1 inverse}
		plane {x, -3}
		plane {z, 2 inverse}
		plane {-x, 0 rotate z*(degrees(acos(2/sqrt(13))))}
		translate <0.05, 1.55, -0.05>
		texture {Strips}
	}
	box {<-3, 1.65, 0.1>, <-0.1, 1.66, 2> texture {Bld1_gr}}
	box {<-3, 1.66, 0.11>, <-0.11, 1.79, 2> texture {Bld1_wall}}
	box {<-3, 1.79, 0.1>, <-0.1, 1.8, 2> texture {Bld1_gr}}
	difference {
		plane {-z, 0 rotate x*(degrees(acos(2/sqrt(13))))}
		plane {y, 0}
		plane {y, 0.2 inverse}
		plane {x, -3}
		plane {z, 2 inverse}
		plane {-x, 0 rotate z*(degrees(acos(2/sqrt(13))))}
		translate <-0.05, 1.8, 0.05>
		texture {Strips}
	}
	box {<-3, 2, 0.35>, <-0.35, 2.01, 2> texture {Bld1_gr}}

	// windows

	// 1st floor
	object {Large_w_1_bright translate <-0.1, 0.06, 0>}
	object {Door translate -x*0.28}
	object {Large_w_1_bright translate <-0.45, 0.06, 0>}

	object {Large_w_1_bright translate <-0.1-0.55, 0.06, 0>}
	object {Large_w_1_bright translate <-0.1-0.55-0.18*1, 0.06, 0>}
	object {Large_w_1_bright translate <-0.1-0.55-0.18*2, 0.06, 0>}
	object {Large_w_1_bright translate <-0.1-0.55-0.18*3, 0.06, 0>}
	object {Large_w_1_bright translate <-0.1-0.55-0.18*4, 0.06, 0>}

	// 2nd floor
	object {Small_w_bright translate <-0.1, 0.5, 0>}
	object {Large_w_bright translate <-0.25, 0.5, 0>}
	object {Small_w_bright translate <-0.5, 0.5, 0>}

	object {Small_w_dark translate <-0.7, 0.5, 0>}

	object {Small_w_bright translate <-0.9, 0.5, 0>}
	object {Large_w_bright translate <-1.05, 0.5, 0>}
	object {Small_w_bright translate <-1.3, 0.5, 0>}

	// 3rd floor
	object {Small_w_dark translate <-0.1, 0.9, 0>}
	object {Small_w_bright translate <-0.3, 0.9, 0>}
	object {Small_w_bright translate <-0.5, 0.9, 0>}
	object {Small_w_bright translate <-0.7, 0.9, 0>}
	object {Small_w_dark translate <-0.9, 0.9, 0>}
	object {Small_w_bright translate <-1.1, 0.9, 0>}
	object {Small_w_dark translate <-1.3, 0.9, 0>}

	// 4th floor
	object {Small_w_bright translate <-0.1, 1.3, 0>}
	object {Large_w_bright translate <-0.25, 1.3, 0>}
	object {Small_w_dark translate <-0.5, 1.3, 0>}

	object {Small_w_bright translate <-0.7, 1.3, 0>}

	object {Small_w_bright translate <-0.9, 1.3, 0>}
	object {Large_w_bright translate <-1.05, 1.3, 0>}
	object {Small_w_dark translate <-1.3, 1.3, 0>}

	object {Cafe translate <-0.44, 0.34, -0.026>}
	object {Restaurant translate <-1.5, 0.34, -0.026>}
	object {Neon rotate y*90 translate <-0.025, 0.56, -0.05>}
	object {Clock rotate y*90 translate <-0.025, 1.175, 0>}
}