// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
//#include "textures.inc"	// Standard Texture definitions
#include "finish.inc"
//#include "woods.inc"
#include "hrcurv.inc"
#include "hrtxtrs.inc"

background{ color DarkTan*0.25 }

global_settings{ ambient_light 0.4
                 assumed_gamma 2.2
                 max_intersections 200
                 max_trace_level 20
                 adc_bailout 1/255
                }

camera{ perspective
        up y
        right x*4/3
        location <130, 0, -351>
        look_at <0, 0, 0>
        //angle 50
        angle 20  //test view
        }

light_source
{
  0*x // light's position (translated below)
  color red 0.8  green 0.8  blue 0.6  // light's color
  area_light 10*y, 10*z, 9, 9
  adaptive 0
  jitter
  rotate  y*-22.5
  translate <-400, 100, -552>

}

light_source
{
  0*x // light's position (translated below)
  color red 0.8  green 0.8  blue 0.6  // light's color
  area_light 10*x, 10*y, 9, 9
  adaptive 0
  jitter
  rotate  x*10
  translate <-100, -100, 400>
}


light_source
{
  0*x // light's position (translated below)
  color red 0.6  green 0.6  blue 0.4  // light's color
  area_light 10*y, 10*z, 9, 9
  adaptive 0
  jitter
  translate <400, 1, 0>

}

light_source
{
  0*x // light's position (translated below)
  color Gray65  // light's color
  area_light 10*y, 10*x, 9, 9
  adaptive 0
  jitter
  translate <-20, -49, -350>
}



/*#declare Quarter = bicubic_patch
{
  type 0 //1
  flatness 0// flatness value
  u_steps 3
  v_steps 3
  <-27, 50, 0> <-27, 50, 36> <27, 50, 36> <27, 50, 0>
  <-27, 7, 0> <-27, 7, 36> <27, 7, 36> <27, 7,  0>
  <-3, 14, 0> <-3, 14, 4> <3, 14, 4> <3, 14,  0>
  <-3, 0, 0> <-3, 0, 4> <3, 0, 4> <3, 0, 0>
}*/

#declare Figure =
union{
       object { Half }
       object { Half rotate x*180 }
      }

#declare GlassPart = object { Figure
                     pigment { color LightWood }

                     }

/*#declare Sand =
         object { Figure scale <0.9, 0.9, 1 >
                  texture { SandTexture }
                }*/

#declare Ring = torus { 40, 5 }

#declare TopnBottom = disc { <0,0,0>, y, 40 }

#declare Caps = union{
                      object { Ring}
                      object { TopnBottom translate y*5 }
                      object { TopnBottom translate y*-5 }
                      texture { CapsTexture }
                      }

#declare HourGlass = union{
                           object { GlassPart }
                           //object { Sand }
                           object { Caps translate y*50 }
                           object { Caps translate y*-50 rotate y*90}
                           }
//#declare HourGlass = cylinder { y*-50, y*50, 14 pigment { color LightWood }}

merge{  // A little trick with mirrors to increase the apparent number of objects
plane { -x, 0
        texture{
                pigment { color Gray10 filter 1}
                //pigment { color rgbf <0.001, 0.001, 0.001, 1.0>}
                finish { Mirror }
                 }
     rotate y*-45
     //translate z*177
}

plane { x, 0
        texture{
                pigment { color Gray10 filter 1}
                //pigment { color rgbf <0.001, 0.001, 0.001, 1.0>}
                finish { Mirror }
                 }
     rotate y*45
     //translate z*177
}

plane { z, -552
        texture{
                pigment { color Gray10 filter 1}
                //pigment { color rgbf <0.001, 0.001, 0.001, 1.0>}
                finish { Mirror }
                 }
     }

plane { -y, -55 //-268.88889
        texture{
                pigment { color Gray10 filter 1}
                //pigment { color rgbf <0.001, 0.001, 0.001, 1.0>}
                finish { Mirror }
                 }
     }

plane { y, -55 //-268.88889
        texture{
                pigment { color Gray10 filter 1}
                //pigment { color rgbf <0.001, 0.001, 0.001, 1.0>}
                finish { Mirror }
                 }
     }
no_shadow
translate z* 177}

#declare ScalingBasis = 1/4 // Each Smaller Hourglass is roughly 1/4 parent's size.
#declare GlassRadi = 27 // Radius of GlassPart
#declare InnerHeight = 90 // Inner Distance Between the Caps
#declare OuterHeight = 110 // Overall Height from Top to Bottom ( Absolute Value )
#declare CapsRadi = 45 // Outer Radius of Each Cap ( = torus.major + torus.minor )
#declare GlobalScalar  = ScalingBasis * ( InnerHeight / OuterHeight )// = .2045454546
                                    // So the smaller ones will fit between the caps.
#declare Out = (GlassRadi + ( CapsRadi * GlobalScalar ))/GlobalScalar
#declare MaxLevel = 2
#declare Level = MaxLevel
#declare ObjectCenter = <0, 0, 0>
#declare Size = 1
#declare Fractal = union{
                          #include "hrglass.inc"
                          }
object { Fractal }

/*#declare OuterHeight = 110 // Redeclared just in case changed by Fractal Object
object { HourGlass scale 1/ GlobalScalar }
object { Fractal translate -y*(3/2)*OuterHeight
                 translate -z*177 }
object { Fractal translate -y*(1/2)*OuterHeight
                 translate -z*177 }
object { Fractal translate y*(1/2)*OuterHeight
                 translate -z*177 }
object { Fractal translate y*(3/2)*OuterHeight
                 translate -z*177 }*/

