/* ****************************************************************
Title	: Dissolution of Memory
Author	: Jeremy C. Witt
Date		: 6/96
Desc		: This little scene contains a sphere circumscribed with a
		  Cube, with the faces of a clock reading 9:00PM on each
	       side. Nearly all textures are reflective or refractive.
		  Therefore, rendering time is slow.
Lisc		: You are free to use this however you want. If you like
		  it, Send me a note. z3a12@ttacs3.ttu.edu
*******************************************************************/

#include "colors.inc"
#include "chars.inc"
#include "textures.inc"
#include "glass.inc"

camera
{
 location < -2,2,-12 >
 look_at < 0,0,0 >
}

// Background light
light_source
{
  < 10, 50, -25 >
  color Gray45
}

// Spotlight on The Clock
light_source
{
 <8,26,-15>
 color White
 spotlight
 point_at <0,0,0>
 radius 4
 falloff 8
}

// Inside the Sphere
light_source
{
 <0,0,0>
 color White
}

// Various Textures Used in this scene
// ***********************************

// This was the Texture of the Cube structure 
#declare OutText=
texture
{
 Chrome_Metal
}

// The Cubes on Each Vertex of the Cube
#declare OutText2=
texture
{ 
 Chrome_Metal
}

// This is the Texture for the Shafts Ends
#declare ShaftText2=
texture
{
 T_Glass3
 pigment
 {color red 0.98 green 0.48 blue 0.48 filter 0.9}
}

// This is the Texture for the Shafs that run on the axes
#declare ShaftText= 
texture
{ 
 T_Glass3
 pigment
 {color red 0.48 green 0.98 blue 0.48 filter 0.9}
}

// Clock Face Texture
#declare Logo_Texture = texture 
{ 
 Gold_Metal
}


// This is the Clock Face Object
#declare ClockFace=
merge
{

 // The Outside
 torus 
 {
  3,.1
  texture {Logo_Texture}
  rotate<-90,0,0>
 }
 
 // The Numbers
 text 
 { 
  ttf "stop.ttf", "12", .25, 0
  translate <-.5, 2.2, -.125>
  texture { Logo_Texture}
  finish {ambient 0.8}
 }

 text 
 { 
  ttf "stop.ttf", "6", .25, 0
  translate <-.25, -2.7, -.125>
  texture { Logo_Texture}
  finish {ambient 0.8}
 }

 text 
 { 
  ttf "stop.ttf", "3", .25, 0
  translate <2.2, -0.20, -.125>
  texture { Logo_Texture}
  finish {ambient 0.8}
 }

 text 
 { 
  ttf "stop.ttf", "9", .25, 0
  translate <-2.7, -0.25, -.125>
  texture { Logo_Texture}
  finish {ambient 0.8}
 }
 
 // The Center
 sphere
 {
  <0,0,0>,.25
  texture { Logo_Texture}
 }

 // The Little Hand
 cone
 {
   <0,0,0>,0.10
   <0,2.0,0>,0
   texture { T_Ruby_Glass }
   finish { ambient 0.80  }
   rotate z*10
 }          

 //  The Big Hand
 cone 
 {
  <0,0,0>,0.20
  <0,1.5,0>,0
  texture { ShaftText }
  finish { ambient 0.80 }
  rotate z*90
 }

  scale 0.62 
} // end merge


// This is the Actual Scene
// ************************
merge
{
 sphere
 {
  < 0,0,0> , 2
  texture { Polished_Chrome }
 }
 
 // The Verticies of the Cube
 box
 {
  <3.5,3.5,3.5><2.5,2.5,2.5>
  texture { OutText2 }
 }
 box
 {
  <-3.5,3.5,3.5><-2.5,2.5,2.5>
  texture { OutText2 }
 }
 box
 {
  <3.5,-3.5,3.5><2.5,-2.5,2.5>
  texture { OutText2 }
 }
 box
 {
  <3.5,3.5,-3.5><2.5,2.5,-2.5>
  texture { OutText2 }
 }
 box
 {
  <-3.5,-3.5,-3.5><-2.5,-2.5,-2.5>
  texture { OutText2 }
 }
 box
 {
  <-3.5,-3.5,3.5><-2.5,-2.5,2.5>
  texture { OutText2 }
 }
 box
 {
  <-3.5,3.5,-3.5><-2.5,2.5,-2.5>
  texture { OutText2 }
 }
 box
 {
  <3.5,-3.5,-3.5><2.5,-2.5,-2.5>
  texture { OutText2 }
 } 
 
 // The Edges of the Cube
 cylinder
 {
  <3,3,3>,<3,3,-3>,.25
  texture {OutText}
 }
 cylinder
 {
  <3,3,3>,<3,-3,3>,.25
  texture {OutText}
 }
 cylinder
 {
  <3,3,3>,<-3,3,3>,.25
  texture {OutText}
 }
 cylinder
 {
  <-3,-3,-3>,<3,-3,-3>,.25
  texture {OutText}
 }
 cylinder
 {
  <-3,-3,-3>,<-3,3,-3>,.25
  texture {OutText}
 }
 cylinder
 {
  <-3,-3,-3>,<-3,-3,3>,.25
  texture {OutText}
 }
 cylinder
 {
  <3,3,-3>,<3,-3,-3>,.25
  texture {OutText}
 }
 cylinder
 {
  <-3,3,-3>,<-3,3,3>,.25
  texture {OutText}
 }
 cylinder
 {
  <-3,3,3>,<-3,-3,3>,.25
  texture {OutText}
 }
 cylinder
 {
  <-3,-3,3>,<3,-3,3>,.25
  texture {OutText}
 }
 cylinder
 {
  <3,-3,3>,<3,-3,-3>,.25
  texture {OutText}
 }
 cylinder
 {
  <-3,3,-3>,<3,3,-3>,.25
  texture {OutText}
 }

 // Shafts
 cylinder
 {
  <0,0,-50>,<0,0,150>,.10
  texture {ShaftText}
 }
 cylinder
 {
  <-50,0,0>,<50,0,0>,.10
  texture {ShaftText}
 }
 cylinder
 {
  <0,-50,0>,<0,900,0>,.10
  texture {ShaftText}
 }

 // Shaft Ends
 cone
 {
 <0,0,0>,.8
 <0,0,2.5>,.2
 texture { ShaftText2 }
 }
 cone
 {
 <0,0,0>,.8
 <0,0,-2.5>,.2
 texture { ShaftText2 }
 }
 cone
 {
 <0,0,0>,.8
 <0,2.5,0>,.2
 texture { ShaftText2 }
 }
 cone
 {
 <0,0,0>,.8
 <0,-2.5,0>,.2
 texture { ShaftText2 }
 }
 cone
 {
 <0,0,0>,.8
 <2.5,0,0>,.2
 texture { ShaftText2 }
 }
 cone
 {
 <0,0,0>,.8
 <-2.5,0,0>,.2
 texture { ShaftText2 }
 } 

 // Clock Faces
 object
 {
  ClockFace
  translate <0,0,-3>
 }
 object
 {
  ClockFace
  translate <0,0,-3>
  rotate -90*y
 }
 object
 {
  ClockFace
  translate <0,0,-3>
  rotate -180*y
 }
 object
 {
  ClockFace
  translate <0,0,-3>
  rotate 90*y
 }
 object
 {
  ClockFace
  translate <0,0,-3>
  rotate 90*x
 }
 object
 {
  ClockFace
  translate <0,0,-3>
  rotate -90*x
 } 

} // end merge

// Sky Sphere 
sphere
{
 <0,0,0>,1000
 texture
 {
  pigment
   {
     Y_Gradient
     color_map 
     {[0.00, 0.33  color rgb <.65,.65,.95> 
                   color Blue]
      [0.33, 0.66  color Blue 
                   color rgb <.65,.25,.65>]
      [0.66, 1.001 color rgb <.65,.25,.65>
                   color rgb <.65,.65,.95>]
      }
   }      
 scale 10
 finish { ambient .45 }
 }
}

// Ground
plane
{
 y,-5
 texture { Silver3 }
 texture { pigment { checker color Red color Clear}
  scale 6}
}

