#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "woods.inc"
#include "glass.inc"
#include "base.inc" // the base of the hourglass
#include "pole.inc" // the polls of the hourglass
#include "glass.inc"// the glass of the hourglass
#include "hood.inc" // the hood of death
#include "scythe.inc"// the scythe of death
#include "hand.inc"

global_settings { assumed_gamma 2.2 }

light_source {
   <2,18,-8>
   color White  // Light Color
}

light_source {
   <-2,18,0>
}

light_source {
   <-10,30,10>
}

background {
   color red 0 green .01 blue .3
}

camera {
   location <0, 10, -90>
   direction <0, 0, 2>          // Which way we are looking <X Y Z>
   up <0, 1, 0>                 // Which direction is   +up <X Y X>
   right <4/3, 0, 0>            // Which way is      +right <X Y Z>
   look_at <-1, 5, 0>  // Point camera at this point(center of view)
}

#declare w_hour_glass = union {
   object { hour_base }
   object { hour_base
      rotate <180,0,0>
      translate <0,19,0>
   }
   object {pole
      translate <4.5,7,0>
   }
   object {pole
      translate <-17,6.9,0>
   }
   object {pole
      translate <-6,7,10>
   }
   object {pole
      translate <-6,6.9,-10>
   }
   texture {
      pigment {
         Tom_Wood
         color_map {
            [0.0 color DarkTan]
            [0.9 color DarkBrown]
            [1.0 color VeryDarkBrown]
         }
         turbulence 0.05
         rotate <90, 0, 0>
         scale <0.2, 0.3, 1>
      }
   }
}

#declare g_hour_glass = union {
   object {glass
   }
   object {glass
      rotate <180,0,0>
   }
   texture {Glass2}
   translate <-4,8,0>
   scale <2.5,1.2,2.5>
}

#declare sand = cone { <0,0,0>, 1
    <0,1,0>, .1
    scale <5.2,4,5.2>
    pigment { color rgbt <1, 1, 1, 2> }
    normal {bumps 0.4 scale 0.2}
    finish {phong 1}
    hollow
}

#declare dot = sphere { <0,0,0>, .2
   scale <5.2,4,5.2>
   pigment { color rgbt <1, 1, 1, 2> }
   normal {bumps 0.4 scale 0.2}
   finish {phong 1}
   hollow
}

#declare dot_glow = sphere { <0,0,0>, .23
   scale <5.2,4,5.2>
   pigment { color rgbt <1, 1, 1, 2> }
   halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <0, .8, 0, 0.5, 1.0> ]
        [ 1 color rgbt <0, .8, .8, 0.5, 0.5> ]
      }
      samples 5
    }
   hollow
}

#declare glow = cone { <0,0,0>, 1.5
   <0,1.5,0>, .2
   scale<5.2,4,5.2>
   pigment { color rgbt <1, 1, 1, 1> }
   halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <0, .8, 0, 0.5, 1.0> ]
        [ 1 color rgbt <0, .8, .8, 0.5, 0.5> ]
      }
      samples 10
   }
   hollow
}

#declare hour_glass = union {
   object {w_hour_glass}
   object {g_hour_glass}
   object {sand
      translate<-9,0,0>
   }
   object {glow
      translate<-9,0,0>
   }
   object {dot_glow
      translate <-8.5,11,0>
   }
   object {dot
      translate <-8.5,11,0>
   }
}

 #declare eye = blob {
   threshold 0.6
   sphere { <.55,0,0>, 1, 1}
   sphere { <0,.1,0>, 1, 1}
   sphere { <-.75,0.2,0>, 1, 1}
   pigment { color rgbt <1, 1, 1, 1> }
   halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 0, 0> ]
      }
      samples 10
   }
   hollow
}

#declare head = union {
   object {eye
      translate <-1.2,0,16>
      scale .8
   }
   object {eye 
      rotate <0,180,0>
      translate <1.2,0,16>
      scale .8
   }
   object { hood
      scale <7,11,7>
      translate <0,-6.5,20>
   }
}

// #declare back_fog  = 
fog {
   distance 100
   colour rgbf<0.03, 0.05, 0.02, 0.001>
   fog_type 2
   fog_offset 15
   fog_alt 3
   turbulence 1.5
   turb_depth 1.5
}

// #declare _lower_white_ground_fog =
sphere { 0, 1
   hollow
   texture {
      pigment { colour Clear }
      halo {
         cubic
         spherical_mapping
         glowing
         color_map {
           [ 0 color rgbt <.1, 0, 0, 1.0> ]
           [ 1 color rgbt <.5,.5,.5, 0.2> ]
         }
         turbulence 1
         samples 40
         aa_level 3
         aa_threshold 0.2
         jitter 0.1
       }
   }
   scale 23
   translate <16,-12,10>
}

object {head
   scale <4,2,1>
   translate<-3,22,0>
}

object {
    hour_glass
    scale <.5,1,.5>
    rotate <2,30,5>
    translate <-13,-13,0>
}
