/* File         : Gardens.inc
 *
 * Purpose      : A section of the house grounds
 * Author       : (C)1996 Matthew Hunter
 * Version      : 0.02  (06 May 1996)
 *                0.05  (28 June 1996)
 *                  Release version.
 */

#include "GTexts.inc"

// **************************************************************************
// The gravel paths, just a plane everything else can be added on top

object {
  plane {
    <0,1,0>
    0
  }
  texture { TGravel }
}

#declare Lawn_Section = union {
  difference {
    box {
      <-999.98,0,2.5>
      < -5,0.16,399.98>
    }
    cylinder {
      <-5,-1,2.5>
      <-5, 1,2.5>
      2.5
    }
    translate <-0.01,0, 0.01>
    texture { TGarden_Lawn_Base }
  }
  difference {
    box {
      <-1000,0.16,2.5>
      < -5,0.32,400>
    }
    cylinder {
      <-5,-1,2.5>
      <-5, 1,2.5>
      2.5
    }
    texture { TGarden_Lawn }
  }
}

object { Lawn_Section };
object {
  Lawn_Section
  scale <-1,1,1>
}
object {
  Lawn_Section
  scale <-1,1,-1>
}
object {
  Lawn_Section
  scale <1,1,-1>
}

#declare Topiary_Tree = union {
  cone {
    <0,0.5,0>, 3
    <0,10,0>, 2
  }
  cylinder {
    <0,0,0>,
    <0,0.5,0>,
    0.2
  }
  texture { TTopiary }
}

union {
#declare Count=-308
#while (Count<-19)
  object {
    Topiary_Tree
    translate <-20,0,Count>
  }
  object {
    Topiary_Tree
    translate < 20,0,Count>
  }
  #declare Count = Count + 15
#end
}

