/* File         : GTexts.inc
 *
 * Purpose      : The textures for the garden and outer walls
 * Author	: (C)1996 Matthew Hunter
 * Version	: 0.02	(06 May 1996)
 */

#ifndef (__GTexts_inc)
#declare __GTexts_inc = 1

#declare TGravel =  texture {
  pigment {
    granite
    colour_map {
      [0.0 colour rgb <0.7,0.7,0.7>]
      [0.1 colour rgb <0.6,0.6,0.6>]
      [0.4 colour rgb <0.5,0.5,0.5>]
      [0.6 colour rgb <0.7,0.7,0.7>]
      [0.7 colour rgb <0.5,0.6,0.5>]
      [0.8 colour rgb <0.8,0.8,0.8>]
      [1.0 colour rgb <0.7,0.7,0.7>]
    }
    scale <0.5,0.5,0.5>
  }
  normal {
    granite
    bump_size 0.5
    scale <0.25,0.25,0.25>
  }
}

#declare TGarden_Lawn_Base = texture {
  pigment {
    granite
    colour_map {
      [0.0 colour rgb <0.4, 0.3, 0.2>]
      [1.0 colour rgb <0.3, 0.25, 0.15>]
    }
  }
}

#declare TGarden_Lawn = texture {
  pigment {
    granite
    colour_map {
      [0.0 colour rgb <0.1, 0.5, 0.2>]
      [1.0 colour rgb <0.05, 0.25, 0>]
    }
  }
  normal {
    granite
    bump_size 0.5
  }
}

#declare TTopiary = texture {
  pigment {
    granite
    colour_map {
      [0.0 colour rgbf <1,1,1,1>]
      [0.1 colour rgbf <1,1,1,1>]
      [0.1 colour rgbf <0.2,0.6,0.3,0>]
      [0.9 colour rgbf <0.1,0.3,0.15,0>]
      [1.0 colour rgbf <0.4,0.1,0.0,0>]
    }
  }
  normal {
    bozo
    bump_size 0.1
  }
}

#declare TSteps = texture {
  pigment {
    granite
    colour_map {
      [0.0 colour rgb <0.93,0.93,0.88>]
      [0.5 colour rgb <0.88,0.88,0.83>]
      [1.0 colour rgb <0.93,0.93,0.88>]
    }
    scale <0.5,0.5,0.5>
  }
  normal {
    granite
    bump_size 0.1
    scale <0.05,0.05,0.05>
  }
}

#declare TCracks = texture {
  pigment {
    crackle
    colour_map {
      [0.0 colour rgbf <1,1,1,1>]
      [0.4 colour rgbf <1,1,1,0.8>]
      [0.8 colour rgbf <1,1,1,1>]
      [1.0 colour rgbf <1,1,1,0.5>]
    }
  }
}

#declare TBrick_Wall = texture {
  brick
  texture {
    pigment {
//      colour rgb <0.53,0.53,0.48>
      colour rgbf <1,1,1,1>
    }
  }
  texture {
    pigment {
      //colour rgb <0.43,0.03,0.00> // dark red
      //colour rgb <0.83,0.83,0.67> // light brick
      colour rgb <0.93,0.90,0.80>
    }
    normal {
      granite
      bump_size 0.2
      scale <0.2,0.2,0.2>
    }
  }
  brick_size <1.8,0.6,1.8>
  mortar 0.10
}

#declare TMortar = texture {
  pigment {
    //colour rgb <0.2,0.2,0.16>
    colour rgb <0.7,0.7,0.7>
  }
}

#declare TSlates = texture {
  pigment {
    colour rgb <0.2,0.2,0.22>
  }
}

#declare TWindow_Frame = texture {
  pigment {
    colour rgb <1,1,1>
  }
  normal {
    bozo
    bump_size 0.02
  }
  finish {
    phong 20
  }
}

#declare TWindow_Glass = texture {
  pigment {
    colour rgbf <1,1,1,0.5>
  }
  finish {
    phong 20
    reflection 0.5
    refraction 1
    ior 1.53
  }
}


#declare TWooden_Floor = texture {
  brick
  texture {
    pigment {
      colour rgb <0,0,0>
    }
  }
  texture {
    pigment {
      //colour rgb <139/255,69/255,19/255>
      //colour rgb <244/255,164/255,96/255>
      // wood
      gradient <0,1,0>
      turbulence 0.1
      octaves 3
      colour_map {
        [0.00 colour rgb <0.9569,0.6431,0.3765>]
        [0.25 colour rgb <0.9569,0.6431,0.3765>]
        [0.50 colour rgb <0.5451,0.2706,0.0745>]
        [0.75 colour rgb <0.9569,0.6431,0.3765>]
        [1.00 colour rgb <0.9569,0.6431,0.3765>]
      }
      //rotate <0,90,0>
      //translate <100,0,0>
      scale <0.2,0.2,0.2>
    }
    finish {
      reflection 0.0
    }
  }
  brick_size <10,0.5,0.5>
  mortar 0.05
  rotate <90,0,0>
}

#end
