/* File         : House.inc
 *
 * Purpose      : The back of the house
 * Author       : (C)1996 Matthew Hunter
 * Version      : 0.02  (06 May 1996)
 *                0.05  (28 June 1996)
 *                  Release version.
 *                  Increase window size.
 */

#include "GTexts.inc"

#declare Window_Width = 6
#declare Window_Height = 8
#declare Wall_Height = 12
#declare Wall_Width = 10

#declare Window_Hole = object {
  box {
    <-Window_Width/2,0,-5>
    < Window_Width/2,Window_Height,5>
  }
}

#declare Window_Glass = object {
  box {
    <-Window_Width/2,0,-0.05>
    < Window_Width/2,Window_Height,0.05>
  }
  translate <0,0,1>
}

#declare Window_Frame = difference {
  union {
    box {         // The top of the window frame
      <-(Window_Width/2)-0.2,-0.2,-1.2>
      < (Window_Width/2)+0.2, 0.2, 1.2>
      translate <0,Window_Height,0>
    }
    box {         // The left side of the window frame
      <-0.2, -0.2,-1.2>
      < 0.2, Window_Height+0.2, 1.2>
      translate <-Window_Width/2,0,0>
    }
    box {         // The right side of the window frame
      <-0.2, -0.2,-1.2>
      < 0.2, Window_Height+0.2, 1.2>
      translate <Window_Width/2,0,0>
    }
    box {         // The window sill
      <-(Window_Width/2)-0.3,-0.3,-1.4>
      < (Window_Width/2)+0.3, 0.3, 1.4>
    }
    #declare Count = 1
    #while (Count<Window_Height)
      box {
        <-Window_Width/2,-0.1,-0.1>
        < Window_Width/2,+0.1, 0.1>
        rotate <45,0,0>
        translate <0,Count,1>
      }
      #declare Count=Count+1
    #end
    #declare Count = 1
    #while (Count<Window_Width)
      box {
        <-0.1,            0,-0.1>
        <+0.1,Window_Height, 0.1>
        rotate <0,45,0>
        translate <Count-(Window_Width/2),0,1>
      }
      #declare Count=Count+1
    #end
  }
  object { Window_Glass }
  texture { TWindow_Frame }
}

#declare Object_Window = union {
  object { Window_Frame }
  object {
    Window_Glass
    texture { TWindow_Glass }
  }
}


#declare House_Height = 34
#declare RoofEdge = 5

#declare Object_House = difference {
  union {
    union {
      box {     // Main house
        <-50, 0,-50>
        < 50,House_Height+RoofEdge, 50>
      }
      box {     // West wing
        <-100, 0,-80>
        < -50,House_Height+RoofEdge, 80>
      }
      box {     // East wing
        < 50, 0,-80>
        <100,House_Height+RoofEdge, 80>
      }
      texture { TBrick_Wall }
    }
    union {
      box {
        <-50.05, 0,-49.95>
        < 50.05,House_Height+RoofEdge, 49.95>
      }
      box {
        <-99.95, 0,-79.95>
        <-50.05,House_Height+RoofEdge, 79.95>
      }
      box {
        <50.05, 0,-79.95>
        <99.95,House_Height+RoofEdge, 79.95>
      }   
      texture { TMortar }
    }
  }
  union {       // Cut out the insides of the house
    box {
      <-52,-1,-48>
      < 52,House_Height+RoofEdge+1, 48>
    }
    box {
      <-98,-1,-78>
      <-52,House_Height+RoofEdge+1, 78>
    }
    box {
      <52,-1,-78>
      <98,House_Height+RoofEdge+1, 78>
    }
  }   
}

#declare Window_Hole_Section = union {
      // Windows on the ground floor
      #declare Count = 1
      #while (Count<5)
        object {    // Ground floor, main building
          Window_Hole
          translate <(Count*10)+5,7,49>
        }
        object {    // Ground floor, end of wing
          Window_Hole
          translate <(Count*10)+50,7,79>
        }
        #declare Count = Count + 1
      #end
      #declare Count = 1
      #while (Count<8)
        object {    // Ground floor, outside of wing
          Window_Hole
          rotate <0,90,0>
          translate <99,7,Count*10>
        }
        #declare Count = Count + 1
      #end
      #declare Count = 1
      #while (Count<3)
        object {    // Ground floor, inside of wing
          Window_Hole
          rotate <0,-90,0>
          translate <51,7,(Count*10)+50>
        }
        #declare Count = Count + 1
      #end
}

#declare Window_Hole_Segment = union {
  object {
    Window_Hole_Section
  }
  object {
    Window_Hole_Section
    translate <0,15,0>
  }
}

#declare Window_Frame_Section = union {
      // Windows on the ground floor
      #declare Count = 1
      #while (Count<5)
        object {    // Ground floor, main building
          Object_Window
          translate <(Count*10)+5,7,49>
        }
        object {    // Ground floor, end of wing
          Object_Window
          translate <(Count*10)+50,7,79>
        }
        #declare Count = Count + 1
      #end
      #declare Count = 1
      #while (Count<8)
        object {    // Ground floor, outside of wing
          Object_Window
          rotate <0,90,0>
          translate <99,7,Count*10>
        }
        #declare Count = Count + 1
      #end
      #declare Count = 1
      #while (Count<3)
        object {    // Ground floor, inside of wing
          Object_Window
          rotate <0,-90,0>
          translate <51,7,(Count*10)+50>
        }
        #declare Count = Count + 1
      #end
}

#declare Window_Frame_Segment = union {
  object {
    Window_Frame_Section
  }
  object {
    Window_Frame_Section
    translate <0,15,0>
  }
}

#declare Object_House_And_Windows = union {
  difference {
    object { Object_House }
    object {
      Window_Hole_Segment
    }
    object {
      Window_Hole_Segment
      scale <-1,1,1>
    }
    object {
      Window_Hole_Segment
      scale <-1,1,-1>
    }
    object {
      Window_Hole_Segment
      scale <1,1,-1>
    }
  }
  union {
    // windows
    object {
      Window_Frame_Segment
    }
    object {
      Window_Frame_Segment
      scale <-1,1,1>
    }
    object {
      Window_Frame_Segment
      scale <-1,1,-1>
    }
    object {
      Window_Frame_Segment
      scale <1,1,-1>
    }
  }
}

#declare Big_Brick = box {
  <0,0.05,0>
  <2,1.00,2>
}

#declare Small_Brick = box {
  <0,0.05,0>
  <1,1.00,1>
}

#declare Lower_Brick_Work = union {
#declare Count = 17
#while (Count > 0)
  object {
    Big_Brick
    translate <0,Count-1,0>
  }
  object {
    Small_Brick
    translate <0,Count-2,0>
  }
  #declare Count = Count -2
#end
}

#declare Upper_Brick_Work = union {
#declare Count = 18
#while (Count < (House_Height-3))
  object {
    Big_Brick
    translate <0,Count,0>
  }
  object {
    Small_Brick
    translate <0,Count+1,0>
  }
  #declare Count = Count +2
#end
  object {
    Big_Brick
    translate <0,Count,0>
  }
}

#declare Brick_Work = union {
  object { Upper_Brick_Work }
  object { Lower_Brick_Work }
}

#declare House_Edging = union {
  box {
    <-50,0.05,-50.25>
    <  0,1,-49>
  }
  box {
    <-100,0.05,-80.25>
    < -50,1,-79>
  }
  box {
    <-51,0.05,-80.25>
    <-49.75,1,-49>
  }
  box {
    <-100.25,0.05,-80.25>
    < -99,1,-49>
  }
}

#declare House_Trim = union {
  object {
    House_Edging
    translate <0,17,0>
  }
  object {
    House_Edging
    translate <0,House_Height-1,0>
  }
  object {
    Brick_Work
    scale <-1,1,1>
    translate <-49.75,0,-80.25>
  }
  object {
    Brick_Work
    translate <-100.25,0,-80.25>
  }
  texture { TSteps }
}

#declare House_Floor = merge {
  box {
    <-52,0,-48>
    < 52,0.5, 48>
  }
  box {
    <-98,0,-78>
    <-52,0.5, 78>
  }
  box {
    <52,0,-78>
    <98,0.5, 78>
  }
  texture { TWooden_Floor }
}

#declare Back_Door_Door = union {
  difference {
    box {
      <-2.7,-16,0.5>
      <-0.05,-3,2>
    }
    #declare Rounded_Size = 3.8
    #declare Rounded_Width = 1.9
    #declare Rounded_Height = 0.3
    object {
      #include "Rounded.inc"
      rotate <90,0,0>
      translate <-1.45,-12.2,0.4>
    }
    object {
      #include "Rounded.inc"
      rotate <90,0,0>
      translate <-1.45,-6.7,0.4>
    }
    texture {
      TWindow_Frame
    }
  }
  union {
    sphere {
      <-1.45,-9,0.5>
      0.3
    }
    torus {
      0.4,0.1
      rotate <90,0,0>
      translate <-1.45,-9.4,0.35>
    }
    texture {
      pigment {
        colour rgb <0,0,0>
      }
    }
  }
}

#declare Back_Door_Frame = union {
  #declare Rounded_Size = 2
  #declare Rounded_Width = 5
  #declare Rounded_Height = 0.2
  #declare RTrans = (Rounded_Width-Rounded_Height)/2
  object {
    #include "Rounded.inc"
    translate <RTrans,-Rounded_Height/2,0>
    rotate <0,0,-30>
  }
  object {
    #include "Rounded.inc"
    translate <RTrans,-Rounded_Height/2,0>
    rotate <0,0,-150>
  }
  #declare Height_Diff = Rounded_Width*sin(radians(30))
  object {
    triangle {
      <0,0,0>
      <-Rounded_Width*cos(radians(30)),-(Height_Diff),0>
      <Rounded_Width*cos(radians(30)),-(Height_Diff),0>
    }
  }
  #declare Rounded_Width = 2*Rounded_Width*cos(radians(30))
  #declare Rounded_Height = 0.8
  object {
    #include "Rounded.inc"
    translate <0,-(Height_Diff)-(Rounded_Height),0>
  }
  object {
    #include "Rounded.inc"
    translate <0,-16,0>
  }
  #declare Rounded_Size = 1.8
  #declare Rounded_Width = 16
  #declare Rounded_Height = 0.25
  #declare Count = 4
  #while (Count>0)
    object {
      #include "Rounded.inc"
      rotate <0,0,90>
      translate <-(2.5+(Count * 0.25)),-(8.2+Height_Diff),0.2>
    }
    object {
      #include "Rounded.inc"
      rotate <0,0,-90>
      translate <2.5+(Count * 0.25),-(8.2+Height_Diff),0.2>
    }
    #declare Count = Count - 1
  #end
  texture { TSteps }
}

#declare Back_Door = union {
  object { Back_Door_Frame }
  object { Back_Door_Door }
  object {
    Back_Door_Door
    scale <-1,1,1>
  }
}

#declare Object_House_Trim_And_Windows = union {
  object { Object_House_And_Windows }
  object { House_Trim }
  object {
    House_Trim
    scale <-1,1, 1>
  }
  object {
    House_Trim
    scale < 1,1,-1>
  }
  object {
    House_Trim
    scale <-1,1,-1>
  }
  object {
    House_Floor
    translate <0,3.2,0>
  }
  object {
    House_Floor
    translate <0,17.2,0>
  }
  object {
    House_Floor
    translate <0,31.2,0>
  }
  object {
    Back_Door
    translate<0,20,-51>
  }
}


#declare Object_Peaked_Roof = union {
  triangle {
    <-40,0,20>, <-30,20,0>, <-40,0,-20>
  }
  triangle {
    <40,0,20>, <30,20,0>, <40,0,-20>
  }
  triangle {
    <-40,0,-20>, <-30,20,0>, <30,20,0>
  }
  triangle {
    <-40,0,-20>, <30,20,0>, <40,0,-20>
  }
  triangle {
    <-40,0,20>, <-30,20,0>, <30,20,0>
  }
  triangle {
    <-40,0,20>, <30,20,0>, <40,0,20>
  }
  cylinder {
    <-30,20,0>
    <30,20,0>
    0.25
  }
  cylinder {
    <-40,0,20>
    <-30,20,0>
    0.25
  }
  cylinder {
    <-40,0,-20>
    <-30,20,0>
    0.25
  }
  cylinder {
    <40,0,20>
    <30,20,0>
    0.25
  }
  cylinder {
    <40,0,-20>
    <30,20,0>
    0.25
  }
  sphere {
    <-30,20,0>
    0.25
  }
  sphere {
    <30,20,0>
    0.25
  }
  texture { TSlates }
}

#declare Object_Chimney = union {
  box {
    <-1, 0,-2>
    < 2,22, 2>
  }
  box {
    <-1.25, 22, -2.25>
    < 1.25, 23,  2.25>
  }
  texture { TBrick_Wall }
}

#declare Object_Roof = union {
  object { Object_Peaked_Roof }
  object {
    Object_Chimney
    translate <-26,0,-10>
  }
  object {
    Object_Chimney
    translate < 26,0,-10>
  }
  translate <0,House_Height,0>
}

union {
  object { Object_House_Trim_And_Windows }
  object { Object_Roof }
  translate <0,0,115>
}

