/* File		: Rounded.inc
 *
 * Purpose	: Defines a flat box with rounded edges
 * Author	: (C)1996 Matthew Hunter
 * Version	: 0.01	(06 May 1996)
 *            0.02  (28 June 1996)
 *              Release version
 */

// *********************************************************
// Rounded
//
// Defines a box, the sides of which are rounded with
// cylinders and spheres

// set up default values if rounded has not previously been
// used
#ifndef (Rounded_Size)
  #declare Rounded_Size = 1
#end

#ifndef (Rounded_Width)
  #declare Rounded_Width = Rounded_Size
#end

#ifndef (Rounded_Height)
  #declare Rounded_Height = 0.5
#end

#declare Rounded_Flute_End = object {
  cylinder {
    <0,0,0>
    <0,Rounded_Size,0>
    Rounded_Height/2
    rotate <90,0,0>
    translate <-(Rounded_Width/2),(Rounded_Height/2), -(Rounded_Size/2)>
  }
}

#declare Rounded_Flute_Side = object {
  cylinder {
    <0,0,0>
    <0,Rounded_Width,0>
    Rounded_Height/2
    rotate <0,0,-90>
    translate <-(Rounded_Width/2),(Rounded_Height/2), -(Rounded_Size/2)>
  }
}

union {
  box {
    <-(Rounded_Width/2), 0.00,-(Rounded_Size/2)>
    < (Rounded_Width/2), Rounded_Height, (Rounded_Size/2)>
  }
  object {
      Rounded_Flute_End
  }
  object {
      Rounded_Flute_End
      translate <Rounded_Width,0,0>
  }
  object {
      Rounded_Flute_Side
  }
  object {
      Rounded_Flute_Side
      translate <0,0,Rounded_Size>
  }
  sphere {
    <0,0,0>
    Rounded_Height/2
    translate <-(Rounded_Width/2),(Rounded_Height/2), -(Rounded_Size/2)>
  } 
  sphere {
    <0,0,0>
    Rounded_Height/2
    translate <-(Rounded_Width/2),(Rounded_Height/2),  (Rounded_Size/2)>
  } 
  sphere {
    <0,0,0>
    Rounded_Height/2
    translate < (Rounded_Width/2),(Rounded_Height/2), -(Rounded_Size/2)>
  } 
  sphere {
    <0,0,0>
    Rounded_Height/2
    translate < (Rounded_Width/2),(Rounded_Height/2),  (Rounded_Size/2)>
  } 
}
