/* File     : Sundial.inc
 *
 * Purpose	: Define the Sundial Object
 * Author   : (C)1996 Matthew Hunter
 * Version	: 0.01	(06 May 1996)
 *            0.02  (28 June 1996)
 *              Release version.
 *              Removed a couple of warnings.
 */

// *********************************************************
// Object_Sundial
//
// After this file has been included the identifier
// Object_Sundial will contain the definition of a Sundial
// it can then be positioned, scaled, rotated using
// object {
//   Object_Sundial
//   [transformations]
// }
#declare Object_Sundial_Flutes = 32
#declare Object_Sundial_Flute_Radius = 0.15
#declare Object_Sundial_Angle = 360/Object_Sundial_Flutes

#declare Object_Sundial_Base = union {
  box {
    <-1,0   ,-1>
    < 1,0.25, 1>
  }
  box {
    <-0.75,0.25,-0.75>
    < 0.75,0.50, 0.75>
  }
}

#declare Object_Sundial_Pedestal = union {
  #declare Count = 0
  #while (Count < 360)
    cylinder {
      <0,0,0>
      <0,3,0>
      Object_Sundial_Flute_Radius
      translate <0.5,0,0>
      rotate <0,Count,0>
    }
    #declare Count = Count+Object_Sundial_Angle
  #end
}


#declare Object_Sundial_Top = union {
  #declare Rounded_Size = 1.3
  #declare Rounded_Width = 1.3
  #declare Rounded_Height = 0.16
  #include "Rounded.inc"
  #declare Rounded_Size = 1.5
  #declare Rounded_Width = 1.5
  #declare Rounded_Height = 0.20
  object {
    #include "Rounded.inc"
    translate <0,0.16,0>
  }
}

#declare TSundial_Pedestal = texture {
  pigment {
    granite
    colour_map {
      [0.0 colour rgb <0.83,0.83,0.73>]
      [0.5 colour rgb <0.78,0.78,0.69>]
      [1.0 colour rgb <0.83,0.83,0.73>]
    }
    scale <0.5,0.5,0.5>
  }
  normal {
    granite
    bump_size 0.1
    scale <0.05,0.05,0.05>
  }
}

#declare TSundial_Face = texture {
      pigment {
        colour rgb <0.72,0.45,0.20>
      }
      finish {
        phong 1.0
        phong_size 60
        metallic
        brilliance 5
      }
}

#declare Object_Sundial = union {
  difference {	// The stone pedestal
    union {
      object { Object_Sundial_Base }
      object {
        Object_Sundial_Pedestal
        translate <0,0.5,0>
      }
      object {
        Object_Sundial_Top
        translate <0,3.50,0>
      }
    }
    object {    // The hole for the sundial's face
      cylinder {
        <0,3.8,0>
        <0,4,0>
        0.65
      }
    }
    texture {
      TSundial_Pedestal
    }
  }
  union {       // The sundial's face
    difference {
      cylinder {
      <0,3.8,0>
      <0,3.86,0>
      0.62
      }
      union {
        cylinder {
          <0,3.85,0>
          <0,4.00,0>
          0.59
        }
        box {
          <-0.005,-0.005,0.20>
          < 0.005, 0.005,0.55>
          translate <0,3.85,0>
        }
        #declare Count = 0
        #declare Base  = 0
        #declare Remaining = 90
        #while (Count<7)
          #declare Angle = ((Remaining-Base)/3)+Base
          box {
            <-0.005,-0.005,0.20>
            < 0.005, 0.005,0.55>
            translate <0,3.85,0>
            rotate <0,Angle,0>
          }
          box {
            <-0.005,-0.005,0.20>
            < 0.005, 0.005,0.55>
            translate <0,3.85,0>
            rotate <0,-Angle,0>
          }
          #declare Base = Angle
          #declare Count = Count + 1
        #end
      }
    }
    texture {
      TSundial_Face
    }
  }
  difference {
    box {
      <-0.01, 0,-0.6>
      < 0.01, 0.3, 0>
    }
    box {
      <-0.2, 0,-3>
      < 0.2, 1, 3>
      rotate <-26.6,0,0>
      translate <0,0.3,0>
    }
    texture {
      TSundial_Face
    }
    translate <0,3.85,0>
  }
}

