// Sheet Music and Conductor Definitions
// A part of Metronome
// Created by the Butter-Fingered Juggler.
// For the POVRAY July 1996 Competition


// Colours and textures

#declare Parchment =
   texture {
      pigment
         {granite
         color_map
         {[0.0   color Quartz]
          [0.3   color White]
          [0.5   color Quartz]
          [0.7   color LightBlue]
          [1.0   color White]
         }
      }
   normal {wrinkles 0.2}
   }

#declare DarkWalnut =
 pigment 
  {wood
   turbulence 0.3
   color_map 
    {[0.00, 0.10 color red 0.60 green 0.30 blue 0.18
                 color red 0.60 green 0.30 blue 0.18]
     [0.10, 0.90 color red 0.60 green 0.30 blue 0.18
                 color red 0.30 green 0.15 blue 0.09]
     [0.90, 1.0  color red 0.30 green 0.15 blue 0.09
                 color red 0.30 green 0.15 blue 0.09]
    }
  }

#declare GunMetal = texture {
   pigment {color SteelBlue}
   finish {
      metallic
      ambient 0.2
      diffuse 0.7
      brilliance 3
   }
   normal {dents 0.2 scale 0.2}
}

#declare Ticker_Metal = texture {
   pigment {color DarkSlateGrey}
   finish {
      metallic
      ambient 0.2
      diffuse 0.7
      brilliance 3
   }
}

#declare Yellow_Conductor =
 texture
   {pigment {color red 0.6 green 0.6 blue 0.0}
    finish 
     {ambient 0.2
      diffuse 0.2
     }
   }

#declare Brassy = texture {
        pigment {color Brass}
        finish {
         metallic
         ambient 0.15
         diffuse 0.7
         brilliance 6.0
         reflection 0.5
         phong 0.8
         phong_size 120
        }
     }

// ----------------------------------------------------

// Objects

#declare H_Bar= union {
  cylinder { <-2, 4, 0>, <2, 4, 0>, 0.2 texture {Ticker_Metal}}
  sphere {<-2, 4, 0>, 0.23 pigment {color IndianRed}}
  sphere {<2, 4, 0>, 0.23 pigment {color IndianRed}}
}

#declare Marking = union {
  cylinder {<0, 4, 0>, <0, 23, 0>, 0.2 texture {Ticker_Metal}}
  sphere { <0, 4, 0>, 0.23 pigment {color IndianRed}}
  sphere { <0, 23, 0>, 0.23 pigment {color IndianRed}}
  object {H_Bar}
  object {H_Bar translate <0, 2, 0>}
  object {H_Bar translate <0, 4, 0>}
  object {H_Bar translate <0, 6, 0>}
  object {H_Bar translate <0, 8, 0>}
  object {H_Bar translate <0, 10, 0>}
  object {H_Bar translate <0, 12, 0>}
  object {H_Bar translate <0, 14, 0>}
  object {H_Bar translate <0, 16, 0>}
  object {H_Bar translate <0, 18, 0>}
}

#declare Screw = union {
  torus {0.5, 0.02
    texture {Brassy}
    rotate <90, 0, 0>}
  difference {
    cylinder {<0, 0, 0>, <0, 0, -0.03>, 0.4 texture {Brassy}}
    cylinder {<-0.5, -0.5, -0.04>, <0.5, 0.5, 0>, 0.1 texture {Brassy}}
  }
}
#declare Plaque = union {
   object {Screw translate <-0.2, 1.6, -0.2>}
   object {Screw translate <7.2, 1.6, -0.2>}
   box {<0, 0, 0>, <7, 2, -0.1> texture {Brassy}}
   object {char_K
        pigment {color Black}
        scale <0.15, 0.15, 0.1>
        translate <1, 1.1, -0.12>
   }
   object {char_M
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <2, 1.1, -0.12>
   }
   object {char_A
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <2.7, 1.1, -0.12>
   }
   object {char_N
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <3.4, 1.1, -0.12>
   }
   object {char_N
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <4.1, 1.1, -0.12>
   }
   object {char_I
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <4.7, 1.1, -0.12>
   }
   object {char_N
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <5.3, 1.1, -0.12>
   }
   object {char_G
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <6, 1.1, -0.12>
   }
}


// square-based trucated pyramid
#declare Chop_Pyr =  intersection {
   plane { < 1, 0,  0>, 1  rotate <  0, 0,  40>}
   plane { <-1, 0,  0>, 1  rotate <  0, 0, -40>}
   plane { < 0, 0,  1>, 1  rotate <-40, 0,   0>}
   plane { < 0, 0, -1>, 1  rotate < 40, 0,   0>}
   plane { <0, -1, 0>, 0 }
   plane { <0, 1, 0>, 0.66}
}            


// These might seem to be big - they are !
// I find it easier to do the coordinates large
// then scale to fit the picture

// The page of music is built up from a single definition
// Note_1 is a single note. Note_2 is 2xnote_1
// These are then built up into bars
// Then the page is made up of a random(ish) selection of bars
// I wouldn't try playing the music !

// Staves
#declare Stave = union {
   box {<-2, 0, 0>, <20, 0.1, -0.05> pigment {color DarkSlateBlue}}
   box {<-2, 2, 0>, <20, 2.1, -0.05> pigment {color DarkSlateBlue}}
   box {<-2, 4, 0>, <20, 4.1, -0.05> pigment {color DarkSlateBlue}}
   box {<-2, 6, 0>, <20, 6.1, -0.05> pigment {color DarkSlateBlue}}
   box {<-2, 8, 0>, <20, 8.1, -0.05> pigment {color DarkSlateBlue}}
   box {<-2, 0, 0>, <-1.9, 8.1, -0.05> pigment {color DarkSlateBlue}}
   box {<20, 0, 0>, <19.9, 8.1, -0.05> pigment {color DarkSlateBlue}}
   }

#declare Note_1 = union
   {
   cylinder {<1, 1, 0>, <1, 1, -0.1>, 1 pigment {color Black}}
   box{<2, 1, 0>, <1.5, 6, -0.1> pigment {color Black}}
   }
#declare Note_2 = union
   {
   box {<0, 0, 0>, <4.8, 0.5, -0.1> pigment {color Black} rotate <0,0,30> translate <1.7, 5.7, 0>}
   object {Note_1}
   object {Note_1 translate <4, 2, 0>}
   }
#declare Bar_1 = union {
   object {Stave}
   object {Note_1}
   object {Note_2 translate <4, 0, 0>}
   object {Note_1 translate <12, 0, 0>}
   object {Note_1 translate <16, 2, 0>}
   }
#declare Bar_2 = union {
   object {Stave}
   object {Note_2 translate <0, 3, 0>}
   object {Note_1 translate <8, 0, 0>}
   object {Note_1 translate <12, 3, 0>}
   object {Note_1 translate <16, 2, 0>}
   }
#declare Bar_3 = union {
   object {Stave}
   object {Note_1 translate <0, 1, 0>}
   object {Note_1 translate <4, 3, 0>}
   object {Note_2 translate <8, 0, 0>}
   object {Note_1 translate <16, 2, 0>}
   }

#declare Music = union {

box { <-15, -10, 0>, <95, 65, 0.05>
   texture {Parchment}
}

object {Bar_1}
object {Bar_2 translate <22, 0, 0>}
object {Bar_3 translate <44, 0, 0>}
object {Bar_1 translate <66, 0, 0>}

object {Bar_3 translate <0, 16, 0>}
object {Bar_2 translate <22, 16, 0>}
object {Bar_1 translate <44, 16, 0>}
object {Bar_3 translate <66, 16, 0>}

object {Bar_2 translate <0, 32, 0>}
object {Bar_1 translate <22, 32, 0>}
object {Bar_3 translate <44, 32, 0>}
object {Bar_3 translate <66, 32, 0>}

object {Bar_1 translate <0, 48, 0>}
object {Bar_1 translate <22, 48, 0>}
object {Bar_3 translate <44, 48, 0>}
object {Bar_2 translate <66, 48, 0>}
}


// ---------------------------------------

// Conductor

#declare Conductor = union {

// legs
cone { <0.5, 0, 0>, 0.5
       <0.4, 5.5, 0>, 0.4
       }
cone { <-0.5, 0, 0>, 0.5
       <-0.4, 5.5, 0>, 0.4
       }
cone { <0.5, 0.5, 0>, 0.5
       <0.5, 0, 2>, 0
       }
cone { <-0.5, 0.5, 0>, 0.5
       <-0.5, 0, 2>, 0
       }

// tails
//cone { <2.5, 3, -1>, 0
//       <0.5, 6, 0>, 1
//       }
//cone { <-2.5, 3, -1>, 0
//       <-0.5, 6, 0>, 1
//       }

object {Chop_Pyr
       scale <0.5, 4, 0.1>
       rotate <180, -45, 10>
       translate <0.75, 5.7, -0.9>
}
object {Chop_Pyr
       scale <0.5, 4, 0.1>
       rotate <180, 45, -10>
       translate <-0.75, 5.7, -0.9>
}
// body
cone { <0, 5.5, 0>, 1.5
       <0, 11, 0>, 1
       }
// head
sphere { <0, 12.2, 0>, 1.1
        }
cylinder {<0, 12.2, 0.2>, <0, 11 ,0.2>, 1}
// right arm
cylinder { <0.5, 10.5, 0>, <3.5, 10.8, 0.2>, 0.3
           }
cylinder { <3.5, 10.8, 0.2>, <4.2, 12.5, 1>, 0.3
           }
sphere { <3.5, 10.8, 0.2>, 0.3}
cylinder { <2.7, 14.5, 1>, <4.5, 11.5, 1>, 0.1
           }
//left arm
cylinder { <-0.5, 10.5, 0>, <-3, 8.5, 0.2>, 0.3
           }
cylinder { <-3, 8.5, 0.2>, <-2.5, 10, 2.5>, 0.3
           }
sphere { <-3, 8.5, 0.2>, 0.3}
}
