// Screw positions clockwise from 10 o/c
#declare Pos1 = <-0.80,-0.015, 0.15>
#declare Pos2 = <-0.75, 0.0075, 0.45>
#declare Pos3 = <-0.30,-0.015, 0.55>
#declare Pos4 = < 0,   -0.015, 0.75>
#declare Pos5 = < 0.80,-0.015,-0.05>
#declare Pos6 = < 0.72, 0.0075,-0.50>
#declare Pos7 = < 0.30,-0.015,-0.65>
#declare Pos8 = <-0.38,-0.015,-0.69>

// Top Plate
#declare W_top =
union {     // union plate + screws

 difference {    // plate - holes

 union {
   cylinder { < 0, -0.01, 0>, < 0, 0.01, 0>, 0.875 }
   torus { 0.875, 0.01 } }

 object { Cut1 rotate y*50 translate <-0.76,0,0> }
 object { Cut1 rotate y*110 translate <-0.7,0,-0.1> }
 object { Cut1 rotate -y*90 translate <-0.5,0,0.615> }
 object { Cut2 rotate -y*165 translate <0.5,0,-0.2> }
 object { Cut1 rotate y*52 translate <-1.2,0,0> }
 object { Cut3 rotate y*20 translate <-0.7,0,-0.1> }
 object { Cut3 rotate -y*42 translate <-0.5,0,-0.24> }
 object { superellipsoid { <0.5, 0.25>
  scale <0.15,0.5,0.5> rotate <90,-50,0> translate <0.6,0,0.55> } }

// Large Gear hole (upper)
 sphere {  < 0, 0, 0 > ,0.31 translate <0.3,0,0.4>  }
// Small Gear hole (upper)
 sphere {  < 0, 0, 0 > ,0.21 translate <0.50,0,-0.05>  }
// Spring wheel hole (upper)
 sphere {  < 0, 0, 0 > ,0.42 translate <-0.40,0,-0.25> }
// 2nd to clear remaining arc
 sphere {  < 0, 0, 0 > ,0.42 translate <-0.48,0,-0.29> }
// Screw holes
  object { Schole scale 0.5 translate Pos1  }
  object { Schole translate Pos2 }
  object { Schole scale 0.75 translate Pos3 }
  object { Schole translate Pos4 }
  object { Schole scale 0.75 translate Pos5 }
  object { Schole translate Pos6 }
  object { Schole translate Pos7 }

 texture { Toptex }
 bounded_by  { sphere { <0,0,0>, 0.9 }  }  }

// Screws
  object { Fltscrew texture { T_Chrome_3B }
        rotate x*90 scale 0.2 translate Pos1  }
  object { Rndscrew texture { T_Chrome_3B }
        rotate x*90 scale 0.50 translate Pos2 }
  object { Fltscrew texture { T_Chrome_3B }
        rotate x*90 scale 0.3 translate Pos3  }
  object { Rndscrew texture { T_Chrome_3B }
        rotate x*90 scale 0.50 translate Pos4 }
  object { Fltscrew texture { T_Chrome_3B }
        rotate x*90 scale 0.3 translate Pos5 }
  object { Rndscrew texture { T_Chrome_3B }
        rotate <90,-45,0> scale 0.50 translate Pos6 }
  object { Rndscrew texture { T_Chrome_3B }
        rotate x*90 scale 0.50 translate Pos7 }
  object { Rndscrew texture { T_Chrome_3B }
        rotate x*90 scale 0.50 translate Pos8 }

}  // end of union top plate + screws

// Middle Plate
#declare W_middle =
 difference {
  union {
   cylinder { < 0, -0.01, 0>, < 0, 0.01, 0>, 0.9 }
   torus { 0.9, 0.01 }
        }

// Large Gear hole (lower)
  sphere {  < 0, 0, 0 > ,0.42 translate <0.28,0,0.38> }
// Spring wheel hole (lower)
  sphere {  < 0, 0, 0 > ,0.42 translate <-0.40,0,-0.25> }
// Third
  sphere {  < 0, 0, 0 > ,0.3 translate <-0.3,0,0.15> }
  texture { Innertex }
  bounded_by { sphere { <0,0,0>, 0.9 } } }

// The spring support piece
#declare W_bar =
 difference {

// Template for shape
  difference {
   sphere {  < 0, 0, 0 > ,1 scale <0.45,0.5,0.6>
    translate <-0.40,0,-0.8> }
   sphere {  < 0, 0, 0 > ,1 scale <0.4,0.2,0.55>
    translate <-0.90,0,-0.35> }
   sphere {  < 0, 0, 0 > ,1 scale <0.6,0.2,0.6>
    translate <0.27,0,-0.40> }
   // Screw hole
   object { Schole translate Pos8 }

   plane { < 0,-1,0 >, 0 }
   plane { < 0,1,0 >,  -0.02 }
                } // end of 'Shape' difference stmt
// Cut out outside of circle
  difference {
   cylinder { < 0, -0.05, 0>, < 0, 0.05, 0>, 2 }
   union {
    cylinder { < 0, -0.01, 0>, < 0, 0.01, 0>, 0.875 }
    torus { 0.875, 0.01 } }  // end of union
             }  // end of 'circle' difference stmnt
   texture { Toptex }
   bounded_by { sphere { <0,0,0>, 0.9 }
}
} // end of difference

// Base plate
#declare W_base =
  union {
   cylinder { < 0, 0, 0>, < 0, 0.02, 0>, 0.9 }
   torus { 0.9, 0.02 }
    texture { Innertex } }

// Case
#declare W_case =
merge {

 difference {
  intersection {
   sphere {  < 0, 0, 0 > ,1 scale <1,0.1,1> }
   quadric
   {< 0, 1, 1>,< 0, 0, 0>,<-1, 0, 0>, -0.9 scale <1,0.5,2> }
   quadric
   {< 0, 1, 1>,< 0, 0, 0>,<-1, 0, 0>, -0.9 scale <1,0.5,2>
    rotate y*72 }
   quadric
   {< 0, 1, 1>,< 0, 0, 0>,<-1, 0, 0>, -0.9 scale <1,0.5,2>
    rotate y*144 }
   quadric
   {< 0, 1, 1>,< 0, 0, 0>,<-1, 0, 0>, -0.9 scale <1,0.5,2>
    rotate y*216 }
   quadric
   {< 0, 1, 1>,< 0, 0, 0>,<-1, 0, 0>, -0.9 scale <1,0.5,2>
    rotate y*288 }  }
 cylinder { < 0, -1, 0>, < 0, 1, 0>, 0.8 }
   translate <0,-0.04,0>
   scale <1.2,1,1.2> }
// Outside rim
 difference {
   torus { 0.91, 0.06  } // was 0.04
   cylinder { < 0, -1, 0>, < 0, 1, 0>, 0.9 }
}
// Lower case
 cylinder { < 0, -0.15, 0>, < 0, -0.13, 0>, 1 }
   texture { Outertex }
 }

// Lid
#declare W_lid =
difference {
  intersection {
   sphere {  < 0, 0, 0 > ,1 scale <1,0.15,1> }
   quadric
   {< 0, 1, 1>,< 0, 0, 0>,<-1, 0, 0>, -0.9 scale <1,0.7,2> }
   quadric
   {< 0, 1, 1>,< 0, 0, 0>,<-1, 0, 0>, -0.9 scale <1,0.7,2>
    rotate y*72 }
   quadric
   {< 0, 1, 1>,< 0, 0, 0>,<-1, 0, 0>, -0.9 scale <1,0.7,2>
    rotate y*144 }
   quadric
   {< 0, 1, 1>,< 0, 0, 0>,<-1, 0, 0>, -0.9 scale <1,0.7,2>
    rotate y*216 }
   quadric
   {< 0, 1, 1>,< 0, 0, 0>,<-1, 0, 0>, -0.9 scale <1,0.7,2>
    rotate y*288 } }

// plane { < 0,-1,0 >,  0 }   }
   sphere {  < 0, 0, 0 > ,1 scale <1,0.1,1> translate <0,-0.06,0>      }
   cylinder { < 0, -1, 0>, < 0, 0.08, 0>, 0.8 }


   translate <0,0.04,0>
   scale <1.2,1,1.2>
   texture { Lidtex }
   }

// Hinge
#declare W_hinge1 =
union {
 difference {
  cylinder { < -1, 0, 0>, < 1, 0, 0>, 0.05 }
  box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
        rotate z*45 translate <0,0.3,0> }
  texture { Outertex } }

 cylinder { < -1, 0, 0>, < 1, 0, 0>, 0.04
        texture { T_Chrome_3B } } }

#declare W_hinge2 =
union {
 difference {
  box { < -0.3, -0.05, -0.01>, < 0.3, 0.05, 0.01> }
  sphere {  < 0, 0, 0 > ,0.025 translate <-0.2,0,0> }
  sphere {  < 0, 0, 0 > ,0.025 translate < 0.2,0,0> }
  texture { T_Chrome_3B } }
 cylinder { < 0, 0, -0.05>, < 0, 0, 0.02>, 0.025
  translate <-0.2,0,0> texture { T_Chrome_3B } }
 cylinder { < 0, 0, -0.05>, < 0, 0, 0.02>, 0.025
  translate < 0.2,0,0> texture { T_Chrome_3B } }
texture { T_Chrome_3B }  }

// Put the lot together
#declare W_plates =
union {
 	object {W_top    translate <0,0.02,0> }
        object {W_middle translate <0,-0.075,0> }
        object {W_bar    translate <0,0.02,0>  }
        object {W_base   translate <0,-0.15,0> }
	object {W_case   translate <0,-0.03,0> }
 }
