
#declare Spud_Wheel_Thickness = 1
#declare Spud_Wheel_Radius = 3

#declare Spud_Weight =
union
   {
   sphere { <0, 0, 0> Spud_Wheel_Thickness/2.5 translate -x*Spud_Wheel_Radius }
   sphere { <0, 0, 0> Spud_Wheel_Thickness/2.5 translate  x*Spud_Wheel_Radius }
   }

#declare Spud_Wheel =
union
   {
   difference
      {
      union
         {
         cylinder
            {
            <0, 0, -Spud_Wheel_Thickness/2> <0, 0, Spud_Wheel_Thickness/2>
            Spud_Wheel_Radius
            }
         #declare spud_count = 8
         #declare Count = 0
         #while ( Count < spud_count )
            object { Spud_Weight rotate Count*z*180/spud_count }
         #declare Count = Count + 1
         #end
         }
      cylinder
         {
         <0, 0, -Spud_Wheel_Thickness/2-Small_Number>
         <0, 0,  Spud_Wheel_Thickness/2+Small_Number>
         Spud_Wheel_Radius-Spud_Wheel_Radius*.1
         }
      }
   box
      {
      <-Spud_Wheel_Radius, -Spud_Wheel_Radius/4, -Spud_Wheel_Thickness/8>
      < Spud_Wheel_Radius,  Spud_Wheel_Radius/4,  Spud_Wheel_Thickness/8>
      clipped_by
         {
         cylinder
            {
            <0, 0, -Spud_Wheel_Thickness/2-Small_Number>
            <0, 0,  Spud_Wheel_Thickness/2+Small_Number>
            Spud_Wheel_Radius-Spud_Wheel_Radius*.1
            }
         }
      }
//   cylinder { <0, 0, -5> <0, 0, 5> Spud_Wheel_Radius/10 }
   }
