// Persistence of Vision Ray Tracer Scene Description File
// File: watch.pov
// Vers: 3
// Desc:
// Date: 5/10/96
// Auth: Robert S. Creager

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "woods.inc"

#declare Small_Number = 0.001
#declare One = (1+Small_Number)
#declare TH     =  .5
#declare TC     =  .5

#declare Gear_Texture = texture { Brass_Metal }
#declare Spring_Texture = texture { finish { F_MetalA ambient .3 }
                                    pigment { Gray45 } }
#declare Spring_Scale = <1, 1, .75>
#declare Small_Gear_Scale = (1/2)
#declare Big_Gear_Scale = (Small_Gear_Scale/4)
#declare Gear_Translate = Small_Gear_Scale

#declare Gear_Spoke = box { <-.1, 0, -1> <.1, 1, 1> }

#declare Gear_Big_Center =
difference
   {
   union
      {
      #declare Count = 0
      #while ( Count < 360 )
         object { Gear_Spoke rotate z*Count }
      #declare Count = Count + 90
      #end
      cylinder { <0, 0, -1> <0, 0, 1> .3 }
      }
   cylinder { <0, 0, -One> <0, 0, One> .15 }
   }

#include "gear4to1.inc"
#include "gear3to1.inc"
#include "ticker.inc"

#declare Watch =
union
   {
   union
      {
      object
         {
         Gear10      // minute hand attaches here
         scale <1, 1, Small_Gear_Scale>
         rotate z*(Rot10/6)
         }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R10, R10, 1>  }
      translate < 0, 0, -6*Gear_Translate>
      }
   union
      {
      object      // driven by minute hand
         {
         Gear40
         scale <1, 1, Big_Gear_Scale>
         rotate -z*(0)
         translate <0, 0, -Small_Gear_Scale/2>
         }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R40, R40, 1>  }
      object      // drives hour hand
         {
         Gear12
         scale <1, 1, Small_Gear_Scale>
         rotate -z*(0)
         translate <0, 0, Small_Gear_Scale/2>
         }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R12, R12, 1>  }
      translate <R40+R10+TH, 0, 0>
      rotate -z*65
      }
   object      // hour hand attaches here
      {
      Gear36
      scale <1, 1, Big_Gear_Scale>
      rotate z*(0*Rot36/2)
      translate <0, 0, Small_Gear_Scale/2>
      }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R36, R36, 1>  }

   union
      {
      object      // drives second hand
         {
         GearXX
//         pigment { color Blue }
         scale <1, 1, Big_Gear_Scale>
         rotate -z*(ThTHXX/6)
         }

#declare radius_start = 6.4
#declare radius_end = 1.5
#declare turns = 10.0
#declare density = 450
#include "coil.inc"

      object { Spring texture { Spring_Texture }
               scale Spring_Scale translate -z*3 }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <RXX, RXX, 1>  }
      union
         {
         object      // link to escape wheel
            {
            GearXSC3
            scale <1, 1, Small_Gear_Scale>
            rotate z*(ThTHXSC3)
            }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <RXSC3, RXSC3, 1>  }
         object { Spud_Wheel translate -z*2 }

#declare radius_start = 3.0
#declare radius_end = .6
#declare turns = 4.0
#declare density = 288
#include "coil.inc"

      object { Spring texture { Spring_Texture }
               scale Spring_Scale translate -z*4 }
         translate <RXX+RXSC3+TH, 0, 0>
         rotate z*110
         }
      translate <RXX+RXSC3+TH, 0, -2*Gear_Translate>
      rotate -z*135
      }

   union
      {
      object      // second hand attaches here
         {
         Gear10
         //pigment { color Green }
         scale <1, 1, Gear_Translate>
//         rotate z*()
         translate <0, 0, 0>
         }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R10, R10, 1> }
      object      // increment for second hand
         {
         GearXSC3
         //pigment { color Red }
         scale <1, 1, Small_Gear_Scale>
         rotate z*(ThTHXSC3/2)
         translate <0, 0, -2*Gear_Translate>
         }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <RXSC3, RXSC3, 1>  }
      }

   union
      {
      object   // driven by second hand
         {
         Gear40
         //pigment { color Yellow }
         scale <1, 1, Big_Gear_Scale>
//         rotate -z*()
         translate <0, 0, 0>
         }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R40, R40, 1>  }
      object      // drives first reduction for minute hand
         {
         Gear12
         scale <1, 1, Small_Gear_Scale>
//         rotate -z*()
         translate <0, 0, -Gear_Translate>
         }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R12, R12, 1>  }
      translate <R40+R10+TH, 0, 0>
      }

   union
      {
      object      // driven by first reduction for minute hand
         {
         Gear36
         scale <1, 1, Big_Gear_Scale>
         rotate z*(Rot36/2)
         translate <0, 0, -Gear_Translate>
         }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R36, R36, 1>  }
      object
         {
         Gear10   // drives second reduction for minute hand
         scale <1, 1, Small_Gear_Scale>
         rotate z*(-Rot10/16)
         translate <0, 0, -2*Gear_Translate>
         }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R10, R10, 1>  }
      union
         {
         union
            {
            object
               {
               Gear40   // driven by second reduction for minute hand
               scale <1, 1, Big_Gear_Scale>
//               rotate z*()
               translate <0, 0, -2*Gear_Translate>
               }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R40, R40, 1>  }
            object
               {
               Gear10   // drives third reduction for minute hand
               scale <1, 1, Small_Gear_Scale>
//               rotate z*()
               translate <0, 0, -3*Gear_Translate>
               }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R10, R10, 1>  }
            union
               {
               object
                  {
                  Gear10   // driven by third reduction for minute hand
                  scale <1, 1, Small_Gear_Scale>
                  rotate z*(Rot10/2)
                  translate <0, 0, -4*Gear_Translate>
                  }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R10, R10, 1>  }
               object
                  {
                  Gear8    // drives link to minute hand
                  scale <1, 1, Small_Gear_Scale>
                  rotate z*(-Rot8/10)
                  translate <0, 0, -6*Gear_Translate>
                  }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R8, R8, 1>  }
               union
                  {
                  object
                     {
                     Gear36   // link to minute hand
                     scale <1, 1, Big_Gear_Scale>
//                     rotate z*()
                     }
//cylinder { <0, 0, -5> <0, 0, 5> .15 scale <R36, R36, 1>  }
                  translate <R36+R8+TH, 0, -6*Gear_Translate>
                  rotate -z*27.5
                  }
               translate <R10+R10+TH, 0, 0>
               rotate z*180
               }
            }
         translate <R40+R10+TH, 0, 0>
         rotate -z*110
         }
      translate <-R40-R10-TH, 0, 0>
      rotate -z*65
      translate <R40+R10+TH, 0, 0>
      }
   texture { Gear_Texture }
   }

//object { Watch rotate <90, 315, 0> translate <0, 0, 0> }
union
   {
   object { Watch rotate <90, 90, 0> translate <1, 2, -1> }
   plane
      {
      y, -1
      texture { T_Wood19 scale <10, 10, 10>
                finish
                   {
                   specular 0.2 roughness 0.7 ambient 0.1
                   diffuse .3
                   }
                rotate <0, 88, 0> }
      }
   translate <0, -1, 0>
   }

camera
   {
   location <0, 20, -15>
   look_at <0, 0, 0>
   }

light_source
   {
   <-10, 20, 10>
   White
   spotlight
   cylinder
   radius 30
   falloff 70
   point_at <-5, 0, 5>
   }

light_source
   {
   <0, 50, -15>
   White
   spotlight
   cylinder
   radius 40
   falloff 80
   point_at <2, 0, 2>
   }

light_source
   {
   <0, 5, -15>
   White
   spotlight
   cylinder
   radius 30
   falloff 80
   point_at <0, 10, 0>
   }

light_source
   {
   <-15, 10, -15>
   White
   spotlight
   cylinder
   radius 30
   falloff 80
   point_at <0, 5, 0>
   }
