// Ruins.Pov:   Roman-style ruins (columns and blocks)
//              Instead of using a complex CSG object for
//              the columns, I merely used a radial texture.
//              Modelled in Moray 3.0
//
//              Rex McDonald
//              rexm@xmission.com
//              1-801-974-3706
//

#include "ruins.inc"

#declare GroupPillar5 = union {
  cylinder { // CylndrTop15
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.5, 0.5, 0.4>
    translate  2.4*z
  }
  cylinder { // CylndrTop16
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.45, 0.45, 0.15>
    translate  2.25*z
  }
  cone { // ConeTop5
    <0,0,0>, 0.4, <0,0,1>, 0.43
    texture {
      TextureGrooves
    }
    scale <1.0, 1.0, 0.25>
    translate  2.0*z
  }
  cylinder { // CylndrTop17
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.42, 0.42, 0.15>
    translate  1.9*z
  }
  cylinder { // CylndrPillar5
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureGrooves
    }
    scale <0.4, 0.4, 4.0>
    translate  -2.0*z
  }
  cylinder { // CylndrCap10
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.53, 0.53, 0.1>
    translate  2.75*z
  }
  cylinder { // CylndrCap11
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.525, 0.525, 0.1>
    translate  2.5*z
  }
  scale 0.8
  rotate <-5.99523, 4.450782, -5.494342>
  translate  <-4.0, 2.0, -2.0>
}
#declare GroupPillar4 = union {
  cylinder { // CylndrTop12
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.5, 0.5, 0.4>
    translate  2.4*z
  }
  cylinder { // CylndrTop13
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.45, 0.45, 0.15>
    translate  2.25*z
  }
  cone { // ConeTop4
    <0,0,0>, 0.4, <0,0,1>, 0.43
    open
    texture {
      TextureGrooves
    }
    scale <1.0, 1.0, 0.25>
    translate  2.0*z
  }
  cylinder { // CylndrTop14
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.42, 0.42, 0.15>
    translate  1.9*z
  }
  cylinder { // CylndrPillar4
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureGrooves
    }
    scale <0.4, 0.4, 4.0>
    translate  -2.0*z
  }
  cylinder { // CylndrCap8
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.53, 0.53, 0.1>
    translate  2.75*z
  }
  cylinder { // CylndrCap9
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.525, 0.525, 0.1>
    translate  2.5*z
  }
  scale 0.8
  rotate <5.0, -5.0, 0.0>
  translate  <0.0, 4.0, -1.5>
}
#declare GroupPillar3 = union {
  cylinder { // CylndrTop9
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.5, 0.5, 0.4>
    translate  2.4*z
  }
  cylinder { // CylndrTop10
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.45, 0.45, 0.15>
    translate  2.25*z
  }
  cone { // ConeTop3
    <0,0,0>, 0.4, <0,0,1>, 0.43
    open
    texture {
      TextureGrooves
    }
    scale <1.0, 1.0, 0.25>
    translate  2.0*z
  }
  cylinder { // CylndrTop11
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.42, 0.42, 0.15>
    translate  1.9*z
  }
  cylinder { // CylndrPillar3
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureGrooves
    }
    scale <0.4, 0.4, 4.0>
    translate  -2.0*z
  }
  cylinder { // CylndrCap6
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.53, 0.53, 0.1>
    translate  2.75*z
  }
  cylinder { // CylndrCap7
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.525, 0.525, 0.1>
    translate  2.5*z
  }
  scale 0.8
  rotate <-4.847982, -5.036711, -0.870534>
  translate  <4.0, 2.0, -1.0>
}
#declare GroupPillar2 = union {
  cylinder { // CylndrTop6
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.5, 0.5, 0.4>
    translate  2.4*z
  }
  cylinder { // CylndrTop7
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.45, 0.45, 0.15>
    translate  2.25*z
  }
  cone { // ConeTop2
    <0,0,0>, 0.4, <0,0,1>, 0.43
    texture {
      TextureGrooves
    }
    scale <1.0, 1.0, 0.25>
    translate  2.0*z
  }
  cylinder { // CylndrTop8
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.42, 0.42, 0.15>
    translate  1.9*z
  }
  cylinder { // CylndrPillar2
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureGrooves
    }
    scale <0.4, 0.4, 4.0>
    translate  -2.0*z
  }
  cylinder { // CylndrCap4
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.53, 0.53, 0.1>
    translate  2.75*z
  }
  cylinder { // CylndrCap5
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.525, 0.525, 0.1>
    translate  2.5*z
  }
  translate  <4.0, -2.0, -0.2>
}
#declare GroupPillar1 = union {
  cylinder { // CylndrTop3
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.5, 0.5, 0.4>
    translate  2.4*z
  }
  cylinder { // CylndrTop4
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.45, 0.45, 0.15>
    translate  2.25*z
  }
  cone { // ConeTop1
    <0,0,0>, 0.4, <0,0,1>, 0.43
    open
    texture {
      TextureGrooves
    }
    scale <1.0, 1.0, 0.25>
    translate  2.0*z
  }
  cylinder { // CylndrTop5
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.42, 0.42, 0.15>
    translate  1.9*z
  }
  cylinder { // CylndrPillar1
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureGrooves
    }
    scale <0.4, 0.4, 4.0>
    translate  -2.0*z
  }
  cylinder { // CylndrCap2
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.53, 0.53, 0.1>
    translate  2.75*z
  }
  cylinder { // CylndrCap3
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.525, 0.525, 0.1>
    translate  2.5*z
  }
  rotate <64.250771, -58.116695, 7.297403>
  translate  <0.0, -4.0, -2.0>
}
#declare GroupPillar = union {
  cylinder { // CylndrTop2
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.5, 0.5, 0.4>
    translate  2.4*z
  }
  cylinder { // CylndrTop1
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.45, 0.45, 0.15>
    translate  2.25*z
  }
  cone { // ConeTop
    <0,0,0>, 0.4, <0,0,1>, 0.43
    texture {
      TextureGrooves
    }
    scale <1.0, 1.0, 0.25>
    translate  2.0*z
  }
  cylinder { // CylndrTop
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.42, 0.42, 0.15>
    translate  1.9*z
  }
  cylinder { // CylndrPillar
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureGrooves
    }
    scale <0.4, 0.4, 4.0>
    translate  -2.0*z
  }
  cylinder { // CylndrCap
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.53, 0.53, 0.1>
    translate  2.75*z
  }
  cylinder { // CylndrCap1
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureStone
    }
    scale <0.525, 0.525, 0.1>
    translate  2.5*z
  }
  rotate <-31.0, 65.0, 0.0>
  translate  <-2.0, -3.9, -2.2>
}

#declare Ruins = union { // GroupRuins
  box { // CubeBlock3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TextureStone
    }
    scale <1.0, 0.5, 0.5>
    rotate <-25.0, 30.0, 45.0>
    translate  <2.0, 3.5, -2.5>
  }
  box { // CubeBlock2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TextureStone
    }
    scale <0.25, 1.0, 0.25>
    rotate <50.0, -90.0, 0.0>
    translate  <-5.0, -1.3, -2.8>
  }
  box { // CubeBlock1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TextureStone
    }
    scale <0.5, 0.25, 0.25>
    rotate <25.0, -90.0, 0.0>
    translate  <-3.0, 0.1, -2.75>
  }
  box { // CubeBlock
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TextureStone
    }
    scale <1.0, 0.5, 0.5>
    rotate <-5.0, -20.0, -20.0>
    translate  <3.0, 0.0, -2.75>
  }
  object { GroupPillar5 }
  object { GroupPillar4 }
  object { GroupPillar3 }
  object { GroupPillar2 }
  object { GroupPillar1 }
  object { GroupPillar }
}




